/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web.datafix;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IDataFixSceneEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IDataFixToolEntityService;
import kd.hrmp.hric.bussiness.domain.init.IDataFixSceneDomainService;
import kd.hrmp.hric.common.DataFixEnum;
import kd.hrmp.hric.common.bean.bo.DataFixToolBo;

public class DataFixToolFormPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private final IDataFixToolEntityService dataFixToolEntityService = (IDataFixToolEntityService)ServiceFactory.getService(IDataFixToolEntityService.class);
    private final IDataFixSceneEntityService dataFixSceneEntityService = (IDataFixSceneEntityService)ServiceFactory.getService(IDataFixSceneEntityService.class);
    private final IDataFixSceneDomainService dataFixSceneDomainService = (IDataFixSceneDomainService)ServiceFactory.getService(IDataFixSceneDomainService.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (!PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ba1\u7406\u5458\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataFixTooListPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.getValue() == OperationStatus.ADDNEW.getValue() && ObjectUtils.isEmpty((Object)this.getView().getModel().getValue("number"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"buttonlast", "savebutton", "exitbutton"});
        }
        if (status.getValue() == OperationStatus.EDIT.getValue()) {
            this.openDetail(this.getView());
            this.getView().setVisible(Boolean.TRUE, new String[]{"exitbutton"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"prompt"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"buttonlast", "savebutton", "buttonnext"});
            DynamicObject dataFixTool = this.getModel().getDataEntity();
            if (dataFixTool != null && "0".equals(dataFixTool.getString("cusstatus"))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"savebutton"});
            }
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"wizardap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initData();
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String args = e.getEventArgs();
        JSONObject json = JSON.parseObject((String)args);
        if ("confirm".equals(eventName)) {
            this.getModel().setValue("fixscene", (Object)Long.parseLong(json.getString("checkId")));
            this.getView().getModel().setDataChanged(false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        DynamicObject dataFixToolDyn;
        FormShowParameter formShowParameter = e.getFormShowParameter();
        Object pkId = ((BillShowParameter)formShowParameter).getPkId();
        if (formShowParameter != null && pkId != null && (dataFixToolDyn = this.dataFixToolEntityService.query("name,fixscene.name,prompt,cusstatus", (Object)Long.parseLong(pkId.toString()))) != null) {
            e.getFormShowParameter().setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be6\u60c5-%s", (String)"DataFixToolFormPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), dataFixToolDyn.getLocaleString("fixscene.name")));
        }
    }

    public void registerListener(EventObject evt) {
        BasedataEdit fPostEdit;
        BasedataEdit aOrgEdit;
        super.registerListener(evt);
        this.addClickListeners(new String[]{"buttonlast", "buttonnext"});
        BasedataEdit bOrgEdit = (BasedataEdit)this.getView().getControl("b_org");
        if (bOrgEdit != null) {
            bOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((aOrgEdit = (BasedataEdit)this.getView().getControl("a_org")) != null) {
            aOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((fPostEdit = (BasedataEdit)this.getView().getControl("f_post")) != null) {
            fPostEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addUserF7SleListener();
    }

    public void addUserF7SleListener() {
        BasedataEdit gUserEdit;
        BasedataEdit eUserEdit;
        BasedataEdit dUserEdit;
        BasedataEdit cUserEdit = (BasedataEdit)this.getView().getControl("c_user");
        if (cUserEdit != null) {
            cUserEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((dUserEdit = (BasedataEdit)this.getView().getControl("d_user")) != null) {
            dUserEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((eUserEdit = (BasedataEdit)this.getView().getControl("e_user")) != null) {
            eUserEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((gUserEdit = (BasedataEdit)this.getView().getControl("g_user")) != null) {
            gUserEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "buttonlast": {
                if (this.getView().getModel().getDataChanged()) {
                    ConfirmCallBackListener confirm = new ConfirmCallBackListener("buttonlast", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"DataFixToolFormPlugin_4", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirm);
                    break;
                }
                this.previous();
                this.handleCtrlVisible(this.getView());
                break;
            }
            case "buttonnext": {
                this.doStepAction(this.getView(), true);
                break;
            }
        }
        this.handleCtrlVisible(this.getView());
    }

    private void initData() {
        Object[] dynamicObjects = this.dataFixSceneDomainService.queryAllScene();
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return;
        }
        Map<String, List<DynamicObject>> dataFixSceneMap = Arrays.asList(dynamicObjects).stream().filter(dy -> dy.getDynamicObject("cloud") != null).collect(Collectors.groupingBy(t -> t.getString("cloud.number")));
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        if (customcontrol == null) {
            return;
        }
        HashMap result = new HashMap(16);
        ArrayList boList = new ArrayList(10);
        dataFixSceneMap.forEach((cloud, dataFixSceneDyn) -> {
            DataFixToolBo dataFixToolBo = new DataFixToolBo();
            this.initDataFixToolBo(dataFixToolBo, (List<DynamicObject>)dataFixSceneDyn);
            boList.add(dataFixToolBo);
        });
        result.put("data", boList);
        customcontrol.setData(result);
        this.getView().updateView("customcontrolap");
    }

    private void initDataFixToolBo(DataFixToolBo dataFixToolBo, List<DynamicObject> dataFixSceneDyn) {
        dataFixToolBo.setCloudId(dataFixSceneDyn.get(0).getString("cloud.id"));
        dataFixToolBo.setCloudName(dataFixSceneDyn.get(0).getString("cloud.name"));
        ArrayList dataFixSceneList = Lists.newArrayListWithCapacity((int)dataFixSceneDyn.size());
        for (DynamicObject dynamicObject : dataFixSceneDyn) {
            HashMap<String, String> fixSceneMap = new HashMap<String, String>();
            fixSceneMap.put("id", dynamicObject.getString("id"));
            fixSceneMap.put("name", dynamicObject.getString("name"));
            dataFixSceneList.add(fixSceneMap);
        }
        dataFixToolBo.setInfoList((List)dataFixSceneList);
    }

    private void handleCtrlVisible(IFormView formView) {
        String tabIndex = (String)formView.getFormShowParameter().getCustomParam("wizardTabIndex");
        if (HRStringUtils.equals((String)"0", (String)tabIndex)) {
            formView.setVisible(Boolean.FALSE, new String[]{"buttonlast"});
            formView.setVisible(Boolean.FALSE, new String[]{"savebutton"});
            formView.setVisible(Boolean.TRUE, new String[]{"buttonnext"});
        }
        if (HRStringUtils.equals((String)"1", (String)tabIndex)) {
            formView.setVisible(Boolean.TRUE, new String[]{"buttonlast"});
            formView.setVisible(Boolean.TRUE, new String[]{"savebutton"});
            formView.setVisible(Boolean.FALSE, new String[]{"buttonnext"});
        }
    }

    private void previous() {
        this.doStepAction(this.getView(), false);
    }

    public void doStepAction(IFormView formView, boolean forward) {
        if (ObjectUtils.isEmpty((Object)this.getModel().getValue("fixscene"))) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u573a\u666f", (String)"DataFixToolFormPlugin_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return;
        }
        Long fixSceneId = this.getModel().getDataEntity().getLong("fixscene.id");
        DynamicObject dataFixScene = this.dataFixSceneEntityService.query("number,name,iscopy,prompt", (Object)fixSceneId);
        if (dataFixScene == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u573a\u666f\u4e0d\u5b58\u5728", (String)"DataFixToolFormPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("prompt", dataFixScene.get("prompt"));
        this.getView().setEnable(Boolean.FALSE, new String[]{"prompt"});
        Tab tab = (Tab)formView.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        int tabIndex = 0;
        for (int i = 0; i < tab.getItems().size(); ++i) {
            Control control = (Control)tab.getItems().get(i);
            if (!control.getKey().equals(currentTab)) continue;
            if (forward) {
                tab.activeTab(((Control)tab.getItems().get(i + 1)).getKey());
                tabIndex = i + 1;
                break;
            }
            this.getView().getModel().deleteEntryData(DataFixEnum.getEntryByNumber((String)dataFixScene.getString("number")));
            tab.activeTab(((Control)tab.getItems().get(i - 1)).getKey());
            tabIndex = i - 1;
            break;
        }
        formView.getFormShowParameter().setCustomParam("wizardTabIndex", (Object)(tabIndex + ""));
        this.getView().getModel().setDataChanged(false);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (StringUtils.equals((CharSequence)callBackId, (CharSequence)"buttonlast") && event.getResult() == MessageBoxResult.Yes) {
            this.previous();
            this.handleCtrlVisible(this.getView());
        }
    }

    public void openDetail(IFormView formView) {
        Tab tab = (Tab)formView.getControl("tabap");
        int tabIndex = 1;
        tab.activeTab(((Control)tab.getItems().get(tabIndex)).getKey());
        this.getView().setVisible(Boolean.FALSE, new String[]{"wizardap"});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        QFilter initDataSourceFilter = new QFilter("initdatasource", "=", (Object)"1");
        beforeF7SelectEvent.addCustomQFilter(initDataSourceFilter);
    }
}

