/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web.datafix;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hies.entry.common.plugin.impt.AfterInitContextArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterQueryRefBdEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeCreateTemplateEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeQueryRefBdEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeTemplateValidateEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.HREntryImportPlugin;
import kd.hrmp.hric.common.DataFixEnum;
import kd.hrmp.hric.common.util.QFilterUtils;

public class DataFixToolImportPlugin
extends HRDataBaseEdit
implements HREntryImportPlugin {
    private static final Map<String, String> F7_FORMAT_CFG = ImmutableMap.builder().put((Object)"b_org", (Object)"number").put((Object)"a_org", (Object)"number").put((Object)"f_post", (Object)"number").put((Object)"c_user", (Object)"number").put((Object)"c_post", (Object)"number").put((Object)"c_department", (Object)"number").put((Object)"c_org", (Object)"number").put((Object)"c_stdpost", (Object)"number").put((Object)"c_job", (Object)"number").put((Object)"c_elmtype", (Object)"number").put((Object)"d_user", (Object)"number").put((Object)"d_org", (Object)"number").put((Object)"d_post", (Object)"number").put((Object)"d_stdpost", (Object)"number").put((Object)"d_job", (Object)"number").put((Object)"d_elmtype", (Object)"number").put((Object)"e_user", (Object)"number").put((Object)"g_user", (Object)"number").put((Object)"emprelstage", (Object)"number").build();
    private static final List<String> BILL_FORM_ID_LIST = ImmutableList.builder().add((Object)"haos_adminorghr").add((Object)"hrpi_person").add((Object)"hbpm_positionhr").add((Object)"hbpm_stposition").build();
    private static final List<String> ENTRY_KEY_LIST = ImmutableList.builder().add((Object)DataFixEnum.MOD_OFFICE_DATE.getEntry()).add((Object)DataFixEnum.MOD_LABRELA_END_DATE.getEntry()).add((Object)DataFixEnum.MOD_OFFICE_START_DATE.getEntry()).add((Object)DataFixEnum.MOD_OFFICE.getEntry()).build();
    private static final List<String> USER_LIST = ImmutableList.builder().add((Object)"c_user").add((Object)"d_user").add((Object)"e_user").add((Object)"g_user").build();

    public void beforeQueryRefBd(BeforeQueryRefBdEventArgs args) {
        ArrayList qFilterList = Lists.newArrayList((Object[])args.getFilters());
        QFilter qFilter = null;
        if (ENTRY_KEY_LIST.contains(args.getEntryKey())) {
            if (USER_LIST.contains(args.getFieldId())) {
                qFilter = QFilterUtils.getDataInitQFilter(Collections.singletonList("hrpi_person"));
            }
        } else {
            qFilter = QFilterUtils.getDataInitQFilter(BILL_FORM_ID_LIST);
        }
        if (qFilter != null) {
            qFilterList.add(qFilter);
        }
        args.setFilters(qFilterList.toArray(new QFilter[0]));
    }

    public void afterQueryRefBd(AfterQueryRefBdEventArgs args) {
        if (!args.isImportInvoke()) {
            args.setDatas(null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (!PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ba1\u7406\u5458\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataFixTooListPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterInitContext(AfterInitContextArgs args) {
        args.setF7formatCfg(F7_FORMAT_CFG);
    }

    public void beforeCreateTemplate(BeforeCreateTemplateEventArgs args) {
        args.setF7formatCfg(F7_FORMAT_CFG);
    }

    public void beforeTemplateValidate(BeforeTemplateValidateEventArgs args) {
        args.setF7formatCfg(F7_FORMAT_CFG);
    }
}

