/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web.midtable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.ext.IInitMetadataEntityService;
import kd.hrmp.hric.bussiness.domain.init.IInitTemplateDomainService;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.bo.MetadataBo;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.table.ColumnInfo;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.table.ColumnInfoReaderFactory;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.util.MetadataUtils;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.util.TableUtils;
import kd.hrmp.hric.bussiness.service.AsyncTaskServiceHelper;
import kd.hrmp.hric.common.bean.MiddleTableField;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.constants.AsyncTaskSceneConstants;
import kd.hrmp.hric.common.constants.MiddleGenerateLogConstants;
import kd.hrmp.hric.common.util.TXHandleUtils;

public class MiddleTableGenerateLogEditPlugin
extends HRDataBaseEdit {
    private static Log LOG = LogFactory.getLog(MiddleTableGenerateLogEditPlugin.class);
    private final IInitTemplateDomainService initTemplateService = (IInitTemplateDomainService)ServiceFactory.getService(IInitTemplateDomainService.class);
    private static final IInitMetadataEntityService iInitMetadataEntityService = (IInitMetadataEntityService)ServiceFactory.getService(IInitMetadataEntityService.class);
    private static final String MIDDLE_TABLE_TAB = "middle_table";
    private static final String INIT_STATUS = "initstatus";
    private static final String INIT_STATUS_DISCARD = "J1";
    private static final String INIT_STATUS_FINISH_SUCCESS = "G1";

    public void afterCreateNewData(EventObject e) {
        this.showMiddleTableTab();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showMiddleFieldTab();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOp = (FormOperate)args.getSource();
        String operateKey = formOp.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"modify_field_length")) {
            if (!this.validateFieldLength()) {
                args.setCancel(true);
            }
        } else if (HRStringUtils.equals((String)operateKey, (String)"regenerate_field")) {
            this.showConfirmPage(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String midTableNumber = (String)formShowParameter.getCustomParam("midTableNumber");
        if (HRStringUtils.equals((String)afterDoOperationEventArgs.getOperateKey(), (String)"modify_field_length")) {
            String tableName = this.getTableName(midTableNumber);
            ArrayList alterSqlList = Lists.newArrayListWithExpectedSize((int)AppConstants.LIST_SIZE);
            DynamicObjectCollection middleTableFieldCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            for (DynamicObject middleTableField : middleTableFieldCollection) {
                int dbFieldLength = middleTableField.getInt("dbfieldlength");
                int targetFieldLength = middleTableField.getInt("targetfieldlength");
                if (targetFieldLength <= dbFieldLength) continue;
                alterSqlList.addAll(this.generateAlterSql(middleTableField, tableName));
            }
            this.exec(alterSqlList);
            this.getView().updateView();
        } else if ("refresh".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.getView().updateView();
        }
    }

    private void exec(List<String> sqlList) {
        sqlList.forEach(sql -> {
            try {
                DB.execute((DBRoute)DBRoute.of((String)"hmp"), (String)sql);
                LOG.info("exec success, sql: {}", sql);
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        });
    }

    private List<String> generateAlterSql(DynamicObject middleTableField, String tableName) {
        ArrayList sqlList = Lists.newArrayListWithExpectedSize((int)2);
        String fieldType = middleTableField.getString("fieldtype");
        String columnName = middleTableField.getString("columnname");
        String targetFieldLength = middleTableField.getString("targetfieldlength");
        StringBuilder sb = new StringBuilder("EXEC p_AlterColumn '");
        String dbColumnType = "";
        switch (fieldType) {
            case "ComboField": {
                dbColumnType = "VARCHAR";
                break;
            }
            case "MuliLangTextField": {
                dbColumnType = "NVARCHAR";
                tableName = tableName + "_l";
                break;
            }
            case "TextField": {
                dbColumnType = "VARCHAR";
            }
        }
        sb.append(tableName).append("', '").append(columnName).append("', '");
        sb.append(dbColumnType).append("(").append(targetFieldLength).append(")").append("', 'NOT NULL', '0100', ''' ''';");
        sqlList.add(sb.toString());
        return sqlList;
    }

    private void showConfirmPage(BeforeDoOperationEventArgs args) {
        int successCount;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String midTableNumber = (String)formShowParameter.getCustomParam("midTableNumber");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(midTableNumber);
        if (!MetadataUtils.isExist((String)midTableNumber)) {
            LOG.error("MiddleTableGenerateLogEditPlugin.showConfirmPage midTableNumber:{} is not exist", (Object)midTableNumber);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f13\u5b58\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u751f\u6210\u7f13\u5b58\u8868\u518d\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"MiddleTableGenerateLogEditPlugin_7", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        int totalCount = serviceHelper.count(midTableNumber, new QFilter[0]);
        int notDiscardCount = serviceHelper.count(midTableNumber, new QFilter[]{new QFilter(INIT_STATUS, "!=", (Object)INIT_STATUS_DISCARD)});
        if (totalCount == 0 || notDiscardCount == 0) {
            ConfirmCallBackListener effectEntryCallBackListener = new ConfirmCallBackListener("regenerate_field_confirm_1", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7f13\u5b58\u8868\u5b57\u6bb5\u548c\u5143\u6570\u636e\u5c06\u91cd\u65b0\u751f\u6210\uff0c\u91cd\u65b0\u751f\u6210\u540e\u518d\u5bfc\u5165\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MiddleTableGenerateLogEditPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, effectEntryCallBackListener);
            args.setCancel(true);
        }
        if ((successCount = serviceHelper.count(midTableNumber, new QFilter[]{new QFilter(INIT_STATUS, "in", Arrays.asList("D1", "E1"))})) > 0) {
            ConfirmCallBackListener confirmCallbackListener = new ConfirmCallBackListener("regenerate_field_confirm_2", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(2, ResManager.loadKDString((String)"\u6211\u5df2\u77e5\u6653", (String)"MiddleTableGenerateLogEditPlugin_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm("", ResManager.loadKDString((String)"\u7f13\u5b58\u8868\u5b57\u6bb5\u548c\u5143\u6570\u636e\u5c06\u91cd\u65b0\u751f\u6210\uff0c\u8bf7\u5148\u5c06\u521d\u59cb\u5316\u4efb\u52a1\u7f13\u5b58\u8868\u7684\u6570\u636e\u8bf7\u6539\u4e3a\u5e9f\u5f03\uff0c\u91cd\u65b0\u751f\u6210\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"MiddleTableGenerateLogEditPlugin_4", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, ConfirmTypes.Default, confirmCallbackListener, btnNameMaps);
            args.setCancel(true);
        }
        int notFinishSuccessCount = serviceHelper.count(midTableNumber, new QFilter[]{new QFilter(INIT_STATUS, "!=", (Object)INIT_STATUS_FINISH_SUCCESS)});
        int noSuccessCount = serviceHelper.count(midTableNumber, new QFilter[]{new QFilter(INIT_STATUS, "not in", Arrays.asList("D1", "E1"))});
        if (notFinishSuccessCount == 0 || noSuccessCount > 0) {
            ConfirmCallBackListener effectEntryCallBackListener = new ConfirmCallBackListener("regenerate_field_confirm_3", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7f13\u5b58\u8868\u5b57\u6bb5\u548c\u5143\u6570\u636e\u5c06\u91cd\u65b0\u751f\u6210 \uff0c\u7f13\u5b58\u8868\u5df2\u5bfc\u5165\u6570\u636e\u5c06\u4e0d\u53ef\u67e5\u8be2\uff0c\u5df2\u540c\u6b65\u4e1a\u52a1\u6570\u636e\u4e0d\u53d7\u5f71\u54cd\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MiddleTableGenerateLogEditPlugin_5", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, effectEntryCallBackListener);
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ((HRStringUtils.equals((String)callBackId, (String)"regenerate_field_confirm_1") || HRStringUtils.equals((String)callBackId, (String)"regenerate_field_confirm_3")) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Long templateId = (Long)formShowParameter.getCustomParam("templateId");
            String midTableNumber = (String)formShowParameter.getCustomParam("midTableNumber");
            Map metadataBoMap = iInitMetadataEntityService.getMetadataBoMap((Set)Sets.newHashSet((Object[])new String[]{midTableNumber}));
            for (Map.Entry entry : metadataBoMap.entrySet()) {
                iInitMetadataEntityService.deleteMetadata(((MetadataBo)entry.getValue()).getId(), "22/9TRQ536NA", "23X1H9WQ7S6U");
                LOG.info("metadata {} delete success", entry.getKey());
                this.dropTableByEntityNumber((String)entry.getKey());
            }
            Map map = this.initTemplateService.getGenerateFieldTemplateKey((List)ImmutableList.of((Object)templateId));
            DynamicObject dynamicObject = AsyncTaskServiceHelper.createTaskAndSave((Map)ImmutableMap.of((Object)"templateId", (Object)templateId, (Object)"generateKey", map.get(midTableNumber)), (String)midTableNumber, (String)ResManager.loadKDString((String)"\u91cd\u65b0\u751f\u6210\u7f13\u5b58\u5b57\u6bb5", (String)"MiddleTableGenerateLogEditPlugin_6", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), (Long)AsyncTaskSceneConstants.SCENE_MIDTABLE_GENERATE);
            AsyncTaskServiceHelper.startJob((long)dynamicObject.getLong("id"));
        }
    }

    private void dropTableByEntityNumber(String entityNumber) {
        TXHandleUtils.execNewTrans(() -> {
            StringBuilder entityTable = new StringBuilder("T_").append(entityNumber.toUpperCase(Locale.ROOT));
            TableUtils.dropTable((String)"hmp", (String)entityTable.toString());
            LOG.info("entity table delete success, table name = {}", (Object)entityTable);
            TableUtils.dropTable((String)"hmp", (String)("T_" + entityNumber.toUpperCase(Locale.ROOT) + "_L"));
            LOG.info("entity language table delete success, table name = {}_L", (Object)entityTable);
        });
    }

    private boolean validateFieldLength() {
        boolean success = true;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String midTableNumber = (String)formShowParameter.getCustomParam("midTableNumber");
        if (!MetadataUtils.isExist((String)midTableNumber)) {
            LOG.error("MiddleTableGenerateLogEditPlugin.validateFieldLength midTableNumber:{} is not exist", (Object)midTableNumber);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f13\u5b58\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u751f\u6210\u7f13\u5b58\u8868\u518d\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"MiddleTableGenerateLogEditPlugin_7", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection middleTableFieldCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject middleTableField : middleTableFieldCollection) {
            int targetFieldLength;
            String fieldName = middleTableField.getString("fieldname");
            int dbFieldLength = middleTableField.getInt("dbfieldlength");
            if (dbFieldLength > (targetFieldLength = middleTableField.getInt("targetfieldlength"))) {
                this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u201c\u4fee\u6539\u540e\u7684\u5b57\u6bb5\u957f\u5ea6\u201d\u4e0d\u80fd\u5c0f\u4e8e\u201c\u6570\u636e\u5e93\u5b57\u6bb5\u957f\u5ea6\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MiddleTableGenerateLogEditPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), fieldName));
                success = false;
            }
            if (targetFieldLength <= 2000) continue;
            this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c\u4fee\u6539\u540e\u7684\u5b57\u6bb5\u957f\u5ea6\u201d\u6700\u5927\u503c\u4e3a2000\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MiddleTableGenerateLogEditPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), fieldName));
            success = false;
        }
        return success;
    }

    private void showMiddleFieldTab() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String midTableNumber = (String)formShowParameter.getCustomParam("midTableNumber");
        if (StringUtils.isEmpty((CharSequence)midTableNumber)) {
            return;
        }
        if (!MetadataUtils.isExist((String)midTableNumber)) {
            LOG.error("MiddleTableGenerateLogEditPlugin.showMiddleFieldTab midTableNumber:{} is not exist", (Object)midTableNumber);
            return;
        }
        List<MiddleTableField> middleTableFieldInfoList = this.getMiddleTableFields(midTableNumber);
        String tableName = this.getTableName(midTableNumber);
        List columnInfoList = ColumnInfoReaderFactory.getReader((String)"hmp").read(this.getTableName(midTableNumber));
        List muliLangColumnInfoList = ColumnInfoReaderFactory.getReader((String)"hmp").read(tableName + "_l");
        columnInfoList.addAll(muliLangColumnInfoList);
        Map columnNameAndColumnMap = columnInfoList.stream().collect(Collectors.toMap(ColumnInfo::getName, Function.identity(), (x1, x2) -> x1));
        DynamicObjectCollection middleTableFieldCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        middleTableFieldCollection.clear();
        middleTableFieldInfoList.forEach(middleTableFieldInfo -> {
            ColumnInfo columnInfo = (ColumnInfo)columnNameAndColumnMap.get(middleTableFieldInfo.getColumnName());
            if (columnInfo != null) {
                DynamicObject row = middleTableFieldCollection.addNew();
                row.set("fieldname", (Object)middleTableFieldInfo.getFieldName());
                row.set("fieldnumber", (Object)middleTableFieldInfo.getFieldNumber());
                row.set("fieldtype", (Object)middleTableFieldInfo.getFieldType());
                row.set("columnname", (Object)columnInfo.getName());
                row.set("dbfieldlength", (Object)columnInfo.getLength());
                row.set("targetfieldlength", (Object)columnInfo.getLength());
                middleTableFieldInfo.setDbFieldLength(columnInfo.getLength());
            }
        });
        this.getView().updateView("entryentity");
    }

    private String getTableName(String midTableNumber) {
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)midTableNumber);
        return ((EntityType)mainEntityType.getAllEntities().get(midTableNumber)).getAlias();
    }

    private List<MiddleTableField> getMiddleTableFields(String midTableNumber) {
        List entityFieldItems = MetadataUtils.getEntityFieldItems((String)midTableNumber);
        ArrayList middleTableFieldInfoList = Lists.newArrayListWithExpectedSize((int)AppConstants.LIST_SIZE);
        entityFieldItems.forEach(field -> {
            if (!MiddleGenerateLogConstants.NOT_SUPPORT_MODIFY_COLUMN_SET.contains(field.getKey())) {
                if (field instanceof ComboField) {
                    middleTableFieldInfoList.add(new MiddleTableField(field.getName().getLocaleValue(), field.getKey(), ComboField.class.getSimpleName(), ((ComboField)field).getFieldName()));
                } else if (field instanceof MuliLangTextField) {
                    middleTableFieldInfoList.add(new MiddleTableField(field.getName().getLocaleValue(), field.getKey(), MuliLangTextField.class.getSimpleName(), ((MuliLangTextField)field).getFieldName()));
                } else if (field instanceof TextField) {
                    middleTableFieldInfoList.add(new MiddleTableField(field.getName().getLocaleValue(), field.getKey(), TextField.class.getSimpleName(), ((TextField)field).getFieldName()));
                }
            }
        });
        return middleTableFieldInfoList;
    }

    private void showMiddleTableTab() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String objNumber = (String)formShowParameter.getCustomParam("objnumber");
        Object templateId = formShowParameter.getCustomParam("templateId");
        String midTableNumber = (String)formShowParameter.getCustomParam("midTableNumber");
        ListShowParameter lsp = new ListShowParameter();
        lsp.setFormId(FormMetadataCache.getListFormConfig((String)"hric_asynctask_midlayout").getF7ListFormId());
        lsp.setBillFormId("hric_asynctask_midlayout");
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(this.getCusFilter(objNumber));
        lsp.setListFilterParameter(listFilterParameter);
        lsp.getCustomParams().put("templateId", templateId);
        lsp.getCustomParams().put("midTableNumber", midTableNumber);
        StyleCss css = new StyleCss();
        css.setWidth("890px");
        css.setHeight("610px");
        lsp.getOpenStyle().setInlineStyleCss(css);
        lsp.getOpenStyle().setClientShowType(ShowType.NewTabPage);
        lsp.getOpenStyle().setTargetKey(MIDDLE_TABLE_TAB);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private QFilter getCusFilter(String objNumber) {
        if (StringUtils.isEmpty((CharSequence)objNumber)) {
            return null;
        }
        return new QFilter("objnumber", "=", (Object)objNumber);
    }
}

