/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web.plan;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.common.bean.vo.PlanImplItemVO;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.util.QFilterUtils;
import kd.hrmp.hric.formplugin.web.InitPlanEditPlugin;
import kd.hrmp.hric.formplugin.web.plan.PlanFrontImplValidator;
import org.apache.commons.lang3.StringUtils;

public class InitPlanFrontImplHandle {
    private static Log LOG = LogFactory.getLog(InitPlanFrontImplHandle.class);
    private final IDataModel dataModel;
    private final IFormView formView;
    private final InitPlanEditPlugin plugin;
    private boolean cancelOp = false;

    public InitPlanFrontImplHandle(InitPlanEditPlugin plugin, IDataModel dataModel) {
        this.dataModel = dataModel;
        this.formView = plugin.getView();
        this.plugin = plugin;
    }

    public boolean doValidate() {
        this.checkFrontImplStartup();
        return this.cancelOp;
    }

    private void checkFrontImplStartup() {
        if (HRStringUtils.isNotEmpty((String)this.getAndRemoveConfirmCache())) {
            return;
        }
        List<PlanImplItemVO> implItemVOList = this.getFrontImplItem();
        List<PlanFrontImplValidator> validatorList = this.getFrontImplValidatorList(implItemVOList);
        LOG.debug("validatorList size is: {}", (Object)validatorList.size());
        Map<PlanImplItemVO, PlanFrontImplValidator> validatorMap = this.getPlanFrontImplValidator(validatorList, implItemVOList);
        this.validateFrontImplNonConfig(implItemVOList, validatorMap);
    }

    private String getAndRemoveConfirmCache() {
        String confirmed = this.plugin.getPageCache().get("startup_frontimpl_confirmed");
        this.plugin.getPageCache().remove("startup_frontimpl_confirmed");
        return confirmed;
    }

    private void validateFrontImplNonConfig(List<PlanImplItemVO> implItemVOList, Map<PlanImplItemVO, PlanFrontImplValidator> validatorMap) {
        StringBuilder sb = new StringBuilder();
        for (PlanImplItemVO planImplItemVO : implItemVOList) {
            List<String> params;
            PlanFrontImplValidator validator = validatorMap.get(planImplItemVO);
            if (Objects.isNull(validator)) continue;
            if (Objects.nonNull(validator) && !validator.validateFrontImplStarted() && validator.isCurrent() && validator.isSkip(planImplItemVO.getNumber())) {
                params = this.getParams(planImplItemVO);
                String tip_one = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u7684\u524d\u7f6e\u5b9e\u65bd\u9879%2$s\u672a\u914d\u7f6e", (String)"InitPlanFrontImplHandle_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), params.get(0), params.get(1));
                sb.append(tip_one);
                sb.append(",\n");
                continue;
            }
            if (!validator.isSkip(planImplItemVO.getNumber())) continue;
            params = this.getParams(planImplItemVO);
            params.add(validator.getDynamicObject().getLocaleString("name").getLocaleValue());
            params.add(planImplItemVO.getName());
            params.add(planImplItemVO.getImplItemName());
            params.add(planImplItemVO.getName());
            String tip_two = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u524d\u7f6e\u5b9e\u65bd\u9879\u201c%2$s\u201d\u6240\u5c5e\u8ba1\u5212\u201c%3$s\u201d\u5df2\u542f\u52a8,\u4f46\u672a\u914d\u7f6e\u5b9e\u65bd\u9879\u201c%4$s\u201d\uff0c\u6b64\u6b21\u201c%5$s\u201d\u5b9e\u65bd\u9879\u6267\u884c\u4efb\u52a1\u5c06\u4e0d\u4f9d\u8d56\u201c%6$s\u201d\u5b9e\u65bd\u9879\u6267\u884c\u4efb\u52a1", (String)"InitPlanFrontImplHandle_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), params.get(0), params.get(1), params.get(2), params.get(3), params.get(4), params.get(5));
            sb.append(tip_two);
            sb.append(",\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)sb)) {
            sb.append(ResManager.loadKDString((String)"\u662f\u5426\u7ee7\u7eed\u542f\u52a8\uff1f", (String)"InitPlanFrontImplHandle_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            ConfirmCallBackListener confirmListener = new ConfirmCallBackListener("startup", (IFormPlugin)this.plugin);
            this.getView().showConfirm(null, sb.toString(), MessageBoxOptions.OKCancel, null, confirmListener);
            this.cancelOperation();
        }
    }

    private List<String> getParams(PlanImplItemVO planImplItemVO) {
        ArrayList params = Lists.newArrayList();
        params.add(planImplItemVO.getImplItemName());
        params.add(planImplItemVO.getName());
        return params;
    }

    private Map<PlanImplItemVO, PlanFrontImplValidator> getPlanFrontImplValidator(List<PlanFrontImplValidator> validatorList, List<PlanImplItemVO> implItemVOList) {
        HashMap map = Maps.newHashMap();
        for (PlanImplItemVO planImplItemVO : implItemVOList) {
            for (PlanFrontImplValidator planFrontImplValidator : validatorList) {
                if (!planFrontImplValidator.existsImplItem(planImplItemVO.getNumber())) continue;
                map.put(planImplItemVO, planFrontImplValidator);
            }
        }
        return map;
    }

    private List<PlanFrontImplValidator> getFrontImplValidatorList(List<PlanImplItemVO> implItemVOList) {
        Map implItemVOMap = implItemVOList.stream().collect(Collectors.toMap(PlanImplItemVO::getNumber, Function.identity(), (v1, v2) -> v1));
        String structNumber = this.dataModel.getDataEntity(true).getString("structnumber");
        List structNumberList = Splitter.on((String)"!").trimResults().splitToList((CharSequence)structNumber);
        if (CollectionUtils.isEmpty((Collection)structNumberList)) {
            throw new KDBizException("Struct long number should not be empty");
        }
        String rootStructNumber = (String)structNumberList.get(0);
        QFilter rootStructNumberFilter = new QFilter("structnumber", "like", (Object)(rootStructNumber + "%"));
        QFilter configModeFilter = new QFilter("configmode", "in", (Object)AppConstants.CONFIG_MODE_LIST);
        QFilter subAreaFilter = new QFilter("bizsubarea.fbasedataid.number", "in", implItemVOList.stream().map(it -> it.getSubArea()).collect(Collectors.toSet()));
        QFilter idFilter = new QFilter("id", "<>", (Object)this.dataModel.getDataEntity(true).getLong("id"));
        DynamicObject[] dynamicObjects = new HRBaseServiceHelper("hric_initplan").query("id,number,planstatus,planperson,bizsubarea,itementryentity.implitem,itementryentity.isskip", configModeFilter.and(subAreaFilter).and(rootStructNumberFilter).and(idFilter).toArray());
        List<PlanFrontImplValidator> validatorList = Stream.of(dynamicObjects).map(it -> new PlanFrontImplValidator((DynamicObject)it, false)).collect(Collectors.toList());
        validatorList.add(new PlanFrontImplValidator(this.dataModel.getDataEntity(true), true));
        return validatorList;
    }

    private List<PlanImplItemVO> getFrontImplItem() {
        DynamicObject dyc = this.dataModel.getDataEntity(true);
        DynamicObjectCollection docs = dyc.getDynamicObjectCollection("itementryentity");
        ArrayList idList = Lists.newArrayList();
        HashMap idNameMap = Maps.newHashMap();
        docs.forEach(it -> {
            if (it.getBoolean("isskip")) {
                return;
            }
            String implItemName = it.getLocaleString("itemname").getLocaleValue();
            DynamicObjectCollection implEntry = it.getDynamicObjectCollection("mulfrontimpl");
            idList.addAll(implEntry.stream().map(impl -> impl.getLong("fbasedataid_id")).collect(Collectors.toList()));
            implEntry.stream().forEach(impl -> idNameMap.put(impl.getLong("fbasedataid_id"), implItemName));
        });
        DynamicObject[] implItemArray = new HRBaseServiceHelper("hric_implitem").query("id,number,bizsubarea", QFilterUtils.getIdInFilter((List)idList).toArray());
        return Stream.of(implItemArray).map(it -> new PlanImplItemVO(Long.valueOf(it.getLong("id")), it.getString("number"), it.getLocaleString("name").getLocaleValue(), it.getDynamicObject("bizsubarea").getString("number"), (String)idNameMap.get(it.getLong("id")))).collect(Collectors.toList());
    }

    public IDataModel getModel() {
        return this.dataModel;
    }

    public IFormView getView() {
        return this.formView;
    }

    public void cancelOperation() {
        this.cancelOp = true;
    }
}

