/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web.plan;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PlanFrontImplValidator {
    private static Log LOG = LogFactory.getLog(PlanFrontImplValidator.class);
    private static final List<String> RIGHT_STATUS_LIST = ImmutableList.of((Object)"B", (Object)"C");
    private DynamicObject dynamicObject;
    private String planStatus;
    private List<String> implItemNumberList;
    private Set<String> skipImplItemNumberSet;
    private boolean current;

    public PlanFrontImplValidator(DynamicObject dynamicObject, boolean current) {
        this.dynamicObject = dynamicObject;
        this.planStatus = dynamicObject.getString("planstatus");
        this.implItemNumberList = this.getImplItemNumber(dynamicObject);
        this.skipImplItemNumberSet = this.getSkipImplItemNumber(dynamicObject);
        this.current = current;
        if (current) {
            this.addRemovedImplItem(dynamicObject);
        }
    }

    private List<String> getImplItemNumber(DynamicObject dynamicObject) {
        return dynamicObject.getDynamicObjectCollection("itementryentity").stream().map(it -> it.getDynamicObject("implitem")).filter(Objects::nonNull).map(it -> it.getString("number")).collect(Collectors.toList());
    }

    private Set<String> getSkipImplItemNumber(DynamicObject dynamicObject) {
        return dynamicObject.getDynamicObjectCollection("itementryentity").stream().filter(it -> it.getBoolean("isskip")).map(it -> it.getDynamicObject("implitem")).filter(Objects::nonNull).map(it -> it.getString("number")).collect(Collectors.toSet());
    }

    private void addRemovedImplItem(DynamicObject dynamicObject) {
        List frontItemList = dynamicObject.getDynamicObjectCollection("itementryentity").stream().map(it -> it.getDynamicObject("implitem")).filter(Objects::nonNull).map(it -> it.getDynamicObjectCollection("mulfrontimpl")).flatMap(Collection::stream).filter(Objects::nonNull).map(it -> it.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(it -> it.getString("number")).filter(it -> !this.implItemNumberList.contains(it)).collect(Collectors.toList());
    }

    public boolean validateFrontImplStarted() {
        return RIGHT_STATUS_LIST.contains(this.planStatus);
    }

    public boolean existsImplItem(String number) {
        return this.implItemNumberList.contains(number);
    }

    public boolean isSkip(String number) {
        return this.skipImplItemNumberSet.contains(number);
    }

    public DynamicObject getDynamicObject() {
        return this.dynamicObject;
    }

    public boolean isCurrent() {
        return this.current;
    }
}

