/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web.plantree;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.RaiseEventType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.rule.RaiseEventSource;
import kd.bos.entity.rule.RuleContainer;
import kd.bos.entity.rule.RuleExecuteContext;
import kd.bos.form.BindingContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.gridconfig.GridConfigRenderUtils;
import kd.bos.form.rule.FormRuleExecuteContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.hrmp.hric.bussiness.service.InitPlanServiceHelper;
import kd.hrmp.hric.bussiness.service.RPCServiceHelper;
import kd.hrmp.hric.common.util.ConvertUtils;

public class HricCustomTreeEntryGrid
extends TreeEntryGrid {
    private static Log LOG = LogFactory.getLog(HricCustomTreeEntryGrid.class);
    private static final String FIRST_PLANS = "firstPlans";
    private static final String SON_PLANS = "sonPlans";
    public static String KEY_LIST_ENTRYENTITY = "treeentryentity";
    private DynamicObjectCollection planAndSonPlanCol = new DynamicObjectCollection();
    private List<Map<String, List<DynamicObject>>> qualifiedData = new ArrayList<Map<String, List<DynamicObject>>>();
    private DynamicObject[] allPlan;
    private QFilter listQFilters;

    public void setListQFilters(QFilter listQFilters) {
        this.listQFilters = listQFilters;
    }

    public boolean isNeedPaged() {
        return true;
    }

    public void bindData(BindingContext bctx) {
        GridConfigRenderUtils.renderGridConfig((IFormView)this.getView(), (String)this.getEntryKey());
        try (TraceSpan span = Tracer.create((String)"CustomTreeEntryGrid", (String)"bindData");){
            this.treeEntryGridBindPageData();
        }
    }

    public void treeEntryGridBindPageData() {
        AbstractGrid.GridState entryState = this.getEntryState();
        int startIndex = 0;
        int endIndex = 0;
        int rowCount = this.getRowCount();
        int pageCount = 0;
        if (this.isNeedPaged()) {
            int pageShowRows = entryState.getPageRows();
            int currPageIndex = entryState.getCurrentPageIndex();
            pageCount = rowCount / pageShowRows + (rowCount % pageShowRows > 0 ? 1 : 0);
            if (pageCount == 0) {
                pageCount = 1;
            }
            if (currPageIndex < 1) {
                entryState.setCurrentPageIndex(Integer.valueOf(1));
            } else if (currPageIndex > pageCount) {
                entryState.setCurrentPageIndex(Integer.valueOf(pageCount));
            }
            startIndex = (currPageIndex - 1) * pageShowRows;
            endIndex = Math.min(startIndex + this.getPageRow(), rowCount);
        } else {
            endIndex = rowCount;
        }
        ArrayList<Object> rows = new ArrayList<Object>();
        ArrayList<RowDataEntity> objs = new ArrayList<RowDataEntity>();
        Object[] dataEntitys = this.getEntryDataEntities(startIndex, endIndex);
        if (!ObjectUtils.isEmpty((Object[])dataEntitys)) {
            this.handleEntryData(objs, rows, (DynamicObject[])dataEntitys);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("rowcount", rowCount);
        data.put("rows", rows);
        data.put("pagerows", entryState.getPageRows());
        data.put("pageindex", entryState.getCurrentPageIndex());
        data.put("isSplitPage", true);
        data.put("phide", !this.isNeedPaged());
        data.put("pagecount", pageCount);
        data.put("datacount", rowCount);
        data.put("dataindex", this.getDataIndex());
        this.fireBindEntryGridDataEvent(objs, data, startIndex);
        IDataEntityProperty property = this.getModel().getProperty(this.getEntryKey());
        if (property instanceof SubEntryProp) {
            data.put("pr", this.getModel().getEntryCurrentRowIndex(property.getParent().getName()));
        }
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        proxy.setEntryProperty(this.getKey(), "data", data);
        this.selectRows(-1);
    }

    private void handleEntryData(List<RowDataEntity> objs, List<Object> rows, DynamicObject[] dataEntitys) {
        EntityType entityType = (EntityType)this.getModel().getDataEntityType().getAllEntities().get(KEY_LIST_ENTRYENTITY);
        int totalTasksCnt = this.queryTreeNodeChildren(dataEntitys);
        this.getModel().getDataEntity(true);
        this.getModel().getDataEntity().getDynamicObjectCollection(KEY_LIST_ENTRYENTITY).clear();
        this.getModel().getDataEntity().getDynamicObjectCollection(KEY_LIST_ENTRYENTITY).addAll((Collection)this.planAndSonPlanCol);
        this.getModel().getDataEntity().getDynamicObjectCollection(KEY_LIST_ENTRYENTITY).setStartRowIndex(0);
        for (int i = 0; i < totalTasksCnt; ++i) {
            objs.add(new RowDataEntity(i, (DynamicObject)this.planAndSonPlanCol.get(i)));
        }
        if (this.getRuleCount() > 0) {
            RuleContainer ruleContainer = (RuleContainer)this.getView().getService(RuleContainer.class);
            ruleContainer.raise(new RaiseEventSource(RaiseEventType.Initialized, objs, (IDataEntityType)entityType), (RuleExecuteContext)new FormRuleExecuteContext(this.getView()));
        }
        objs.forEach(rowDataEntity -> {
            BindingContext bindCtx = new BindingContext((IDataEntityType)entityType, rowDataEntity.getDataEntity(), rowDataEntity.getRowIndex());
            rows.add(this.getRowBindValue(bindCtx));
        });
    }

    public int getQualifiedData(AbstractGrid.GridState entryState) {
        int pageShowRows = entryState.getPageRows();
        this.allPlan = InitPlanServiceHelper.getAllPlans();
        if (ObjectUtils.isEmpty((Object[])this.allPlan)) {
            return 0;
        }
        QFilter dataRuleFilter = null;
        try {
            dataRuleFilter = RPCServiceHelper.getInitPlanDataRuleQFilter();
        }
        catch (Exception e) {
            LOG.error("[HRIC] Call RPC IHRCSDataPermissionService-getDataRule", (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u83b7\u53d6\u51fa\u9519\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HricCustomTreeEntryGrid_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return 0;
        }
        if (dataRuleFilter != null) {
            List dataRuleMatchingDataList = InitPlanServiceHelper.getAllPlansWithDataRule((QFilter)(this.listQFilters == null ? dataRuleFilter : dataRuleFilter.and(this.listQFilters)));
            if (CollectionUtils.isEmpty((Collection)dataRuleMatchingDataList)) {
                return 0;
            }
            return this.structQualifiedData(pageShowRows, dataRuleMatchingDataList);
        }
        if (this.listQFilters == null) {
            return this.structQualifiedData(pageShowRows, InitPlanServiceHelper.getFirstPlans((DynamicObject[])this.allPlan));
        }
        DynamicObject[] plans = InitPlanServiceHelper.getPlanByListQFilter((QFilter)this.listQFilters);
        return this.structQualifiedData(pageShowRows, InitPlanServiceHelper.getFirstPlans((DynamicObject[])plans));
    }

    private int structQualifiedData(int pageShowRows, List<DynamicObject> firstPlans) {
        if (CollectionUtils.isEmpty(firstPlans)) {
            return 0;
        }
        Collections.sort(firstPlans, (o1, o2) -> o2.getDate("createtime").compareTo(o1.getDate("createtime")));
        List firstPlanPartition = Lists.partition(firstPlans, (int)pageShowRows);
        firstPlanPartition.forEach(it -> {
            HashMap<String, List> pageDataMap = new HashMap<String, List>();
            pageDataMap.put(FIRST_PLANS, (List)it);
            ArrayList sonPlans = new ArrayList();
            it.forEach(data -> this.getSonPlan((DynamicObject)data, sonPlans));
            pageDataMap.put(SON_PLANS, sonPlans);
            this.qualifiedData.add(pageDataMap);
        });
        return firstPlans.size();
    }

    private int queryTreeNodeChildren(DynamicObject[] dys) {
        List plans = ConvertUtils.transferArrayToList((Object[])dys);
        int currentPageIndex = this.getEntryState().getCurrentPageIndex();
        Object[] sonPlans = this.qualifiedData.get(currentPageIndex - 1).get(SON_PLANS).toArray(new DynamicObject[0]);
        if (!ObjectUtils.isEmpty((Object[])sonPlans)) {
            List sonPlanIds = Arrays.stream(sonPlans).map(plan -> plan.getLong("id")).collect(Collectors.toList());
            Object[] sonPlanDys = InitPlanServiceHelper.getPlansByIdList(sonPlanIds);
            plans.addAll(ConvertUtils.transferArrayToList((Object[])sonPlanDys));
        }
        DynamicObjectCollection treeEntity = this.getModel().getEntryEntity(KEY_LIST_ENTRYENTITY);
        plans.forEach(plan -> {
            DynamicObject dyc = new DynamicObject(treeEntity.getDynamicObjectType());
            dyc.set("id", (Object)plan.getLong("id"));
            DynamicObject parentdyc = plan.getDynamicObject("parent");
            dyc.set("pid", (Object)(parentdyc == null ? 0L : parentdyc.getLong("id")));
            dyc.set("name", (Object)plan.getString("name"));
            dyc.set("number", (Object)plan.getString("number"));
            dyc.set("parent", (Object)parentdyc);
            dyc.set("group", (Object)plan.getDynamicObjectCollection("group"));
            dyc.set("bizsubarea", (Object)plan.getDynamicObjectCollection("bizsubarea"));
            dyc.set("startdate", (Object)plan.getDate("startdate"));
            dyc.set("enddate", (Object)plan.getDate("enddate"));
            dyc.set("actualenddate", (Object)plan.getDate("actualenddate"));
            dyc.set("planperson", (Object)plan.getDynamicObject("planperson"));
            dyc.set("planstatus", (Object)plan.getString("planstatus"));
            dyc.set("datarange", (Object)plan.getLocaleString("datarange").getLocaleValue());
            dyc.set("creator", (Object)plan.getDynamicObject("creator"));
            dyc.set("createtime", (Object)plan.getDate("createtime"));
            dyc.set("sourcesystem", (Object)plan.getDynamicObject("sourcesystem"));
            dyc.set("initfinish", (Object)plan.getString("initfinish"));
            dyc.set("industrytype", (Object)plan.getDynamicObject("industrytype"));
            this.planAndSonPlanCol.add((Object)dyc);
        });
        return plans.size();
    }

    private void getSonPlan(DynamicObject data, List<DynamicObject> allSonPlans) {
        List<DynamicObject> sonPlans = this.getSonPlansWithParentId(data.getLong("id"), this.allPlan);
        sonPlans.forEach(plan -> this.getSonPlan((DynamicObject)plan, allSonPlans));
        if (!CollectionUtils.isEmpty(sonPlans)) {
            allSonPlans.addAll(sonPlans);
        }
    }

    private List<DynamicObject> getSonPlansWithParentId(Long id, DynamicObject[] dys) {
        List<DynamicObject> sonPlanList = Arrays.stream(dys).filter(dyc -> {
            DynamicObject parent = dyc.getDynamicObject("parent");
            if (parent == null) {
                return false;
            }
            return parent.getLong("id") == id.longValue();
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sonPlanList)) {
            return new ArrayList<DynamicObject>();
        }
        return sonPlanList;
    }

    protected int getRowCount() {
        return this.getQualifiedData(this.getEntryState());
    }

    protected DynamicObject[] getEntryDataEntities(int startIndex, int endIndex) {
        int currentPageIndex = this.getEntryState().getCurrentPageIndex();
        if (CollectionUtils.isEmpty(this.qualifiedData)) {
            return new DynamicObject[0];
        }
        DynamicObject[] firstPlans = this.qualifiedData.get(currentPageIndex - 1).get(FIRST_PLANS).toArray(new DynamicObject[0]);
        List firstPlanIds = Arrays.stream(firstPlans).map(plan -> plan.getLong("id")).collect(Collectors.toList());
        Object[] firstPlanDys = InitPlanServiceHelper.getPlansByIdList(firstPlanIds);
        List dys = ConvertUtils.transferArrayToList((Object[])firstPlanDys);
        Collections.sort(dys, (o1, o2) -> o2.getDate("createtime").compareTo(o1.getDate("createtime")));
        return dys.toArray(new DynamicObject[0]);
    }

    public void setPageIndex(int pageIndex) {
        AbstractGrid.GridState entryState = this.getEntryState();
        entryState.setCurrentPageIndex(Integer.valueOf(pageIndex));
        this.treeEntryGridBindPageData();
    }

    public void setPageRows(int rows) {
        AbstractGrid.GridState entryState = this.getEntryState();
        entryState.setPageRows(rows);
        this.treeEntryGridBindPageData();
    }
}

