/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web.plantree;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IImplItemEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IPTplPlanEntityService;
import kd.hrmp.hric.bussiness.domain.init.ICooperativeDomainService;
import kd.hrmp.hric.bussiness.domain.init.IInitPlanDomainService;
import kd.hrmp.hric.bussiness.domain.init.IPlanTemplateDomainService;
import kd.hrmp.hric.common.bean.FormPluginResponse;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.constants.InitTempAddPlanConstants;
import kd.hrmp.hric.common.constants.msg.PlanMsgEnum;
import kd.hrmp.hric.common.util.HricDynamicObjectUtils;
import kd.hrmp.hric.common.util.QFilterUtils;
import kd.hrmp.hric.common.util.ShowMessagegUtils;
import kd.hrmp.hric.formplugin.web.util.ImplItemFormUtils;
import kd.hrmp.hric.formplugin.web.util.InitPlanFormUtils;

public class InitTempAddPlanEditPlugin
extends HRDataBaseEdit
implements TreeNodeCheckListener,
BeforeF7SelectListener,
HyperLinkClickListener {
    private Map<String, DynamicObject> cacheInitPlanMap = new HashMap<String, DynamicObject>();
    private static final String STARTUP = "startup";
    private static final String SEARCHAP = "searchap";
    private static final String CACHE_ROOTNODEID = "rootNodeId";
    private static final String CACHE_INIT_PLAN = "cacheInitPlan";
    private static final String CACHE_LASTTIME_SELECT_NODE_ID = "cache_lasttime_select_node_id";
    private static final String CACHE_CURRENT_NODE_ID = "cache_current_node_id";
    private static final String CACHE_PLAN_TEMP_ARR = "cache_plan_temp_arr";
    private static final String PLAN_INFO_PANEL = "planinfopanel";
    private static final String ADD_IMPLITEM_FIELDS = "name,number,impltype,implsubtype,group,bizsubarea,entityobjscope,usescene,mulfrontimpl,isinitlog,baseimplentry.implitem";
    private static final Set<String> ENTRY_BTN = ImmutableSet.of((Object)"ebatchdivideexecute", (Object)"ebatchdividevalidate", (Object)"ebatchopenvalidate", (Object)"ebatchclosevalidate");
    private static final List<String> HIDE_BTN_LIST = ImmutableList.of((Object)"batchdividevalidate", (Object)"batchopenvalidate", (Object)"batchclosevalidate", (Object)"ebatchdividevalidate", (Object)"ebatchopenvalidate", (Object)"ebatchclosevalidate");
    IPTplPlanEntityService ipTplPlanEntityService = (IPTplPlanEntityService)ServiceFactory.getService(IPTplPlanEntityService.class);
    IImplItemEntityService implItemEntityService = (IImplItemEntityService)ServiceFactory.getService(IImplItemEntityService.class);
    IInitPlanDomainService iInitPlanDomainService = (IInitPlanDomainService)ServiceFactory.getService(IInitPlanDomainService.class);
    IPlanTemplateDomainService iPlanTemplateDomainService = (IPlanTemplateDomainService)ServiceFactory.getService(IPlanTemplateDomainService.class);
    ICooperativeDomainService iSystemParamDomainService = (ICooperativeDomainService)ServiceFactory.getService(ICooperativeDomainService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label deployLabel = (Label)this.getControl("deployintegration");
        deployLabel.addClickListener((ClickListener)this);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        ((Search)this.getControl(SEARCHAP)).addEnterListener(see -> this.updatePlanTree(see.getText()));
        BasedataEdit sourceSystemEdit = (BasedataEdit)this.getControl("sourcesystem");
        sourceSystemEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entry = (EntryGrid)this.getView().getControl("entryentity");
        entry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String pkid = this.getView().getFormShowParameter().getCustomParams().get("pkid").toString();
        boolean isSaveSuccess = this.iPlanTemplateDomainService.savePTplByBaseId(Long.valueOf(Long.parseLong(pkid)));
        if (!isSaveSuccess) {
            this.getView().showErrorNotification(PlanMsgEnum.PLAN_TEMP_SAVE_ERROR_MSG.get());
            this.getView().setEnable(Boolean.FALSE, InitTempAddPlanConstants.BTN_LIST.toArray(new String[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"tippanel"});
            return;
        }
        this.handleCollaborationMode();
        DynamicObject dyc = this.ipTplPlanEntityService.queryStructNumberById(Long.valueOf(Long.parseLong(pkid)));
        if (dyc == null) {
            return;
        }
        DynamicObject[] dys = this.ipTplPlanEntityService.queryByStructNumber(dyc.getString("structnumber"));
        if (dys.length == 0) {
            return;
        }
        this.getPageCache().put(CACHE_PLAN_TEMP_ARR, SerializationUtils.serializeToBase64((Object)dys));
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addNode(this.iInitPlanDomainService.initTree(pkid, dys, this.cacheInitPlanMap, true));
        this.initTreeConfigure(treeView);
        this.getPageCache().put(CACHE_LASTTIME_SELECT_NODE_ID, pkid);
        this.getPageCache().put(CACHE_CURRENT_NODE_ID, pkid);
        this.getPageCache().put(CACHE_ROOTNODEID, pkid);
        this.insertOrUpdateCacheInitPlanMap(this.cacheInitPlanMap);
        this.initInterfacePlanInfo(this.cacheInitPlanMap.get(pkid));
        this.handleCodeRule(this.cacheInitPlanMap.get(pkid));
    }

    private void handleCollaborationMode() {
        boolean collaborationMode = this.iSystemParamDomainService.getParameterBoolean();
        if (!collaborationMode) {
            InitPlanFormUtils.handleCollaborationMode(this.getView(), HIDE_BTN_LIST);
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        String nodeId = evt.getNodeId().toString();
        this.getPageCache().put(CACHE_CURRENT_NODE_ID, nodeId);
        String lastTimeSelectNodeId = this.getPageCache().get(CACHE_LASTTIME_SELECT_NODE_ID);
        if (HRStringUtils.equals((String)nodeId, (String)lastTimeSelectNodeId)) {
            return;
        }
        this.getPageCache().put(CACHE_LASTTIME_SELECT_NODE_ID, nodeId);
        this.stagingInitInfo(lastTimeSelectNodeId);
        this.initInterfacePlanInfo(this.getCacheInitPlanMap().get(nodeId));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        this.stagingInitInfo(this.getView().getPageCache().get(CACHE_CURRENT_NODE_ID));
        switch (args.getOperateKey()) {
            case "add": {
                this.showF7Base("hric_implitem", "add");
                break;
            }
            case "skip": {
                this.skip();
                break;
            }
            case "cancelskip": {
                if (((EntryGrid)this.getView().getControl("entryentity")).getSelectRows().length == 0) {
                    this.getView().showTipNotification(PlanMsgEnum.NO_SELECT_MSG.getMsg());
                    return;
                }
                this.cancelSkip(false);
                break;
            }
            case "batchdivideexecute": {
                this.batchHandleBtn("batchdivideexecute");
                break;
            }
            case "ebatchdivideexecute": {
                this.batchHandleBtn("ebatchdivideexecute");
                break;
            }
            case "batchdividevalidate": {
                this.batchHandleBtn("batchdividevalidate");
                break;
            }
            case "ebatchdividevalidate": {
                this.batchHandleBtn("ebatchdividevalidate");
                break;
            }
            case "batchopenvalidate": {
                this.batchHandleBtn("batchopenvalidate");
                break;
            }
            case "batchclosevalidate": {
                this.batchHandleBtn("batchclosevalidate");
                break;
            }
            case "ebatchopenvalidate": {
                this.batchHandleBtn("ebatchopenvalidate");
                break;
            }
            case "ebatchclosevalidate": {
                this.batchHandleBtn("ebatchclosevalidate");
                break;
            }
            case "divideplanleader": {
                this.batchHandleBtn("divideplanleader");
                break;
            }
        }
    }

    private void skip() {
        int[] selectRows = ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(PlanMsgEnum.NO_SELECT_MSG.getMsg());
            return;
        }
        this.stagingInitInfo(this.getPageCache().get(CACHE_CURRENT_NODE_ID));
        Map<String, DynamicObject> cacheInitPlanMap = this.getCacheInitPlanMap();
        FormPluginResponse resp = this.iInitPlanDomainService.validateSkipImplItem(cacheInitPlanMap.get(this.getPageCache().get(CACHE_CURRENT_NODE_ID)), selectRows, cacheInitPlanMap);
        if (resp.isPass()) {
            this.openComfirmPage();
        } else if (resp.isMandatoryValidate()) {
            ShowMessagegUtils.showMessage((String)resp.getTitle(), (String)resp.getContext(), (IFormView)this.getView(), (MessageTypes)MessageTypes.Default, (ConfirmCallBackListener)new ConfirmCallBackListener("skipConfirmForBatch", (IFormPlugin)this));
        } else {
            this.getView().showConfirm(resp.getTitle(), resp.getContext(), resp.getMsgType(), resp.getConfirmTypes(), new ConfirmCallBackListener("skipConfirmForBatch", (IFormPlugin)this));
        }
    }

    private void openComfirmPage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hric_skipconfirm");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "skipConfirmForBatch"));
        this.getView().showForm(parameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (HRStringUtils.equals((String)"skipConfirmForBatch", (String)evt.getCallBackId())) {
            if (evt.getResult() == MessageBoxResult.Yes) {
                this.openComfirmPage();
            }
        } else if (HRStringUtils.equals((String)"skipConfirmForSingle", (String)evt.getCallBackId())) {
            if (evt.getResult() == MessageBoxResult.Yes) {
                this.openComfirmPage();
            } else {
                this.entryCancelSkipHandle();
            }
        }
    }

    private void entryCancelSkipHandle() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        this.getModel().beginInit();
        this.getModel().setValue("isskip", (Object)0, entryCurrentRowIndex);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void cancelSkip(boolean isEntry) {
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = grid.getSelectRows();
        this.getModel().beginInit();
        Arrays.stream(selectRows).forEach(rowIndex -> {
            Boolean isSkip = (Boolean)this.getModel().getValue("isskip", rowIndex);
            if (isEntry) {
                isSkip = isSkip == false;
            }
            if (!isSkip.booleanValue()) {
                return;
            }
            this.getModel().setValue("skipreason", null, rowIndex);
            this.getModel().setValue("isskip", (Object)0, rowIndex);
            this.getModel().setValue("verifyperson", null, rowIndex);
            this.getModel().setValue("executeperson", null, rowIndex);
            this.getModel().setValue("isdataverify", (Object)false, rowIndex);
        });
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        if (HRStringUtils.equals((String)evt.getActionId(), (String)"divideplanleader")) {
            this.updatePlanLeader(this.iInitPlanDomainService.getF7SelectUserId(evt));
        } else if (HRStringUtils.equals((String)evt.getActionId(), (String)"batchdivideexecute")) {
            this.batchHandleUser(this.iInitPlanDomainService.getF7SelectUserId(evt), "executeperson");
        } else if (HRStringUtils.equals((String)evt.getActionId(), (String)"ebatchdivideexecute")) {
            this.batchHandleUserWithEntry(this.iInitPlanDomainService.getF7SelectUserId(evt), "executeperson");
        } else if (HRStringUtils.equals((String)evt.getActionId(), (String)"batchdividevalidate")) {
            this.batchHandleUser(this.iInitPlanDomainService.getF7SelectUserId(evt), "verifyperson");
        } else if (HRStringUtils.equals((String)evt.getActionId(), (String)"ebatchdividevalidate")) {
            this.batchHandleUserWithEntry(this.iInitPlanDomainService.getF7SelectUserId(evt), "verifyperson");
        } else if (HRStringUtils.equals((String)evt.getActionId(), (String)"add")) {
            this.addImplItem(this.iInitPlanDomainService.getF7SelectUserId(evt));
        } else if (HRStringUtils.equals((String)evt.getActionId(), (String)"skipConfirmForBatch")) {
            Object returnData = evt.getReturnData();
            this.entryOperationSkip(returnData);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)formOperate.getOperateKey(), (String)STARTUP) && this.doCheck()) {
            this.doStartUp();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldName = Optional.ofNullable(evt).map(BeforeF7SelectEvent::getProperty).map(IMetadata::getName).orElse(null);
        if (HRStringUtils.equals((String)fieldName, (String)"sourcesystem")) {
            ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setOrderBy("index");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        Object implItem = this.getModel().getValue("implitem", evt.getRowIndex());
        if (implItem instanceof DynamicObject) {
            Long pkValue = (Long)((DynamicObject)implItem).getPkValue();
            ImplItemFormUtils.showImplItemForm(this.getView(), pkValue, OperationStatus.VIEW, null);
        }
    }

    public void click(EventObject e) {
        super.click(e);
        String controlKey = "";
        Object source = e.getSource();
        if (source instanceof Control) {
            controlKey = ((Control)source).getKey();
        }
        if (HRStringUtils.equals((String)"deployintegration", (String)controlKey)) {
            OpenPageUtils.openMenu((IFormView)this.getView(), (String)"1307812164626595840", (String)"TV3/VDJ86RC", null);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        parentView.invokeOperation("refresh");
        this.getView().sendFormAction(parentView);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeFieldName;
        switch (changeFieldName = Optional.ofNullable(e).map(PropertyChangedArgs::getProperty).map(IMetadata::getName).orElse("")) {
            case "startdate": {
                this.dateCheck("startdate");
                break;
            }
            case "enddate": {
                this.dateCheck("enddate");
                break;
            }
            case "name": {
                if (!this.nameUniqueCheck(e)) break;
                this.reInitTree();
                break;
            }
            case "isdataverify": {
                this.handleDataVerify();
                break;
            }
            case "isskip": {
                this.entryIsSkipHandle();
                break;
            }
            case "sourcesystem": {
                this.updatePlanSourceSystemOrIndustry("sourcesystem");
            }
        }
    }

    private void updatePlanSourceSystemOrIndustry(String field) {
        Integer layer = (Integer)this.getModel().getValue("layer");
        if (layer != 1) {
            return;
        }
        Map<String, DynamicObject> cacheInitPlanMap = this.getCacheInitPlanMap();
        cacheInitPlanMap.values().forEach(plan -> plan.set(field, this.getModel().getValue(field)));
        this.insertOrUpdateCacheInitPlanMap(cacheInitPlanMap);
    }

    public void entryOperationSkip(Object returnData) {
        if (returnData instanceof Boolean || returnData == null) {
            return;
        }
        this.skipEntryUpdate(true, returnData);
    }

    private void entryIsSkipHandle() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        grid.selectRows(entryCurrentRowIndex);
        boolean isSkip = (Boolean)this.getModel().getValue("isskip", entryCurrentRowIndex);
        if (isSkip) {
            this.stagingInitInfo(this.getPageCache().get(CACHE_CURRENT_NODE_ID));
            Map<String, DynamicObject> cacheInitPlanMap = this.getCacheInitPlanMap();
            FormPluginResponse resp = this.iInitPlanDomainService.validateSkipImplItem(this.getCacheInitPlanMap().get(this.getPageCache().get(CACHE_CURRENT_NODE_ID)), grid.getSelectRows(), cacheInitPlanMap);
            if (resp.isPass()) {
                this.skipEntryUpdate(false, null);
            } else if (resp.isMandatoryValidate()) {
                ShowMessagegUtils.showMessage((String)resp.getTitle(), (String)resp.getContext(), (IFormView)this.getView(), (MessageTypes)MessageTypes.Default, (ConfirmCallBackListener)new ConfirmCallBackListener("skipConfirmForSingle", (IFormPlugin)this));
            } else {
                this.getView().showConfirm(resp.getTitle(), resp.getContext(), resp.getMsgType(), resp.getConfirmTypes(), new ConfirmCallBackListener("skipConfirmForSingle", (IFormPlugin)this));
            }
        } else {
            this.cancelSkip(true);
        }
    }

    private void skipEntryUpdate(boolean isBatch, Object returnData) {
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = grid.getSelectRows();
        this.getModel().beginInit();
        Arrays.stream(selectRows).forEach(rowIndex -> {
            IDataModel model = this.getModel();
            if (isBatch) {
                model.setValue("skipreason", returnData, rowIndex);
            }
            model.setValue("isskip", (Object)1, rowIndex);
            model.setValue("executeperson", null, rowIndex);
            model.setValue("verifyperson", null, rowIndex);
            model.setValue("isdataverify", (Object)"0", rowIndex);
        });
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void addImplItem(List<Long> idList) {
        DynamicObject[] implItemDys = this.implItemEntityService.queryImplItemsByIdList(ADD_IMPLITEM_FIELDS, idList);
        if (implItemDys.length <= 0) {
            return;
        }
        int entryCount = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").size();
        this.getModel().beginInit();
        this.getModel().batchCreateNewEntryRow("entryentity", null, implItemDys.length);
        this.getModel().endInit();
        Set currMaterPlanImplItems = this.iInitPlanDomainService.getCurrMaterPlanImplItemIdSet(this.getCacheInitPlanMap());
        for (int index = 0; index < implItemDys.length; ++index) {
            this.getModel().setValue("implitem", (Object)implItemDys[index], entryCount + index);
            this.getModel().setValue("itemname", (Object)implItemDys[index].getString("name"), entryCount + index);
            this.getModel().setValue("impltype", (Object)implItemDys[index].getString("impltype"), entryCount + index);
            this.getModel().setValue("implsubtype", (Object)implItemDys[index].getString("implsubtype"), entryCount + index);
            this.getModel().setValue("implgroup", (Object)implItemDys[index].getDynamicObject("group"), entryCount + index);
            this.getModel().setValue("implbizsubarea", (Object)implItemDys[index].getDynamicObject("bizsubarea"), entryCount + index);
            this.getModel().setValue("entityobjscope", (Object)implItemDys[index].getDynamicObject("entityobjscope"), entryCount + index);
            this.getModel().setValue("usescene", (Object)implItemDys[index].getString("usescene"), entryCount + index);
            DynamicObjectCollection docs = implItemDys[index].getDynamicObjectCollection("mulfrontimpl");
            if (CollectionUtils.isEmpty((Collection)docs)) continue;
            ListIterator iter = docs.listIterator();
            while (iter.hasNext()) {
                DynamicObject dyc = (DynamicObject)((DynamicObject)iter.next()).get(1);
                if (currMaterPlanImplItems.contains(dyc.getLong("id"))) continue;
                iter.remove();
            }
            this.getModel().setValue("mulfrontimpl", (Object)docs, entryCount + index);
        }
        HricDynamicObjectUtils.entitySort((String)"entryentity", (IDataModel)this.getModel(), (IFormView)this.getView());
        this.stagingInitInfo(this.getPageCache().get(CACHE_CURRENT_NODE_ID));
    }

    private void batchHandleBtn(String batchHandleSign) {
        if (HRStringUtils.equals((String)batchHandleSign, (String)"batchdivideexecute")) {
            if (this.checkIsNoSelect(PlanMsgEnum.BATCH_DIVIDE_EXECUTE_TIP.get())) {
                return;
            }
        } else if (HRStringUtils.equals((String)batchHandleSign, (String)"batchdividevalidate")) {
            if (this.checkIsNoSelect(PlanMsgEnum.BATCH_DIVIDE_VALIDATE_TIP.get())) {
                return;
            }
        } else {
            if (HRStringUtils.equals((String)batchHandleSign, (String)"batchopenvalidate")) {
                if (this.checkIsNoSelect(PlanMsgEnum.BATCH_OPEN_VALIDATE_TIP.get())) {
                    return;
                }
                this.batchOpenOrCloseValidateSwitch(batchHandleSign);
                return;
            }
            if (HRStringUtils.equals((String)batchHandleSign, (String)"batchclosevalidate")) {
                if (this.checkIsNoSelect(PlanMsgEnum.BATCH_CLOSE_VALIDATE_TIP.get())) {
                    return;
                }
                this.batchOpenOrCloseValidateSwitch(batchHandleSign);
                return;
            }
            if (HRStringUtils.equals((String)batchHandleSign, (String)"divideplanleader")) {
                if (this.checkIsNoSelect(PlanMsgEnum.DIVIDE_PLAN_LEADER_TIP.get())) {
                    return;
                }
            } else if (ENTRY_BTN.contains(batchHandleSign)) {
                if (((EntryGrid)this.getView().getControl("entryentity")).getSelectRows().length <= 0) {
                    this.getView().showTipNotification(PlanMsgEnum.NO_SELECT_MSG.getMsg());
                    return;
                }
                if (HRStringUtils.equals((String)batchHandleSign, (String)"ebatchopenvalidate")) {
                    this.eBatchOpenOrCloseValidateSwitch(batchHandleSign);
                    return;
                }
                if (HRStringUtils.equals((String)batchHandleSign, (String)"ebatchclosevalidate")) {
                    this.eBatchOpenOrCloseValidateSwitch(batchHandleSign);
                    return;
                }
            }
        }
        this.showF7Base("hric_bosuserlayout", batchHandleSign);
    }

    private void eBatchOpenOrCloseValidateSwitch(String batchHandleSign) {
        this.getModel().beginInit();
        for (int index : ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows()) {
            if (((Boolean)this.getModel().getValue("isskip", index)).booleanValue()) continue;
            if (HRStringUtils.equals((String)batchHandleSign, (String)"ebatchopenvalidate")) {
                this.getModel().setValue("isdataverify", (Object)"1", index);
                continue;
            }
            if (!HRStringUtils.equals((String)batchHandleSign, (String)"ebatchclosevalidate")) continue;
            this.getModel().setValue("isdataverify", (Object)"0", index);
            this.getModel().setValue("verifyperson", null, index);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void batchOpenOrCloseValidateSwitch(String batchHandleSign) {
        List checkedNodeIds = ((TreeView)this.getView().getControl("treeviewap")).getTreeState().getCheckedNodeIds();
        String currNodeId = this.getPageCache().get(CACHE_CURRENT_NODE_ID);
        AtomicBoolean isContainCurrNodeId = new AtomicBoolean(false);
        Map<String, DynamicObject> cacheInitPlanMap = this.getCacheInitPlanMap();
        checkedNodeIds.forEach(nodeId -> {
            if (HRStringUtils.equals((String)currNodeId, (String)nodeId)) {
                isContainCurrNodeId.set(true);
            }
            DynamicObject dyc = (DynamicObject)cacheInitPlanMap.get(nodeId);
            DynamicObjectCollection docs = dyc.getDynamicObjectCollection("itementryentity");
            docs.stream().filter(doc -> !doc.getBoolean("isskip")).forEach(doc -> {
                if (HRStringUtils.equals((String)batchHandleSign, (String)"batchopenvalidate")) {
                    doc.set("isdataverify", (Object)"1");
                } else if (HRStringUtils.equals((String)batchHandleSign, (String)"batchclosevalidate")) {
                    doc.set("isdataverify", (Object)"0");
                    doc.set("verifyperson", null);
                }
            });
        });
        this.insertOrUpdateCacheInitPlanMap(cacheInitPlanMap);
        if (isContainCurrNodeId.get()) {
            this.initInterfacePlanInfo(cacheInitPlanMap.get(currNodeId));
        }
    }

    private boolean checkIsNoSelect(String tip) {
        if (CollectionUtils.isEmpty((Collection)((TreeView)this.getView().getControl("treeviewap")).getTreeState().getCheckedNodeIds())) {
            this.getView().showTipNotification(tip);
            return true;
        }
        return false;
    }

    private void showF7Base(String baseNumber, String callBackSignOrOp) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(baseNumber);
        showParameter.setFormId(FormMetadataCache.getListFormConfig((String)baseNumber).getF7ListFormId());
        OpenStyle style = new OpenStyle();
        StyleCss css = new StyleCss();
        style.setShowType(ShowType.Modal);
        css.setWidth("900px");
        css.setHeight("600px");
        style.setInlineStyleCss(css);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackSignOrOp));
        showParameter.setOpenStyle(style);
        showParameter.setShowTitle(false);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(false);
        showParameter.setAppId("hric");
        showParameter.setHasRight(true);
        showParameter.getListFilterParameter().setFilter(QFilterUtils.getEnableQFilter());
        if (HRStringUtils.equals((String)callBackSignOrOp, (String)"add")) {
            showParameter.setMultiSelect(true);
            showParameter.getListFilterParameter().setFilter(QFilterUtils.getEnableQFilter());
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "not in", this.getFilterIdList()));
            showParameter.getListFilterParameter().setFilter(this.getGroupFilter());
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private List<Long> getFilterIdList() {
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        return entry.stream().map(it -> it.getLong("implitem.id")).collect(Collectors.toList());
    }

    private QFilter getGroupFilter() {
        DynamicObjectCollection group = (DynamicObjectCollection)this.getModel().getValue("group");
        QFilter groupFilter = new QFilter("group", "in", group.stream().map(gro -> ((DynamicObject)gro.get(1)).getLong("id")).collect(Collectors.toSet()));
        DynamicObjectCollection bizSubAreaDyns = (DynamicObjectCollection)this.getModel().getValue("bizsubarea");
        return groupFilter.and(new QFilter("bizsubarea", "in", bizSubAreaDyns.stream().map(gro -> ((DynamicObject)gro.get(1)).getLong("id")).collect(Collectors.toSet())));
    }

    private void batchHandleUserWithEntry(List<Long> idList, String sign) {
        AtomicInteger rowCount = new AtomicInteger();
        AtomicInteger successCount = new AtomicInteger();
        this.getModel().beginInit();
        StringBuilder msgSb = new StringBuilder();
        for (int index : ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows()) {
            if (((Boolean)this.getModel().getValue("isskip", index)).booleanValue()) continue;
            rowCount.getAndAdd(1);
            if (HRStringUtils.equals((String)sign, (String)"verifyperson")) {
                if (((Boolean)this.getModel().getValue("isdataverify", index)).booleanValue()) {
                    this.getModel().setValue(sign, (Object)idList.get(0), index);
                    successCount.getAndAdd(1);
                    continue;
                }
                ILocaleString implItemName = (ILocaleString)this.getModel().getValue("itemname", index);
                msgSb.append(String.format(Locale.ROOT, PlanMsgEnum.IMPLITEM_BATCH_DIVIDE_VALIDATE_DETAIL.get(), implItemName.getLocaleValue())).append("\n");
                continue;
            }
            this.getModel().setValue(sign, (Object)idList.get(0), index);
        }
        this.getModel().endInit();
        if (msgSb.length() > 0) {
            this.getView().showMessage(String.format(Locale.ROOT, PlanMsgEnum.IMPLITEM_BATCH_DIVIDE_VALIDATE_TIP.get(), rowCount.get(), successCount.get(), rowCount.get() - successCount.get()), msgSb.toString(), MessageTypes.Default);
        }
        this.getView().updateView("entryentity");
    }

    private void batchHandleUser(List<Long> idList, String sign) {
        List checkedNodeIds = ((TreeView)this.getView().getControl("treeviewap")).getTreeState().getCheckedNodeIds();
        String currNodeId = this.getPageCache().get(CACHE_CURRENT_NODE_ID);
        AtomicBoolean isContainCurrNodeId = new AtomicBoolean(false);
        Map<String, DynamicObject> cacheInitPlanMap = this.getCacheInitPlanMap();
        AtomicInteger rowCount = new AtomicInteger();
        AtomicInteger successCount = new AtomicInteger();
        StringBuilder msgSb = new StringBuilder();
        checkedNodeIds.forEach(nodeId -> {
            if (HRStringUtils.equals((String)currNodeId, (String)nodeId)) {
                isContainCurrNodeId.set(true);
            }
            DynamicObjectCollection docs = ((DynamicObject)cacheInitPlanMap.get(nodeId)).getDynamicObjectCollection("itementryentity");
            docs.stream().filter(doc -> !doc.getBoolean("isskip")).forEach(doc -> {
                if (HRStringUtils.equals((String)sign, (String)"verifyperson")) {
                    rowCount.addAndGet(1);
                    if (doc.getBoolean("isdataverify")) {
                        doc.set(sign, idList.get(0));
                        successCount.addAndGet(1);
                    } else {
                        String implItemName = doc.getLocaleString("itemname").getLocaleValue();
                        msgSb.append(String.format(Locale.ROOT, PlanMsgEnum.IMPLITEM_BATCH_DIVIDE_VALIDATE_DETAIL.get(), implItemName)).append("\n");
                    }
                } else {
                    doc.set(sign, idList.get(0));
                }
            });
        });
        if (msgSb.length() > 0) {
            this.getView().showMessage(String.format(Locale.ROOT, PlanMsgEnum.IMPLITEM_BATCH_DIVIDE_VALIDATE_TIP.get(), rowCount.get(), successCount.get(), rowCount.get() - successCount.get()), msgSb.toString(), MessageTypes.Default);
        }
        this.insertOrUpdateCacheInitPlanMap(cacheInitPlanMap);
        if (isContainCurrNodeId.get()) {
            this.initInterfacePlanInfo(cacheInitPlanMap.get(currNodeId));
        }
    }

    private void updatePlanLeader(List<Long> idList) {
        Long userId = idList.get(0);
        List checkedNodeIds = ((TreeView)this.getView().getControl("treeviewap")).getTreeState().getCheckedNodeIds();
        Map<String, DynamicObject> cacheInitPlanMap = this.getCacheInitPlanMap();
        checkedNodeIds.forEach(nodeId -> ((DynamicObject)cacheInitPlanMap.get(nodeId)).set("planperson", (Object)userId));
        this.getModel().setValue("planperson", (Object)userId);
        this.insertOrUpdateCacheInitPlanMap(cacheInitPlanMap);
    }

    private void handleDataVerify() {
        int currIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        Boolean isDataVerify = (Boolean)this.getModel().getValue("isdataverify", currIndex);
        if (!isDataVerify.booleanValue()) {
            this.getModel().beginInit();
            this.getModel().setValue("verifyperson", null, currIndex);
            this.getModel().endInit();
        }
        this.getView().updateView("entryentity");
    }

    private boolean showMsgAndSignNoPass(Set<String> msgSet) {
        this.getView().showMessage("", Joiner.on((String)"\n").join(msgSet), MessageTypes.Default);
        return false;
    }

    private void updatePlanTree(String name) {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        DynamicObject[] planTempArr = (DynamicObject[])SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(CACHE_PLAN_TEMP_ARR));
        DynamicObject[] filterPlanTempArr = this.iInitPlanDomainService.filterTreeByName(planTempArr, name);
        treeView.updateNode(this.iInitPlanDomainService.initTree(this.getPageCache().get(CACHE_ROOTNODEID), filterPlanTempArr, null, false));
    }

    private void handleCodeRule(DynamicObject plan) {
        boolean isExist = CodeRuleServiceHelper.isExist((String)"hric_initplan", (DynamicObject)plan, null);
        boolean isModifiable = CodeRuleServiceHelper.isModifiable((String)"hric_initplan", (DynamicObject)plan, null);
        if (isExist) {
            if (isModifiable) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"number"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
            }
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"number"});
        }
    }

    private void doStartUp() {
        if (this.iInitPlanDomainService.startUp(this.getCacheInitPlanMap())) {
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.showSuccessNotification(PlanMsgEnum.START_UP_SUCCESS.get());
            }
            this.getView().invokeOperation("close");
        } else {
            this.getView().showErrorNotification(PlanMsgEnum.START_UP_FAIL.get());
        }
    }

    private boolean doCheck() {
        this.stagingInitInfo(this.getPageCache().get(CACHE_CURRENT_NODE_ID));
        Map<String, DynamicObject> cacheInitPlanMap = this.getCacheInitPlanMap();
        HashSet msgSet = Sets.newHashSet();
        msgSet.add(this.iInitPlanDomainService.mustInputCheck(cacheInitPlanMap));
        msgSet.remove("");
        if (!CollectionUtils.isEmpty((Collection)msgSet)) {
            return this.showMsgAndSignNoPass(msgSet);
        }
        msgSet.add(this.iInitPlanDomainService.planNumberUniqueCheck(cacheInitPlanMap));
        DynamicObject masterPlan = this.getCacheInitPlanMap().get(this.getPageCache().get(CACHE_ROOTNODEID));
        String planName = masterPlan.getLocaleString("name").getLocaleValue();
        msgSet.add(this.iInitPlanDomainService.checkMasterPlanNameUnique(planName));
        msgSet.add(this.iInitPlanDomainService.checkImplItemEntryEmpty(cacheInitPlanMap));
        msgSet.remove("");
        if (CollectionUtils.isEmpty((Collection)msgSet)) {
            return true;
        }
        return this.showMsgAndSignNoPass(msgSet);
    }

    private void reInitTree() {
        this.stagingInitInfo(this.getPageCache().get(CACHE_CURRENT_NODE_ID));
        DynamicObject[] planTempArr = (DynamicObject[])SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(CACHE_PLAN_TEMP_ARR));
        this.getCacheInitPlanMap().entrySet().forEach(entry -> {
            String nodeId = (String)entry.getKey();
            ILocaleString name = ((DynamicObject)entry.getValue()).getLocaleString("name");
            Arrays.stream(planTempArr).forEach(temp -> {
                if (HRStringUtils.equals((String)temp.getString("id"), (String)nodeId)) {
                    temp.set("planname", (Object)name);
                }
            });
        });
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.updateNode(this.iInitPlanDomainService.initTree(this.getPageCache().get(CACHE_ROOTNODEID), planTempArr, null, false));
        this.getPageCache().put(CACHE_PLAN_TEMP_ARR, SerializationUtils.serializeToBase64((Object)planTempArr));
    }

    private boolean nameUniqueCheck(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        String oldValue = ((DynamicObject)((LocaleDynamicObjectCollection)changeSet[0].getOldValue()).get(0)).getString("name");
        String newValue = ((DynamicObject)((LocaleDynamicObjectCollection)changeSet[0].getNewValue()).get(0)).getString("name");
        String msg = this.iInitPlanDomainService.checkPlanNameUnique(this.getPageCache().get(CACHE_CURRENT_NODE_ID), newValue, this.getCacheInitPlanMap());
        if (HRStringUtils.isEmpty((String)msg)) {
            return true;
        }
        this.getView().showErrorNotification(msg);
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue("name", (Object)oldValue);
        model.endInit();
        return false;
    }

    private void dateCheck(String fieldName) {
        Integer layer = (Integer)this.getModel().getValue("layer");
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (layer == 1) {
            if (this.dayAfter(startDate, endDate)) {
                this.showMsg(fieldName, PlanMsgEnum.DATE_TIP_MSG.get());
                return;
            }
            Map<String, DynamicObject> cacheInitPlanMap = this.getCacheInitPlanMap();
            cacheInitPlanMap.values().forEach(plan -> plan.set(fieldName, this.getModel().getValue(fieldName)));
            this.insertOrUpdateCacheInitPlanMap(cacheInitPlanMap);
        } else {
            DynamicObject currentPlan = this.getCacheInitPlanMap().get(this.getPageCache().get(CACHE_CURRENT_NODE_ID));
            DynamicObject parentPlan = currentPlan.getDynamicObject("parent");
            Date parentPlanStartDate = parentPlan.getDate("startdate");
            Date parentPlanEndDate = parentPlan.getDate("enddate");
            if (this.dayAfter(startDate, endDate)) {
                this.showMsg(fieldName, PlanMsgEnum.DATE_TIP_MSG.get());
                return;
            }
            if (this.dayAfter(parentPlanStartDate, startDate)) {
                this.showMsg(fieldName, String.format(Locale.ROOT, PlanMsgEnum.SON_DATE_TIP_MSG.get(), PlanMsgEnum.START_DATA_TIP.get(), PlanMsgEnum.LESSTHAN_TIP.get(), PlanMsgEnum.START_DATA_TIP.get()));
                return;
            }
            if (this.dayAfter(startDate, parentPlanEndDate)) {
                this.showMsg(fieldName, String.format(Locale.ROOT, PlanMsgEnum.SON_DATE_TIP_MSG.get(), PlanMsgEnum.START_DATA_TIP.get(), PlanMsgEnum.GREATERTHAN_TIP.get(), PlanMsgEnum.END_DATA_TIP.get()));
                return;
            }
            if (this.dayAfter(endDate, parentPlanEndDate)) {
                this.showMsg(fieldName, String.format(Locale.ROOT, PlanMsgEnum.SON_DATE_TIP_MSG.get(), PlanMsgEnum.END_DATA_TIP.get(), PlanMsgEnum.GREATERTHAN_TIP.get(), PlanMsgEnum.END_DATA_TIP.get()));
                return;
            }
            if (this.dayAfter(parentPlanStartDate, endDate)) {
                this.showMsg(fieldName, String.format(Locale.ROOT, PlanMsgEnum.SON_DATE_TIP_MSG.get(), PlanMsgEnum.END_DATA_TIP.get(), PlanMsgEnum.LESSTHAN_TIP.get(), PlanMsgEnum.START_DATA_TIP.get()));
                return;
            }
        }
    }

    private void showMsg(String fieldName, String msg) {
        this.getView().showErrorNotification(msg);
        this.getModel().setValue(fieldName, null);
    }

    private boolean dayAfter(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return false;
        }
        return startDate.after(endDate);
    }

    private void stagingInitInfo(String lastTimeSelectNodeId) {
        Map<String, DynamicObject> cacheInitPlanMap = this.getCacheInitPlanMap();
        DynamicObject initPlan = cacheInitPlanMap.get(lastTimeSelectNodeId);
        IDataModel model = this.getModel();
        initPlan.set("name", model.getValue("name"));
        initPlan.set("number", model.getValue("number"));
        initPlan.set("startdate", model.getValue("startdate"));
        initPlan.set("enddate", model.getValue("enddate"));
        Object planPerson = model.getValue("planperson");
        if (planPerson instanceof DynamicObject) {
            initPlan.set("planperson", ((DynamicObject)planPerson).getPkValue());
        } else {
            initPlan.set("planperson", planPerson);
        }
        initPlan.set("datarange", model.getValue("datarange"));
        initPlan.set("sourcesystem", model.getValue("sourcesystem"));
        initPlan.set("industrytype", model.getValue("industrytype"));
        String configMode = initPlan.getString("configmode");
        if (AppConstants.CONFIG_MODE_LIST.contains(configMode)) {
            this.planImplItemEntryValSetter(initPlan);
        }
        cacheInitPlanMap.put(lastTimeSelectNodeId, initPlan);
        this.insertOrUpdateCacheInitPlanMap(cacheInitPlanMap);
    }

    private void planImplItemEntryValSetter(DynamicObject initPlan) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection planImplItemEntry = initPlan.getDynamicObjectCollection("itementryentity");
        DynamicObjectCollection interfaceImplItemEntry = model.getEntityEntity("entryentity");
        Map<Long, DynamicObject> planImplItemEntryMap = planImplItemEntry.stream().filter(impl -> impl.getDynamicObject("implitem") != null).collect(Collectors.toMap(impl -> impl.getDynamicObject("implitem").getLong("id"), impl -> impl));
        interfaceImplItemEntry.stream().filter(impl -> impl.getDynamicObject("implitem") != null).forEach(impl -> {
            DynamicObject implItem = impl.getDynamicObject("implitem");
            DynamicObject planImplItem = (DynamicObject)planImplItemEntryMap.get(implItem.getLong("id"));
            if (planImplItem == null) {
                planImplItem = planImplItemEntry.addNew();
                planImplItem.set("implitem", (Object)implItem);
                planImplItem.set("itemname", (Object)implItem.getLocaleString("name"));
                planImplItem.set("impltype", (Object)implItem.getString("impltype"));
                planImplItem.set("implsubtype", (Object)implItem.getString("implsubtype"));
                planImplItem.set("implgroup", (Object)implItem.getDynamicObject("group"));
                planImplItem.set("implbizsubarea", (Object)implItem.getDynamicObject("bizsubarea"));
                planImplItem.set("usescene", (Object)implItem.getString("usescene"));
                planImplItem.set("entityobjscope", (Object)implItem.getDynamicObject("entityobjscope"));
                planImplItem.set("mulfrontimpl", (Object)impl.getDynamicObjectCollection("mulfrontimpl"));
            }
            planImplItem.set("isskip", (Object)impl.getBoolean("isskip"));
            planImplItem.set("skipreason", (Object)impl.getLocaleString("skipreason"));
            DynamicObject execPerson = impl.getDynamicObject("executeperson");
            if (execPerson instanceof DynamicObject) {
                planImplItem.set("executeperson", execPerson.getPkValue());
            } else {
                planImplItem.set("executeperson", (Object)execPerson);
            }
            planImplItem.set("isdataverify", (Object)impl.getBoolean("isdataverify"));
            DynamicObject verifyPerson = impl.getDynamicObject("verifyperson");
            if (verifyPerson instanceof DynamicObject) {
                planImplItem.set("verifyperson", verifyPerson.getPkValue());
            } else {
                planImplItem.set("verifyperson", (Object)verifyPerson);
            }
        });
    }

    private void initInterfacePlanInfo(DynamicObject initPlan) {
        IDataModel model = this.getModel();
        model.setValue("number", (Object)initPlan.getString("number"));
        model.setValue("group", (Object)initPlan.getDynamicObjectCollection("group"));
        model.setValue("bizsubarea", (Object)initPlan.getDynamicObjectCollection("bizsubarea"));
        Object planPerson = initPlan.get("planperson");
        if (planPerson instanceof DynamicObject) {
            model.setValue("planperson", ((DynamicObject)planPerson).getPkValue());
        } else {
            model.setValue("planperson", planPerson);
        }
        model.setValue("datarange", (Object)initPlan.getLocaleString("datarange"));
        model.setValue("layer", (Object)initPlan.getInt("layer"));
        model.beginInit();
        model.setValue("name", (Object)initPlan.getLocaleString("name"));
        model.setValue("startdate", (Object)initPlan.getDate("startdate"));
        model.setValue("enddate", (Object)initPlan.getDate("enddate"));
        model.endInit();
        DynamicObject masterPlan = this.getCacheInitPlanMap().get(this.getPageCache().get(CACHE_ROOTNODEID));
        model.setValue("sourcesystem", (Object)masterPlan.getDynamicObject("sourcesystem"));
        model.setValue("industrytype", (Object)masterPlan.getDynamicObject("industrytype"));
        String configMode = initPlan.getString("configmode");
        model.setValue("configmode", (Object)configMode);
        this.getView().updateView(PLAN_INFO_PANEL);
        if (AppConstants.CONFIG_MODE_LIST.contains(configMode)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"implitementrypanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tippanel"});
            this.initInterfaceImplItemEntry(initPlan);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"implitementrypanel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"tippanel"});
        }
    }

    private void initInterfaceImplItemEntry(DynamicObject initPlan) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection implItemEntry = initPlan.getDynamicObjectCollection("itementryentity");
        if (CollectionUtils.isEmpty((Collection)implItemEntry)) {
            model.deleteEntryData("entryentity");
            return;
        }
        this.getModel().beginInit();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", null, implItemEntry.size());
        List<DynamicObject> implItemEntryList = implItemEntry.stream().sorted(Comparator.comparing(item -> item.getDynamicObject("implitem").getLong("listseq"))).collect(Collectors.toList());
        implItemEntryList.forEach(implItem -> {
            int index = implItemEntryList.indexOf(implItem);
            model.setValue("implitem", (Object)implItem.getDynamicObject("implitem"), index);
            model.setValue("itemname", (Object)implItem.getLocaleString("itemname"), index);
            model.setValue("impltype", (Object)implItem.getString("impltype"), index);
            model.setValue("implsubtype", (Object)implItem.getString("implsubtype"), index);
            model.setValue("implgroup", (Object)implItem.getDynamicObject("implgroup"), index);
            model.setValue("implbizsubarea", (Object)implItem.getDynamicObject("implbizsubarea"), index);
            model.setValue("usescene", (Object)implItem.getString("usescene"), index);
            model.setValue("entityobjscope", (Object)implItem.getDynamicObject("entityobjscope"), index);
            model.setValue("mulfrontimpl", (Object)implItem.getDynamicObjectCollection("mulfrontimpl"), index);
            model.setValue("isskip", (Object)implItem.getBoolean("isskip"), index);
            model.setValue("skipreason", (Object)implItem.getLocaleString("skipreason"), index);
            Object executePerson = implItem.get("executeperson");
            if (executePerson instanceof DynamicObject) {
                model.setValue("executeperson", ((DynamicObject)executePerson).getPkValue(), index);
            } else {
                model.setValue("executeperson", executePerson == null ? null : Long.valueOf(Long.parseLong(executePerson.toString())), index);
            }
            model.setValue("isdataverify", (Object)implItem.getBoolean("isdataverify"), index);
            Object verifyPerson = implItem.get("verifyperson");
            if (verifyPerson instanceof DynamicObject) {
                model.setValue("verifyperson", ((DynamicObject)verifyPerson).getPkValue(), index);
            } else {
                model.setValue("verifyperson", verifyPerson == null ? null : Long.valueOf(Long.parseLong(verifyPerson.toString())), index);
            }
        });
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void initTreeConfigure(TreeView treeView) {
        treeView.setMulti(true);
        treeView.setRootVisible(true);
        treeView.setDraggable(false);
        treeView.setDroppable(false);
    }

    private Map<String, DynamicObject> getCacheInitPlanMap() {
        return (Map)SerializationUtils.deSerializeFromBase64((String)this.getView().getPageCache().get(CACHE_INIT_PLAN));
    }

    private void insertOrUpdateCacheInitPlanMap(Map<String, DynamicObject> cacheInitPlanMap) {
        this.getPageCache().put(CACHE_INIT_PLAN, SerializationUtils.serializeToBase64(cacheInitPlanMap));
    }
}

