/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web.plantree;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.AfterSearchClickListener;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hric.bussiness.service.InitPlanServiceHelper;
import kd.hrmp.hric.common.util.LogUtils;
import kd.hrmp.hric.common.util.QFilterUtils;
import kd.hrmp.hric.formplugin.web.plantree.HricCustomTreeEntryGrid;
import kd.hrmp.hric.formplugin.web.util.InitPlanFormUtils;

public class PlanTreeListPlugin
extends HRDataBaseEdit
implements FilterContainerInitListener,
AfterSearchClickListener,
ItemClickListener,
HyperLinkClickListener {
    private static Log LOG = LogFactory.getLog(PlanTreeListPlugin.class);
    private String STATUS_IS_NOT_A_MSG = ResManager.loadKDString((String)"\u8be5\u8ba1\u5212\u65e0\u6cd5\u8fdb\u884c\u914d\u7f6e\uff0c\u56e0\u4e3a\u5b83\u4e0d\u662f\u5f85\u914d\u7f6e\u72b6\u6001\u3002", (String)"PlanTreeListPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String STATUS_IS_A_MSG = ResManager.loadKDString((String)"\u8be5\u8ba1\u5212\u4e3a\u5f53\u524d\u8ba1\u5212\uff0c\u975e\u603b\u8ba1\u5212\u3002", (String)"PlanTreeListPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String EMPTY_MSG = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PlanTreeListPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String ISDEL_MSG = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%s\u6761\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\u3002\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"PlanTreeListPlugin_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String TOP_TIPS = ResManager.loadKDString((String)"\u5171%1$s\u4e2a\u8ba1\u5212\uff0c\u6210\u529f\u5220\u9664%2$s\u6761\uff0c\u5220\u9664\u5931\u8d25%3$s\u6761\u3002", (String)"PlanTreeListPlugin_4", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String TIPS = ResManager.loadKDString((String)"%s\u4e0d\u80fd\u5220\u9664\uff0c\u4e0d\u518d\u5904\u7406\u6570\u636e\uff01", (String)"PlanTreeListPlugin_5", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private static final String BIZOBJ = "bizobj";
    private static final String DEL_CONFIREM = "delConfirem";
    private static final String PAGECACHE_NEED_DEL_IDS = "needDelIds";
    private static final String PAGECACHE_NEED_TIPS_IDS = "needTipsIds";
    private static final String KEY_LIST_ENTRYENTITY = "treeentryentity";
    private static final String[] SCHEME_FILTER_COLUMN_FIELD = new String[]{"number", "name", "startdate", "enddate", "actualenddate", "planstatus", "datarange", "createtime", "initfinish"};
    private static final Map<String, String> SCHEME_FILTER_COLUMN_BASEDATA_FIELD = new ImmutableMap.Builder().put((Object)"industrytype", (Object)"industrytype.name").put((Object)"parent", (Object)"parent.name").put((Object)"group", (Object)"group.name").put((Object)"bizsubarea", (Object)"bizsubarea.name").put((Object)"planperson", (Object)"planperson.name").put((Object)"creator", (Object)"creator.name").put((Object)"sourcesystem", (Object)"sourcesystem.name").build();

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (filterContainer != null) {
            filterContainer.setEntityId("hric_initplan");
            filterContainer.setNeedShareScheme(true);
            filterContainer.addFilterContainerInitListener((FilterContainerInitListener)this);
            filterContainer.addAfterSearchClickListener((AfterSearchClickListener)this);
        }
        this.getView().addCustomControls(new String[]{KEY_LIST_ENTRYENTITY});
    }

    public void filterContainerInit(FilterContainerInitEvent evt) {
        evt.addFilterColumn(new FilterColumn("number"));
        evt.addFilterColumn(new FilterColumn("name"));
        evt.addFilterColumn((FilterColumn)new CommonFilterColumn("planstatus"));
        this.removeToBeConfiguredStatus(evt.getCommonFilterColumns());
        Arrays.stream(SCHEME_FILTER_COLUMN_FIELD).forEach(field -> evt.addFilterColumn((FilterColumn)new SchemeFilterColumn(field)));
        DataEntityPropertyCollection properties = MetadataServiceHelper.getDataEntityType((String)"hric_initplan").getProperties();
        SCHEME_FILTER_COLUMN_BASEDATA_FIELD.entrySet().forEach(entry -> {
            SchemeFilterColumn schemeFilterColumn = new SchemeFilterColumn((String)entry.getValue());
            schemeFilterColumn.setCaption(((IDataEntityProperty)properties.get(entry.getKey())).getDisplayName());
            evt.addFilterColumn((FilterColumn)schemeFilterColumn);
        });
        this.removeToBeConfiguredStatus(evt.getSchemeFilterColumns());
    }

    public void onGetControl(OnGetControlArgs e) {
        if (KEY_LIST_ENTRYENTITY.equalsIgnoreCase(e.getKey())) {
            TreeEntryGrid treeEntryGrid = this.newTreeEntryGrid();
            treeEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
            e.setControl((Control)treeEntryGrid);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String homeQfilterScheme = (String)this.getView().getFormShowParameter().getCustomParam("home_qfilter_scheme");
        if (HRStringUtils.isNotEmpty((String)homeQfilterScheme)) {
            this.getView().getPageCache().put(this.getView().getPageId() + RequestContext.get().getCurrUserId() + "", homeQfilterScheme);
        }
        this.getParentOfTreeEntryGrid().getItems().set(0, this.newTreeEntryGrid());
    }

    public void click(SearchClickEvent searchClickEvent) {
        List fastQFilters = searchClickEvent.getFastQFilters();
        List otherFilters = searchClickEvent.getFilterParameter().getQFilters();
        if (!CollectionUtils.isEmpty((Collection)fastQFilters)) {
            otherFilters.addAll(fastQFilters);
        }
        if (!CollectionUtils.isEmpty((Collection)otherFilters)) {
            QFilter listQFilters = (QFilter)otherFilters.remove(0);
            for (QFilter qFilter : otherFilters) {
                listQFilters.and(qFilter);
            }
            this.getView().getPageCache().put(this.getView().getPageId() + RequestContext.get().getCurrUserId() + "", listQFilters.toSerializedString());
        } else {
            this.getView().getPageCache().put(this.getView().getPageId() + RequestContext.get().getCurrUserId() + "", null);
        }
        ((HricCustomTreeEntryGrid)this.newTreeEntryGrid()).treeEntryGridBindPageData();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "new": {
                this.newPlan();
                break;
            }
            case "importtemplate": {
                this.openTempPage();
                break;
            }
            case "copy": {
                this.copyPlan();
                break;
            }
            case "delete": {
                this.deletePlan();
                break;
            }
            case "viewalllog": {
                this.viewAllLog();
                break;
            }
            case "refresh": {
                this.getView().updateView(KEY_LIST_ENTRYENTITY);
                break;
            }
            case "close": {
                this.getView().close();
                break;
            }
            default: {
                return;
            }
        }
    }

    private void openTempPage() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("hric_ptplbase");
        parameter.setFormId(FormMetadataCache.getListFormConfig((String)"hric_ptplbase").getF7ListFormId());
        OpenStyle style = new OpenStyle();
        StyleCss css = new StyleCss();
        style.setShowType(ShowType.Modal);
        css.setWidth("900px");
        css.setHeight("600px");
        style.setInlineStyleCss(css);
        parameter.setOpenStyle(style);
        parameter.setShowTitle(false);
        parameter.setLookUp(true);
        parameter.setMultiSelect(false);
        parameter.setF7Style(0);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(QFilterUtils.getEnableQFilter());
        parameter.setListFilterParameter(listFilterParameter);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hric_ptplbase"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (HRStringUtils.equals((String)evt.getActionId(), (String)"hric_ptplbase") && evt.getReturnData() != null) {
            FormShowParameter showParameter;
            Long pkId = (Long)((ListSelectedRowCollection)evt.getReturnData()).get(0).getPrimaryKeyValue();
            String pageId = SessionManager.getCurrent().get(pkId + "");
            if (HRStringUtils.isEmpty((String)pageId) || SessionManager.getCurrent().getView(pageId) == null) {
                showParameter = new FormShowParameter();
                showParameter.setFormId("hric_inittempaddplan");
                showParameter.setCustomParam("pkid", (Object)pkId.toString());
                SessionManager.getCurrent().put(pkId + "", showParameter.getPageId());
            } else {
                showParameter = SessionManager.getCurrent().getFormShowParameter(pageId);
            }
            showParameter.getOpenStyle().setClientShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        this.deleteConfirmCallBack(evt);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        Optional<Long> pkId = Optional.ofNullable(this.getModel()).map(it -> it.getDataEntity(true)).map(it -> it.getDynamicObjectCollection(KEY_LIST_ENTRYENTITY)).map(it -> (DynamicObject)it.get(evt.getRowIndex())).map(it -> it.getLong("id"));
        if (!pkId.isPresent()) {
            return;
        }
        InitPlanFormUtils.linkInitPlan(this.getView(), pkId.get());
    }

    private void removeToBeConfiguredStatus(List<FilterColumn> filterColumns) {
        Optional<FilterColumn> planStatusColumn = filterColumns.stream().filter(column -> HRStringUtils.equals((String)column.getFieldName(), (String)"planstatus")).findFirst();
        if (!planStatusColumn.isPresent()) {
            return;
        }
        FilterColumn filterColumn = planStatusColumn.get();
        List<ComboItem> comboItems = new ArrayList();
        comboItems = filterColumn instanceof CommonFilterColumn ? ((CommonFilterColumn)filterColumn).getComboItems() : ((SchemeFilterColumn)filterColumn).getComboItems();
        comboItems.removeIf(comboItem -> HRStringUtils.equals((String)comboItem.getValue(), (String)"E"));
    }

    protected TreeEntryGrid newTreeEntryGrid() {
        HricCustomTreeEntryGrid newTreeEntryGrid = new HricCustomTreeEntryGrid();
        TreeEntryGrid oldTreeEntryGrid = (TreeEntryGrid)this.getParentOfTreeEntryGrid().getItems().get(0);
        newTreeEntryGrid.getItems().addAll(oldTreeEntryGrid.getItems());
        newTreeEntryGrid.setKey(oldTreeEntryGrid.getKey());
        newTreeEntryGrid.setEntryKey(oldTreeEntryGrid.getEntryKey());
        newTreeEntryGrid.setModel(oldTreeEntryGrid.getModel());
        newTreeEntryGrid.setView(oldTreeEntryGrid.getView());
        newTreeEntryGrid.setSplitPage(true);
        newTreeEntryGrid.setPageRow(20);
        String qFilterStr = this.getView().getPageCache().get(this.getView().getPageId() + RequestContext.get().getCurrUserId() + "");
        if (HRStringUtils.isEmpty((String)qFilterStr)) {
            newTreeEntryGrid.setListQFilters(null);
        } else {
            newTreeEntryGrid.setListQFilters(QFilter.fromSerializedString((String)qFilterStr));
        }
        return newTreeEntryGrid;
    }

    protected Container getParentOfTreeEntryGrid() {
        FormRoot formRoot = (FormRoot)this.getView().getRootControl();
        Container container = (Container)formRoot.getItems().get(2);
        return container;
    }

    protected void newPlan() {
        String pageId = SessionManager.getCurrent().get(this.getView().getPageId() + "newAdd");
        BillShowParameter showParameter = null;
        if (HRStringUtils.isEmpty((String)pageId) || SessionManager.getCurrent().getView(pageId) == null) {
            showParameter = new BillShowParameter();
            showParameter.setFormId("hric_initplan");
            SessionManager.getCurrent().put(this.getView().getPageId() + "newAdd", showParameter.getPageId());
        } else {
            showParameter = (BillShowParameter)SessionManager.getCurrent().getFormShowParameter(pageId);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected void viewAllLog() {
        ListShowParameter lsp = new ListShowParameter();
        lsp.setFormId("bos_list");
        lsp.setBillFormId("hbss_history_logview");
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(new QFilter(BIZOBJ, "=", (Object)"hric_initplan"));
        lsp.setListFilterParameter(listFilterParameter);
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.setHasRight(true);
        this.getView().showForm((FormShowParameter)lsp);
    }

    protected void copyPlan() {
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_LIST_ENTRYENTITY);
        int[] selectedRows = grid.getEntryState().getSelectedRows();
        if (ObjectUtils.isEmpty((Object)selectedRows)) {
            this.getView().showTipNotification(this.EMPTY_MSG);
            return;
        }
        if (selectedRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u590d\u5236\u7684\u6570\u636e\u3002", (String)"PlanTreeListPlugin_6", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return;
        }
        int index = this.getModel().getEntryCurrentRowIndex(KEY_LIST_ENTRYENTITY);
        DynamicObject selectedData = this.getModel().getEntryRowEntity(KEY_LIST_ENTRYENTITY, index);
        long pkId = selectedData.getLong("id");
        if (InitPlanServiceHelper.getPlansById((Long)pkId) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u4ed6\u4eba\u5220\u9664\u3002", (String)"PlanTreeListPlugin_7", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return;
        }
        this.ShowParameter(pkId);
    }

    protected void deletePlan() {
        ArrayList delIdLists = new ArrayList();
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl(KEY_LIST_ENTRYENTITY);
        int[] selectedRows = grid.getEntryState().getSelectedRows();
        if (ObjectUtils.isEmpty((Object)selectedRows)) {
            this.getView().showTipNotification(this.EMPTY_MSG);
            return;
        }
        Arrays.stream(selectedRows).forEach(row -> {
            DynamicObject selectedData = this.getModel().getEntryRowEntity(KEY_LIST_ENTRYENTITY, row);
            HashMap<String, String> delPlanMap = new HashMap<String, String>();
            delPlanMap.put("id", selectedData.getLong("id") + "");
            delPlanMap.put("number", selectedData.getString("number"));
            DynamicObject parent = selectedData.getDynamicObject("parent");
            delPlanMap.put("parentid", parent == null ? "" : parent.getLong("id") + "");
            delPlanMap.put("planstatus", selectedData.getString("planstatus"));
            delIdLists.add(delPlanMap);
        });
        ArrayList needDelIds = new ArrayList();
        ArrayList needTipsIds = new ArrayList();
        delIdLists.forEach(it -> {
            if (HRStringUtils.isEmpty((String)((String)it.get("parentid"))) && HRStringUtils.equals((String)((String)it.get("planstatus")), (String)"A")) {
                needDelIds.add(new HashMap<String, String>(){
                    {
                        this.put("id", it.get("id"));
                        this.put("number", it.get("number"));
                    }
                });
            } else {
                needTipsIds.add(new HashMap<String, String>(){
                    {
                        this.put("number", it.get("number"));
                        this.put("planstatus", it.get("planstatus"));
                    }
                });
            }
        });
        this.getPageCache().put(PAGECACHE_NEED_DEL_IDS, JSONObject.toJSONString(needDelIds));
        this.getPageCache().put(PAGECACHE_NEED_TIPS_IDS, JSONObject.toJSONString(needTipsIds));
        this.getView().showConfirm(String.format(Locale.ROOT, this.ISDEL_MSG, delIdLists.size()), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(DEL_CONFIREM, (IFormPlugin)this));
    }

    protected void deleteConfirmCallBack(MessageBoxClosedEvent evt) {
        List needDelIds = (List)JSONObject.parseObject((String)this.getView().getPageCache().get(PAGECACHE_NEED_DEL_IDS), List.class);
        List needTipsIds = (List)JSONObject.parseObject((String)this.getView().getPageCache().get(PAGECACHE_NEED_TIPS_IDS), List.class);
        if (HRStringUtils.equals((String)evt.getCallBackId(), (String)DEL_CONFIREM) && evt.getResult() == MessageBoxResult.Yes) {
            InitPlanServiceHelper.delMasterPlans((Long[])((Long[])needDelIds.stream().map(map -> Long.parseLong((String)map.get("id"))).toArray(Long[]::new)));
            List needDelTips = needDelIds.stream().map(map -> (String)map.get("number")).collect(Collectors.toList());
            String logTips = "";
            if (!CollectionUtils.isEmpty(needDelTips)) {
                logTips = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7%s\uff0c\u5220\u9664\u6210\u529f\u3002", (String)"PlanTreeListPlugin_9", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), Joiner.on((String)"\u3001").join(needDelTips));
            }
            if (!CollectionUtils.isEmpty((Collection)needTipsIds)) {
                String secondTip = String.format(Locale.ROOT, this.TOP_TIPS, needDelIds.size() + needTipsIds.size(), needDelIds.size(), needTipsIds.size());
                this.getView().showConfirm(secondTip, this.getTipsMsg(needTipsIds), MessageBoxOptions.OK, ConfirmTypes.Delete, null);
                secondTip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u53f7%s\u3002\u5220\u9664\u5931\u8d25\u3002", (String)"PlanTreeListPlugin_10", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), Joiner.on((String)"\u3001").join((Iterable)needTipsIds.stream().map(map -> (String)map.get("number")).collect(Collectors.toList())));
                logTips = HRStringUtils.isNotEmpty((String)logTips) ? logTips + secondTip : secondTip;
            }
            LogUtils.recordAppLog((String)"hric_initplan", (String)ResManager.loadKDString((String)"\u5220\u9664", (String)"PlanTreeListPlugin_8", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), (String)logTips);
            this.getPageCache().remove(PAGECACHE_NEED_DEL_IDS);
            this.getPageCache().remove(PAGECACHE_NEED_TIPS_IDS);
            this.getView().updateView(KEY_LIST_ENTRYENTITY);
        }
    }

    private String getTipsMsg(List<Map<String, String>> needTipsIds) {
        StringBuilder msg = new StringBuilder();
        needTipsIds.forEach(tip -> {
            String number = (String)tip.get("number");
            String planStatus = (String)tip.get("planstatus");
            msg.append(number).append(":").append(String.format(Locale.ROOT, this.TIPS, HRStringUtils.equals((String)planStatus, (String)"A") ? this.STATUS_IS_A_MSG : this.STATUS_IS_NOT_A_MSG)).append("\n");
        });
        return msg.toString();
    }

    private void ShowParameter(long pkId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("hric_initplan");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.ADDNEW);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("iscopy", Boolean.TRUE);
        customParams.put("id", pkId + "");
        showParameter.setCustomParams(customParams);
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

