/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.ImplItemListDaoHelper;

public class ImplItemFormUtils {
    public static void showImplItemF7(IFormView view, CloseCallBack closeCallBack, QFilter qFilter) {
        ListShowParameter showParameter = ImplItemFormUtils.getListShowParameter(closeCallBack, qFilter);
        view.showForm((FormShowParameter)showParameter);
    }

    private static ListShowParameter getListShowParameter(CloseCallBack closeCallBack, QFilter qFilter) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("hric_implitem");
        showParameter.setFormId(FormMetadataCache.getListFormConfig((String)"hric_implitem").getF7ListFormId());
        OpenStyle style = new OpenStyle();
        StyleCss css = new StyleCss();
        style.setShowType(ShowType.Modal);
        css.setWidth("900px");
        css.setHeight("600px");
        style.setInlineStyleCss(css);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setOpenStyle(style);
        showParameter.setShowTitle(false);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(true);
        showParameter.setF7Style(0);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(qFilter);
        showParameter.setListFilterParameter(listFilterParameter);
        return showParameter;
    }

    public static void showImplItemForm(IFormView view, Long pkid, OperationStatus operationStatus, CloseCallBack closeCallBack) {
        String pageId = SessionManager.getCurrent().get(view.getPageId() + pkid + "");
        BillShowParameter showParameter = null;
        if (HRStringUtils.isEmpty((String)pageId) || SessionManager.getCurrent().getView(pageId) == null) {
            showParameter = new BillShowParameter();
            showParameter.setFormId("hric_implitem");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(operationStatus);
            showParameter.setPkId((Object)pkid);
            showParameter.getOpenStyle().setClientShowType(ShowType.MainNewTabPage);
            showParameter.setCloseCallBack(closeCallBack);
            SessionManager.getCurrent().put(view.getPageId() + pkid + "", showParameter.getPageId());
            showParameter.setCaption(ResManager.loadKDString((String)"\u5b9e\u65bd\u9879\u8be6\u60c5", (String)"ImplItemEditPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        } else {
            showParameter = (BillShowParameter)SessionManager.getCurrent().getFormShowParameter(pageId);
            showParameter.getOpenStyle().setClientShowType(ShowType.MainNewTabPage);
        }
        view.showForm((FormShowParameter)showParameter);
    }

    public static void handleImplItemF7Callback(IFormView view, String entryEntity, String entryImplItemField, ClosedCallBackEvent closedCallBackEvent) {
        List<Long> idList = ImplItemFormUtils.getF7SelectedIdList(closedCallBackEvent);
        ImplItemFormUtils.setEntryInfo(view, entryEntity, entryImplItemField, idList);
    }

    private static List<Long> getF7SelectedIdList(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection rowList = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        return rowList.stream().map(ListSelectedRow::getPrimaryKeyValue).map(it -> (Long)it).collect(Collectors.toList());
    }

    private static void setEntryInfo(IFormView view, String entryEntity, String implItemField, List<Long> idList) {
        IDataModel model = view.getModel();
        Object[] implItemDynamicObjects = ImplItemListDaoHelper.getImplItemObjectByIds((String)"id, name,number,listseq", idList);
        if (ArrayUtils.isNotEmpty((Object[])implItemDynamicObjects)) {
            List implItemDynList = Arrays.stream(implItemDynamicObjects).collect(Collectors.toList());
            DynamicObjectCollection entryCol = model.getDataEntity(true).getDynamicObjectCollection(entryEntity);
            entryCol.stream().forEach(entryDyn -> implItemDynList.add(entryDyn.getDynamicObject(implItemField)));
            List allImplItemList = implItemDynList.stream().sorted(Comparator.comparing(implItemDyn -> implItemDyn.getInt("listseq"))).collect(Collectors.toList());
            model.beginInit();
            model.deleteEntryData(entryEntity);
            model.batchCreateNewEntryRow(entryEntity, null, allImplItemList.size());
            model.endInit();
            for (int index = 0; index < allImplItemList.size(); ++index) {
                model.setValue(implItemField, allImplItemList.get(index), index);
            }
        }
        view.updateView(entryEntity);
    }
}

