/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web.util;

import com.google.common.base.Splitter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.ImplItemListDaoHelper;
import kd.hrmp.hric.bussiness.service.InitPlanServiceHelper;

public class InitPlanFormUtils {
    private static final String implItemSelectProperties = "name, number, impltype, implsubtype, group, bizsubarea, entityobjscope, usescene, mulfrontimpl, isinitlog, listseq,belongimplitem,industrytype";

    public static void linkInitPlan(IFormView view, long planId) {
        DynamicObject plan = InitPlanServiceHelper.getPlansById((Long)planId);
        if (HRStringUtils.equals((String)plan.getString("planstatus"), (String)"B") || HRStringUtils.equals((String)plan.getString("planstatus"), (String)"C")) {
            InitPlanFormUtils.openPage(view, "hric_initplandetail", planId, plan.getString("name"));
        } else {
            InitPlanFormUtils.openPage(view, "hric_initplan", planId, plan.getString("name"));
        }
    }

    private static void openPage(IFormView view, String entityNumber, long planId, String planName) {
        FormShowParameter showParameter = null;
        String pageId = SessionManager.getCurrent().get(view.getPageId() + planId);
        if (HRStringUtils.isNotEmpty((String)pageId) && SessionManager.getCurrent().getView(pageId) != null) {
            showParameter = SessionManager.getCurrent().getFormShowParameter(pageId);
        } else {
            showParameter = InitPlanFormUtils.getShowParameter(view, entityNumber, planId, planName);
            if (showParameter == null) {
                return;
            }
            showParameter.setHasRight(true);
            SessionManager.getCurrent().put(view.getPageId() + planId, showParameter.getPageId());
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm(showParameter);
    }

    private static FormShowParameter getShowParameter(IFormView view, String entityNumber, long planId, String planName) {
        if (HRStringUtils.equals((String)entityNumber, (String)"hric_initplan")) {
            return InitPlanFormUtils.getPlanEditParameter(planId, planName);
        }
        if (HRStringUtils.equals((String)entityNumber, (String)"hric_initplandetail")) {
            return InitPlanFormUtils.getPlanDetailParameter(planId, planName);
        }
        return new FormShowParameter();
    }

    private static BillShowParameter getPlanEditParameter(long planId, String planName) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("hric_initplan");
        showParameter.setPkId((Object)planId);
        if (HRStringUtils.isNotEmpty((String)planName)) {
            showParameter.setCaption(planName);
        }
        return showParameter;
    }

    private static FormShowParameter getPlanDetailParameter(long planId, String planName) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hric_initplandetail");
        showParameter.setCustomParam("id", (Object)planId);
        if (HRStringUtils.isNotEmpty((String)planName)) {
            showParameter.setCaption(planName);
        }
        return showParameter;
    }

    public static void autoGenerateItemEntry(IDataModel model, IFormView view, boolean isMustExec, DynamicObject industry) {
        DynamicObjectCollection subAreaDyns = (DynamicObjectCollection)model.getValue("bizsubarea");
        if (CollectionUtils.isEmpty((Collection)subAreaDyns)) {
            return;
        }
        Long[] subAreaIds = subAreaDyns.stream().map(dyn -> dyn.getLong("fbasedataid_id")).collect(Collectors.toSet()).toArray(new Long[subAreaDyns.size()]);
        InitPlanFormUtils.generateImplItemData(model, view, subAreaIds, isMustExec, industry);
    }

    private static void generateImplItemData(IDataModel model, IFormView view, Long[] subAreaIds, boolean isMustExec, DynamicObject industry) {
        String planType = (String)model.getValue("plantype");
        List implList = ImplItemListDaoHelper.getImplItemObjectByBizSubArea((String)implItemSelectProperties, Arrays.stream(subAreaIds).collect(Collectors.toSet()), (String)planType, (boolean)isMustExec);
        if (industry != null) {
            implList.removeIf(impl -> {
                DynamicObjectCollection industryDys = impl.getDynamicObjectCollection("industrytype");
                if (industryDys.size() <= 0) {
                    return false;
                }
                long count = industryDys.stream().filter(dyc -> dyc.getDynamicObject("fbasedataid").getLong("id") == industry.getLong("id")).count();
                return count <= 0L;
            });
        }
        model.deleteEntryData("itementryentity");
        InitPlanFormUtils.insertImplItemEntry(model, view, implList, 0, false);
    }

    public static void insertImplItemEntry(IDataModel model, IFormView view, List<DynamicObject> implList, int entryCount, boolean isF7AddImplItem) {
        List subAreaIds;
        if (CollectionUtils.isEmpty(implList)) {
            return;
        }
        if (!isF7AddImplItem) {
            implList = implList.stream().filter(impl -> CollectionUtils.isEmpty((Collection)impl.getDynamicObjectCollection("belongimplitem"))).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(implList)) {
            return;
        }
        model.beginInit();
        model.batchCreateNewEntryRow("itementryentity", null, implList.size());
        model.endInit();
        Object parent = model.getValue("parent");
        if (Objects.isNull(parent)) {
            DynamicObjectCollection subAreaDyns = (DynamicObjectCollection)model.getValue("bizsubarea");
            subAreaIds = subAreaDyns.stream().map(dyn -> dyn.getLong("fbasedataid_id")).collect(Collectors.toList());
        } else {
            String structNumber = (String)Splitter.on((String)"!").trimResults().splitToList((CharSequence)((DynamicObject)parent).getString("structnumber")).get(0);
            DynamicObject dyc = InitPlanServiceHelper.getMasterPlanByStructNumber((String)structNumber);
            DynamicObjectCollection docs = dyc.getDynamicObjectCollection("bizsubarea");
            subAreaIds = docs.stream().map(dyn -> dyn.getLong("fbasedataid_id")).collect(Collectors.toList());
        }
        for (int index = 0; index < implList.size(); ++index) {
            model.setValue("implitem", implList.get(index), entryCount + index);
            model.setValue("itemname", (Object)((DynamicObject)implList.get(index)).getString("name"), entryCount + index);
            model.setValue("impltype", (Object)((DynamicObject)implList.get(index)).getString("impltype"), entryCount + index);
            model.setValue("implsubtype", (Object)((DynamicObject)implList.get(index)).getString("implsubtype"), entryCount + index);
            model.setValue("implgroup", (Object)((DynamicObject)implList.get(index)).getDynamicObject("group"), entryCount + index);
            model.setValue("implbizsubarea", (Object)((DynamicObject)implList.get(index)).getDynamicObject("bizsubarea"), entryCount + index);
            model.setValue("entityobjscope", (Object)((DynamicObject)implList.get(index)).getDynamicObject("entityobjscope"), entryCount + index);
            model.setValue("usescene", (Object)((DynamicObject)implList.get(index)).getString("usescene"), entryCount + index);
            DynamicObjectCollection docs = ((DynamicObject)implList.get(index)).getDynamicObjectCollection("mulfrontimpl");
            if (!CollectionUtils.isEmpty((Collection)docs)) {
                ListIterator iter = docs.listIterator();
                while (iter.hasNext()) {
                    DynamicObject dyc = (DynamicObject)((DynamicObject)iter.next()).get(1);
                    Long id = dyc.getDynamicObject("bizsubarea").getLong("id");
                    String enable = dyc.getString("enable");
                    if (subAreaIds.contains(id) && HRStringUtils.equals((String)enable, (String)"1")) continue;
                    iter.remove();
                }
            }
            model.setValue("mulfrontimpl", (Object)docs, entryCount + index);
        }
        view.updateView("itementryentity");
    }

    public static void handleCollaborationMode(IFormView view, List<String> btnList) {
        view.setVisible(Boolean.FALSE, btnList.toArray(new String[0]));
        view.setVisible(Boolean.valueOf(false), new String[]{"isdataverify", "verifyperson"});
    }
}

