/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web.util;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.init.IInitTaskDomainService;
import kd.hrmp.hric.bussiness.service.InitTaskServiceHelper;
import kd.hrmp.hric.common.bean.vo.InitTaskIdCacheVO;

public class InitTaskFormUtils {
    private static IInitTaskDomainService iInitTaskDomainService = (IInitTaskDomainService)ServiceFactory.getService(IInitTaskDomainService.class);

    public static String showTaskPage(IFormView view, long pkId, String taskName, IFormView parentView) {
        FormShowParameter showParameter = null;
        String pageId = SessionManager.getCurrent().get(view.getPageId() + pkId);
        if (parentView != null) {
            pageId = SessionManager.getCurrent().get(parentView.getPageId() + pkId);
        }
        if (HRStringUtils.isEmpty((String)pageId) || SessionManager.getCurrent().getView(pageId) == null) {
            showParameter = new FormShowParameter();
            if (parentView != null) {
                showParameter.setParentPageId(parentView.getPageId());
            }
            showParameter.setFormId("hric_inittaskform");
            showParameter.setCustomParam("id", (Object)pkId);
            if (HRStringUtils.isNotEmpty((String)taskName)) {
                showParameter.setCaption(taskName);
            } else {
                DynamicObject task = InitTaskServiceHelper.getTask((long)pkId);
                showParameter.setCaption(task.getString("name"));
            }
            String curPageId = parentView == null ? view.getPageId() : parentView.getPageId();
            SessionManager.getCurrent().put(curPageId + pkId, showParameter.getPageId());
        } else {
            showParameter = SessionManager.getCurrent().getFormShowParameter(pageId);
            IFormView targetView = SessionManager.getCurrent().getView(pageId);
            if (Objects.nonNull(targetView)) {
                targetView.getFormShowParameter().setCustomParam("RepeatOpening", (Object)Boolean.TRUE);
                targetView.invokeOperation("refresh");
                view.sendFormAction(targetView);
            }
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm(showParameter);
        return showParameter.getPageId();
    }

    public static void skipFirstTask(IFormView view, long taskId) {
        InitTaskIdCacheVO cacheVO = InitTaskFormUtils.getInitTaskIdCacheVO(taskId);
        if (cacheVO.getFirstId() == 0L) {
            cacheVO.setFirstId(iInitTaskDomainService.getFirstInitTaskId());
            SessionManager.getCurrent().put(InitTaskFormUtils.getCacheKey(), SerializationUtils.toJsonString((Object)cacheVO));
        }
        if (cacheVO.getFirstId() == taskId) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u7b2c\u4e00\u4e2a\u4efb\u52a1\u3002", (String)"InitTaskFormUtils_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return;
        }
        InitTaskFormUtils.showTaskPage(view, cacheVO.getFirstId(), "", view.getParentView());
        view.close();
    }

    public static void skipPreviousTask(IFormView view, long taskId) {
        int previousIndex;
        InitTaskIdCacheVO cacheVO = InitTaskFormUtils.getInitTaskIdCacheVO(taskId);
        List midIdList = cacheVO.getMidIdList();
        int currentIndex = midIdList.indexOf(taskId);
        if (CollectionUtils.isEmpty((Collection)midIdList) || currentIndex <= 0) {
            cacheVO = iInitTaskDomainService.getInitTaskIdCacheVO(Long.valueOf(taskId));
            SessionManager.getCurrent().put(InitTaskFormUtils.getCacheKey(), SerializationUtils.toJsonString((Object)cacheVO));
        }
        if ((previousIndex = cacheVO.getMidIdList().indexOf(taskId) - 1) < 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u7b2c\u4e00\u4e2a\u4efb\u52a1\u3002", (String)"InitTaskFormUtils_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return;
        }
        Long previousTaskId = (Long)cacheVO.getMidIdList().get(previousIndex);
        InitTaskFormUtils.showTaskPage(view, previousTaskId, "", view.getParentView());
        view.close();
    }

    public static void skipNextTask(IFormView view, long taskId) {
        int nextIndex;
        InitTaskIdCacheVO cacheVO = InitTaskFormUtils.getInitTaskIdCacheVO(taskId);
        List midIdList = cacheVO.getMidIdList();
        int currentIndex = midIdList.indexOf(taskId);
        if (CollectionUtils.isEmpty((Collection)midIdList) || currentIndex == midIdList.size() - 1 || currentIndex < 0) {
            cacheVO = iInitTaskDomainService.getInitTaskIdCacheVO(Long.valueOf(taskId));
            SessionManager.getCurrent().put(InitTaskFormUtils.getCacheKey(), SerializationUtils.toJsonString((Object)cacheVO));
        }
        if ((nextIndex = cacheVO.getMidIdList().indexOf(taskId) + 1) >= cacheVO.getMidIdList().size()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u4e2a\u4efb\u52a1\u3002", (String)"InitTaskFormUtils_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return;
        }
        Long nextTaskId = (Long)cacheVO.getMidIdList().get(nextIndex);
        InitTaskFormUtils.showTaskPage(view, nextTaskId, "", view.getParentView());
        view.close();
    }

    public static void skipLastTask(IFormView view, long taskId) {
        InitTaskIdCacheVO cacheVO = InitTaskFormUtils.getInitTaskIdCacheVO(taskId);
        if (cacheVO.getLastId() == 0L) {
            cacheVO.setLastId(iInitTaskDomainService.getLastInitTaskId());
            SessionManager.getCurrent().put(InitTaskFormUtils.getCacheKey(), SerializationUtils.toJsonString((Object)cacheVO));
        }
        if (cacheVO.getLastId() == taskId) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u4e2a\u4efb\u52a1\u3002", (String)"InitTaskFormUtils_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return;
        }
        InitTaskFormUtils.showTaskPage(view, cacheVO.getLastId(), "", view.getParentView());
        view.close();
    }

    private static InitTaskIdCacheVO getInitTaskIdCacheVO(Long taskId) {
        String sessionCacheJson = SessionManager.getCurrent().get(InitTaskFormUtils.getCacheKey());
        if (HRStringUtils.isEmpty((String)sessionCacheJson)) {
            return iInitTaskDomainService.getInitTaskIdCacheVO(taskId);
        }
        return (InitTaskIdCacheVO)SerializationUtils.fromJsonString((String)sessionCacheJson, InitTaskIdCacheVO.class);
    }

    private static String getCacheKey() {
        return "INITTASKID" + UserServiceHelper.getCurrentUserId();
    }
}

