/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.annex;

import com.google.common.base.Splitter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.annex.IAnnexOpHandle;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.init.IAnnexErrorDataDomainService;
import kd.hrmp.hric.bussiness.domain.init.IContractAnnexDomainService;
import kd.hrmp.hric.bussiness.domain.init.IMigrationToolDomainService;
import kd.hrmp.hric.bussiness.domain.init.IPersonHeadPicDomainService;
import kd.hrmp.hric.common.util.AttachmentUtils;

public abstract class AbstractAnnexOpHandle
implements IAnnexOpHandle {
    private static Log LOG = LogFactory.getLog(AbstractAnnexOpHandle.class);
    protected String ensemeleType;
    protected String dischemeNumber;
    protected String transferType;
    protected List<String> apiList = new ArrayList<String>();
    protected FileService fs;
    protected RequestContext requestContext;
    protected String fileName;
    protected String status;
    protected byte[] fileData;
    protected String errorMsg;
    IMigrationToolDomainService migrationToolDomainService = ServiceFactory.getService(IMigrationToolDomainService.class);
    IPersonHeadPicDomainService personHeadPicDomainService = ServiceFactory.getService(IPersonHeadPicDomainService.class);
    IContractAnnexDomainService iContractAnnexDomainService = ServiceFactory.getService(IContractAnnexDomainService.class);
    IAnnexErrorDataDomainService iAnnexErrorDataDomainService = ServiceFactory.getService(IAnnexErrorDataDomainService.class);

    @Override
    public void handleAnnexImporotByDi(Map<String, Object> paramMap) {
        this.init(paramMap);
        this.doHandleForDi(paramMap);
    }

    @Override
    public int getAnnexImportSchedule(Map<String, Object> paramMap) {
        if (AttachmentUtils.handleStop(paramMap)) {
            return 100;
        }
        BigDecimal countBig = new BigDecimal(this.getCurFinishCount((Long)paramMap.get("migratebatchnumber")));
        BigDecimal totalBig = new BigDecimal((Integer)paramMap.get("count"));
        if (totalBig.compareTo(new BigDecimal(0)) == 0) {
            return 100;
        }
        return countBig.divide(totalBig, 2, 4).multiply(new BigDecimal(100)).intValue();
    }

    public abstract int getCurFinishCount(Long var1);

    public abstract void doHandleForDi(Map<String, Object> var1);

    protected void init(Map<String, Object> paramMap) {
        DynamicObject annexInitTypeInfo = this.migrationToolDomainService.getAnnexInitTypeInfo(paramMap.get("annexinittype").toString());
        this.ensemeleType = annexInitTypeInfo.getString("ensembletype");
        this.dischemeNumber = annexInitTypeInfo.getString("dischemenumber");
        this.transferType = annexInitTypeInfo.getString("transfertype");
        String bizApi = annexInitTypeInfo.getString("bizapi");
        this.apiList = Splitter.on((String)"_").splitToList((CharSequence)bizApi);
        this.fs = HRStringUtils.equals((String)this.transferType, (String)"A") ? FileServiceFactory.getImageFileService() : FileServiceFactory.getAttachmentFileService();
        this.requestContext = RequestContext.get();
    }

    protected void handleErrorMsg(DynamicObject dyc, String errorMsg) {
        dyc.set("initstatus", (Object)"B");
        if (errorMsg.length() >= 255) {
            dyc.set("errormsg", (Object)errorMsg.substring(0, 255));
            dyc.set("errormsg_tag", (Object)errorMsg);
        } else {
            dyc.set("errormsg", (Object)errorMsg);
        }
    }

    protected boolean checkReturnResult(DynamicObject dyc, Map<String, Object> returnMap) {
        if (!returnMap.containsKey("filename")) {
            return this.updateErrorInfo(dyc, "filename");
        }
        this.fileName = returnMap.get("filename").toString();
        if (!returnMap.containsKey("data")) {
            return this.updateErrorInfo(dyc, "data");
        }
        this.fileData = (byte[])returnMap.get("data");
        if (returnMap.containsKey("status")) {
            this.status = returnMap.get("status").toString();
            if (HRStringUtils.isEmpty((String)this.status)) {
                return this.updateErrorInfo(dyc, "status");
            }
        } else {
            return this.updateErrorInfo(dyc, "status");
        }
        if (!returnMap.containsKey("errormsg")) {
            return this.updateErrorInfo(dyc, "errormsg");
        }
        this.errorMsg = returnMap.get("errormsg").toString();
        return false;
    }

    protected boolean updateErrorInfo(DynamicObject dyc, String field) {
        dyc.set("initstatus", (Object)"B");
        dyc.set("errormsg", (Object)String.format(Locale.ROOT, "The %s is empty", field));
        this.personHeadPicDomainService.saveOne(dyc);
        return true;
    }

    protected void saveErrorZip(Map<String, String> fileNameMap, DynamicObject[] dynamicObjects, String entityCode, String number) {
        List numberList = Arrays.stream(dynamicObjects).map(it -> it.getString(number)).collect(Collectors.toList());
        ArrayList<String> keyList = new ArrayList<String>(fileNameMap.size());
        for (Map.Entry<String, String> entry : fileNameMap.entrySet()) {
            String name = entry.getKey();
            if (name.indexOf("/") > -1) {
                name = name.substring(name.lastIndexOf("/") + 1);
            }
            name = name.substring(0, name.lastIndexOf("."));
            if (HRStringUtils.equals((String)entityCode, (String)"hric_perheadpicinit")) {
                if (name.indexOf("+") > -1) {
                    name = name.substring(0, name.indexOf("+"));
                }
            } else {
                name = name.substring(name.lastIndexOf("+") + 1);
            }
            if (!numberList.contains(name)) continue;
            keyList.add(entry.getKey());
        }
        keyList.forEach(it -> fileNameMap.remove(it));
    }
}

