/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.annex;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.bos.util.FileNameUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.annex.AbstractAnnexOpHandle;
import kd.hrmp.hric.bussiness.service.BaseConfigServiceHelper;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.constants.msg.AnnexEnum;
import kd.hrmp.hric.common.util.AttachmentUtils;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.common.util.HricCacheUtils;
import kd.hrmp.hric.common.util.HricDynamicObjectUtils;

public class AnnexOpHandleForContract
extends AbstractAnnexOpHandle {
    private static Log LOG = LogFactory.getLog(AnnexOpHandleForContract.class);

    @Override
    public void handlePersonSync(String annexInitType, Long batchNumber, Map<String, String> zipParamMap) {
        ThreadPools.executeOnceIncludeRequestContext((String)"contract-personsync-task", () -> {
            DynamicObject annexInitTypeInfo = this.migrationToolDomainService.getAnnexInitTypeInfo(annexInitType);
            String string = annexInitTypeInfo.getString("personapi");
            String[] split = string.split("_");
            int pageIndex = 1;
            int pageSize = 5000;
            String annexSize = Optional.ofNullable(BaseConfigServiceHelper.get("hric_initannex_size")).orElseGet(() -> "");
            if (HRStringUtils.isNotEmpty((String)annexSize)) {
                pageSize = Integer.parseInt(annexSize);
            }
            while (HricCacheUtils.get((String)annexInitType, String.class) == null) {
                Map personMap = (Map)HRMServiceHelper.invokeBizService((String)split[0], (String)split[1], (String)split[2], (String)split[3], (Object[])new Object[]{pageIndex, pageSize});
                Map dataMap = (Map)personMap.get("data");
                if (HRStringUtils.equals((String)ConvertUtils.toString(personMap.get("code")), (String)"202") || HRStringUtils.equals((String)ConvertUtils.toString(personMap.get("code")), (String)"203") || HRStringUtils.equals((String)ConvertUtils.toString(personMap.get("code")), (String)"205")) break;
                if (HRStringUtils.equals((String)ConvertUtils.toString(personMap.get("code")), (String)"201")) {
                    ++pageIndex;
                    continue;
                }
                List data = (List)dataMap.get("data");
                if (CollectionUtils.isEmpty((Collection)data)) {
                    ++pageIndex;
                    continue;
                }
                this.iContractAnnexDomainService.saveOrUpdate(data, batchNumber, zipParamMap, annexInitTypeInfo.getString("uniquefield"));
                ++pageIndex;
            }
        }, (String)"hric");
    }

    @Override
    public void doHandleForDi(Map<String, Object> paramMap) {
        Long migrateBatchNumber = (Long)paramMap.get("migratebatchnumber");
        ThreadPools.executeOnceIncludeRequestContext((String)"personheadpic-improtbydi-task", () -> {
            try {
                while (!AttachmentUtils.handleStop((Map)paramMap)) {
                    Object[] dys;
                    boolean isPart = paramMap.containsKey("pkids");
                    if (isPart) {
                        dys = this.iContractAnnexDomainService.getContractInfoByIdSet((Set)paramMap.get("pkids"));
                    } else {
                        dys = this.iContractAnnexDomainService.getFailAndWaitContractInfo();
                        if (HRArrayUtils.isEmpty((Object[])dys)) break;
                    }
                    for (Object dyc : dys) {
                        Map resultMap;
                        dyc.set("batchnumber", (Object)migrateBatchNumber);
                        final String contractNumber = dyc.getString("contractnumber");
                        try {
                            if (HRStringUtils.equals((String)this.ensemeleType, (String)"isc_service_flow")) {
                                Map result = (Map)HRMServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"execute", (Object[])new Object[]{this.dischemeNumber, new ArrayList<String>(){
                                    {
                                        this.add(contractNumber);
                                    }
                                }});
                                Map output = (Map)result.get("output");
                                resultMap = (Map)output.get("returnMap");
                            } else {
                                List resultForAPI = (List)HRMServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscApicService", (String)"invokeScriptApi2", (Object[])new Object[]{this.dischemeNumber, new HashMap<String, String>(){
                                    {
                                        this.put("contractnumber", contractNumber);
                                    }
                                }, null});
                                resultMap = (Map)resultForAPI.get(0);
                            }
                        }
                        catch (Exception e) {
                            this.handleErrorMsg((DynamicObject)dyc, e.getMessage());
                            this.iContractAnnexDomainService.saveOne((DynamicObject)dyc);
                            continue;
                        }
                        this.handleReturnResult((DynamicObject)dyc, resultMap);
                    }
                    if (!isPart) continue;
                    break;
                }
            }
            catch (Exception e) {
                LOG.error("doHandleForDi error", (Throwable)e);
            }
        }, (String)"hric");
    }

    private void handleReturnResult(DynamicObject dyc, Map<String, Object> returnMap) {
        block7: {
            if (this.checkReturnResult(dyc, returnMap)) {
                return;
            }
            if (HRStringUtils.equals((String)this.status, (String)"S")) {
                try {
                    String pathParam = FileNameUtils.getAttachmentFileName((String)this.requestContext.getTenantId(), (String)this.requestContext.getAccountId(), (Object)"init", (String)this.fileName);
                    if (this.fs.exists(pathParam)) {
                        this.fileName = String.join((CharSequence)"", ConvertUtils.toString((Object)ID.genLongId()), this.fileName);
                        pathParam = FileNameUtils.getAttachmentFileName((String)this.requestContext.getTenantId(), (String)this.requestContext.getAccountId(), (Object)"init", (String)this.fileName);
                    }
                    FileItem fi = new FileItem(this.fileName, pathParam, (InputStream)new ByteArrayInputStream(this.fileData));
                    fi.setCreateNewFileWhenExists(true);
                    this.fs.upload(fi);
                    HashMap paramMap = Maps.newHashMap();
                    paramMap.put("id", dyc.getLong("contractid"));
                    paramMap.put("number", dyc.getString("contractnumber"));
                    paramMap.put("protocolType", dyc.getString("contracttype"));
                    paramMap.put("fileId", pathParam);
                    String filename = returnMap.get("filename").toString();
                    paramMap.put("fileName", filename);
                    paramMap.put("extName", this.getFileNameSuffix(filename, pathParam));
                    paramMap.put("fileSize", this.getFileSize(returnMap, pathParam));
                    Map apiResult = (Map)HRMServiceHelper.invokeBizService((String)((String)this.apiList.get(0)), (String)((String)this.apiList.get(1)), (String)((String)this.apiList.get(2)), (String)((String)this.apiList.get(3)), (Object[])new Object[]{paramMap});
                    Boolean success = (Boolean)apiResult.get("success");
                    if (success.booleanValue()) {
                        dyc.set("initstatus", (Object)"A");
                        dyc.set("errormsg", null);
                        dyc.set("errormsg_tag", null);
                        dyc.set("filepath", (Object)pathParam);
                        dyc.set("filename", (Object)filename);
                        dyc.set("filesize", returnMap.get("filesize"));
                        break block7;
                    }
                    this.handleErrorMsg(dyc, apiResult.get("errormsg").toString());
                }
                catch (Exception e) {
                    this.handleErrorMsg(dyc, e.getMessage());
                }
            } else {
                dyc.set("initstatus", (Object)"B");
                dyc.set("errormsg", (Object)this.errorMsg);
            }
        }
        this.iContractAnnexDomainService.saveOne(dyc);
    }

    private int getFileSize(Map<String, Object> returnMap, String pathParam) throws Exception {
        int size = ConvertUtils.toInteger((Object)returnMap.get("filesize"));
        if (ObjectUtils.isEmpty((Object)size)) {
            return AttachmentServiceHelper.getFileSizeByPath((String)pathParam);
        }
        return size;
    }

    private String getFileNameSuffix(String filename, String pathParam) {
        String suffix = filename.substring(filename.lastIndexOf(".") + 1);
        if (HRStringUtils.isEmpty((String)suffix)) {
            suffix = pathParam.substring(pathParam.lastIndexOf(".") + 1);
        }
        return suffix;
    }

    @Override
    public void handleAnnexImporotByZip(Map<String, Object> paramMap) {
        ThreadPools.executeOnceIncludeRequestContext((String)"contract-improtbyzip-task", () -> {
            Map errorDataMap;
            Long migrateBatchNumber = (Long)paramMap.get("migratebatchnumber");
            Map zipParamMap = (Map)paramMap.get("zipparammap");
            List<String> zipList = zipParamMap.keySet().stream().collect(Collectors.toList());
            DynamicObject annexInitTypeInfo = this.migrationToolDomainService.getAnnexInitTypeInfo(paramMap.get("annexinittype").toString());
            String uniqueType = annexInitTypeInfo.getString("uniquefield");
            String bizApi = annexInitTypeInfo.getString("bizapi");
            List pkIdSet = (List)paramMap.get("pkids");
            paramMap.put("uniquefield", uniqueType);
            int count = ConvertUtils.toInteger(paramMap.get("count"));
            Map fileNameMap = AttachmentUtils.analyzeZip((Map)zipParamMap);
            List numberList = AttachmentUtils.getIdsByZip((Map)zipParamMap, (String)"hric_contractinit", (String)uniqueType);
            if (count == 0) {
                HashMap<String, Map<String, String>> errorDataMap2 = new HashMap<String, Map<String, String>>(1);
                this.iAnnexErrorDataDomainService.save(migrateBatchNumber, fileNameMap, errorDataMap2);
                return;
            }
            if (CollectionUtils.isEmpty((Collection)pkIdSet)) {
                DynamicObject[] contracts = this.iContractAnnexDomainService.getContractByNumberList(numberList);
                Map<String, String> errorFileNumberMap = this.updateFile(bizApi, migrateBatchNumber, contracts, paramMap, zipList);
                errorDataMap = AttachmentUtils.analyzeFileMap(errorFileNumberMap, (Map)fileNameMap);
                this.saveErrorZip(fileNameMap, contracts, "hric_contractinit", "contractnumber");
            } else {
                DynamicObject[] personHeadPics = this.iContractAnnexDomainService.getPersonHeadPicByIds(pkIdSet.toArray());
                Map<String, String> errorFileNumberMap = this.updateFile(bizApi, migrateBatchNumber, personHeadPics, paramMap, zipList);
                errorDataMap = AttachmentUtils.analyzeFileMap(errorFileNumberMap, (Map)fileNameMap);
                this.saveErrorZip(fileNameMap, personHeadPics, "hric_contractinit", "contractnumber");
            }
            this.iAnnexErrorDataDomainService.save(migrateBatchNumber, fileNameMap, errorDataMap);
        }, (String)"hric");
    }

    private Map<String, String> updateFile(String bizApi, Long batchNumber, DynamicObject[] personHeadPics, Map<String, Object> zipParamMap, List<String> map) {
        String[] params = bizApi.split("_");
        ArrayList newList = new ArrayList();
        HashMap<String, String> errorFileNumberMap = new HashMap<String, String>(AppConstants.MAP_SIZE);
        FileService fs = FileServiceFactory.getAttachmentFileService();
        Arrays.stream(personHeadPics).filter(AttachmentUtils.distinctByKey(p -> p.getString("contractnumber"))).forEach(newList::add);
        Map<String, DynamicObject> personMap = newList.stream().collect(Collectors.toMap(it -> it.getString("contractnumber"), it -> it));
        Map zipMap = new HashMap(AppConstants.MAP_SIZE);
        if (CollectionUtils.isNotEmpty(map)) {
            zipMap = AttachmentUtils.parseUrl(map, (String)"hric_contractinit", newList.stream().collect(Collectors.toMap(it -> it.getString("contractnumber"), it -> String.join((CharSequence)"", ConvertUtils.toString((Object)it.get("number")), "+", ConvertUtils.toString((Object)it.get("name"))))), (String)ConvertUtils.toString((Object)zipParamMap.get("uniquefield")));
        }
        for (Map.Entry<String, DynamicObject> entry : personMap.entrySet()) {
            if (AttachmentUtils.handleStop(zipParamMap)) break;
            DynamicObject value = entry.getValue();
            value.set("batchnumber", (Object)batchNumber);
            value.set("modifytime", (Object)new Date());
            value.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
            if (HRStringUtils.isNotEmpty((String)value.getString("filepath")) || zipMap.containsKey(entry.getKey())) {
                String path = value.getString("filepath");
                if (zipMap.containsKey(entry.getKey())) {
                    if (HRStringUtils.equals((String)ConvertUtils.toString(zipMap.get(entry.getKey())), (String)"false")) {
                        value.set("errormsg", (Object)String.format(Locale.ROOT, AnnexEnum.ANNEX_CONTRACTNAME_CHECK.getMsg(), entry.getValue().getString("number")));
                        value.set("initstatus", (Object)"B");
                        this.iContractAnnexDomainService.saveOne(value);
                        errorFileNumberMap.put(value.getString("contractnumber"), String.format(Locale.ROOT, AnnexEnum.ANNEX_CONTRACTNAME_CHECK.getMsg(), entry.getValue().getString("number")));
                        continue;
                    }
                    path = (String)zipMap.get(entry.getKey());
                    value.set("filepath", zipMap.get(entry.getKey()));
                    value.set("filename", (Object)entry.getKey());
                } else if (CollectionUtils.isNotEmpty(map)) {
                    this.iContractAnnexDomainService.saveOne(value);
                    continue;
                }
                value.set("filesize", (Object)fs.getFileSize(path));
                String ext = path.substring(path.lastIndexOf(".") + 1);
                HashMap<String, Object> paramsMap = new HashMap<String, Object>(AppConstants.MAP_SIZE);
                paramsMap.put("id", value.getLong("contractid"));
                paramsMap.put("number", value.getString("contractnumber"));
                paramsMap.put("protocolType", value.getString("contracttype"));
                paramsMap.put("fileId", value.getString("filepath"));
                paramsMap.put("fileName", String.join((CharSequence)".", value.getString("filename"), ext));
                paramsMap.put("extName", ext);
                paramsMap.put("fileSize", value.getLong("fileSize"));
                Map resultMap = (Map)HRMServiceHelper.invokeBizService((String)params[0], (String)params[1], (String)params[2], (String)params[3], (Object[])new Object[]{paramsMap});
                value.set("initstatus", (Object)(ConvertUtils.toBoolean(resultMap.get("success")) ? "A" : "B"));
                if (ConvertUtils.toBoolean(resultMap.get("success"))) {
                    value.set("errormsg", (Object)"");
                } else {
                    HricDynamicObjectUtils.setBigText((DynamicObject)value, (String)"errormsg", (String)ConvertUtils.toString(resultMap.get("message")));
                    errorFileNumberMap.put(value.getString("contractnumber"), ConvertUtils.toString(resultMap.get("message")));
                }
            }
            this.iContractAnnexDomainService.saveOne(value);
        }
        return errorFileNumberMap;
    }

    @Override
    public int getPersonSyncSchedule(Map<String, Object> map) {
        if (AttachmentUtils.handleStop(map)) {
            return 100;
        }
        int count = this.iContractAnnexDomainService.queryCountByBatchNumber((Long)map.get("batchnumber"));
        return AttachmentUtils.getProgressValue(map, (int)count);
    }

    @Override
    public int getFailAndWaitTotal() {
        return this.iContractAnnexDomainService.getFailAndWaitContractInfoTotal();
    }

    @Override
    public List<Long> getIdsByNumbers(List<String> numberList) {
        DynamicObject[] dyns = this.iContractAnnexDomainService.getContractByNumberList(numberList);
        return Arrays.stream(dyns).map(it -> it.getLong("id")).collect(Collectors.toList());
    }

    @Override
    public int getCurFinishCount(Long batchNumber) {
        return this.iContractAnnexDomainService.queryCountByBatchNumber(batchNumber);
    }
}

