/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.annex;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.fileservice.FileItem;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.bos.util.FileNameUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.annex.AbstractAnnexOpHandle;
import kd.hrmp.hric.bussiness.service.BaseConfigServiceHelper;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.constants.msg.AnnexEnum;
import kd.hrmp.hric.common.util.AttachmentUtils;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.common.util.HricCacheUtils;
import kd.hrmp.hric.common.util.HricDynamicObjectUtils;

public class AnnexOpHandleForPersonHeadPic
extends AbstractAnnexOpHandle {
    private static Log LOG = LogFactory.getLog(AnnexOpHandleForPersonHeadPic.class);

    @Override
    public void handlePersonSync(String annexInitType, Long batchNumber, Map<String, String> zipParamMap) {
        ThreadPools.executeOnceIncludeRequestContext((String)"personheadpic-personsync-task", () -> {
            DynamicObject annexInitTypeInfo = this.migrationToolDomainService.getAnnexInitTypeInfo(annexInitType);
            String string = annexInitTypeInfo.getString("personapi");
            String[] split = string.split("_");
            int pageIndex = 1;
            int pageSize = 5000;
            String annexSize = Optional.ofNullable(BaseConfigServiceHelper.get("hric_initannex_size")).orElseGet(() -> "");
            if (HRStringUtils.isNotEmpty((String)annexSize)) {
                pageSize = Integer.parseInt(annexSize);
            }
            boolean lastPage = false;
            while (!lastPage && HricCacheUtils.get((String)annexInitType, String.class) == null) {
                Map personMap = (Map)HRMServiceHelper.invokeBizService((String)split[0], (String)split[1], (String)split[2], (String)split[3], (Object[])new Object[]{pageIndex, pageSize});
                lastPage = ConvertUtils.toBoolean(personMap.get("lastPage"));
                List list = (List)personMap.get("data");
                this.personHeadPicDomainService.saveOrUpdate(list, batchNumber, zipParamMap, annexInitTypeInfo.getString("uniquefield"));
                ++pageIndex;
            }
        }, (String)"hric");
    }

    @Override
    public void doHandleForDi(Map<String, Object> paramMap) {
        Long migrateBatchNumber = (Long)paramMap.get("migratebatchnumber");
        boolean isPart = paramMap.containsKey("pkids");
        ThreadPools.executeOnceIncludeRequestContext((String)"personheadpic-improtbydi-task", () -> {
            try {
                while (!AttachmentUtils.handleStop((Map)paramMap)) {
                    Object[] dys;
                    if (isPart) {
                        dys = this.personHeadPicDomainService.getPersonHeadPicByIdSet((Set)paramMap.get("pkids"));
                    } else {
                        dys = this.personHeadPicDomainService.getFailAndWaitPersonHeadPicInfo();
                        if (HRArrayUtils.isEmpty((Object[])dys)) break;
                    }
                    for (Object dyc : dys) {
                        Map resultMap;
                        dyc.set("batchnumber", (Object)migrateBatchNumber);
                        final String number = dyc.getString("number");
                        try {
                            if (HRStringUtils.equals((String)this.ensemeleType, (String)"isc_service_flow")) {
                                Map result = (Map)HRMServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"execute", (Object[])new Object[]{this.dischemeNumber, new ArrayList<String>(){
                                    {
                                        this.add(number);
                                    }
                                }});
                                Map output = (Map)result.get("output");
                                resultMap = (Map)output.get("returnMap");
                            } else {
                                List resultForAPI = (List)HRMServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscApicService", (String)"invokeScriptApi2", (Object[])new Object[]{this.dischemeNumber, new HashMap<String, String>(){
                                    {
                                        this.put("number", number);
                                    }
                                }, null});
                                resultMap = (Map)resultForAPI.get(0);
                            }
                        }
                        catch (Exception e) {
                            this.handleErrorMsg((DynamicObject)dyc, e.getMessage());
                            this.personHeadPicDomainService.saveOne((DynamicObject)dyc);
                            continue;
                        }
                        this.handleReturnResult((DynamicObject)dyc, number, resultMap);
                    }
                    if (!isPart) continue;
                    break;
                }
            }
            catch (Exception e) {
                LOG.error("doHandleForDi error", (Throwable)e);
            }
        }, (String)"hric");
    }

    private void handleReturnResult(DynamicObject dyc, String number, Map<String, Object> returnMap) {
        block7: {
            if (this.checkReturnResult(dyc, returnMap)) {
                return;
            }
            if (HRStringUtils.equals((String)this.status, (String)"S")) {
                try {
                    String pathParam = FileNameUtils.getAttachmentFileName((String)this.requestContext.getTenantId(), (String)this.requestContext.getAccountId(), (Object)"init", (String)this.fileName);
                    if (this.fs.exists(pathParam)) {
                        this.fileName = String.join((CharSequence)"", ConvertUtils.toString((Object)ID.genLongId()), this.fileName);
                        pathParam = FileNameUtils.getAttachmentFileName((String)this.requestContext.getTenantId(), (String)this.requestContext.getAccountId(), (Object)"init", (String)this.fileName);
                    }
                    FileItem fi = new FileItem(this.fileName, pathParam, (InputStream)new ByteArrayInputStream(this.fileData));
                    fi.setCreateNewFileWhenExists(true);
                    this.fs.upload(fi);
                    Map apiResult = (Map)HRMServiceHelper.invokeBizService((String)((String)this.apiList.get(0)), (String)((String)this.apiList.get(1)), (String)((String)this.apiList.get(2)), (String)((String)this.apiList.get(3)), (Object[])new Object[]{number, pathParam});
                    Boolean success = (Boolean)apiResult.get("success");
                    if (success.booleanValue()) {
                        dyc.set("initstatus", (Object)"A");
                        dyc.set("errormsg", null);
                        dyc.set("errormsg_tag", null);
                        dyc.set("filepath", (Object)pathParam);
                        break block7;
                    }
                    this.handleErrorMsg(dyc, apiResult.get("message").toString());
                }
                catch (Exception e) {
                    this.handleErrorMsg(dyc, e.getMessage());
                }
            } else {
                dyc.set("initstatus", (Object)"B");
                dyc.set("errormsg", (Object)this.errorMsg);
            }
        }
        this.personHeadPicDomainService.saveOne(dyc);
    }

    @Override
    public void handleAnnexImporotByZip(Map<String, Object> paramMap) {
        ThreadPools.executeOnceIncludeRequestContext((String)"personheadpic-improtbyzip-task", () -> {
            Map errorDataMap;
            Long migrateBatchNumber = (Long)paramMap.get("migratebatchnumber");
            Map zipParamMap = (Map)paramMap.get("zipparammap");
            List<String> zipList = zipParamMap.keySet().stream().collect(Collectors.toList());
            DynamicObject annexInitTypeInfo = this.migrationToolDomainService.getAnnexInitTypeInfo(paramMap.get("annexinittype").toString());
            String uniqueType = annexInitTypeInfo.getString("uniquefield");
            String bizApi = annexInitTypeInfo.getString("bizapi");
            List pkIdSet = (List)paramMap.get("pkids");
            paramMap.put("uniquefield", uniqueType);
            int count = ConvertUtils.toInteger(paramMap.get("count"));
            Map fileNameMap = AttachmentUtils.analyzeZip((Map)zipParamMap);
            List numberList = AttachmentUtils.getIdsByZip((Map)zipParamMap, (String)"hric_perheadpicinit", (String)uniqueType);
            if (count == 0) {
                HashMap<String, Map<String, String>> errorDataMap2 = new HashMap<String, Map<String, String>>(1);
                this.iAnnexErrorDataDomainService.save(migrateBatchNumber, fileNameMap, errorDataMap2);
                return;
            }
            if (CollectionUtils.isEmpty((Collection)pkIdSet)) {
                DynamicObject[] persons = this.personHeadPicDomainService.getPersonHeadByNumberList(numberList);
                Map<String, String> errorFileNumberMap = this.updateFile(bizApi, migrateBatchNumber, persons, paramMap, zipList);
                errorDataMap = AttachmentUtils.analyzeFileMap(errorFileNumberMap, (Map)fileNameMap);
                this.saveErrorZip(fileNameMap, persons, "hric_perheadpicinit", "number");
            } else {
                DynamicObject[] personHeadPics = this.personHeadPicDomainService.getPersonHeadPicByIds(pkIdSet.toArray());
                Map<String, String> errorFileNumberMap = this.updateFile(bizApi, migrateBatchNumber, personHeadPics, paramMap, zipList);
                errorDataMap = AttachmentUtils.analyzeFileMap(errorFileNumberMap, (Map)fileNameMap);
                this.saveErrorZip(fileNameMap, personHeadPics, "hric_perheadpicinit", "number");
            }
            this.iAnnexErrorDataDomainService.save(migrateBatchNumber, fileNameMap, errorDataMap);
        }, (String)"hric");
    }

    private Map<String, String> updateFile(String bizApi, Long batchNumber, DynamicObject[] personHeadPics, Map<String, Object> zipParamMap, List<String> zipMap) {
        String[] params = bizApi.split("_");
        ArrayList newList = new ArrayList();
        HashMap<String, String> errorFileNumberMap = new HashMap<String, String>(AppConstants.MAP_SIZE);
        Arrays.stream(personHeadPics).filter(AttachmentUtils.distinctByKey(p -> p.getString("number"))).forEach(newList::add);
        Map<String, DynamicObject> personMap = newList.stream().collect(Collectors.toMap(it -> it.getString("number"), it -> it));
        Map map = new HashMap(AppConstants.MAP_SIZE);
        if (CollectionUtils.isNotEmpty(zipMap)) {
            map = AttachmentUtils.parseUrl(zipMap, (String)"hric_perheadpicinit", newList.stream().collect(Collectors.toMap(it -> it.getString("number"), it -> it.get("name"))), (String)ConvertUtils.toString((Object)zipParamMap.get("uniquefield")));
        }
        Date date = new Date();
        for (Map.Entry<String, DynamicObject> entry : personMap.entrySet()) {
            if (AttachmentUtils.handleStop(zipParamMap)) break;
            DynamicObject personHead = entry.getValue();
            personHead.set("batchnumber", (Object)batchNumber);
            personHead.set("modifytime", (Object)date);
            personHead.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
            if (HRStringUtils.isNotEmpty((String)personHead.getString("filepath")) || map.containsKey(entry.getKey())) {
                if (map.containsKey(entry.getKey())) {
                    if (HRStringUtils.equals((String)ConvertUtils.toString(map.get(entry.getKey())), (String)"false")) {
                        personHead.set("errormsg", (Object)String.format(Locale.ROOT, AnnexEnum.ANNEX_NAME_CHECK.getMsg(), entry.getKey()));
                        personHead.set("initstatus", (Object)"B");
                        this.personHeadPicDomainService.saveOne(personHead);
                        errorFileNumberMap.put(personHead.getString("number"), String.format(Locale.ROOT, AnnexEnum.ANNEX_NAME_CHECK.getMsg(), entry.getKey()));
                        continue;
                    }
                    personHead.set("filepath", map.get(entry.getKey()));
                } else if (CollectionUtils.isNotEmpty(zipMap)) {
                    this.personHeadPicDomainService.saveOne(personHead);
                    continue;
                }
                Map resultMap = (Map)HRMServiceHelper.invokeBizService((String)params[0], (String)params[1], (String)params[2], (String)params[3], (Object[])new Object[]{entry.getKey(), personHead.getString("filepath")});
                personHead.set("initstatus", (Object)(ConvertUtils.toBoolean(resultMap.get("success")) ? "A" : "B"));
                if (ConvertUtils.toBoolean(resultMap.get("success"))) {
                    personHead.set("errormsg", (Object)"");
                } else {
                    HricDynamicObjectUtils.setBigText((DynamicObject)personHead, (String)"errormsg", (String)ConvertUtils.toString(resultMap.get("message")));
                    errorFileNumberMap.put(personHead.getString("number"), ConvertUtils.toString(resultMap.get("message")));
                }
            }
            this.personHeadPicDomainService.saveOne(personHead);
        }
        return errorFileNumberMap;
    }

    @Override
    public int getPersonSyncSchedule(Map<String, Object> map) {
        if (AttachmentUtils.handleStop(map)) {
            return 100;
        }
        int count = this.personHeadPicDomainService.queryCountByBatchNumber((Long)map.get("batchnumber"));
        return AttachmentUtils.getProgressValue(map, (int)count);
    }

    @Override
    public int getFailAndWaitTotal() {
        return this.personHeadPicDomainService.getFailAndWaitPersonHeadPicInfoTotal();
    }

    @Override
    public List<Long> getIdsByNumbers(List<String> numberList) {
        DynamicObject[] dyns = this.personHeadPicDomainService.getPersonHeadByNumberList(numberList);
        return Arrays.stream(dyns).map(it -> it.getLong("id")).collect(Collectors.toList());
    }

    @Override
    public int getCurFinishCount(Long batchNumber) {
        return this.personHeadPicDomainService.queryCountByBatchNumber(batchNumber);
    }
}

