/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.common;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.common.PredicateContainer;
import kd.hrmp.hric.common.constants.AppConstants;

public class ServiceFactory {
    private static final Log LOG = LogFactory.getLog(ServiceFactory.class);
    private static final Map<String, String> SERVICE_MAP = new HashMap<String, String>();
    private static volatile boolean inited = false;
    private static final String CLASS_SUFFIX = ".class";
    private static final Map<String, String> SCAN_PACKAGE_MAP = ImmutableMap.of((Object)"kd.hrmp.hric.bussiness.domain.init", (Object)"", (Object)"kd.hrmp.hric.bussiness.domain.entityservice.ext", (Object)"", (Object)"kd.hrmp.hric.bussiness.domain.entityservice.init", (Object)"");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initServiceMap() {
        if (inited) return;
        Class<ServiceFactory> clazz = ServiceFactory.class;
        synchronized (ServiceFactory.class) {
            if (inited) return;
            SCAN_PACKAGE_MAP.entrySet().forEach(entry -> ServiceFactory.initServiceInfo((String)entry.getKey(), ServiceFactory.getImplPackage(entry)));
            inited = true;
            LOG.info("ServiceFactory inited, {} service inited", (Object)SERVICE_MAP.size());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static String getImplPackage(Map.Entry<String, String> entry) {
        String interfacePackage = entry.getKey();
        String implPackage = entry.getValue();
        if (HRStringUtils.isNotEmpty((String)implPackage)) {
            return implPackage;
        }
        return String.format(Locale.ROOT, "%s.impl", interfacePackage);
    }

    private static void initServiceInfo(String interfacePackageName, String implPackageName) {
        try {
            Map<String, Class> interfaceMap = ServiceFactory.findPackageContainsClassNameList(interfacePackageName);
            Map<String, Class> classMap = ServiceFactory.findPackageContainsClassNameList(implPackageName);
            LOG.info("find {} interface and {} impl in package summary {}", new Object[]{interfaceMap.size(), classMap.size(), ServiceFactory.getPackageSummary(interfacePackageName)});
            for (Map.Entry<String, Class> entry : classMap.entrySet()) {
                for (Class<?> interfaceClass : entry.getValue().getInterfaces()) {
                    if (!interfaceMap.containsKey(interfaceClass.getName())) continue;
                    SERVICE_MAP.put(interfaceClass.getSimpleName(), entry.getValue().getName());
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
        }
    }

    private static String getPackageSummary(String interfacePackageName) {
        List summaryList = Splitter.on((String)".").splitToList((CharSequence)interfacePackageName).stream().filter(HRStringUtils::isNotEmpty).map(it -> it.substring(0, 1)).collect(Collectors.toList());
        return Joiner.on((String)".").join(summaryList);
    }

    private static Map<String, Class> findPackageContainsClassNameList(String interfacePackageName) throws IOException, ClassNotFoundException {
        String packagePath = interfacePackageName.replace('.', '/');
        Enumeration<URL> ensureUrls = ServiceFactory.class.getClassLoader().getResources(packagePath);
        ArrayList classList = Lists.newArrayList();
        while (ensureUrls.hasMoreElements()) {
            URL url = ensureUrls.nextElement();
            if (url == null) continue;
            String protocol = url.getProtocol();
            if ("file".equals(protocol)) {
                classList.addAll(ServiceFactory.scanDir(URLDecoder.decode(url.getPath(), "UTF-8")));
                continue;
            }
            if ("jar".equals(protocol)) {
                classList.addAll(ServiceFactory.scanJar(url, packagePath));
                continue;
            }
            LOG.warn("the protocol {} is not support", (Object)protocol);
        }
        return classList.stream().collect(Collectors.toMap(className -> interfacePackageName + "." + className, className -> {
            try {
                return ServiceFactory.class.getClassLoader().loadClass(interfacePackageName + "." + className);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }, (o1, o2) -> o1 == null ? o2 : o1));
    }

    private static List<String> scanJar(URL url, String basePackage) throws IOException {
        ArrayList classNameList = Lists.newArrayList();
        URLConnection urlConn = url.openConnection();
        if (urlConn instanceof JarURLConnection) {
            JarURLConnection jarUrlConn = (JarURLConnection)urlConn;
            classNameList.addAll(ServiceFactory.parseFileInJar(basePackage, jarUrlConn));
        }
        return classNameList;
    }

    private static List<String> parseFileInJar(String basePackage, JarURLConnection jarUrlConn) throws IOException {
        ArrayList simpleClassNameList = Lists.newArrayListWithCapacity((int)AppConstants.INT_TEN);
        try (JarFile jarFile = jarUrlConn.getJarFile();){
            jarFile.stream().forEach(jarEntry -> {
                String className = jarEntry.getName();
                String judgeSimpleClassName = ServiceFactory.judgeClassName(className, basePackage);
                if (HRStringUtils.isNotEmpty((String)judgeSimpleClassName)) {
                    simpleClassNameList.add(judgeSimpleClassName);
                }
            });
        }
        return simpleClassNameList;
    }

    private static String judgeClassName(String className, String basePackage) {
        PredicateContainer predicateContainer = PredicateContainer.getInstance();
        predicateContainer.append(it -> it.endsWith(CLASS_SUFFIX));
        predicateContainer.append(it -> it.startsWith(basePackage));
        if (predicateContainer.allMatch((Object)className)) {
            String simpleClassName = ServiceFactory.getSimpleClassName(className);
            if (className.equals(basePackage + "/" + simpleClassName + CLASS_SUFFIX)) {
                return simpleClassName;
            }
        }
        return null;
    }

    private static String getSimpleClassName(String className) {
        String simpleClassName = className.substring(0, className.length() - 6).replace('/', '.');
        if (simpleClassName.contains(".")) {
            simpleClassName = simpleClassName.substring(simpleClassName.lastIndexOf(".") + 1);
        }
        return simpleClassName;
    }

    private static List<String> scanDir(String dirPath) {
        ArrayList classNames = Lists.newArrayList();
        File dir = new File(dirPath);
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                String fileName = file.getName();
                if (fileName.lastIndexOf(CLASS_SUFFIX) <= -1) continue;
                fileName = fileName.substring(0, fileName.lastIndexOf("."));
                classNames.add(fileName);
            }
        }
        return classNames;
    }

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceFactory.getService(clazz.getSimpleName());
    }

    public static Object getService(String serviceName) {
        ServiceFactory.initServiceMap();
        String className = SERVICE_MAP.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230\u3002", (String)"ServiceFactory_0", (String)"hrmp-hric-business", (Object[])new Object[0]), serviceName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }
}

