/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.entityservice.ext.impl;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.domain.entityservice.ext.IInitMetadataEntityService;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.bo.MetadataBo;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.util.MetadataUtils;

public class InitMetadataEntityServiceImpl
implements IInitMetadataEntityService {
    private static Log LOG = LogFactory.getLog(InitMetadataEntityServiceImpl.class);
    private static final String SQL = "";

    @Override
    public void saveAppUnit(String formId, String bizUnitId, String bizAppId) {
        QFilter q1 = new QFilter("form", "=", (Object)formId);
        QFilter q2 = new QFilter("bizunit", "=", (Object)bizUnitId);
        QFilter[] filters = new QFilter[]{q1, q2};
        DeleteServiceHelper.delete((String)"bos_devportal_unitrelform", (QFilter[])filters);
        DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_unitrelform");
        dObject.set("bizapp", (Object)bizAppId);
        dObject.set("bizunit", (Object)bizUnitId);
        dObject.set("form", (Object)formId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObject});
    }

    @Override
    public Map<String, Object> save(Map<String, Object> metadataMap) {
        return MetadataUtils.save(metadataMap);
    }

    @Override
    public String getExtMetaObject(String entityNumber) {
        return MetadataUtils.getExtMetaNumber(entityNumber);
    }

    @Override
    public AbstractMetadata loadMeta(String entityNumber) {
        String id = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form);
        return MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
    }

    @Override
    public Map<String, Date> getMetadataLastestModifyTime(Set<String> entityNumberSet) {
        Map<String, String> metadataInheritPathMap = MetadataUtils.getMetadataInheritPath(MetadataUtils.getMetadataBoByNumberMap(entityNumberSet));
        Set<String> allEffectMetaIdSet = this.getAllEffMetaNumberSet(metadataInheritPathMap);
        Map<String, MetadataBo> effBoMap = MetadataUtils.getMetadataBoByIdMap(allEffectMetaIdSet);
        Map<String, Date> resultMap = this.convertToLastmodifyTime(metadataInheritPathMap, effBoMap);
        return resultMap;
    }

    @Override
    public Map<String, MetadataBo> getMetadataBoMap(Set<String> entityNumberSet) {
        Map<String, MetadataBo> metadataBoByNumberMap = MetadataUtils.getMetadataBoByNumberMap(entityNumberSet);
        return metadataBoByNumberMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toMap(MetadataBo::getNumber, Function.identity(), (o1, o2) -> o1));
    }

    @Override
    public boolean deleteMetadata(String formId, String bizAppId, String bizUnitId) {
        Map result = DevportalUtil.deletePage((String)formId, (String)bizUnitId, (Boolean)false, (String)bizAppId, (String)"0", (String)"PAGE_TYPE", (String)"bos_formmeta");
        return false;
    }

    @Override
    public boolean isExists(String entityNumber) {
        return MetadataUtils.checkNumber(entityNumber);
    }

    private Map<String, Date> convertToLastmodifyTime(Map<String, String> metadataInheritPathMap, Map<String, MetadataBo> effBoMap) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)effBoMap.size());
        for (Map.Entry<String, String> entry : metadataInheritPathMap.entrySet()) {
            Optional<Object> dateOptional = Arrays.stream(entry.getValue().split(",")).filter(HRStringUtils::isNotEmpty).map(it -> (MetadataBo)effBoMap.get(it)).filter(Objects::nonNull).map(it -> it.getModifyDate()).filter(Objects::nonNull).collect(Collectors.maxBy(Date::compareTo));
            map.put(effBoMap.get(entry.getKey()).getNumber(), dateOptional.orElse(null));
        }
        return map;
    }

    private Set<String> getAllEffMetaNumberSet(Map<String, String> metadataInheritPathMap) {
        return metadataInheritPathMap.entrySet().stream().map(it -> (String)it.getValue()).map(it -> it.split(",")).flatMap(Arrays::stream).filter(HRStringUtils::isNotEmpty).collect(Collectors.toSet());
    }
}

