/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.entityservice.ext.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.acl.ApilAclManager;
import kd.bos.openapi.base.util.ApiUriModelCacheUtil;
import kd.bos.openapi.base.util.LocalCacheUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hrmp.hric.bussiness.common.entityservice.AbstractBaseEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.ext.IOpenApiEntityService;
import kd.hrmp.hric.common.exception.KDHricException;

public class OpenApiEntityServiceImpl
extends AbstractBaseEntityService
implements IOpenApiEntityService {
    private static Log LOG = LogFactory.getLog(OpenApiEntityServiceImpl.class);

    public OpenApiEntityServiceImpl() {
        super("openapi_scriptapi");
    }

    @Override
    public DynamicObject generateEmptyDynamicObject() {
        return super.generateEmptyDynamicObject();
    }

    @Override
    public DynamicObject generateEmptyEntryDynamicObject(String entryEntity) {
        return this.hrBaseServiceHelper.generateEmptyEntryDynamicObject(entryEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteByNumberSet(Set<String> numberSet) {
        TXHandle txHandle = TX.requiresNew();
        DynamicObject[] openApiArray = this.query("id", new QFilter[]{new QFilter("number", "in", numberSet)});
        List<Long> idList = Arrays.stream(openApiArray).map(openApi -> openApi.getLong("id")).collect(Collectors.toList());
        try {
            this.clearCache(idList);
            DeleteServiceHelper.delete((String)this.entityNumber, (QFilter[])new QFilter[]{new QFilter("number", "in", numberSet)});
        }
        catch (Exception ex) {
            txHandle.markRollback();
            LOG.error("openApi delete error", (Throwable)ex);
        }
        finally {
            txHandle.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean opSave(List<DynamicObject> openApiDyList) {
        OperationResult operationResult;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", Boolean.TRUE.toString());
        try (TXHandle txHandle = TX.requiresNew();){
            operationResult = OperationServiceHelper.executeOperate((String)"save", (String)this.entityNumber, (DynamicObject[])openApiDyList.toArray(new DynamicObject[0]), (OperateOption)option);
        }
        if (!operationResult.isSuccess()) {
            throw new KDHricException(StringUtils.isNotBlank((CharSequence)operationResult.getMessage()) ? operationResult.getMessage() : ResManager.loadKDString((String)"OpenApi\u53d1\u5e03\u5931\u8d25\u3002", (String)"OpenApiEntityServiceImpl_0", (String)"hrmp-hric-business", (Object[])new Object[0]));
        }
        return operationResult.isSuccess();
    }

    private void clearCache(List<Long> idList) {
        if (idList.isEmpty()) {
            return;
        }
        LocalCacheUtil.clear((String)"apiserviceId");
        DynamicObject[] openApiArray = BusinessDataServiceHelper.load((String)"openapi_apilist", (String)"urlformat", (QFilter[])new QFilter("id", "in", idList).toArray());
        if (openApiArray != null && openApiArray.length > 0) {
            for (DynamicObject dy : openApiArray) {
                ApiUriModelCacheUtil.removeApiModelCache((String)dy.getString("urlformat"));
                ApilAclManager.removeApiAclModel((String)dy.getString("urlformat"));
            }
        }
    }
}

