/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.entityservice.ext.impl;

import com.google.common.collect.Maps;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dbversion.IndustryVersionInfo;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.dbversion.IndustryVersionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.common.entityservice.AbstractBaseEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.ext.ISchScheduleEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IVerRecordEntityService;
import kd.hrmp.hric.bussiness.service.factory.ThreadPoolFactory;
import kd.hrmp.hric.bussiness.task.MidTableAutoGenerateTask;
import kd.hrmp.hric.common.util.HricObjectUtils;

public class SchScheduleEntityServiceImpl
extends AbstractBaseEntityService
implements ISchScheduleEntityService {
    private final String TXT_DESC = "txtdesc";
    private static Log LOG = LogFactory.getLog(SchScheduleEntityServiceImpl.class);
    private static String HRMP_HRIC_VER_RECORD = "hrmp.hric.verrecord";
    private static String hrVersion;
    private IVerRecordEntityService iVerRecordEntityService = ServiceFactory.getService(IVerRecordEntityService.class);

    public SchScheduleEntityServiceImpl() {
        super("sch_schedule");
    }

    @Override
    public String getTxtDescByNumber(String number) {
        DynamicObject dyn = this.queryOne("txtdesc", new QFilter[]{new QFilter("number", "=", (Object)number)});
        if (null == dyn) {
            return "";
        }
        if (HRStringUtils.isEmpty((String)dyn.getString("txtdesc"))) {
            return "";
        }
        return dyn.getString("txtdesc");
    }

    @Override
    public void executeMiddleJob() {
        if (!this.isVersionChanged()) {
            return;
        }
        ThreadPoolFactory.getCommonExecutor().execute(() -> new MidTableAutoGenerateTask().execute(null, Maps.newHashMapWithExpectedSize((int)16)));
    }

    private boolean isVersionChanged() {
        IndustryVersionInfo versionInfo = IndustryVersionServiceHelper.getVersion((String)"constellation_hr", (String)"kingdee");
        if (versionInfo == null) {
            LOG.info("do not get hrVersion!");
            return false;
        }
        String currentVersion = versionInfo.getVersion();
        if (HRStringUtils.equals((String)hrVersion, (String)currentVersion)) {
            return false;
        }
        try (DLock dLock = DLock.create((String)HRMP_HRIC_VER_RECORD);){
            if (!dLock.tryLock()) {
                LOG.warn("user do not get lock");
                boolean bl = false;
                return bl;
            }
            if (HRStringUtils.isEmpty((String)hrVersion)) {
                DynamicObject verRecord = this.iVerRecordEntityService.queryOne("hrversion", null, "createtime desc");
                if (HricObjectUtils.isEmpty((Object)verRecord)) {
                    this.insertVerRecord(currentVersion);
                    LOG.info("first startup hrVersion: {}", (Object)currentVersion);
                    boolean bl = true;
                    return bl;
                }
                hrVersion = verRecord.getString("hrversion");
                LOG.info("hrVersion reset cache: {}", (Object)hrVersion);
            }
            if (!HRStringUtils.equals((String)hrVersion, (String)currentVersion)) {
                LOG.info("hrVersion upgrade,upgrade_before_version:{},upgrade_after_version:{}", (Object)hrVersion, (Object)currentVersion);
                this.insertVerRecord(currentVersion);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private void insertVerRecord(String currentVersion) {
        DynamicObject verRecord = this.iVerRecordEntityService.generateEmptyDynamicObject();
        verRecord.set("hrversion", (Object)currentVersion);
        verRecord.set("createtime", (Object)new Date());
        this.iVerRecordEntityService.save(verRecord);
        LOG.info("version upgrade, insert new version record into t_hric_verrecord!");
        hrVersion = currentVersion;
    }
}

