/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.entityservice.init.impl;

import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.common.entityservice.AbstractBaseEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IContractAnnexEntityService;
import kd.hrmp.hric.bussiness.service.BaseConfigServiceHelper;

public class ContractAnnexEntityServiceImpl
extends AbstractBaseEntityService
implements IContractAnnexEntityService {
    private static final Set<String> statusSet = Sets.newHashSet((Object[])new String[]{"B", "C"});
    public static final String SELECT_FIELD = "number,name,contractnumber,contracttype,contractid,initstatus,errormsg,errormsg_tag,filepath,filename,filesize,batchnumber,creator,modifier,createtime,modifytime";

    public ContractAnnexEntityServiceImpl() {
        super("hric_contractinit");
    }

    @Override
    public int queryCountByBatchNumber(Long batchNumber) {
        return this.hrBaseServiceHelper.count("hric_contractinit", new QFilter("batchnumber", "=", (Object)batchNumber).toArray());
    }

    @Override
    public DynamicObject[] getFailAndWaitContractInfo() {
        DynamicObject[] dys;
        int top = 1000;
        String annexSize = Optional.ofNullable(BaseConfigServiceHelper.get("hric_initannex_size")).orElse("");
        if (HRStringUtils.isNotEmpty((String)annexSize)) {
            top = Integer.parseInt(annexSize);
        }
        if (Objects.isNull(dys = this.hrBaseServiceHelper.query(SELECT_FIELD, new QFilter("initstatus", "in", statusSet).toArray(), "id", top))) {
            return new DynamicObject[0];
        }
        return dys;
    }

    @Override
    public int getFailAndWaitContractInfoTotal() {
        return this.hrBaseServiceHelper.count("hric_contractinit", new QFilter("initstatus", "in", statusSet).toArray());
    }
}

