/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.entityservice.init.impl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.common.entityservice.AbstractBaseEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IInitPlanEntityService;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.constants.InitPlanConstants;

public class InitPlanEntityServiceImpl
extends AbstractBaseEntityService
implements IInitPlanEntityService,
InitPlanConstants {
    private static final List<String> PLANSTATUS_LIST = ImmutableList.of((Object)"A", (Object)"B", (Object)"C");
    private static final String GET_IMPLITEM_PLAN_BY_STRUCT_NUMBER_FIELD = "id,bizsubarea,planstatus,itementryentity.implitem,itementryentity.itemname,itementryentity.isskip,itementryentity.mulfrontimpl";
    private static final String SELECT_ROP = "id, name, parent.id, structnumber, layer, configmode, group, bizsubarea, industrytype,itementryentity.implitem";

    public InitPlanEntityServiceImpl() {
        super("hric_initplan");
    }

    @Override
    public DynamicObject[] getImplItemPlanByStructNumber(String structNumber) {
        Object[] result = new DynamicObject[]{};
        if (HRStringUtils.isEmpty((String)structNumber)) {
            return result;
        }
        QFilter[] filters = new QFilter[]{new QFilter("structnumber", "like", (Object)(structNumber + "%")).and(new QFilter("configmode", "in", (Object)AppConstants.CONFIG_MODE_LIST)).and(new QFilter("planstatus", "in", PLANSTATUS_LIST))};
        result = this.query(GET_IMPLITEM_PLAN_BY_STRUCT_NUMBER_FIELD, filters);
        if (ObjectUtils.isEmpty((Object[])result)) {
            return new DynamicObject[0];
        }
        return result;
    }

    @Override
    public DynamicObject[] getPlanInfoByNumbers(Set<String> numbers) {
        Object[] result = new DynamicObject[]{};
        if (CollectionUtils.isEmpty(numbers)) {
            return result;
        }
        QFilter qFilter = new QFilter("number", "in", numbers);
        result = this.query("number", qFilter.toArray());
        if (ObjectUtils.isEmpty((Object[])result)) {
            return new DynamicObject[0];
        }
        return result;
    }

    @Override
    public DynamicObject[] getByStructNumber(String structNumber) {
        QFilter qFilter = new QFilter("structnumber", "like", (Object)(structNumber + "%"));
        return this.query(SELECT_ROP, new QFilter[]{qFilter});
    }

    @Override
    public DynamicObject[] getByNumber(String number, String midTableNumber) {
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        DynamicObject planDyn = this.queryOne("structnumber", new QFilter[]{qFilter});
        if (planDyn == null) {
            return null;
        }
        QFilter structNumberQFilter = new QFilter("structnumber", "like", (Object)(planDyn.getString("structnumber") + "%"));
        structNumberQFilter.and(new QFilter("itementryentity.implitem.initimporttemplat.intermediatetable", "=", (Object)midTableNumber));
        return this.query("number", new QFilter[]{structNumberQFilter});
    }

    @Override
    public boolean isExistMasterPlan(String masterPlanName) {
        QFilter nameFilter = new QFilter("name", "=", (Object)masterPlanName);
        QFilter layerFilter = new QFilter("layer", "=", (Object)1);
        return this.hrBaseServiceHelper.isExists(nameFilter.and(layerFilter));
    }

    @Override
    public boolean isExistUnConfig(String structNumber) {
        QFilter qFilter = new QFilter("structnumber", "like", (Object)(structNumber + "%"));
        qFilter.and(new QFilter("planstatus", "=", (Object)"A"));
        return this.hrBaseServiceHelper.isExists(qFilter);
    }
}

