/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.entityservice.init.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.hrmp.hric.bussiness.common.entityservice.AbstractBaseEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IPTplPlanEntityService;
import kd.hrmp.hric.common.constants.PlanTemplateConstants;

public class PTplPlanEntityServiceImpl
extends AbstractBaseEntityService
implements IPTplPlanEntityService,
PlanTemplateConstants {
    public PTplPlanEntityServiceImpl() {
        super("hric_ptplplan");
    }

    @Override
    public List<DynamicObject> queryByRootId(Long rootId) {
        String selectProp = "planname, ptplplbizarea, ptplplbizsubarea, configmode, plandescription, structnumber, industrytype, parent, layer, hric_ptplitementry, hric_ptplitementry.seq, hric_ptplitementry.fbasedataid";
        DynamicObject rootDyn = this.queryOne("structnumber", new QFilter[]{new QFilter("id", "=", (Object)rootId)});
        if (rootDyn == null) {
            return new ArrayList<DynamicObject>();
        }
        QFilter qFilter = new QFilter("structnumber", "like", (Object)(rootDyn.getString("structnumber") + "%"));
        DynamicObject[] planInfoArr = this.query(selectProp, new QFilter[]{qFilter});
        return Arrays.stream(planInfoArr).collect(Collectors.toList());
    }

    @Override
    public List<Long> queryPlanTempIdByRootId(Set<Long> rootIdSet) {
        DynamicObject[] rootArray = this.query("id,structnumber", new QFilter[]{new QFilter("id", "in", rootIdSet)});
        List structNumberList = Arrays.stream(rootArray).map(s -> s.getString("structnumber")).collect(Collectors.toList());
        if (structNumberList.size() == 0) {
            return new ArrayList<Long>();
        }
        QFilter structLongNumberFilter = new QFilter("structnumber", "like", (Object)((String)structNumberList.get(0) + "%"));
        for (int i = 1; i < structNumberList.size(); ++i) {
            structLongNumberFilter.or("structnumber", "like", (Object)((String)structNumberList.get(i) + "%"));
        }
        DynamicObject[] planInfoArr = this.query("id", new QFilter[]{structLongNumberFilter});
        return Arrays.stream(planInfoArr).map(s -> s.getLong("id")).collect(Collectors.toList());
    }

    @Override
    public DynamicObject generateEmptyEntryDynamicObject(String entryEntity) {
        return this.hrBaseServiceHelper.generateEmptyEntryDynamicObject(entryEntity);
    }

    @Override
    public DynamicObject queryStructNumberById(Long id) {
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        return this.hrBaseServiceHelper.queryOne("structnumber", idFilter);
    }

    @Override
    public DynamicObject[] queryByStructNumber(String structnumber) {
        QFilter qFilter = new QFilter("structnumber", "like", (Object)(structnumber + "%"));
        Object[] result = this.hrBaseServiceHelper.loadDynamicObjectArray(qFilter.toArray());
        if (ObjectUtils.isEmpty((Object[])result)) {
            return new DynamicObject[0];
        }
        return result;
    }
}

