/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IAnnexErrorDataEntityService;
import kd.hrmp.hric.bussiness.domain.init.IAnnexErrorDataDomainService;

public class AnnexErrorDataDomainServiceImpl
implements IAnnexErrorDataDomainService {
    private final IAnnexErrorDataEntityService iAnnexErrorDataEntityService = ServiceFactory.getService(IAnnexErrorDataEntityService.class);
    private String TIP = ResManager.loadKDString((String)"\u65e0\u6cd5\u5339\u914d\u7cfb\u7edf\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u7684\u6570\u636e\u3002", (String)"AnnexErrorDataDomainServiceImpl_0", (String)"hrmp-hric-business", (Object[])new Object[0]);

    @Override
    public void save(Long batchNumber, Map<String, String> map, Map<String, Map<String, String>> errorFileNumberMap) {
        ArrayList<DynamicObject> annexErrorDataList = new ArrayList<DynamicObject>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.buildDyn(batchNumber, annexErrorDataList, entry.getValue(), entry.getKey(), this.TIP);
        }
        for (Map.Entry<String, Object> entry : errorFileNumberMap.entrySet()) {
            Map valueMap = (Map)entry.getValue();
            Map.Entry valueEntry = valueMap.entrySet().iterator().next();
            this.buildDyn(batchNumber, annexErrorDataList, (String)valueEntry.getKey(), entry.getKey(), (String)valueEntry.getValue());
        }
        this.iAnnexErrorDataEntityService.save(annexErrorDataList.toArray(new DynamicObject[annexErrorDataList.size()]));
    }

    @Override
    public int queryErrorCountByBatchNumber(Long batchNumber) {
        Object[] query = this.iAnnexErrorDataEntityService.query("id", new QFilter("batchnumber", "=", (Object)batchNumber).toArray());
        if (HRArrayUtils.isEmpty((Object[])query)) {
            return 0;
        }
        return query.length;
    }

    private void buildDyn(Long batchNumber, List<DynamicObject> annexErrorDataList, String zipName, String fileName, String tip) {
        DynamicObject annexErrorData = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hric_annexerrordata"));
        annexErrorData.set("zipname", (Object)zipName);
        annexErrorData.set("filename", (Object)fileName);
        annexErrorData.set("errorcause", (Object)tip);
        annexErrorData.set("batchnumber", (Object)batchNumber);
        annexErrorDataList.add(annexErrorData);
    }
}

