/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IInitTaskEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IMicConfigEntityService;
import kd.hrmp.hric.bussiness.domain.init.IBaseConfigDomainService;
import kd.hrmp.hric.bussiness.domain.init.IInitTaskDomainService;
import kd.hrmp.hric.bussiness.service.BaseConfigServiceHelper;
import kd.hrmp.hric.common.bean.MidTableMetaDataClearRule;
import kd.hrmp.hric.common.exception.KDHricException;

public class BaseConfigDomainServiceImpl
implements IBaseConfigDomainService {
    private IMicConfigEntityService iMicConfigEntityService = ServiceFactory.getService(IMicConfigEntityService.class);
    private IInitTaskDomainService iInitTaskDomainService = ServiceFactory.getService(IInitTaskDomainService.class);
    private static final String MIDDLE_TABLE_CLEAR_RULE = "middle.table.clear.rule";

    @Override
    public boolean isCanRollbackSelect(long taskId) {
        IInitTaskEntityService iInitTaskEntityService = ServiceFactory.getService(IInitTaskEntityService.class);
        DynamicObject task = iInitTaskEntityService.getTaskById("implitemrel.entityobjscope", taskId);
        DynamicObject implItemDyn = task.getDynamicObject("implitemrel");
        String entityCode = implItemDyn.getString("entityobjscope.number");
        if (HRStringUtils.isEmpty((String)entityCode)) {
            return false;
        }
        DynamicObject micConfig = this.iMicConfigEntityService.getMicConfigByEntityCode("configtype", entityCode);
        String configType = micConfig.getString("configtype");
        String configValue = "";
        if (HRStringUtils.equals((String)configType, (String)"A") || HRStringUtils.equals((String)configType, (String)"B")) {
            configValue = BaseConfigServiceHelper.get("rollback.selected.general");
        } else if (HRStringUtils.equals((String)configType, (String)"C")) {
            configValue = BaseConfigServiceHelper.get("rollback.selected." + this.iInitTaskDomainService.getBizSubAreaByTaskId(taskId));
        }
        return HRStringUtils.isNotEmpty((String)configValue) && Boolean.parseBoolean(configValue);
    }

    @Override
    public String get(String number) {
        return BaseConfigServiceHelper.get(number);
    }

    @Override
    public MidTableMetaDataClearRule getMidTableDataClearRule() {
        MidTableMetaDataClearRule midTableMetaDataClearRule = new MidTableMetaDataClearRule();
        String ruleStr = this.get(MIDDLE_TABLE_CLEAR_RULE);
        if (ruleStr == null) {
            return midTableMetaDataClearRule;
        }
        try {
            midTableMetaDataClearRule = (MidTableMetaDataClearRule)HRJSONUtils.cast((String)ruleStr, MidTableMetaDataClearRule.class);
        }
        catch (Exception exception) {
            throw new KDHricException(exception.getMessage());
        }
        return midTableMetaDataClearRule;
    }
}

