/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IContractAnnexEntityService;
import kd.hrmp.hric.bussiness.domain.init.IContractAnnexDomainService;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.constants.msg.AnnexEnum;
import kd.hrmp.hric.common.util.AttachmentUtils;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.common.util.HricCacheUtils;

public class ContractAnnexDomainServiceImpl
implements IContractAnnexDomainService {
    private static Log LOG = LogFactory.getLog(ContractAnnexDomainServiceImpl.class);
    IContractAnnexEntityService iContractAnnexEntityService = ServiceFactory.getService(IContractAnnexEntityService.class);
    private String QUERY_FIELD = "contractnumber,name,number,initstatus,creator,filepath,createtime,errormsg,batchnumber,modifytime,modifier,contractid,filename,filesize,contracttype,errormsg_tag";
    private String QUERY_ALL = "number,name,initstatus,creator,modifier,createtime,modifytime,contractnumber,contractid,batchnumber,filename,filesize,filepath";

    @Override
    public DynamicObject[] getContractExistByNumbers(List<String> numberList) {
        DynamicObject[] query = this.iContractAnnexEntityService.query(this.QUERY_FIELD, new QFilter("contractnumber", "in", numberList).and(new QFilter("initstatus", "=", (Object)"A")).toArray());
        return query;
    }

    @Override
    public void saveOrUpdate(List<Map<String, Object>> resultList, Long batchNumber, Map<String, String> zipParamMap, String uniqueType) {
        List contracts = resultList.stream().map(it -> ConvertUtils.toString(it.get("number"))).collect(Collectors.toList());
        if ((long)contracts.size() != contracts.stream().distinct().count()) {
            List repeatList = contracts.stream().collect(Collectors.toMap(e -> e, e -> 1, Integer::sum)).entrySet().stream().filter(e -> (Integer)e.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
            LOG.error("ContractAnnex repeating data {}: ", repeatList);
            if (HRStringUtils.isEmpty((String)((String)HricCacheUtils.get((String)"repeat_contract_cache", String.class)))) {
                HricCacheUtils.put((String)"repeat_contract_cache", (Object)"1");
            }
        }
        Object[] exists = this.iContractAnnexEntityService.query(this.QUERY_ALL, new QFilter("contractnumber", "in", contracts).toArray());
        ArrayList newList = new ArrayList(AppConstants.LIST_SIZE);
        Arrays.stream(exists).filter(AttachmentUtils.distinctByKey(p -> p.getString("contractnumber"))).forEach(newList::add);
        Map<String, DynamicObject> existsMap = newList.stream().collect(Collectors.toMap(it -> it.getString("contractnumber"), it -> it));
        if (exists.length != newList.size()) {
            if (HRStringUtils.isEmpty((String)((String)HricCacheUtils.get((String)"repeat_contract_cache", String.class)))) {
                HricCacheUtils.put((String)"repeat_contract_cache", (Object)"1");
            }
            LOG.error("ContractAnnex repeating data \u6709\u91cd\u590d\u6570\u636e \u8bf7\u68c0\u67e5 {}: ", exists);
        }
        ArrayList distinctList = new ArrayList(AppConstants.LIST_SIZE);
        resultList.stream().filter(AttachmentUtils.distinctByKey(p -> p.get("number"))).forEach(distinctList::add);
        ArrayList<DynamicObject> contractList = new ArrayList<DynamicObject>(AppConstants.LIST_SIZE);
        ArrayList<DynamicObject> existList = new ArrayList<DynamicObject>(AppConstants.LIST_SIZE);
        Map fileMap = new HashMap(AppConstants.MAP_SIZE);
        Map<String, Object> nameAndNumberMap = distinctList.stream().collect(Collectors.toMap(it -> ConvertUtils.toString(it.get("number")), it -> String.join((CharSequence)"", ConvertUtils.toString(it.get("empnumber")), "+", ConvertUtils.toString(it.get("name")))));
        if (!CollectionUtils.isEmpty(zipParamMap)) {
            fileMap = AttachmentUtils.parseUrl(zipParamMap.keySet().stream().collect(Collectors.toList()), (String)"hric_contractinit", nameAndNumberMap, (String)uniqueType);
        }
        for (Map map : distinctList) {
            String path;
            if (existsMap.containsKey(map.get("number"))) {
                DynamicObject dynamicObject = existsMap.get(map.get("number"));
                if (!HRStringUtils.equals((String)dynamicObject.getString("initstatus"), (String)"A")) {
                    dynamicObject.set("initstatus", (Object)"C");
                }
                if (fileMap.containsKey(map.get("number")) && !HRStringUtils.equals((String)ConvertUtils.toString(fileMap.get(map.get("number"))), (String)"false")) {
                    path = (String)fileMap.get(map.get("number"));
                    dynamicObject.set("filepath", (Object)path);
                    dynamicObject.set("filename", (Object)path.substring(path.lastIndexOf("/") + 1, path.lastIndexOf(46)));
                }
                if (fileMap.containsKey(map.get("number")) && HRStringUtils.equals((String)ConvertUtils.toString(fileMap.get(map.get("number"))), (String)"false")) {
                    dynamicObject.set("errormsg", (Object)String.format(Locale.ROOT, AnnexEnum.ANNEX_CONTRACTNAME_CHECK.getMsg(), map.get("empnumber")));
                    dynamicObject.set("initstatus", (Object)"B");
                }
                dynamicObject.set("batchnumber", (Object)batchNumber);
                existList.add(dynamicObject);
                continue;
            }
            DynamicObject contract = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hric_contractinit"));
            contract.set("number", map.get("empnumber"));
            contract.set("contractnumber", map.get("number"));
            contract.set("name", map.get("name"));
            contract.set("initstatus", (Object)"C");
            contract.set("contractid", map.get("id"));
            contract.set("contracttype", map.get("protocoltype"));
            contract.set("batchnumber", (Object)batchNumber);
            contract.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            if (fileMap.containsKey(map.get("number"))) {
                path = (String)fileMap.get(map.get("number"));
                contract.set("filepath", (Object)path);
                contract.set("filename", (Object)path.substring(path.lastIndexOf("/") + 1, 46));
            }
            contractList.add(contract);
        }
        this.iContractAnnexEntityService.save(contractList.toArray(new DynamicObject[0]));
        if (!CollectionUtils.isEmpty(existList)) {
            this.iContractAnnexEntityService.save(existList.toArray(new DynamicObject[0]));
        }
    }

    @Override
    public int queryCountByBatchNumber(Long batchNumber) {
        return this.iContractAnnexEntityService.queryCountByBatchNumber(batchNumber);
    }

    @Override
    public DynamicObject[] getDataByBatchNumber(Long batchNumber) {
        return this.iContractAnnexEntityService.query(this.QUERY_FIELD, new QFilter("batchnumber", "=", (Object)batchNumber).toArray());
    }

    @Override
    public DynamicObject[] getPersonHeadPicByIds(Object[] toArray) {
        return this.iContractAnnexEntityService.query(this.QUERY_FIELD, new QFilter("id", "in", (Object)toArray).toArray());
    }

    @Override
    public DynamicObject[] getContractInfoByIdSet(Set<Long> idSet) {
        return this.iContractAnnexEntityService.query(this.QUERY_FIELD, new QFilter("id", "in", (Object)idSet.toArray()).toArray());
    }

    @Override
    public void saveOne(DynamicObject value) {
        try (TXHandle tx = TX.required();){
            this.iContractAnnexEntityService.save(value);
        }
    }

    @Override
    public DynamicObject[] getFailAndWaitContractInfo() {
        return this.iContractAnnexEntityService.getFailAndWaitContractInfo();
    }

    @Override
    public int getFailAndWaitContractInfoTotal() {
        return this.iContractAnnexEntityService.getFailAndWaitContractInfoTotal();
    }

    @Override
    public DynamicObject[] getContractByNumberList(List<String> numberList) {
        return this.iContractAnnexEntityService.query(this.QUERY_FIELD, new QFilter("contractnumber", "in", numberList).toArray());
    }
}

