/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.ext.ISchScheduleEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IDataClearEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IDataClearLogEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IDataClearLogEntryEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IDataClearStrategyEntityService;
import kd.hrmp.hric.bussiness.domain.init.IDataClearDomainService;
import kd.hrmp.hric.bussiness.domain.init.impl.clear.DataClearFactory;
import kd.hrmp.hric.bussiness.domain.init.impl.clear.DataClearStrategyMsgFactory;
import kd.hrmp.hric.common.constants.AppConstants;

public class DataClearDomainService
implements IDataClearDomainService {
    private static final Log LOG = LogFactory.getLog(DataClearDomainService.class);
    private final IDataClearEntityService iDataClearEntityService = ServiceFactory.getService(IDataClearEntityService.class);
    private final IDataClearStrategyEntityService iDataClearStrategyEntityService = ServiceFactory.getService(IDataClearStrategyEntityService.class);
    private static final ThreadLocal<Map<Long, String>> THREAD_LOCAL = new ThreadLocal();
    private final IDataClearLogEntityService iDataClearLogEntityService = ServiceFactory.getService(IDataClearLogEntityService.class);
    private final IDataClearLogEntryEntityService iDataClearLogEntryEntityService = ServiceFactory.getService(IDataClearLogEntryEntityService.class);
    private final ISchScheduleEntityService iSchScheduleEntityService = ServiceFactory.getService(ISchScheduleEntityService.class);
    private final String SCH_NUMBER = "hric_dataclear_SKDP_S";

    @Override
    public void clear(DynamicObject dataClearObj) {
        DataClearFactory.get(dataClearObj).startClear();
    }

    @Override
    public void clear(List<Long> dataClearIdList) {
        this.doClear(this.iDataClearEntityService.listByIdList(dataClearIdList));
    }

    @Override
    public void clearAll() {
        this.doClear(this.iDataClearEntityService.listAll());
    }

    @Override
    public void deleteDataClearLog(DynamicObject entryEntity) {
        DynamicObject dataClear = this.iDataClearEntityService.getDataById("entryentity.id", entryEntity.getLong("id"));
        Map dataClearMap = entryEntity.getDynamicObjectCollection("entryentity").stream().collect(Collectors.toMap(it -> it.getLong("id"), Function.identity()));
        ArrayList<Long> idList = new ArrayList<Long>(AppConstants.LIST_SIZE);
        dataClear.getDynamicObjectCollection("entryentity").forEach(it -> {
            if (!dataClearMap.containsKey(it.getLong("id"))) {
                idList.add(it.getLong("id"));
            }
        });
        if (!CollectionUtils.isEmpty(idList)) {
            this.iDataClearLogEntryEntityService.deleteByDataClearEntryIdList(idList);
            Object[] dynamicObjects = this.iDataClearLogEntityService.queryByDataClearId(dataClear.getLong("id"));
            if (HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
                return;
            }
            ArrayList<Long> logIdList = new ArrayList<Long>(dynamicObjects.length);
            Arrays.stream(dynamicObjects).forEach(it -> {
                if (CollectionUtils.isEmpty((Collection)it.getDynamicObjectCollection("entryentity"))) {
                    logIdList.add(it.getLong("id"));
                }
            });
            if (!CollectionUtils.isEmpty(logIdList)) {
                this.iDataClearLogEntityService.deleteLogByEntryEntityIdList(logIdList);
            }
        }
    }

    @Override
    public String getSchTxtDesc() {
        return this.iSchScheduleEntityService.getTxtDescByNumber("hric_dataclear_SKDP_S");
    }

    private void doClear(List<DynamicObject> dataClearDynList) {
        if (dataClearDynList == null) {
            LOG.info("clear schema is empty");
            return;
        }
        for (DynamicObject dataClear : dataClearDynList) {
            this.clear(dataClear);
        }
    }

    @Override
    public String getDataClearStrategy(Long id) {
        HashMap strategyMessageMap = THREAD_LOCAL.get();
        if (strategyMessageMap == null) {
            strategyMessageMap = Maps.newHashMap();
            THREAD_LOCAL.set(strategyMessageMap);
        }
        if (HRStringUtils.isNotEmpty((String)((String)strategyMessageMap.get(id)))) {
            return (String)strategyMessageMap.get(id);
        }
        DynamicObject dynamicObject = this.iDataClearStrategyEntityService.queryById(id);
        strategyMessageMap.put(id, DataClearStrategyMsgFactory.get(dynamicObject).buildMsg());
        return (String)strategyMessageMap.get(id);
    }

    @Override
    public void clearStrategyCache() {
        THREAD_LOCAL.remove();
    }
}

