/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IImplInitLogEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IInitTaskEntityService;
import kd.hrmp.hric.bussiness.domain.init.IImplInitLogDomainService;

public class ImplInitLogDomainServiceImpl
implements IImplInitLogDomainService {
    IInitTaskEntityService iInitTaskEntityService = ServiceFactory.getService(IInitTaskEntityService.class);
    IImplInitLogEntityService iImplInitLogEntityService = ServiceFactory.getService(IImplInitLogEntityService.class);

    @Override
    public void saveInitItemLog(DynamicObject task) {
        DynamicObject[] subTasks = this.iInitTaskEntityService.getSubTaskByParentId("implitemrel,belongplan", task.getLong("id"));
        List<DynamicObject> taskList = Arrays.stream(subTasks).collect(Collectors.toList());
        taskList.add(task);
        List<Long> implIdList = taskList.stream().map(it -> it.getDynamicObject("implitemrel").getLong("id")).collect(Collectors.toList());
        Object[] implLogs = this.iImplInitLogEntityService.getImplLogByPlanAndImplIdList(task, implIdList);
        Arrays.stream(implLogs).forEach(it -> {
            it.set("initdate", (Object)new Date());
            it.set("userfield", (Object)UserServiceHelper.getCurrentUserId());
        });
        if (HRArrayUtils.isNotEmpty((Object[])implLogs)) {
            this.iImplInitLogEntityService.save((DynamicObject[])implLogs);
            Map<Long, Long> implLogMap = Arrays.stream(implLogs).map(it -> it.getDynamicObject("initimplid").getLong("id")).distinct().collect(Collectors.toMap(it -> it, it -> it));
            List<DynamicObject> subTaskList = taskList.stream().filter(it -> !implLogMap.containsKey(it.getDynamicObject("implitemrel").getLong("id"))).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(subTaskList)) {
                List<DynamicObject> implInitLogList = this.buildInitLog(subTaskList);
                this.iImplInitLogEntityService.save(implInitLogList.toArray(new DynamicObject[implInitLogList.size()]));
            }
        } else {
            List<DynamicObject> implInitLogList = this.buildInitLog(taskList);
            this.iImplInitLogEntityService.save(implInitLogList.toArray(new DynamicObject[implInitLogList.size()]));
        }
    }

    private List<DynamicObject> buildInitLog(List<DynamicObject> subTaskList) {
        ArrayList<DynamicObject> implInitLogList = new ArrayList<DynamicObject>(subTaskList.size());
        subTaskList.forEach(it -> {
            DynamicObject initImplLog = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hric_initimpllog"));
            initImplLog.set("initimplid", (Object)it.getDynamicObject("implitemrel").getLong("id"));
            initImplLog.set("initdate", (Object)new Date());
            initImplLog.set("initplanid", (Object)it.getDynamicObject("belongplan").getLong("id"));
            initImplLog.set("userfield", (Object)UserServiceHelper.getCurrentUserId());
            implInitLogList.add(initImplLog);
        });
        return implInitLogList;
    }
}

