/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IBaseImplEntryEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IImplItemEntityService;
import kd.hrmp.hric.bussiness.domain.init.IImplItemDomainService;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.constants.msg.ImplItemMsgEnum;
import kd.hrmp.hric.common.util.QFilterUtils;

public class ImplItemDomainServiceImpl
implements IImplItemDomainService {
    IImplItemEntityService iImplItemEntityService = ServiceFactory.getService(IImplItemEntityService.class);
    IBaseImplEntryEntityService iBaseImplEntryEntityService = ServiceFactory.getService(IBaseImplEntryEntityService.class);
    private static final String SELECT_PROP = "bizsubarea.id,mulfrontimpl.id,listseq,belongimplitem,industrytype,ismandatory,baseimplentry.implitem";

    @Override
    public Map<Long, DynamicObjectCollection> getImplItemByBizSubArea(Set<Long> eBizSubAreaIdSet) {
        DynamicObject[] implItemDirect = this.iImplItemEntityService.queryByBizSubArea(SELECT_PROP, eBizSubAreaIdSet);
        List implItemList = Arrays.stream(implItemDirect).filter(Objects::nonNull).collect(Collectors.toList());
        Arrays.stream(implItemDirect).forEach(implItem -> this.getMulFrontImpl(implItem.getDynamicObjectCollection("mulfrontimpl"), implItemList));
        QFilter qFilter = new QFilter("id", "in", implItemList.stream().filter(Objects::nonNull).map(implItem -> implItem.getLong("id")).collect(Collectors.toList()));
        qFilter.and(QFilterUtils.getEnableQFilter());
        DynamicObject[] itemsByIdList = this.iImplItemEntityService.query(SELECT_PROP, new QFilter[]{qFilter}, "listseq asc");
        return Arrays.stream(itemsByIdList).filter(g -> g.getDynamicObject("bizsubarea") != null).collect(Collectors.groupingBy(g -> g.getDynamicObject("bizsubarea").getLong("id"), Collectors.toCollection(DynamicObjectCollection::new)));
    }

    private void getMulFrontImpl(DynamicObjectCollection mulFrontImplList, List<DynamicObject> implItemIdList) {
        if (mulFrontImplList.isEmpty()) {
            return;
        }
        List<DynamicObject> recurMulFrontImpl = mulFrontImplList.stream().filter(Objects::nonNull).map(s -> s.getDynamicObject("fbasedataid")).collect(Collectors.toList());
        implItemIdList.addAll(recurMulFrontImpl);
        if (!recurMulFrontImpl.isEmpty()) {
            recurMulFrontImpl.forEach(s -> {
                if (s != null && s.containsProperty("mulfrontimpl")) {
                    this.getMulFrontImpl(s.getDynamicObjectCollection("mulfrontimpl"), implItemIdList);
                }
            });
        }
    }

    private void buildResultArea(List<DynamicObject> allImplItemList, List<DynamicObject> implItemDirect, List<DynamicObject> relateImplItem) {
        relateImplItem.addAll(implItemDirect);
        Set implSet = implItemDirect.stream().filter(it -> !CollectionUtils.isEmpty((Collection)it.getDynamicObjectCollection("mulfrontimpl"))).map(it -> it.getDynamicObjectCollection("mulfrontimpl")).map(it -> (DynamicObject)it.get(0)).map(it -> it.get(1)).map(gro -> (DynamicObject)gro).map(it -> it.getLong("id")).collect(Collectors.toSet());
        List<DynamicObject> preImplItemList = allImplItemList.stream().filter(it -> implSet.contains(it.getLong("id"))).collect(Collectors.toList());
        if (preImplItemList.stream().anyMatch(it -> !CollectionUtils.isEmpty((Collection)it.getDynamicObjectCollection("mulfrontimpl")))) {
            this.buildResultArea(allImplItemList, preImplItemList, relateImplItem);
        }
    }

    @Override
    public String validateComposeOperation(List<Long> selectIdList) {
        boolean hasMultiBizSubAreaByImplItems;
        if (CollectionUtils.isEmpty(selectIdList) || selectIdList.size() < 2) {
            return ImplItemMsgEnum.GE_TWO_SAME_BIZ_SUBAREA_IMPL_ITEM_COMPOSE.getMsg();
        }
        DynamicObject[] implItems = this.iImplItemEntityService.queryImplItemsByIdList("id,bizsubarea,category,initfordatasource", selectIdList);
        boolean hasComposeImplItem = Arrays.stream(implItems).anyMatch(implItem -> HRStringUtils.equals((String)"1", (String)implItem.getString("category")));
        if (hasComposeImplItem) {
            return ImplItemMsgEnum.COMPOSED_IMPL_ITEM_NOT_SUPPORTED.getMsg();
        }
        boolean hasManualImplItem = Arrays.stream(implItems).anyMatch(implItem -> HRStringUtils.equals((String)"C", (String)implItem.getString("initfordatasource")));
        boolean hasCacheImplItem = Arrays.stream(implItems).anyMatch(implItem -> HRStringUtils.equals((String)"A", (String)implItem.getString("initfordatasource")));
        if (hasManualImplItem && hasCacheImplItem) {
            return ImplItemMsgEnum.MANUAL_IMPL_ITEM_NOT_SUPPORTED.getMsg();
        }
        boolean bl = hasMultiBizSubAreaByImplItems = Arrays.stream(implItems).map(implItem -> implItem.getDynamicObject("bizsubarea").getLong("id")).distinct().count() > 1L;
        if (hasMultiBizSubAreaByImplItems) {
            return ImplItemMsgEnum.SAME_BIZ_SUBAREA_IMPL_ITEM_COMPOSE.getMsg();
        }
        if (selectIdList.size() > AppConstants.INT_TEN) {
            return ImplItemMsgEnum.LE_TEN_IMPL_ITEM_COMPOSE.getMsg();
        }
        return "";
    }

    @Override
    public String validateRepeatComposeImplItem(DynamicObject implItemDyn) {
        DynamicObjectCollection baseImplItemEntryCol = implItemDyn.getDynamicObjectCollection("baseimplentry");
        if (baseImplItemEntryCol.size() < 2) {
            return ImplItemMsgEnum.GE_TWO_IMPL_ITEM_COMPOSE.getMsg();
        }
        if (baseImplItemEntryCol.size() > AppConstants.INT_TEN) {
            return ImplItemMsgEnum.LE_TEN_IMPL_ITEM_COMPOSE.getMsg();
        }
        return "";
    }

    private void setImplItemIdNameMap(Map<Long, String> implItemIdNameMap, DynamicObject[] implItemDyns) {
        Arrays.stream(implItemDyns).forEach(implItemDyn -> implItemIdNameMap.put(implItemDyn.getLong("id"), implItemDyn.getString("name")));
    }

    private DynamicObject[] getImplItemDynsById(Collection implItemIdCol) {
        QFilter implItemQFilter = new QFilter("id", "in", (Object)implItemIdCol);
        return this.iImplItemEntityService.query("id,name", new QFilter[]{implItemQFilter});
    }

    private Map<Long, Long> getSubItemToComposeItemMap(DynamicObject implItemDyn) {
        DynamicObject[] baseImplEntryDyns = this.getEnabledComposeImplItemDyns(implItemDyn);
        return Arrays.stream(baseImplEntryDyns).collect(Collectors.toMap(entryDyn -> entryDyn.getLong("implitem.id"), entryDyn -> entryDyn.getLong("parentimplitem"), (k1, k2) -> k1));
    }

    private DynamicObject[] getEnabledComposeImplItemDyns(DynamicObject composeImplItemDyn) {
        DynamicObjectCollection baseImplItemEntryCol = composeImplItemDyn.getDynamicObjectCollection("baseimplentry");
        List baseImplItemIdList = baseImplItemEntryCol.stream().map(dyn -> dyn.getDynamicObject("implitem").getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("implitem", "in", baseImplItemIdList);
        qFilter.and(new QFilter("parentimplitem", "!=", (Object)composeImplItemDyn.getLong("id")));
        List<Long> enabledComImplItemIdList = this.iImplItemEntityService.queryEnabledComImplItemIdList();
        qFilter.and(new QFilter("parentimplitem", "in", enabledComImplItemIdList));
        return this.iBaseImplEntryEntityService.query("implitem.id,parentimplitem", qFilter.toArray());
    }

    @Override
    public void disableImplItemByIdSet(Set<Long> implItemIdSet) {
        DynamicObject[] implItemDyns = this.iImplItemEntityService.query("id,enable", implItemIdSet.toArray());
        Arrays.stream(implItemDyns).forEach(implItemDyn -> implItemDyn.set("enable", (Object)"0"));
        this.iImplItemEntityService.save(implItemDyns);
    }

    @Override
    public Set<String> getEnabledImplItemRelEntitySet(List<DynamicObject> relatedImplItemDynList) {
        List<String> entityNumberList = relatedImplItemDynList.stream().map(implItem -> implItem.getDynamicObject("entityobjscope").getString("id")).collect(Collectors.toList());
        Set<String> repeatEnableImplEntitySet = this.getEnabledBaseImplItemEntitySet(entityNumberList);
        return repeatEnableImplEntitySet;
    }

    @Override
    public void updateBelongImplItem(Set<Long> implItemIdSet, DynamicObject implItem) {
        DynamicObject[] implItemDyns = this.iImplItemEntityService.query("id,belongimplitem", implItemIdSet.toArray());
        DynamicObject implItemEntity = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hric_implitem"));
        DynamicObjectType dynamicObjectType = implItemEntity.getDynamicObjectCollection("belongimplitem").getDynamicObjectType();
        Arrays.stream(implItemDyns).forEach(implItemDyn -> {
            DynamicObjectCollection belongImplItemList = implItemDyn.getDynamicObjectCollection("belongimplitem");
            MulBasedataDynamicObjectCollection dys = new MulBasedataDynamicObjectCollection();
            DynamicObject dy = new DynamicObject(dynamicObjectType);
            dy.set("fbasedataid", (Object)implItem);
            dys.add(dy);
            belongImplItemList.addAll((Collection)dys);
        });
        this.iImplItemEntityService.save(implItemDyns);
    }

    @Override
    public DynamicObject[] getImplItemByIds(List<Long> ids) {
        QFilter qFilter = new QFilter("id", "in", ids);
        return this.iImplItemEntityService.query(SELECT_PROP, new QFilter[]{qFilter});
    }

    @Override
    public void removeBelongImplItem(List<Long> baseIds, DynamicObject implItemById) {
        DynamicObject[] implItemDyns = this.iImplItemEntityService.query("id,belongimplitem", baseIds.toArray());
        Arrays.stream(implItemDyns).forEach(implItemDyn -> {
            DynamicObjectCollection belongImplItemList = implItemDyn.getDynamicObjectCollection("belongimplitem");
            for (int i = 0; i < belongImplItemList.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)belongImplItemList.get(i);
                long id = dynamicObject.getDynamicObject("fbasedataid").getLong("id");
                if (implItemById.getLong("id") != id) continue;
                belongImplItemList.remove(i);
            }
        });
        this.iImplItemEntityService.save(implItemDyns);
    }

    private Set<String> getEnabledBaseImplItemEntitySet(List<String> entityNumberList) {
        QFilter baseImplFilter = new QFilter("entityobjscope", "in", entityNumberList);
        baseImplFilter.and(QFilterUtils.getEnableQFilter());
        DynamicObject[] baseImplImplDyns = this.iImplItemEntityService.query("entityobjscope", baseImplFilter.toArray());
        return Arrays.stream(baseImplImplDyns).map(implItem -> implItem.getDynamicObject("entityobjscope").getString("id")).collect(Collectors.toSet());
    }

    private Set<String> getEnabledComImplItemEntitySet(List<String> entityNumberList) {
        QFilter entityFilter = new QFilter("implitem.entityobjscope", "in", entityNumberList);
        List<Long> enabledComImplItemIdList = this.iImplItemEntityService.queryEnabledComImplItemIdList();
        entityFilter.and(new QFilter("parentimplitem", "in", enabledComImplItemIdList));
        DynamicObject[] dyns = this.iBaseImplEntryEntityService.query("id,implitem.entityobjscope.id", entityFilter.toArray());
        return Arrays.stream(dyns).map(dyn -> dyn.getDynamicObject("implitem").getDynamicObject("entityobjscope").getString("id")).collect(Collectors.toSet());
    }
}

