/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IInitPlanEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IInitTaskEntityService;
import kd.hrmp.hric.bussiness.domain.init.ICooperativeDomainService;
import kd.hrmp.hric.bussiness.domain.init.IInitPlanDomainService;
import kd.hrmp.hric.bussiness.domain.init.impl.plan.PlanBo;
import kd.hrmp.hric.bussiness.domain.init.impl.plan.PlanImplItemBo;
import kd.hrmp.hric.bussiness.service.AsyncTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.InitPlanServiceHelper;
import kd.hrmp.hric.bussiness.service.MessageSendServiceHelper;
import kd.hrmp.hric.common.InitMessageInfoBuilder;
import kd.hrmp.hric.common.bean.FormPluginResponse;
import kd.hrmp.hric.common.bean.InitMessageInfo;
import kd.hrmp.hric.common.bean.bo.InitPlanBo;
import kd.hrmp.hric.common.bean.bo.PlanTempBo;
import kd.hrmp.hric.common.bean.bo.StructTaskBo;
import kd.hrmp.hric.common.bean.bo.StructTreeBo;
import kd.hrmp.hric.common.bean.vo.PlanVO;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.constants.msg.PlanMsgEnum;
import kd.hrmp.hric.common.exception.KDHricException;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class InitPlanDomainServiceImpl
implements IInitPlanDomainService {
    private static Log LOG = LogFactory.getLog(InitPlanDomainServiceImpl.class);
    private IInitPlanEntityService initPlanEntityService = ServiceFactory.getService(IInitPlanEntityService.class);
    private IInitTaskEntityService initTaskEntityService = ServiceFactory.getService(IInitTaskEntityService.class);
    ICooperativeDomainService iSystemParamDomainService = ServiceFactory.getService(ICooperativeDomainService.class);

    @Override
    public FormPluginResponse validateSkipImplItem(DynamicObject dyc, int[] selectRows, Map<String, DynamicObject> cacheInitPlanMap) {
        PlanBo planBo = new PlanBo(dyc);
        planBo.init(selectRows);
        if (planBo.validateAllImplItemInit()) {
            return FormPluginResponse.getInstance();
        }
        String mandatoryValidateMsg = planBo.isMandatoryValidate();
        if (HRStringUtils.isEmpty((String)mandatoryValidateMsg)) {
            String dependentValidateMsg = ObjectUtils.isEmpty(cacheInitPlanMap) ? planBo.dependentValidate(this.getImplItemIdTriple(planBo)) : planBo.dependentValidate(this.getImplItemIdTriple(cacheInitPlanMap));
            if (HRStringUtils.isEmpty((String)dependentValidateMsg)) {
                return FormPluginResponse.getInstance();
            }
            return new FormPluginResponse(false, PlanMsgEnum.SKIP_TITLI_MSG.getMsg(), dependentValidateMsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default);
        }
        return new FormPluginResponse(false, "", mandatoryValidateMsg, MessageBoxOptions.OK, ConfirmTypes.Default, true);
    }

    public List<ImmutableTriple<Long, String, Long>> getImplItemIdTriple(Map<String, DynamicObject> cacheInitPlanMap) {
        ArrayList<ImmutableTriple<Long, String, Long>> implItemIdTriple = new ArrayList<ImmutableTriple<Long, String, Long>>();
        cacheInitPlanMap.values().stream().filter(plan -> AppConstants.CONFIG_MODE_LIST.contains(plan.getString("configmode"))).forEach(plan -> this.commonImplItemHandle(implItemIdTriple, (List<DynamicObject>)plan.getDynamicObjectCollection("itementryentity")));
        return implItemIdTriple;
    }

    public List<ImmutableTriple<Long, String, Long>> getImplItemIdTriple(PlanBo planBo) {
        List<ImmutableTriple<Long, String, Long>> implItemIdTriple = this.getOtherSonPlanEntityImplItemId(planBo.getMasterPlanStructNumber());
        List<PlanImplItemBo> implItemBoList = planBo.getImplItemBoList();
        this.commonImplItemHandle(implItemIdTriple, implItemBoList.stream().map(bo -> bo.getDyn()).collect(Collectors.toList()));
        return implItemIdTriple;
    }

    private List<ImmutableTriple<Long, String, Long>> getOtherSonPlanEntityImplItemId(String masterPlanStructNumber) {
        ArrayList<ImmutableTriple<Long, String, Long>> implItemIdTriple = new ArrayList<ImmutableTriple<Long, String, Long>>();
        DynamicObject[] implItemPlanDys = this.initPlanEntityService.getImplItemPlanByStructNumber(masterPlanStructNumber);
        Arrays.stream(implItemPlanDys).forEach(it -> {
            DynamicObjectCollection docs = it.getDynamicObjectCollection("itementryentity");
            this.commonImplItemHandle(implItemIdTriple, (List<DynamicObject>)docs);
        });
        return implItemIdTriple;
    }

    private void commonImplItemHandle(List<ImmutableTriple<Long, String, Long>> implItemIdTriple, List<DynamicObject> docs) {
        docs.stream().filter(doc -> !doc.getBoolean("isskip")).forEach(doc -> {
            String implItemName = doc.getLocaleString("itemname").getLocaleValue();
            long entryImplItemId = doc.getDynamicObject("implitem").getLong("id");
            DynamicObjectCollection mulFrontImpls = doc.getDynamicObjectCollection("mulfrontimpl");
            if (CollectionUtils.isEmpty((Collection)mulFrontImpls)) {
                return;
            }
            mulFrontImpls.stream().map(pre -> pre.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(pre -> pre.getLong("id")).filter(Objects::nonNull).forEach(preId -> implItemIdTriple.add(ImmutableTriple.of((Object)preId, (Object)implItemName, (Object)entryImplItemId)));
        });
    }

    @Override
    public List<DynamicObject> getSkipImplList(long planId) {
        ArrayList implList = Lists.newArrayList();
        DynamicObject plan = InitPlanServiceHelper.getPlansById(planId);
        DynamicObject[] subPlans = InitPlanServiceHelper.getSubInitPlansByStructNumber(plan.getString("structnumber"));
        Arrays.stream(subPlans).map(it -> it.getDynamicObjectCollection("itementryentity")).forEach(it -> implList.addAll(it.stream().filter(dyn -> dyn.getBoolean("isskip")).collect(Collectors.toList())));
        return implList;
    }

    @Override
    public TreeNode initTree(String pkid, DynamicObject[] dys, Map<String, DynamicObject> cacheInitPlanMap, boolean isLoadPlan) {
        LinkedList idQueue = Lists.newLinkedList();
        HashSet implItemIdSet = Sets.newHashSet();
        this.saveImplItemId(dys, implItemIdSet);
        Arrays.stream(ID.genLongIds((int)(dys.length * 2))).forEach(id -> idQueue.offer(id));
        Map<String, DynamicObject> planTempMap = Arrays.stream(dys).collect(Collectors.toMap(planTemp -> planTemp.getString("id"), planTemp -> planTemp));
        DynamicObject planTempDyc = planTempMap.get(pkid);
        TreeNode rootNode = new TreeNode("", planTempDyc.getString("id"), planTempDyc.getString("planname"));
        Date currDate = new Date();
        Long currUser = RequestContext.get().getCurrUserId();
        if (isLoadPlan) {
            this.initNodePlan(new InitPlanBo(planTempDyc, currDate, currUser, cacheInitPlanMap, (Queue)idQueue, (Set)implItemIdSet));
        }
        rootNode.setIsOpened(true);
        planTempMap.remove(pkid);
        this.structTree(new StructTreeBo(rootNode, this.convertToBoMap(planTempMap), isLoadPlan, currDate, currUser, cacheInitPlanMap, (Set)implItemIdSet, (Queue)idQueue));
        return rootNode;
    }

    private List<PlanTempBo> convertToBoMap(Map<String, DynamicObject> planTempMap) {
        return planTempMap.values().stream().map(PlanTempBo::new).collect(Collectors.toList());
    }

    @Override
    public DynamicObject[] filterTreeByName(DynamicObject[] planTempArr, String name) {
        List<DynamicObject> filterList = Arrays.stream(planTempArr).filter(it -> it.getString("planname").contains(name)).collect(Collectors.toList());
        HashMap idMap = Maps.newHashMap();
        ArrayList result = Lists.newArrayList();
        result.add(Arrays.stream(planTempArr).filter(it -> it.getLong("parent.id") == 0L).findFirst().get());
        Map allTplMap = Arrays.stream(planTempArr).collect(Collectors.toMap(it -> it.getLong("id"), Function.identity()));
        filterList.forEach(it -> this.buildResultTplList((DynamicObject)it, idMap, result, allTplMap));
        return result.toArray(new DynamicObject[0]);
    }

    @Override
    public String mustInputCheck(Map<String, DynamicObject> cacheInitPlanMap) {
        ArrayList planBoList = Lists.newArrayList();
        cacheInitPlanMap.values().forEach(plan -> planBoList.add(new PlanBo((DynamicObject)plan)));
        HashSet msgSet = Sets.newHashSet();
        boolean collaborationMode = this.iSystemParamDomainService.getParameterBoolean();
        planBoList.forEach(plan -> {
            msgSet.add(plan.numbersIsEmpty());
            msgSet.add(plan.nameIsEmpty());
            msgSet.add(plan.planPersonIsEmpty());
            List<PlanImplItemBo> implItemBoList = plan.getImplItemBoList();
            implItemBoList.forEach(impl -> {
                msgSet.add(impl.execPersonIsEmpty());
                if (collaborationMode) {
                    msgSet.add(impl.verifyPersonIsEmpty());
                }
            });
        });
        msgSet.remove("");
        if (CollectionUtils.isEmpty((Collection)msgSet)) {
            return "";
        }
        return Joiner.on((String)"\n").join((Iterable)msgSet);
    }

    @Override
    public String planNumberUniqueCheck(Map<String, DynamicObject> cacheInitPlanMap) {
        ArrayList planVOList = Lists.newArrayList();
        StringBuilder resultTipSb = this.interfaceDataCheck(planVOList, cacheInitPlanMap);
        Set<String> numbers = planVOList.stream().map(planVO -> planVO.getNumber()).collect(Collectors.toSet());
        DynamicObject[] dys = this.initPlanEntityService.getPlanInfoByNumbers(numbers);
        if (resultTipSb.length() <= 0 && dys.length == 0) {
            return "";
        }
        Arrays.stream(dys).forEach(dyc -> {
            String dbNumber = dyc.getString("number");
            StringBuilder tipSb = new StringBuilder();
            planVOList.forEach(planVO -> {
                if (!HRStringUtils.equals((String)dbNumber, (String)planVO.getNumber())) {
                    return;
                }
                tipSb.append("\"").append(planVO.getName()).append("\"");
            });
            resultTipSb.append(String.format(Locale.ROOT, PlanMsgEnum.PLAN_NUMBER_EXIST_MSG.get(), tipSb.toString(), dbNumber)).append("\n");
        });
        if (resultTipSb.length() > 0) {
            return resultTipSb.toString().trim();
        }
        return "";
    }

    @Override
    public String checkPlanNameUnique(String currNodeId, String name, Map<String, DynamicObject> cacheInitPlanMap) {
        boolean isRepeat = false;
        for (Map.Entry<String, DynamicObject> entry : cacheInitPlanMap.entrySet()) {
            if (HRStringUtils.equals((String)currNodeId, (String)entry.getKey()) || !HRStringUtils.equals((String)name, (String)entry.getValue().getLocaleString("name").getLocaleValue())) continue;
            isRepeat = true;
            break;
        }
        if (isRepeat) {
            return String.format(Locale.ROOT, PlanMsgEnum.PLAN_NAME_REPEAT_MSG.get(), name);
        }
        return "";
    }

    @Override
    public String checkMasterPlanNameUnique(String name) {
        boolean isRepeat = this.initPlanEntityService.isExistMasterPlan(name);
        if (isRepeat) {
            return String.format(Locale.ROOT, PlanMsgEnum.PLAN_NAME_EXIST_MSG.get(), name);
        }
        return "";
    }

    @Override
    public boolean startUp(Map<String, DynamicObject> cacheInitPlanMap) {
        ArrayList currInitTasks = Lists.newArrayList();
        this.generateTask(currInitTasks, cacheInitPlanMap);
        cacheInitPlanMap.values().stream().forEach(planDyn -> planDyn.set("startuptime", (Object)new Date()));
        return this.savePlanAndTask(currInitTasks, cacheInitPlanMap);
    }

    @Override
    public List<Long> getF7SelectUserId(ClosedCallBackEvent evt) {
        ListSelectedRowCollection rowList = (ListSelectedRowCollection)evt.getReturnData();
        return rowList.stream().map(ListSelectedRow::getPrimaryKeyValue).map(it -> (Long)it).collect(Collectors.toList());
    }

    @Override
    public Set<Long> getCurrMaterPlanImplItemIdSet(Map<String, DynamicObject> cacheInitPlanMap) {
        HashSet implItemIdSet = Sets.newHashSet();
        cacheInitPlanMap.values().stream().filter(plan -> AppConstants.CONFIG_MODE_LIST.contains(plan.getString("configmode"))).forEach(plan -> {
            DynamicObjectCollection implItemEntry = plan.getDynamicObjectCollection("itementryentity");
            Set entryImplItemIdSet = implItemEntry.stream().map(impl -> impl.getDynamicObject("implitem")).filter(Objects::nonNull).filter(impl -> HRStringUtils.equals((String)impl.getString("enable"), (String)"1")).map(impl -> impl.getLong("id")).collect(Collectors.toSet());
            implItemIdSet.addAll(entryImplItemIdSet);
        });
        return implItemIdSet;
    }

    @Override
    public String checkImplItemEntryEmpty(Map<String, DynamicObject> cacheInitPlanMap) {
        ArrayList implItemEmptyMsgList = Lists.newArrayList();
        cacheInitPlanMap.values().stream().filter(plan -> AppConstants.CONFIG_MODE_LIST.contains(plan.getString("configmode"))).forEach(plan -> {
            String name = plan.getLocaleString("name").getLocaleValue();
            DynamicObjectCollection dys = plan.getDynamicObjectCollection("itementryentity");
            long noSkipCount = dys.stream().filter(dyc -> !dyc.getBoolean("isskip")).count();
            if (noSkipCount <= 0L) {
                implItemEmptyMsgList.add(String.format(Locale.ROOT, PlanMsgEnum.IMPLITEM_EMPTY_TIP.get(), name));
            }
        });
        return Joiner.on((String)"\n").join((Iterable)implItemEmptyMsgList);
    }

    private void generateTask(List<DynamicObject> currInitTasks, Map<String, DynamicObject> cacheInitPlanMap) {
        ArrayList taskNumbers = Lists.newArrayList();
        LinkedList idQueue = Lists.newLinkedList();
        HashMap implPreImplMapping = Maps.newHashMap();
        this.saveImplPreImplMappingRel(implPreImplMapping, cacheInitPlanMap);
        Date currDate = new Date();
        Long currUser = RequestContext.get().getCurrUserId();
        boolean collaborationMode = this.iSystemParamDomainService.getParameterBoolean();
        cacheInitPlanMap.values().stream().filter(plan -> AppConstants.CONFIG_MODE_LIST.contains(plan.getString("configmode"))).forEach(plan -> {
            DynamicObjectCollection dys = plan.getDynamicObjectCollection("itementryentity");
            Arrays.stream(ID.genLongIds((int)(dys.size() * 3))).forEach(id -> idQueue.offer(id));
            dys.stream().filter(it -> !it.getBoolean("isskip")).forEach(doc -> {
                DynamicObject execTask = this.initTaskEntityService.generateEmptyDynamicObject();
                this.structInitTask(new StructTaskBo(plan, doc, false, null, execTask, currDate, currUser, idQueue, new HashSet(), taskNumbers), currInitTasks);
                this.handleSonTask(plan.getLong("id"), (DynamicObject)doc, execTask, idQueue, currInitTasks);
                if (!collaborationMode) {
                    return;
                }
                if (!doc.getBoolean("isdataverify")) {
                    return;
                }
                DynamicObject verifyTask = this.initTaskEntityService.generateEmptyDynamicObject();
                this.structInitTask(new StructTaskBo(plan, doc, true, execTask, verifyTask, currDate, currUser, idQueue, new HashSet(), taskNumbers), currInitTasks);
            });
        });
        this.handlePreTask(currInitTasks, implPreImplMapping);
    }

    private void handlePreTask(List<DynamicObject> currInitTasks, Map<Long, DynamicObjectCollection> implPreImplMapping) {
        Map<Long, DynamicObject> implTaskMapping = currInitTasks.stream().filter(task -> HRStringUtils.equals((String)task.getString("tasktype"), (String)"B")).filter(task -> task.getDynamicObject("parent") == null).collect(Collectors.toMap(task -> task.getDynamicObject("implitemrel").getLong("id"), task -> task, (o1, o2) -> o1));
        Set<Long> implItemIdSet = implTaskMapping.keySet();
        implPreImplMapping.entrySet().forEach(entry -> {
            Long implId = (Long)entry.getKey();
            DynamicObjectCollection preImpl = (DynamicObjectCollection)entry.getValue();
            DynamicObject currTask = (DynamicObject)implTaskMapping.get(implId);
            DynamicObjectCollection docs = currTask.getDynamicObjectCollection("pretask");
            preImpl.stream().map(pre -> pre.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(pre -> pre.getLong("id")).forEach(preImplId -> {
                if (!implItemIdSet.contains(preImplId)) {
                    return;
                }
                DynamicObject dy = new DynamicObject(docs.getDynamicObjectType());
                dy.set("fbasedataid", implTaskMapping.get(preImplId));
                docs.add((Object)dy);
            });
            if (CollectionUtils.isEmpty((Collection)docs)) {
                return;
            }
            currTask.set("pretask", (Object)docs);
            currTask.set("taskstatus", (Object)"A");
            currTask.set("taskbegintime", null);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean savePlanAndTask(List<DynamicObject> currInitTasks, Map<String, DynamicObject> cacheInitPlanMap) {
        try (TXHandle required = TX.required();){
            this.initPlanEntityService.save(cacheInitPlanMap.values().stream().collect(Collectors.toList()).toArray(new DynamicObject[0]));
            this.initTaskEntityService.save(currInitTasks.toArray(new DynamicObject[0]));
            this.sendMsg(currInitTasks.stream().filter(task -> task.getDynamicObject("parent") == null).collect(Collectors.toList()));
        }
        return true;
    }

    private void sendMsg(List<DynamicObject> currInitTasks) {
        ArrayList<InitMessageInfo> messageInfos = new ArrayList<InitMessageInfo>();
        List<Long> ids = currInitTasks.stream().map(it -> it.getLong("id")).collect(Collectors.toList());
        DynamicObject[] taskList = this.initTaskEntityService.getTaskByIds(ids);
        Arrays.stream(taskList).forEach(task -> {
            ArrayList<Long> receivers = new ArrayList<Long>();
            receivers.add(task.getDynamicObject("taskleader").getLong("id"));
            DynamicObject currentUser = UserServiceHelper.getCurrentUser((String)"name");
            InitMessageInfo info = new InitMessageInfoBuilder().buildReceivers(receivers).buildSenderName(currentUser.getString("name")).buildSenderId(Long.valueOf(currentUser.getLong("id"))).buildEntityName("hric_inittaskform").buildEntityId(Long.valueOf(task.getLong("id"))).buildContent(this.buildContent((DynamicObject)task, task.getDynamicObject("belongplan"))).buildTitle(PlanMsgEnum.MESSAGE_TITLE.get()).buildTag(PlanMsgEnum.MESSAGE_TAG.get()).build();
            messageInfos.add(info);
        });
        MessageSendServiceHelper.saveMessage(messageInfos);
        AsyncTaskServiceHelper.startJob();
    }

    private String buildContent(DynamicObject task, DynamicObject plan) {
        if (HRStringUtils.equals((String)task.getString("tasktype"), (String)"B")) {
            return String.format(Locale.ROOT, PlanMsgEnum.IMPLITEM_EXECUTE_MSG.get(), plan.getDynamicObject("planperson").getString("name"), task.getString("name"));
        }
        return String.format(Locale.ROOT, PlanMsgEnum.DATA_VERIFY_MSG.get(), plan.getDynamicObject("planperson").getString("name"), task.getString("name"));
    }

    private void structInitTask(StructTaskBo structTaskBo, List<DynamicObject> currInitTasks) {
        DynamicObject initTask = structTaskBo.getInitTask();
        DynamicObject plan = structTaskBo.getPlan();
        DynamicObject entryRow = structTaskBo.getEntryRow();
        Date currDate = structTaskBo.getCurrDate();
        Long currUser = structTaskBo.getCurrUser();
        initTask.set("id", structTaskBo.getIdQueue().poll());
        initTask.set("belongplan", (Object)plan.getLong("id"));
        initTask.set("taskaccepttime", (Object)currDate);
        initTask.set("creator", (Object)currUser);
        initTask.set("createtime", (Object)currDate);
        initTask.set("implitemrel", (Object)entryRow.getDynamicObject("implitem"));
        initTask.set("listseq", (Object)entryRow.getDynamicObject("implitem").getInt("listseq"));
        String parentNum = plan.getString("number");
        if (structTaskBo.isDataVerify()) {
            this.createImplItemExeTask(structTaskBo, initTask, entryRow, parentNum, currInitTasks);
            return;
        }
        initTask.set("number", (Object)this.getTaskNumber(structTaskBo.getTaskNumbers(), parentNum + "-Z"));
        initTask.set("tasktype", (Object)"B");
        initTask.set("name", (Object)(entryRow.getLocaleString("itemname").getLocaleValue() + PlanMsgEnum.EXECUTE.get()));
        Object executePerson = entryRow.get("executeperson");
        if (executePerson instanceof DynamicObject) {
            initTask.set("taskleader", ((DynamicObject)executePerson).getPkValue());
        } else {
            initTask.set("taskleader", executePerson);
        }
        initTask.set("taskstatus", (Object)"B");
        initTask.set("taskbegintime", (Object)currDate);
        initTask.set("pretask", null);
        currInitTasks.add(initTask);
    }

    private void createImplItemExeTask(StructTaskBo structTaskBo, DynamicObject initTask, DynamicObject entryRow, String parentNum, List<DynamicObject> currInitTasks) {
        initTask.set("number", (Object)this.getTaskNumber(structTaskBo.getTaskNumbers(), parentNum + "-Y"));
        initTask.set("tasktype", (Object)"C");
        initTask.set("name", (Object)(entryRow.getLocaleString("itemname").getLocaleValue() + PlanMsgEnum.VERIFICATION.get()));
        Object verifyPerson = entryRow.get("verifyperson");
        if (verifyPerson instanceof DynamicObject) {
            initTask.set("taskleader", ((DynamicObject)verifyPerson).getPkValue());
        } else {
            initTask.set("taskleader", verifyPerson);
        }
        initTask.set("taskstatus", (Object)"A");
        this.structPreTask(structTaskBo.getPreTask(), initTask);
        currInitTasks.add(initTask);
    }

    private void structPreTask(DynamicObject executeTask, DynamicObject initTask) {
        DynamicObjectCollection docs = initTask.getDynamicObjectCollection("pretask");
        DynamicObject dy = new DynamicObject(docs.getDynamicObjectType());
        dy.set("fbasedataid", (Object)executeTask);
        docs.add((Object)dy);
        initTask.set("pretask", (Object)docs);
    }

    private void saveImplPreImplMappingRel(Map<Long, DynamicObjectCollection> implPreImplMapping, Map<String, DynamicObject> cacheInitPlanMap) {
        cacheInitPlanMap.values().stream().filter(plan -> AppConstants.CONFIG_MODE_LIST.contains(plan.getString("configmode"))).forEach(plan -> {
            DynamicObjectCollection dys = plan.getDynamicObjectCollection("itementryentity");
            dys.stream().filter(it -> !it.getBoolean("isskip")).filter(it -> it.getDynamicObject("implitem") != null).forEach(doc -> {
                DynamicObject implItem = doc.getDynamicObject("implitem");
                DynamicObjectCollection mulFrontImpl = doc.getDynamicObjectCollection("mulfrontimpl");
                if (CollectionUtils.isNotEmpty((Collection)mulFrontImpl)) {
                    implPreImplMapping.put(implItem.getLong("id"), mulFrontImpl);
                }
            });
        });
    }

    private String getTaskNumber(List<String> taskNumbers, String taskNumberPrefix) {
        long numCount = taskNumbers.stream().filter(num -> num.startsWith(taskNumberPrefix)).count();
        String taskNumber = numCount == 0L ? taskNumberPrefix + "0001" : taskNumberPrefix + String.format(Locale.ROOT, "%04d", numCount + 1L);
        taskNumbers.add(taskNumber);
        return taskNumber;
    }

    private void saveImplItemId(DynamicObject[] planTempArr, Set<Long> implItemIdSet) {
        Arrays.stream(planTempArr).filter(plan -> AppConstants.CONFIG_MODE_LIST.contains(plan.getString("configmode"))).forEach(plan -> {
            DynamicObjectCollection implItemEntry = plan.getDynamicObjectCollection("hric_ptplitementry");
            Set entryImplItemIdSet = implItemEntry.stream().map(impl -> impl.getDynamicObject("fbasedataid")).filter(Objects::nonNull).filter(impl -> HRStringUtils.equals((String)impl.getString("enable"), (String)"1")).map(impl -> impl.getLong("id")).collect(Collectors.toSet());
            implItemIdSet.addAll(entryImplItemIdSet);
        });
    }

    private StringBuilder interfaceDataCheck(List<PlanVO> planVOList, Map<String, DynamicObject> cacheInitPlanMap) {
        HashMap numberMap = new HashMap();
        ArrayList repeatNumberList = Lists.newArrayList();
        cacheInitPlanMap.values().forEach(plan -> {
            PlanVO planVo = new PlanVO(plan.getLocaleString("name"), plan.getString("number"));
            planVOList.add(planVo);
            this.recordRepeatNumber(numberMap, planVo.getNumber());
        });
        numberMap.keySet().forEach(number -> {
            if ((Integer)numberMap.get(number) > 1) {
                repeatNumberList.add(number);
            }
        });
        StringBuilder sb = new StringBuilder();
        repeatNumberList.forEach(repeatNumber -> {
            String planNameStr = planVOList.stream().map(PlanVO::getName).map(ILocaleString::getLocaleValue).collect(Collectors.joining("\u3001", "\"", "\""));
            String msgTip = String.format(Locale.ROOT, PlanMsgEnum.PLAN_NUMBER_REPEAT_MSG.get(), planNameStr, repeatNumber);
            sb.append(msgTip).append("\n");
        });
        return sb;
    }

    private void recordRepeatNumber(Map<String, Integer> numberMap, String number) {
        int i = 1;
        if (numberMap.get(number) != null) {
            i = numberMap.get(number) + 1;
        }
        numberMap.put(number, i);
    }

    private void structTree(StructTreeBo structTreeBo) {
        TreeNode node = structTreeBo.getTreeNode();
        List planTempBoList = structTreeBo.getPlanTempBoList();
        boolean loadPlan = structTreeBo.isLoadPlan();
        Date currDate = structTreeBo.getCurrDate();
        Long currUser = structTreeBo.getCurrUser();
        Map cacheInitPlanMap = structTreeBo.getCacheInitPlanMap();
        if (CollectionUtils.isEmpty((Collection)node.getChildren()) && !ObjectUtils.isEmpty((Object)planTempBoList)) {
            String childrenId = node.getId();
            for (PlanTempBo planTempBo : planTempBoList) {
                DynamicObject planTempDyc;
                String parentId;
                if (planTempBo.isRemove() || !HRStringUtils.equals((String)(parentId = (planTempDyc = planTempBo.getPlanTempDy()).getDynamicObject("parent").getString("id")), (String)childrenId)) continue;
                TreeNode sonNode = new TreeNode(childrenId, planTempDyc.getString("id"), planTempDyc.getString("planname"));
                sonNode.setIsOpened(true);
                planTempBo.remove();
                node.addChild(sonNode);
                if (loadPlan) {
                    this.initNodePlan(new InitPlanBo(planTempDyc, currDate, currUser, cacheInitPlanMap, structTreeBo.getIdQueue(), structTreeBo.getImplItemIdSet()));
                }
                this.structTree(new StructTreeBo(sonNode, planTempBoList, loadPlan, currDate, currUser, cacheInitPlanMap, structTreeBo.getImplItemIdSet(), structTreeBo.getIdQueue()));
            }
        }
    }

    private void buildResultTplList(DynamicObject tpl, Map<Long, Long> idMap, List<DynamicObject> result, Map<Long, DynamicObject> allTplMap) {
        if (idMap.containsKey(tpl.getLong("id")) || tpl.getLong("parent.id") == 0L) {
            return;
        }
        result.add(tpl);
        idMap.put(tpl.getLong("id"), tpl.getLong("id"));
        this.buildResultTplList(allTplMap.get(tpl.getLong("parent.id")), idMap, result, allTplMap);
    }

    private void initNodePlan(InitPlanBo initPlanBo) {
        DynamicObject planTempDyc = initPlanBo.getPlanTempDyc();
        Map cacheInitPlanMap = initPlanBo.getCacheInitPlanMap();
        String nodeId = planTempDyc.getString("id");
        Long id = (Long)initPlanBo.getIdQueue().poll();
        DynamicObject plan = this.initPlanEntityService.generateEmptyDynamicObject();
        plan.set("id", (Object)id);
        plan.set("masterid", (Object)id);
        plan.set("number", (Object)this.hasCodeRule(plan));
        plan.set("name", (Object)planTempDyc.getLocaleString("planname"));
        DynamicObject parent = planTempDyc.getDynamicObject("parent");
        if (parent != null) {
            String parentId = parent.getString("id");
            DynamicObject parentPlan = (DynamicObject)cacheInitPlanMap.get(parentId);
            if (parentPlan != null) {
                String parentPlanStructNumber = parentPlan.getString("structnumber");
                plan.set("parent", (Object)parentPlan);
                plan.set("structnumber", (Object)(parentPlanStructNumber + "!" + ID.toStringId((long)id)));
            }
        } else {
            plan.set("parent", null);
            plan.set("structnumber", (Object)ID.toStringId((long)id));
        }
        plan.set("industrytype", (Object)planTempDyc.getDynamicObject("industrytype"));
        plan.set("layer", (Object)planTempDyc.getInt("layer"));
        plan.set("planstatus", (Object)"B");
        plan.set("plantype", (Object)"A");
        plan.set("datarange", (Object)planTempDyc.getLocaleString("plandescription"));
        plan.set("group", (Object)this.handleMulBasedata(planTempDyc, "ptplplbizarea"));
        plan.set("bizsubarea", (Object)this.handleMulBasedata(planTempDyc, "ptplplbizsubarea"));
        plan.set("status", (Object)"C");
        plan.set("enable", (Object)"1");
        plan.set("creator", (Object)initPlanBo.getCurrUser());
        plan.set("createtime", (Object)initPlanBo.getCurrDate());
        String configMode = planTempDyc.getString("configmode");
        if (AppConstants.CONFIG_MODE_LIST.contains(configMode)) {
            this.initImplItemEntry(plan, planTempDyc, initPlanBo.getImplItemIdSet());
        }
        plan.set("configmode", (Object)configMode);
        cacheInitPlanMap.put(nodeId, plan);
    }

    private void initImplItemEntry(DynamicObject plan, DynamicObject planTempDyc, Set<Long> implItemIdSet) {
        DynamicObjectCollection implItemEntry = plan.getDynamicObjectCollection("itementryentity");
        DynamicObjectCollection tempImplItem = planTempDyc.getDynamicObjectCollection("hric_ptplitementry");
        tempImplItem.stream().map(implItem -> implItem.getDynamicObject("fbasedataid")).filter(Objects::nonNull).filter(implItem -> HRStringUtils.equals((String)implItem.getString("enable"), (String)"1")).sorted(Comparator.comparing(implItem -> implItem.getLong("listseq"))).forEach(implItem -> {
            DynamicObject implItemRow = implItemEntry.addNew();
            implItemRow.set("implitem", implItem);
            implItemRow.set("itemname", (Object)implItem.getLocaleString("name"));
            implItemRow.set("impltype", (Object)implItem.getString("impltype"));
            implItemRow.set("implsubtype", (Object)implItem.getString("implsubtype"));
            implItemRow.set("implgroup", (Object)implItem.getDynamicObject("group"));
            implItemRow.set("implbizsubarea", (Object)implItem.getDynamicObject("bizsubarea"));
            implItemRow.set("usescene", (Object)implItem.getString("usescene"));
            implItemRow.set("entityobjscope", (Object)implItem.getDynamicObject("entityobjscope"));
            DynamicObjectCollection mulFrontImpl = implItem.getDynamicObjectCollection("mulfrontimpl");
            MulBasedataDynamicObjectCollection dys = new MulBasedataDynamicObjectCollection();
            mulFrontImpl.forEach(impl -> {
                long implId = impl.getLong("fbasedataid_id");
                if (!implItemIdSet.contains(implId)) {
                    return;
                }
                DynamicObject preImpl = new DynamicObject(mulFrontImpl.getDynamicObjectType());
                preImpl.set("fbasedataid_id", (Object)implId);
                preImpl.set("fbasedataid", (Object)impl.getDynamicObject("fbasedataid"));
                dys.add(preImpl);
            });
            implItemRow.set("mulfrontimpl", (Object)dys);
        });
    }

    private String hasCodeRule(DynamicObject plan) {
        try {
            boolean isExist = CodeRuleServiceHelper.isExist((String)"hric_initplan", (DynamicObject)plan, null);
            if (isExist) {
                return CodeRuleServiceHelper.getNumber((String)"hric_initplan", (DynamicObject)plan, null);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new KDHricException(e.getMessage());
        }
        return "";
    }

    private DynamicObjectCollection handleMulBasedata(DynamicObject planTempDyc, String mulBasedataField) {
        DynamicObjectType type = ((DynamicObject)planTempDyc.getDynamicObjectCollection(mulBasedataField).get(0)).getDynamicObjectType();
        MulBasedataDynamicObjectCollection dys = new MulBasedataDynamicObjectCollection();
        planTempDyc.getDynamicObjectCollection(mulBasedataField).forEach(dyc -> {
            DynamicObject dynamicObject = new DynamicObject(type);
            dynamicObject.set("fbasedataid", dyc.get(1));
            dys.add(dynamicObject);
        });
        return dys;
    }

    private void handleSonTask(Long planId, DynamicObject doc, DynamicObject parentTask, Queue<Long> idQueue, List<DynamicObject> currInitTasks) {
        String parentTaskNumber = parentTask.getString("number");
        DynamicObject implItem = doc.getDynamicObject("implitem");
        if (implItem == null) {
            LOG.info("[HRIC] The task:{} relation implItem is empty", (Object)parentTaskNumber);
            return;
        }
        String category = implItem.getString("category");
        if (HRStringUtils.equals((String)category, (String)"1")) {
            DynamicObjectCollection baseImplEntry = implItem.getDynamicObjectCollection("baseimplentry");
            Object executePerson = doc.get("executeperson");
            long taskLeader = executePerson instanceof DynamicObject ? Long.parseLong(((DynamicObject)executePerson).getPkValue().toString()) : Long.parseLong(executePerson.toString());
            parentTask.set("haschildren", (Object)1);
            baseImplEntry.stream().forEach(baseImplItem -> {
                DynamicObject sonImplItem = baseImplItem.getDynamicObject("implitem");
                if (sonImplItem == null) {
                    LOG.info("[HRIC] The task:{} has sonTask relation implItem is empty", (Object)parentTaskNumber);
                    return;
                }
                DynamicObject sonTask = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hric_inittask"));
                sonTask.set("number", (Object)(parentTaskNumber + "-" + (baseImplEntry.indexOf(baseImplItem) + 1)));
                sonTask.set("taskleader", (Object)taskLeader);
                sonTask.set("belongplan", (Object)planId);
                sonTask.set("parent", (Object)parentTask);
                this.sonTaskValSetter(sonTask, sonImplItem, idQueue);
                currInitTasks.add(sonTask);
            });
        }
    }

    private void sonTaskValSetter(DynamicObject sonTask, DynamicObject sonImplItem, Queue<Long> idQueue) {
        sonTask.set("id", (Object)idQueue.poll());
        sonTask.set("name", (Object)(sonImplItem.getLocaleString("name").getLocaleValue() + PlanMsgEnum.EXECUTE.get()));
        sonTask.set("taskaccepttime", (Object)new Date());
        sonTask.set("creator", (Object)RequestContext.get().getCurrUserId());
        sonTask.set("createtime", (Object)new Date());
        sonTask.set("implitemrel", (Object)sonImplItem);
        sonTask.set("taskstatus", (Object)"B");
        sonTask.set("tasktype", (Object)"B");
    }
}

