/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.ext.IDataRuleEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IImplItemEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IInitTaskEntityService;
import kd.hrmp.hric.bussiness.domain.init.IInitTaskDomainService;
import kd.hrmp.hric.bussiness.domain.init.impl.implitem.GroupImplItemValiateServiceBo;
import kd.hrmp.hric.common.bean.vo.InitTaskIdCacheVO;
import kd.hrmp.hric.common.constants.InitTaskConstants;
import kd.hrmp.hric.common.util.HricCacheUtils;

public class InitTaskDomainServiceImpl
implements IInitTaskDomainService {
    private IInitTaskEntityService iInitTaskEntityService = ServiceFactory.getService(IInitTaskEntityService.class);
    private IImplItemEntityService iImplItemEntityService = ServiceFactory.getService(IImplItemEntityService.class);
    private IDataRuleEntityService iDataRuleEntityService = ServiceFactory.getService(IDataRuleEntityService.class);

    @Override
    public String getBizSubAreaByTaskId(Long taskId) {
        DynamicObject task = this.iInitTaskEntityService.getTaskById("implitemrel.bizsubarea", taskId);
        DynamicObject implItemDyn = task.getDynamicObject("implitemrel");
        return Optional.ofNullable(implItemDyn.getDynamicObject("bizsubarea")).map(subAreaDyn -> subAreaDyn.getString("number")).orElse("");
    }

    @Override
    public HrApiResponse<Map<String, Object>> invokeGroupImplItemBizValidate(Long taskId) {
        DynamicObject task = this.iInitTaskEntityService.getTaskById("implitemrel.id", taskId);
        DynamicObject implItemDy = this.iImplItemEntityService.queryOriginalOne("validateservice", task.getDynamicObject("implitemrel").getLong("id"));
        Object[] params = new Object[1];
        Optional<String> validateServiceOptional = Optional.ofNullable(implItemDy).map(it -> it.getString("validateservice")).map(HRStringUtils::trim).filter(HRStringUtils::isNotEmpty);
        if (!validateServiceOptional.isPresent()) {
            return new HrApiResponse();
        }
        params[0] = this.getSonTaskEntityNumberMap(taskId);
        return new GroupImplItemValiateServiceBo(validateServiceOptional.get()).invoke(params);
    }

    @Override
    public DynamicObject[] getSubTaskByParentId(Long parentTaskId) {
        return this.iInitTaskEntityService.getSubTaskByParentId("number,name,tasktype,taskstatus,pretask,taskleader,implitemrel,initformode,belongplan,parent", parentTaskId);
    }

    @Override
    public InitTaskIdCacheVO getInitTaskIdCacheVO(Long currentTaskId) {
        DynamicObject[] initTaskDyns = this.iInitTaskEntityService.query("id", this.getInitTaskQFilters(), "listseq asc, tasktype asc, taskaccepttime desc");
        List initTaskIdList = Arrays.stream(initTaskDyns).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        Long firstTaskId = (Long)initTaskIdList.get(0);
        Long lastTaskId = (Long)initTaskIdList.get(initTaskIdList.size() - 1);
        int flagIndex = initTaskIdList.indexOf(currentTaskId);
        int startIndex = flagIndex - 100;
        startIndex = startIndex >= 0 ? startIndex : 0;
        int endIndex = flagIndex + 100;
        endIndex = endIndex < initTaskIdList.size() ? endIndex : initTaskIdList.size();
        List rangeTaskIdList = initTaskIdList.subList(startIndex, endIndex);
        return new InitTaskIdCacheVO(firstTaskId, lastTaskId, rangeTaskIdList);
    }

    @Override
    public Long getFirstInitTaskId() {
        DynamicObject firstInitTaskDyn = this.iInitTaskEntityService.queryOne("id", this.getInitTaskQFilters(), "listseq asc,tasktype asc,taskaccepttime desc");
        if (HRObjectUtils.isEmpty((Object)firstInitTaskDyn)) {
            return 0L;
        }
        return firstInitTaskDyn.getLong("id");
    }

    @Override
    public Long getLastInitTaskId() {
        DynamicObject lastInitTaskDyn = this.iInitTaskEntityService.queryOne("id", this.getInitTaskQFilters(), "listseq asc, tasktype asc, taskaccepttime desc");
        if (HRObjectUtils.isEmpty((Object)lastInitTaskDyn)) {
            return 0L;
        }
        return lastInitTaskDyn.getLong("id");
    }

    @Override
    public Map<String, Long> getSonTaskEntityNumberMap(Long parentTaskId) {
        Map resultMap = (Map)HricCacheUtils.get((String)("hric$subTaskInitBatchMap" + parentTaskId), Map.class);
        if (resultMap == null) {
            DynamicObject[] subTaskDyns = this.getSubTaskByParentId(parentTaskId);
            HashMap sonTaskValMap = Maps.newHashMapWithExpectedSize((int)subTaskDyns.length);
            Arrays.stream(subTaskDyns).forEach(sonTask -> {
                long taskId = sonTask.getLong("id");
                DynamicObject implItem = sonTask.getDynamicObject("implitemrel");
                DynamicObject entityObj = implItem.getDynamicObject("entityobjscope");
                sonTaskValMap.put(entityObj.getString("number"), taskId);
            });
            resultMap = sonTaskValMap;
            HricCacheUtils.put((String)("hric$subTaskInitBatchMap" + parentTaskId), (Object)sonTaskValMap);
        }
        return resultMap;
    }

    @Override
    public DynamicObject[] getTaskWithSpecifyParam(Map<String, Set<Long>> fieldFilterMap, Set<String> selectFieldSet) {
        ArrayList qFilterList = Lists.newArrayList();
        fieldFilterMap.entrySet().forEach(entry -> qFilterList.add(new QFilter((String)entry.getKey(), "in", entry.getValue())));
        String selectField = Joiner.on((String)",").join(selectFieldSet);
        return this.iInitTaskEntityService.queryTaskWithSpecifyParam(qFilterList.toArray(new QFilter[0]), selectField);
    }

    private QFilter[] getInitTaskQFilters() {
        QFilter sonTaskFilter = new QFilter("parent", "=", (Object)0);
        QFilter taskTypeFilter = new QFilter("tasktype", "!=", (Object)"A");
        QFilter taskStatusFilter = new QFilter("taskstatus", "in", (Object)InitTaskConstants.STATUS_LIST);
        QFilter dataRuleQFilter = this.iDataRuleEntityService.getDataRuleQFilter("hric_inittask");
        return new QFilter[]{sonTaskFilter, taskStatusFilter, taskTypeFilter, dataRuleQFilter};
    }
}

