/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.DataType;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.ext.IOpenApiEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IInitTempEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IMidTableEntityService;
import kd.hrmp.hric.bussiness.domain.init.IInitTemplateDomainService;
import kd.hrmp.hric.bussiness.domain.init.impl.template.bo.InitTemplateBo;
import kd.hrmp.hric.bussiness.service.MidTableAutoGenerateExecTaskServiceHelper;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.constants.msg.CommonTipsEnum;
import kd.hrmp.hric.common.openapi.ApiErrorCodeCustom;
import kd.hrmp.hric.common.openapi.OpenApiEntryModel;
import kd.hrmp.hric.common.openapi.OpenApiHricUtils;

public class InitTemplateDomainServiceImpl
implements IInitTemplateDomainService {
    private static Log log = LogFactory.getLog(InitTemplateDomainServiceImpl.class);
    private final IOpenApiEntityService iOpenApiEntityService = ServiceFactory.getService(IOpenApiEntityService.class);
    private final IInitTempEntityService iInitTempEntityService = ServiceFactory.getService(IInitTempEntityService.class);
    private final IMidTableEntityService iMidTableEntityService = ServiceFactory.getService(IMidTableEntityService.class);
    private static final String PRESCRIPT_TAG = "var cloudId = 'hrmp';\nvar appId = 'hric';\nvar serviceName = 'IInitMidTableService';\nvar methodName = 'syncMidTableData';\nvar params = [planNumber,'%s', batchNumber, data, hricSourceSys];\nvar result = MS.invokeBizService(cloudId, appId, serviceName, methodName, params);\n";
    private static final String SELECT_PROPERTIES = "intermediatetable, ispublish, treeentryentity.id, treeentryentity.entitynumber, treeentryentity.ismustinput, treeentryentity.entityname, treeentryentity.isfield, treeentryentity.isimport";

    @Override
    public Map<String, String> getGenerateFieldTemplateKey(List<Long> idList) {
        Object[] dycs = MidTableAutoGenerateExecTaskServiceHelper.getMidTableEntryDetail(idList);
        return this.getGenerateFieldTemplateKeyByDyc(Lists.newArrayList((Object[])dycs));
    }

    @Override
    public Map<String, String> getGenerateFieldTemplateKeyByDyc(List<DynamicObject> dycList) {
        ArrayList templateBoList = Lists.newArrayListWithExpectedSize((int)dycList.size());
        for (DynamicObject dyc : dycList) {
            templateBoList.add(new InitTemplateBo(dyc));
        }
        return templateBoList.stream().collect(Collectors.toMap(InitTemplateBo::getMidtableNumber, InitTemplateBo::convertToString, (o1, o2) -> o1));
    }

    private Set<String> getOpenApiNumberByInitTemp(List<DynamicObject> initTemps) {
        return initTemps.stream().map(initTemp -> initTemp.getString("intermediatetable") + "/save").collect(Collectors.toSet());
    }

    @Override
    public void unPublish(Set<Long> ids) {
        List<DynamicObject> initTempList = this.iInitTempEntityService.queryByIds("intermediatetable,ispublish", ids);
        this.iOpenApiEntityService.deleteByNumberSet(this.getOpenApiNumberByInitTemp(initTempList));
        this.iInitTempEntityService.batchChangeTempPublishStatus(initTempList, false);
    }

    @Override
    public void publishOpenApiDyn(Set<Long> ids) {
        List<DynamicObject> initTempList = this.iInitTempEntityService.queryByIds(SELECT_PROPERTIES, ids);
        List<DynamicObject> openApiObjectList = this.packageOpenApiDyList(initTempList);
        this.iOpenApiEntityService.deleteByNumberSet(this.getOpenApiNumberByInitTemp(initTempList));
        boolean openApiSave = this.iOpenApiEntityService.opSave(openApiObjectList);
        if (openApiSave) {
            this.iInitTempEntityService.batchChangeTempPublishStatus(initTempList, true);
        }
    }

    private List<DynamicObject> packageOpenApiDyList(List<DynamicObject> initTemps) {
        ArrayList<DynamicObject> openApiObjectList = new ArrayList<DynamicObject>(initTemps.size());
        for (DynamicObject initTemp : initTemps) {
            DynamicObject openApiObject = this.iOpenApiEntityService.generateEmptyDynamicObject();
            this.makeOpenApiDyn(openApiObject, initTemp);
            openApiObjectList.add(openApiObject);
        }
        return openApiObjectList;
    }

    private void makeOpenApiDyn(DynamicObject openApiObject, DynamicObject initTemp) {
        this.setApi(openApiObject, initTemp);
        this.setApiHeader(openApiObject);
        this.setApiBody(openApiObject, initTemp);
        this.setApiResp(openApiObject);
        this.setResource(openApiObject);
        openApiObject.set("errorcodeentity", (Object)this.setErrorCode());
    }

    private void setApi(DynamicObject openApiObject, DynamicObject initTemp) {
        Date today = new Date();
        openApiObject.set("number", (Object)(initTemp.getString("intermediatetable") + "/save"));
        openApiObject.set("name", (Object)initTemp.getString("name"));
        openApiObject.set("httpmethod", (Object)"1");
        openApiObject.set("createtime", (Object)today);
        openApiObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        openApiObject.set("appid_id", (Object)"22/9TRQ536NA");
        openApiObject.set("customsort", (Object)"1592644677578929152");
        openApiObject.set("urlformat", (Object)String.format(Locale.ROOT, "/v2/hric/%s/save", initTemp.getString("intermediatetable")));
        openApiObject.set("enable", (Object)"1");
        openApiObject.set("status", (Object)"C");
        openApiObject.set("apiservicetype", (Object)"3");
        openApiObject.set("version", (Object)"2");
        String isvId = ISVServiceHelper.getISVInfo().getId();
        openApiObject.set("isvid", (Object)isvId);
        openApiObject.set("cosmicver", (Object)"4.0.004");
        openApiObject.set("stdmodifytime", (Object)today);
        openApiObject.set("discription", (Object)ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4e2d\u5fc3\u52a8\u6001\u751f\u6210\u7684\u7f13\u5b58\u8868\u5199\u5165\u63a5\u53e3\u670d\u52a1\u3002", (String)"InitTemplateDomainServiceImpl_0", (String)"hrmp-hric-business", (Object[])new Object[0]));
        String tableNumber = initTemp.getString("intermediatetable");
        openApiObject.set("prescript_tag", (Object)String.format(Locale.ROOT, PRESCRIPT_TAG, tableNumber));
    }

    private void setApiHeader(DynamicObject openApiObject) {
    }

    private void setApiBody(DynamicObject openApiObject, DynamicObject initTemp) {
        DynamicObjectCollection treeEntryEntities = initTemp.getDynamicObjectCollection("treeentryentity");
        DynamicObjectCollection bodyEntryEntity = new DynamicObjectCollection();
        long dataId = ID.genLongId();
        ArrayList bodyList = Lists.newArrayListWithCapacity((int)AppConstants.LIST_SIZE);
        String PLAN_NUMBER = ResManager.loadKDString((String)"\u8ba1\u5212\u7f16\u53f7", (String)"OpenApiConstants_0", (String)"hrmp-hric-common", (Object[])new Object[0]);
        String BATCH_NUMBER = ResManager.loadKDString((String)"\u6279\u6b21\u53f7", (String)"OpenApiConstants_1", (String)"hrmp-hric-common", (Object[])new Object[0]);
        String SOURCE_SYS = ResManager.loadKDString((String)"\u6765\u6e90\u7cfb\u7edf", (String)"OpenApiConstants_2", (String)"hrmp-hric-common", (Object[])new Object[0]);
        bodyList.add(new OpenApiEntryModel("planNumber", "String", "0", "1", PLAN_NUMBER, "1", "\"example\""));
        bodyList.add(new OpenApiEntryModel("batchNumber", "String", "0", "1", BATCH_NUMBER, "0", "\"example\""));
        bodyList.add(new OpenApiEntryModel("hricSourceSys", "String", "0", "1", SOURCE_SYS, "0", "\"example\""));
        bodyList.add(new OpenApiEntryModel("data", "Struct", "1", "1", "data", "1", "[]"));
        bodyList.forEach(row -> {
            DynamicObject bodyDyn = this.iOpenApiEntityService.generateEmptyEntryDynamicObject("bodyentryentity");
            bodyDyn.set("paramname", (Object)row.getParamName());
            bodyDyn.set("paramtype", (Object)row.getParamType());
            bodyDyn.set("is_req_mul_value", (Object)row.getMulValue());
            bodyDyn.set("body_level", (Object)row.getLevel());
            bodyDyn.set("bodyparamdes", (Object)row.getParamDes());
            bodyDyn.set("must", (Object)row.getMust());
            bodyDyn.set("example", (Object)row.getExample());
            if ("data".equals(row.getParamName())) {
                bodyDyn.set("id", (Object)dataId);
            }
            bodyEntryEntity.add((Object)bodyDyn);
        });
        bodyEntryEntity.addAll((Collection)this.makeMidTableField(treeEntryEntities, initTemp.getString("intermediatetable"), dataId));
        openApiObject.set("bodyentryentity", (Object)bodyEntryEntity);
    }

    private DynamicObjectCollection makeMidTableField(DynamicObjectCollection treeEntryEntities, String midTableNumber, long dataId) {
        DynamicObject midTableDyn = this.iMidTableEntityService.generateEmptyDynamicObject(midTableNumber);
        DynamicObjectCollection bodyEntryEntity = new DynamicObjectCollection();
        for (DynamicObject tree : treeEntryEntities) {
            if (!tree.getBoolean("isfield") || !tree.getBoolean("isimport")) continue;
            String number = tree.getString("entitynumber");
            IDataEntityProperty property = (IDataEntityProperty)midTableDyn.getDataEntityType().getProperties().get((Object)number);
            if (property == null) {
                log.info("publish openAPI midTable property is null. midTableNumber= {},  property= {}", (Object)midTableNumber, (Object)number);
                continue;
            }
            if (property instanceof MuliLangTextProp) {
                this.handleMulilangProp(dataId, bodyEntryEntity, tree, number);
                continue;
            }
            this.buildBody(dataId, bodyEntryEntity, tree.getBoolean("ismustinput") ? "1" : "0", number, property, String.valueOf(tree.getString("entityname")));
        }
        this.setHricSourceSys(dataId, bodyEntryEntity, midTableDyn);
        return bodyEntryEntity;
    }

    private void buildBody(long dataId, DynamicObjectCollection bodyEntryEntity, String must, String number, IDataEntityProperty property, String bodyparamdes) {
        DynamicObject body = this.iOpenApiEntityService.generateEmptyEntryDynamicObject("bodyentryentity");
        body.set("paramname", (Object)number);
        body.set("must", (Object)must);
        body.set("bodyparamdes", (Object)bodyparamdes);
        body.set("body_level", (Object)"2");
        body.set("paramtype", (Object)OpenApiHricUtils.getPropertyType((IDataEntityProperty)property));
        body.set("example", OpenApiHricUtils.getDefaultValue((IDataEntityProperty)property));
        body.set("pid", (Object)dataId);
        bodyEntryEntity.add((Object)body);
    }

    private void setHricSourceSys(long dataId, DynamicObjectCollection bodyEntryEntity, DynamicObject midTableDyn) {
        IDataEntityProperty property = (IDataEntityProperty)midTableDyn.getDataEntityType().getProperties().get((Object)"hricsourcesyskey");
        this.buildBody(dataId, bodyEntryEntity, "0", "hricsourcesyskey", property, CommonTipsEnum.EXPLLAN.getMsg());
    }

    private void handleMulilangProp(long dataId, DynamicObjectCollection bodyEntryEntity, DynamicObject tree, String number) {
        DynamicObject body = this.iOpenApiEntityService.generateEmptyEntryDynamicObject("bodyentryentity");
        body.set("paramname", (Object)number);
        body.set("paramtype", (Object)"Struct");
        body.set("must", (Object)(tree.getBoolean("ismustinput") ? "1" : "0"));
        body.set("bodyparamdes", (Object)String.valueOf(tree.getString("entityname")));
        body.set("is_req_mul_value", (Object)"0");
        body.set("body_level", (Object)"2");
        body.set("example", (Object)"-");
        body.set("pid", (Object)dataId);
        long muliLangRowId = ID.genLongId();
        body.set("id", (Object)muliLangRowId);
        bodyEntryEntity.add((Object)body);
        List enabledLangList = InteServiceHelper.getEnabledLang();
        enabledLangList.forEach(enabledLang -> {
            DynamicObject sonBody = this.iOpenApiEntityService.generateEmptyEntryDynamicObject("bodyentryentity");
            sonBody.set("paramname", (Object)enabledLang.getNumber());
            sonBody.set("paramtype", (Object)DataType.STRING.type());
            sonBody.set("must", (Object)"0");
            sonBody.set("bodyparamdes", (Object)enabledLang.getName());
            sonBody.set("is_req_mul_value", (Object)"0");
            sonBody.set("body_level", (Object)"3");
            sonBody.set("example", (Object)"-");
            sonBody.set("pid", (Object)muliLangRowId);
            bodyEntryEntity.add((Object)sonBody);
        });
    }

    private void setApiResp(DynamicObject openApiObject) {
        DynamicObjectCollection dynCollection = new DynamicObjectCollection();
        ArrayList<OpenApiEntryModel> respList = new ArrayList<OpenApiEntryModel>();
        respList.add(new OpenApiEntryModel("result", "Struct", "0", "1", "result", "1", "\"example\""));
        respList.forEach(row -> {
            DynamicObject resp = this.iOpenApiEntityService.generateEmptyEntryDynamicObject("respentryentity");
            resp.set("respparamname", (Object)row.getParamName());
            resp.set("respparamtype", (Object)row.getParamType());
            resp.set("is_resp_mul_value", (Object)row.getMulValue());
            resp.set("resp_level", (Object)row.getLevel());
            resp.set("respdes", (Object)row.getParamDes());
            resp.set("respexample", (Object)row.getExample());
            dynCollection.add((Object)resp);
        });
        openApiObject.set("respentryentity", (Object)dynCollection);
    }

    private void setResource(DynamicObject openApiObject) {
    }

    private DynamicObjectCollection setErrorCode() {
        DynamicObjectCollection dynCollection = new DynamicObjectCollection();
        for (ApiErrorCodeCustom item : ApiErrorCodeCustom.values()) {
            DynamicObject errorCodeDyn = this.iOpenApiEntityService.generateEmptyEntryDynamicObject("errorcodeentity");
            errorCodeDyn.set("errorcode", (Object)item.getCode());
            errorCodeDyn.set("errorcodedesc", item.getErrorMsg().get());
            dynCollection.add((Object)errorCodeDyn);
        }
        return dynCollection;
    }
}

