/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.util.CodeRuleSerialNumUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IExecTaskEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IInitPlanEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IInitTaskEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IInitTempEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IMidTableEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.ISourceSysEntityService;
import kd.hrmp.hric.bussiness.domain.init.IMidTableDomainService;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.MidTableGenerate;
import kd.hrmp.hric.bussiness.service.InitMidTableServiceHelper;
import kd.hrmp.hric.bussiness.service.task.handle.ChangeValidatedStatusHandle;
import kd.hrmp.hric.bussiness.service.task.handle.MidTableHandleInfo;
import kd.hrmp.hric.common.OperateEnum;
import kd.hrmp.hric.common.bean.bo.ExecTaskCallbackBo;
import kd.hrmp.hric.common.constants.msg.MidTableMsgEnum;
import kd.hrmp.hric.common.exception.KDHricException;
import kd.hrmp.hric.common.openapi.ApiErrorCodeCustom;
import org.apache.commons.lang3.StringUtils;

public class MidTableDomainServiceImpl
implements IMidTableDomainService {
    private static Log LOG = LogFactory.getLog(MidTableDomainServiceImpl.class);
    private final IInitTempEntityService initTempEntityService = ServiceFactory.getService(IInitTempEntityService.class);
    private final IInitTaskEntityService initTaskEntityService = ServiceFactory.getService(IInitTaskEntityService.class);
    private final IInitPlanEntityService initPlanEntityService = ServiceFactory.getService(IInitPlanEntityService.class);
    private final IMidTableEntityService iMidTableEntityService = ServiceFactory.getService(IMidTableEntityService.class);
    private final IExecTaskEntityService iExecTaskEntityService = ServiceFactory.getService(IExecTaskEntityService.class);
    private final ISourceSysEntityService iSourceSysEntityService = ServiceFactory.getService(ISourceSysEntityService.class);
    private static List<String> permitStatus = Lists.newArrayList((Object[])new String[]{OperateEnum.INITIMPORTDATA.getSuccessStatus(), OperateEnum.INITCHECK.getErrorStatus(), OperateEnum.CHECK.getErrorStatus(), OperateEnum.SYNC.getErrorStatus(), OperateEnum.ROLLBACK.getSuccessStatus()});

    @Override
    public List<String> generate(DynamicObject dynamicObject) {
        MidTableGenerate midTableGenerate = new MidTableGenerate(dynamicObject);
        midTableGenerate.autoGenerateMiddleTableAndMetadata();
        return midTableGenerate.getErrorMsgList();
    }

    @Override
    public Integer clearData(String midTableNumber, QFilter[] qFilters) {
        return new HRBaseServiceHelper(midTableNumber).deleteByFilter(qFilters);
    }

    @Override
    public boolean batchUpdateBizTableStatusForSignTask(Long taskId, ExecTaskCallbackBo execTaskCallbackBo, List<MidTableHandleInfo> subTaskHandleInfoList) {
        MidTableHandleInfo midTableHandleInfo = new MidTableHandleInfo((long)taskId, execTaskCallbackBo, subTaskHandleInfoList, OperateEnum.VERIFY);
        return new ChangeValidatedStatusHandle(midTableHandleInfo).handle();
    }

    @Override
    public void syncMidTableData(String planNumber, String midTableNumber, String batchNumber, List<Map<String, Object>> dataList, String hricSourceSys) {
        DynamicObject initTaskDyn = this.getTaskDyn(planNumber, midTableNumber);
        if (initTaskDyn == null) {
            return;
        }
        QFilter sourceQFilter = new QFilter("number", "=", (Object)hricSourceSys);
        DynamicObject sourceDyn = this.iSourceSysEntityService.queryOne("id", new QFilter[]{sourceQFilter});
        ArrayList midTableList = new ArrayList();
        Map<String, IDataEntityProperty> propertyMap = this.iMidTableEntityService.generateEmptyDynamicObject(midTableNumber).getDataEntityType().getProperties().stream().collect(Collectors.toMap(IMetadata::getName, property -> property));
        String batchNumberCreate = this.createBatchNumber(batchNumber);
        dataList.forEach(dataRow -> {
            DynamicObject midTableDy = this.iMidTableEntityService.generateEmptyDynamicObject(midTableNumber);
            dataRow.forEach((field, value) -> {
                if (!propertyMap.containsKey(field)) {
                    return;
                }
                if (propertyMap.get(field) instanceof DateTimeProp) {
                    this.setDateValue(midTableDy, (IDataEntityProperty)propertyMap.get(field), value);
                } else {
                    midTableDy.set(field, value);
                }
            });
            midTableDy.set("initbatchnumber", (Object)batchNumberCreate);
            midTableDy.set("hrictaskid", initTaskDyn.getPkValue());
            midTableDy.set("initstatus", (Object)OperateEnum.INITIMPORTDATA.getSuccessStatus());
            midTableDy.set("hricsourcesys", sourceDyn.getPkValue());
            midTableList.add(midTableDy);
        });
        SaveServiceHelper.save((DynamicObject[])midTableList.toArray(new DynamicObject[0]));
    }

    private void setDateValue(DynamicObject midTableDy, IDataEntityProperty prop, Object timeValue) {
        Date startTime;
        DateTimeProp timeProp = (DateTimeProp)prop;
        try {
            startTime = timeValue instanceof Date ? (Date)timeValue : timeProp.parse((Object)midTableDy, timeValue.toString());
        }
        catch (ParseException e) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5%1$s\u548c%2$s\u7684\u683c\u5f0f\u662f\u5426\u6b63\u786e\u3002", (String)"MidTableDomainServiceImpl_0", (String)"hrmp-hric-business", (Object[])new Object[0]), prop.getName(), timeValue);
            throw new OpenApiException(ApiErrorCode.Data_Invalid, errMsg, new Object[]{""});
        }
        midTableDy.set(prop.getName(), (Object)startTime);
    }

    @Override
    public void syncMidTableValidate(String planNumber, String midTableNumber, String batchNumber, List<Map<String, Object>> dataList, String hricSourceSys) {
        QFilter qFilter = new QFilter("intermediatetable", "=", (Object)midTableNumber);
        boolean midTableExist = this.initTempEntityService.isExists(qFilter);
        if (!midTableExist) {
            String kdString = ResManager.loadKDString((String)"\u7f13\u5b58\u8868\u4e0d\u5b58\u5728\uff1a%s\u3002", (String)"OpenApiDomainServiceImpl_1", (String)"hrmp-hric-business", (Object[])new Object[0]);
            throw new OpenApiException(ApiErrorCode.Data_NotFound, String.format(Locale.ROOT, kdString, midTableNumber), new Object[]{""});
        }
        DynamicObject initTaskDyn = this.getTaskDyn(planNumber, midTableNumber);
        if (initTaskDyn == null) {
            String kdString = ResManager.loadKDString((String)"\u603b\u8ba1\u5212\u7f16\u7801\u9519\u8bef\uff1a%s\u3002", (String)"OpenApiDomainServiceImpl_0", (String)"hrmp-hric-business", (Object[])new Object[0]);
            String format = String.format(Locale.ROOT, kdString, planNumber);
            throw new KDHricException(new ErrorCode(ApiErrorCodeCustom.PLAN_NUMBER.getCode(), format), new Object[0]);
        }
        QFilter sourceQFilter = new QFilter("number", "=", (Object)hricSourceSys);
        boolean sourceExists = this.iSourceSysEntityService.isExists(sourceQFilter);
        if (!sourceExists) {
            String kdString = ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u6765\u6e90\u7cfb\u7edf\uff1a%1$s\u3002", (String)"OpenApiDomainServiceImpl_5", (String)"hrmp-hric-business", (Object[])new Object[0]);
            throw new OpenApiException(ApiErrorCode.Data_NotFound, String.format(Locale.ROOT, kdString, midTableNumber), new Object[]{""});
        }
        boolean exists = this.iMidTableEntityService.isExists(midTableNumber, new QFilter("initbatchnumber", "=", (Object)batchNumber));
        if (exists) {
            String kdString = ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u9519\u8bef\uff1a%s\u3002", (String)"OpenApiDomainServiceImpl_2", (String)"hrmp-hric-business", (Object[])new Object[0]);
            throw new KDHricException(new ErrorCode(ApiErrorCodeCustom.BATCH_NUMBER.getCode(), String.format(Locale.ROOT, kdString, midTableNumber)), new Object[0]);
        }
        if (dataList.size() > 10000) {
            String kdString = ResManager.loadKDString((String)"\u5355\u6b21\u6570\u636e\u603b\u91cf\u4e0d\u5f97\u8d85\u8fc710000\u3002", (String)"OpenApiDomainServiceImpl_3", (String)"hrmp-hric-business", (Object[])new Object[0]);
            throw new OpenApiException(ApiErrorCode.HTTP_NOT_ACCEPTABLE, String.format(Locale.ROOT, kdString, midTableNumber), new Object[]{""});
        }
    }

    @Override
    public DynamicObject[] getMidTblWithSpecifyParam(Map<String, Set<Object>> fieldFilterMap, Map<String, Set<Object>> initFieldFilterMap, Long execTaskId, Set<String> selectFieldSet) {
        DynamicObject execTask = this.iExecTaskEntityService.query("taskinfo,batchnumber", execTaskId);
        if (ObjectUtils.isEmpty((Object)execTask)) {
            LOG.info("[HRIC]Call RPC Service,The ExecTask cannot be found according to the execTaskId");
            return new DynamicObject[0];
        }
        long taskId = execTask.getLong("batchnumber");
        String taskInfo = execTask.getString("taskinfo");
        String midTblNumber = JSON.parseObject((String)taskInfo).getString("midTableNumber");
        Map<String, String> midTblAndEntityMappingMap = InitMidTableServiceHelper.getMidTableAndEntityMappingWithoutName(midTblNumber);
        HashMap midTblQFilterMap = Maps.newHashMapWithExpectedSize((int)fieldFilterMap.size());
        fieldFilterMap.keySet().forEach(key -> midTblAndEntityMappingMap.entrySet().forEach(entry -> {
            if (((String)entry.getValue()).contains((CharSequence)key)) {
                midTblQFilterMap.put(entry.getKey(), fieldFilterMap.get(key));
            }
        }));
        if (!CollectionUtils.isEmpty(initFieldFilterMap)) {
            midTblQFilterMap.putAll(initFieldFilterMap);
        }
        HashSet midTblSelectFieldSet = Sets.newHashSetWithExpectedSize((int)selectFieldSet.size());
        selectFieldSet.forEach(field -> midTblAndEntityMappingMap.entrySet().forEach(entry -> {
            if (((String)entry.getValue()).contains((CharSequence)field)) {
                midTblSelectFieldSet.add(entry.getKey());
            }
        }));
        ArrayList qFilterList = Lists.newArrayList((Object[])new QFilter[]{new QFilter("hrictaskid", "!=", (Object)taskId)});
        midTblQFilterMap.entrySet().forEach(entry -> qFilterList.add(new QFilter((String)entry.getKey(), "in", entry.getValue())));
        midTblSelectFieldSet.add("hrictaskid");
        String selectFieldStr = Joiner.on((String)",").join((Iterable)midTblSelectFieldSet);
        return this.iMidTableEntityService.getMidTblData(midTblNumber, qFilterList.toArray(new QFilter[0]), selectFieldStr);
    }

    @Override
    public String getMidTableDataStatusCheckResult(String midTableName, Object[] primaryKeyValues) {
        Object[] midTblData = this.iMidTableEntityService.getMidTblData(midTableName, new QFilter("id", "in", (Object)primaryKeyValues).toArray(), "initstatus");
        if (HRArrayUtils.isEmpty((Object[])midTblData)) {
            MidTableMsgEnum.CHECK_MSG_TWO.getMsg();
        }
        if (Arrays.stream(midTblData).anyMatch(it -> !permitStatus.contains(it.getString("initstatus")))) {
            return MidTableMsgEnum.CHECK_MSG_ONE.getMsg();
        }
        return "true";
    }

    private DynamicObject getTaskDyn(String planNumber, String midTableNumber) {
        QFilter qFilter = new QFilter("number", "=", (Object)planNumber);
        DynamicObject planDyn = this.initPlanEntityService.queryOne("structnumber", new QFilter[]{qFilter});
        if (planDyn == null) {
            return null;
        }
        QFilter planQFilter = new QFilter("belongplan.structnumber", "like", (Object)(planDyn.getString("structnumber") + "%"));
        QFilter tableQFilter = new QFilter("implitemrel.initimporttemplat.intermediatetable", "=", (Object)midTableNumber);
        QFilter taskTypeQFilter = new QFilter("tasktype", "=", (Object)"B");
        return this.initTaskEntityService.queryOne("id", new QFilter[]{planQFilter, tableQFilter, taskTypeQFilter});
    }

    private String createBatchNumber(String batchNumber) {
        if (StringUtils.isNotBlank((CharSequence)batchNumber)) {
            return batchNumber;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String randomNumber = CodeRuleSerialNumUtil.getRandomNumber((int)3);
        return "API" + dateFormat.format(new Date()) + randomNumber;
    }
}

