/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IImplItemEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IInitPlanEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IPTplPlanEntityService;
import kd.hrmp.hric.bussiness.domain.init.IImplItemDomainService;
import kd.hrmp.hric.bussiness.domain.init.IPTplPlanDomainService;
import kd.hrmp.hric.bussiness.service.PlanTemplateServiceHelper;
import kd.hrmp.hric.common.constants.PlanTemplateConstants;
import kd.hrmp.hric.common.util.HricCacheUtils;
import org.apache.commons.collections4.CollectionUtils;

public class PTplPlanDomainServiceImpl
implements IPTplPlanDomainService,
PlanTemplateConstants {
    private static final Log logger = LogFactory.getLog(PTplPlanDomainServiceImpl.class);
    private final IPTplPlanEntityService pTplPlanEntityService = ServiceFactory.getService(IPTplPlanEntityService.class);
    private final IImplItemDomainService implItemDomainService = ServiceFactory.getService(IImplItemDomainService.class);
    private final IInitPlanEntityService initPlanEntityService = ServiceFactory.getService(IInitPlanEntityService.class);
    IImplItemEntityService iImplItemEntityService = ServiceFactory.getService(IImplItemEntityService.class);

    @Override
    public String loadPlanInfo(Long rootId) {
        List<DynamicObject> planInfoList = this.pTplPlanEntityService.queryByRootId(rootId);
        return this.toBase64String(planInfoList);
    }

    @Override
    public List<DynamicObject> createPlanInfo(Long rootId, DynamicObjectCollection bizAreaCo, DynamicObjectCollection bizSubAreaCo, DynamicObjectCollection eBizSubArea) {
        ArrayList<DynamicObject> pTplPlanList = new ArrayList<DynamicObject>();
        LocaleString rootName = new LocaleString(ResManager.loadKDString((String)"\u603b\u8ba1\u5212", (String)"PlanTemplateEditPlugin_0", (String)"hrmp-hric-business", (Object[])new Object[0]));
        rootName.setLocaleValue_zh_TW(ResManager.loadKDString((String)"\u7e3d\u8a08\u5283", (String)"PlanTemplateEditPlugin_2", (String)"hrmp-hric-business", (Object[])new Object[0]));
        DynamicObject rootPlan = this.createPlanInfo(rootId, (ILocaleString)rootName, 0L, bizAreaCo, bizSubAreaCo, ID.toStringId((long)rootId));
        rootPlan.set("configmode", (Object)"A");
        rootPlan.set("layer", (Object)1);
        pTplPlanList.add(rootPlan);
        pTplPlanList.addAll(this.createPlanBody(rootId, bizAreaCo, bizSubAreaCo));
        this.getImplItem(pTplPlanList, eBizSubArea.stream().map(s -> s.getLong("fbasedataid_id")).collect(Collectors.toSet()));
        return pTplPlanList;
    }

    @Override
    public List<DynamicObject> planTransToTemplate(String structNumber) {
        DynamicObject[] initPlanDynArr = this.initPlanEntityService.getByStructNumber(structNumber);
        Map<Object, Object> transFieldMap = PlanTemplateServiceHelper.transIdAndStructNumber(initPlanDynArr);
        ArrayList<DynamicObject> pTplPlanList = new ArrayList<DynamicObject>(initPlanDynArr.length);
        for (DynamicObject plan : initPlanDynArr) {
            long templateId = (Long)transFieldMap.get(plan.getLong("id"));
            long parent = (Long)transFieldMap.get(plan.getLong("parent.id"));
            String planStructNumber = (String)transFieldMap.get(plan.getString("structnumber"));
            ILocaleString name = plan.getLocaleString("name");
            DynamicObjectCollection bizArea = plan.getDynamicObjectCollection("group");
            DynamicObjectCollection bizSubArea = plan.getDynamicObjectCollection("bizsubarea");
            DynamicObject planTemplate = this.createPlanInfo(templateId, name, parent, bizArea, bizSubArea, planStructNumber);
            planTemplate.set("configmode", (Object)plan.getString("configmode"));
            planTemplate.set("layer", (Object)plan.getInt("layer"));
            planTemplate.set("industrytype", (Object)plan.getDynamicObject("industrytype"));
            List<Long> implItemIdSet = plan.getDynamicObjectCollection("itementryentity").stream().map(s -> s.getLong("implitem.id")).collect(Collectors.toList());
            DynamicObjectCollection implItemCo = this.simpleImplItem(implItemIdSet);
            planTemplate.set("hric_ptplitementry", (Object)implItemCo);
            pTplPlanList.add(planTemplate);
        }
        return pTplPlanList;
    }

    public List<DynamicObject> createPlanBody(Long rootId, DynamicObjectCollection bizAreaCo, DynamicObjectCollection bizSubAreaCo) {
        ArrayList<DynamicObject> pTplPlanList = new ArrayList<DynamicObject>();
        long[] ids = ID.genLongIds((int)(bizAreaCo.size() + bizSubAreaCo.size()));
        int i = 0;
        HashMap<Long, DynamicObject> parentMap = new HashMap<Long, DynamicObject>();
        Map<Long, DynamicObjectCollection> bizSubAreaMap = bizSubAreaCo.stream().collect(Collectors.groupingBy(subArea -> subArea.getLong("fbasedataid.group.id"), Collectors.toCollection(DynamicObjectCollection::new)));
        bizAreaCo.removeIf(bizArea -> !bizSubAreaMap.containsKey(bizArea.getLong("fbasedataid_id")));
        for (DynamicObject bizArea2 : bizAreaCo) {
            Long bizAreaId = bizArea2.getLong("fbasedataid_id");
            if (!bizSubAreaMap.containsKey(bizAreaId)) continue;
            long secondId = ids[i++];
            String planStructNum = String.join((CharSequence)"!", ID.toStringId((long)rootId), ID.toStringId((long)secondId));
            DynamicObjectCollection bizAreaItemCo = new DynamicObjectCollection();
            bizAreaItemCo.add((Object)bizArea2);
            ILocaleString name = bizArea2.getLocaleString("fbasedataid.name");
            DynamicObject planObj = this.createPlanInfo(secondId, name, rootId, bizAreaItemCo, bizSubAreaMap.get(bizAreaId), planStructNum);
            planObj.set("configmode", (Object)"A");
            planObj.set("layer", (Object)2);
            pTplPlanList.add(planObj);
            parentMap.put(bizAreaId, planObj);
        }
        bizSubAreaMap.forEach((k, v) -> {
            DynamicObject parentPlan = (DynamicObject)parentMap.get(k);
            if (parentPlan != null) {
                pTplPlanList.addAll(this.createPlanBizSubArea(parentPlan, (DynamicObjectCollection)v));
            }
        });
        return pTplPlanList;
    }

    public List<DynamicObject> createPlanBizSubArea(DynamicObject bizAreaDyn, DynamicObjectCollection bizSubAreaCo) {
        ArrayList<DynamicObject> pTplPlanList = new ArrayList<DynamicObject>();
        long[] ids = ID.genLongIds((int)bizSubAreaCo.size());
        int i = 0;
        for (DynamicObject bizSubArea : bizSubAreaCo) {
            DynamicObjectCollection bizSubAreaItemCo = new DynamicObjectCollection();
            bizSubAreaItemCo.add((Object)bizSubArea);
            ILocaleString subName = bizSubArea.getLocaleString("fbasedataid.name");
            Long parentId = bizAreaDyn.getLong("id");
            DynamicObjectCollection bizAreaCoS = bizAreaDyn.getDynamicObjectCollection("ptplplbizarea");
            long thirdId = ids[i++];
            String planStructNum = String.join((CharSequence)"!", bizAreaDyn.getString("structnumber"), ID.toStringId((long)thirdId));
            DynamicObject planSubObj = this.createPlanInfo(thirdId, subName, parentId, bizAreaCoS, bizSubAreaItemCo, planStructNum);
            planSubObj.set("configmode", (Object)"B");
            planSubObj.set("layer", (Object)3);
            pTplPlanList.add(planSubObj);
        }
        return pTplPlanList;
    }

    private DynamicObject createPlanInfo(Long id, ILocaleString name, Long parent, DynamicObjectCollection bizArea, DynamicObjectCollection bizSubArea, String structNumber) {
        DynamicObject planSubObj = this.pTplPlanEntityService.generateEmptyDynamicObject();
        planSubObj.set("id", (Object)id);
        planSubObj.set("planname", (Object)name);
        DynamicObject parentObj = this.pTplPlanEntityService.generateEmptyDynamicObject();
        parentObj.set("id", (Object)parent);
        planSubObj.set("parent", (Object)parentObj);
        planSubObj.set("ptplplbizarea", (Object)this.handleMulBaseData(bizArea, "ptplplbizarea"));
        planSubObj.set("ptplplbizsubarea", (Object)this.handleMulBaseData(bizSubArea, "ptplplbizsubarea"));
        planSubObj.set("structnumber", (Object)structNumber);
        planSubObj.set("enable", (Object)"1");
        return planSubObj;
    }

    @Override
    public String updatePlanTemp(String pTplPlanCache, String currentId, String field, Object newValue) {
        Map<String, DynamicObject> pTplPlanMap = this.pTplPlanListToMap(pTplPlanCache);
        DynamicObject pTplPlan = pTplPlanMap.get(currentId);
        if (pTplPlan == null) {
            return pTplPlanCache;
        }
        if ("configmode".equals(field)) {
            this.updateConfigMode(pTplPlanMap, currentId, newValue);
            pTplPlan.set(field, newValue);
        } else if ("planname".equals(field)) {
            if (CollectionUtils.isEmpty((Collection)((DynamicObjectCollection)newValue))) {
                return pTplPlanCache;
            }
            pTplPlan.set(field, (Object)this.getLocalValueByField((LocaleDynamicObjectCollection)newValue, field));
        } else if ("plandescription".equals(field)) {
            if (CollectionUtils.isEmpty((Collection)((DynamicObjectCollection)newValue))) {
                return pTplPlanCache;
            }
            pTplPlan.set(field, (Object)this.getLocalValueByField((LocaleDynamicObjectCollection)newValue, field));
        } else if ("deleteentry".equals(field)) {
            pTplPlan.set("hric_ptplitementry", (Object)this.simpleImplItem((DynamicObjectCollection)newValue));
        } else if ("fbasedataid".equals(field)) {
            pTplPlan.set("hric_ptplitementry", (Object)this.simpleImplItem((DynamicObjectCollection)newValue));
        } else if ("industrytype".equals(field)) {
            this.updateIndustryType(pTplPlanMap, currentId, (DynamicObject)newValue);
        }
        return SerializationUtils.serializeToBase64(new ArrayList<DynamicObject>(pTplPlanMap.values()));
    }

    private void updateIndustryType(Map<String, DynamicObject> pTplPlanMap, String currentId, DynamicObject newValue) {
        for (Map.Entry<String, DynamicObject> tplMap : pTplPlanMap.entrySet()) {
            DynamicObject pTplDyn = tplMap.getValue();
            pTplDyn.set("industrytype", (Object)newValue);
        }
        DynamicObject pTplPlan = pTplPlanMap.get(currentId);
        DynamicObjectCollection bizSubAreaCollection = pTplPlan.getDynamicObjectCollection("ptplplbizsubarea");
        Set<Long> bizSubAreaSet = bizSubAreaCollection.stream().map(s -> s.getLong("fbasedataid_id")).collect(Collectors.toSet());
        Map<Long, DynamicObjectCollection> implItemMap = this.implItemDomainService.getImplItemByBizSubArea(bizSubAreaSet);
        for (Map.Entry<String, DynamicObject> tplMap : pTplPlanMap.entrySet()) {
            Long itemAreaId;
            DynamicObject dy = tplMap.getValue();
            if ("A".equals(dy.getString("configmode")) || implItemMap.get(itemAreaId = Long.valueOf(((DynamicObject)dy.getDynamicObjectCollection("ptplplbizsubarea").get(0)).getLong("fbasedataid_id"))) == null) continue;
            DynamicObjectCollection bizSubAreaCol = dy.getDynamicObjectCollection("ptplplbizsubarea");
            if (bizSubAreaCol.size() == 0) {
                return;
            }
            DynamicObjectCollection implCollect = "B".equals(dy.getString("configmode")) ? implItemMap.get(itemAreaId).stream().filter(it -> CollectionUtils.isEmpty((Collection)it.getDynamicObjectCollection("industrytype")) || it.getDynamicObjectCollection("industrytype").stream().anyMatch(dyn -> dyn.getDynamicObject(1).getLong("id") == newValue.getLong("id"))).filter(it -> CollectionUtils.isEmpty((Collection)it.getDynamicObjectCollection("belongimplitem"))).collect(Collectors.toCollection(DynamicObjectCollection::new)) : implItemMap.get(itemAreaId).stream().filter(it -> CollectionUtils.isEmpty((Collection)it.getDynamicObjectCollection("industrytype")) || it.getDynamicObjectCollection("industrytype").stream().anyMatch(dyn -> dyn.getDynamicObject(1).getLong("id") == newValue.getLong("id"))).filter(it -> CollectionUtils.isEmpty((Collection)it.getDynamicObjectCollection("belongimplitem"))).filter(it -> it.getBoolean("ismandatory")).collect(Collectors.toCollection(DynamicObjectCollection::new));
            dy.set("hric_ptplitementry", (Object)this.transImplItem(implCollect));
        }
    }

    private void updateConfigMode(Map<String, DynamicObject> pTplPlanMap, String currentId, Object newValue) {
        DynamicObject pTplPlan = pTplPlanMap.get(currentId);
        DynamicObjectCollection bizAreaCollection = pTplPlan.getDynamicObjectCollection("ptplplbizarea");
        DynamicObjectCollection bizSubAreaCollection = pTplPlan.getDynamicObjectCollection("ptplplbizsubarea");
        Set<Long> bizSubAreaSet = bizSubAreaCollection.stream().map(s -> s.getLong("fbasedataid_id")).collect(Collectors.toSet());
        DynamicObject[] implItemDirect = this.iImplItemEntityService.queryByBizSubArea("belongimplitem,industrytype,ismandatory", bizSubAreaSet);
        List implItemDirectList = Arrays.stream(implItemDirect).collect(Collectors.toList());
        if (pTplPlan.getDynamicObject("industrytype") != null) {
            implItemDirectList = implItemDirectList.stream().filter(it -> CollectionUtils.isEmpty((Collection)it.getDynamicObjectCollection("industrytype")) || it.getDynamicObjectCollection("industrytype").stream().anyMatch(dyn -> dyn.getDynamicObject(1).getLong("id") == pTplPlan.getDynamicObject("industrytype").getLong("id"))).collect(Collectors.toList());
        }
        if ("A".equals(newValue.toString())) {
            List<DynamicObject> addPlanInfo = pTplPlan.getLong("parent.id") == 0L ? this.createPlanBody(Long.valueOf(currentId), bizAreaCollection, bizSubAreaCollection) : this.createPlanBizSubArea(pTplPlan, bizSubAreaCollection);
            pTplPlan.set("hric_ptplitementry", null);
            this.getImplItem(addPlanInfo, bizSubAreaCollection.stream().map(s -> s.getLong("fbasedataid_id")).collect(Collectors.toSet()));
            addPlanInfo.forEach(s -> pTplPlanMap.put(String.valueOf(s.getLong("id")), (DynamicObject)s));
        } else {
            if ("C".equals(newValue.toString())) {
                implItemDirectList = implItemDirectList.stream().filter(it -> it.getBoolean("ismandatory")).collect(Collectors.toList());
            }
            List<Long> implItemIdSet = implItemDirectList.stream().filter(it -> CollectionUtils.isEmpty((Collection)it.getDynamicObjectCollection("belongimplitem"))).map(s -> s.getLong("id")).collect(Collectors.toList());
            pTplPlan.set("hric_ptplitementry", (Object)this.simpleImplItem(implItemIdSet));
            Set<Long> children = this.findChildren(pTplPlanMap.values(), pTplPlan.getLong("id"));
            pTplPlanMap.values().removeIf(s -> children.contains(s.getLong("id")));
        }
    }

    private Set<Long> findChildren(Collection<DynamicObject> pTplPlanList, Long currentId) {
        ArrayList<DynamicObject> children = new ArrayList<DynamicObject>();
        for (DynamicObject dyn : pTplPlanList) {
            DynamicObject dynamicObject = this.parentEqual(pTplPlanList, dyn, currentId);
            if (dynamicObject == null) continue;
            children.add(dyn);
        }
        return children.stream().map(s -> s.getLong("id")).collect(Collectors.toSet());
    }

    private DynamicObject parentEqual(Collection<DynamicObject> pTplPlanList, DynamicObject currentDyn, Long currentId) {
        if (currentDyn.getLong("parent.id") == 0L) {
            return null;
        }
        if (currentDyn.getLong("parent.id") == currentId.longValue()) {
            return currentDyn;
        }
        AtomicReference pTplPlanDyn = new AtomicReference();
        pTplPlanList.forEach(pTplPlan -> {
            if (pTplPlan.getLong("id") == currentDyn.getLong("parent.id")) {
                pTplPlanDyn.set(pTplPlan);
            }
        });
        return this.parentEqual(pTplPlanList, (DynamicObject)pTplPlanDyn.get(), currentId);
    }

    private LocaleString getLocalValueByField(LocaleDynamicObjectCollection collection, String field) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (DynamicObject tempObj : collection) {
            map.put(tempObj.getString("localeid"), tempObj.getString(field));
        }
        return LocaleString.fromMap(map);
    }

    private DynamicObjectCollection handleMulBaseData(DynamicObjectCollection mulBaseData, String field) {
        DynamicObjectType type = this.pTplPlanEntityService.generateEmptyDynamicObject().getDynamicObjectCollection(field).getDynamicObjectType();
        MulBasedataDynamicObjectCollection dys = new MulBasedataDynamicObjectCollection();
        mulBaseData.forEach(bizArea -> {
            DynamicObject dynamicObject = new DynamicObject(type);
            dynamicObject.set("fbasedataid_id", (Object)bizArea.getLong("fbasedataid_id"));
            dynamicObject.set("fbasedataid", (Object)bizArea.getDynamicObject("fbasedataid"));
            dys.add(dynamicObject);
        });
        return dys;
    }

    private void getImplItem(List<DynamicObject> pTplPlanList, Set<Long> eBizSubAreaSet) {
        Map<Long, DynamicObjectCollection> implItemMap = this.implItemDomainService.getImplItemByBizSubArea(eBizSubAreaSet);
        for (DynamicObject dy : pTplPlanList) {
            Long itemAreaId;
            if ("A".equals(dy.getString("configmode")) || implItemMap.get(itemAreaId = Long.valueOf(((DynamicObject)dy.getDynamicObjectCollection("ptplplbizsubarea").get(0)).getLong("fbasedataid_id"))) == null) continue;
            DynamicObjectCollection bizSubAreaCollection = dy.getDynamicObjectCollection("ptplplbizsubarea");
            if (bizSubAreaCollection.size() == 0) {
                return;
            }
            dy.set("hric_ptplitementry", (Object)this.transImplItem(implItemMap.get(itemAreaId)));
        }
    }

    @Override
    public String toBase64String(List<DynamicObject> planInfoList) {
        for (DynamicObject planInfo : planInfoList) {
            DynamicObjectCollection implItemCollection = planInfo.getDynamicObjectCollection("hric_ptplitementry");
            planInfo.set("hric_ptplitementry", (Object)this.simpleImplItem(implItemCollection));
        }
        return SerializationUtils.serializeToBase64(planInfoList);
    }

    @Override
    public List<DynamicObject> fromBase64String(long rootId) {
        List pTplPlanList;
        String cacheKey = "hric_ptplplan" + rootId;
        try {
            String base64String = (String)HricCacheUtils.get((String)cacheKey, String.class);
            pTplPlanList = (List)SerializationUtils.deSerializeFromBase64((String)base64String);
        }
        catch (Exception ex) {
            logger.error("Cache Data Failed\uff1a", (Throwable)ex);
            return null;
        }
        return pTplPlanList;
    }

    public Map<String, DynamicObject> pTplPlanListToMap(String pTplPlanCache) {
        List pTplPlanList = (List)SerializationUtils.deSerializeFromBase64((String)pTplPlanCache);
        return this.pTplPlanListToMap(pTplPlanList);
    }

    @Override
    public Map<String, DynamicObject> pTplPlanListToMap(List<DynamicObject> pTplPlanList) {
        HashMap<String, DynamicObject> PlanTempMap = new HashMap<String, DynamicObject>(pTplPlanList.size());
        for (DynamicObject planTemp : pTplPlanList) {
            PlanTempMap.put(String.valueOf(planTemp.getLong("id")), planTemp);
        }
        return PlanTempMap;
    }

    private DynamicObjectCollection simpleImplItem(DynamicObjectCollection implItemCo) {
        List itemIdSet = null;
        if (implItemCo.size() != 0) {
            itemIdSet = implItemCo.stream().map(ptEntry -> ptEntry.getDynamicObject("fbasedataid")).sorted(Comparator.comparing(item -> item.getLong("listseq"))).map(s -> s.getLong("id")).collect(Collectors.toList());
        }
        if (itemIdSet == null) {
            return new DynamicObjectCollection();
        }
        return this.simpleImplItem(itemIdSet);
    }

    private DynamicObjectCollection simpleImplItem(List<Long> implItemIdSet) {
        DynamicObjectCollection implItemCollection = new DynamicObjectCollection();
        implItemIdSet.forEach(implItemId -> {
            DynamicObject entryEntityRow = this.pTplPlanEntityService.generateEmptyEntryDynamicObject("hric_ptplitementry");
            entryEntityRow.set("fbasedataid_id", implItemId);
            implItemCollection.add((Object)entryEntityRow);
        });
        return implItemCollection;
    }

    private DynamicObjectCollection transImplItem(DynamicObjectCollection implItemIdCo) {
        DynamicObjectCollection implItemCollection = new DynamicObjectCollection();
        List<DynamicObject> implItemIdCollect = implItemIdCo.stream().filter(it -> CollectionUtils.isEmpty((Collection)it.getDynamicObjectCollection("belongimplitem"))).collect(Collectors.toList());
        implItemIdCollect.forEach(implItemDyn -> {
            DynamicObject entryEntityRow = this.pTplPlanEntityService.generateEmptyEntryDynamicObject("hric_ptplitementry");
            entryEntityRow.set("fbasedataid_id", (Object)implItemDyn.getLong("id"));
            entryEntityRow.set("fbasedataid", implItemDyn);
            implItemCollection.add((Object)entryEntityRow);
        });
        return implItemCollection;
    }

    @Override
    public void deletePlanTemp(Set<Long> rootIdSet) {
        List<Long> list = this.pTplPlanEntityService.queryPlanTempIdByRootId(rootIdSet);
        this.pTplPlanEntityService.delete(list.toArray());
    }

    @Override
    public List<DynamicObject> copyPTplPlanList(List<DynamicObject> pTplPlanList) {
        Map<Object, Object> transFieldMap = PlanTemplateServiceHelper.transIdAndStructNumber(pTplPlanList.toArray(new DynamicObject[0]));
        ArrayList<DynamicObject> planCopyList = new ArrayList<DynamicObject>(pTplPlanList.size());
        for (DynamicObject plan : pTplPlanList) {
            DynamicObject planCopy = this.pTplPlanEntityService.generateEmptyDynamicObject();
            planCopy.set("id", transFieldMap.get(plan.getLong("id")));
            DynamicObject parentObj = this.pTplPlanEntityService.generateEmptyDynamicObject();
            parentObj.set("id", transFieldMap.get(plan.getLong("parent.id")));
            planCopy.set("parent", (Object)parentObj);
            planCopy.set("structnumber", transFieldMap.get(plan.getString("structnumber")));
            planCopy.set("layer", (Object)plan.getInt("layer"));
            planCopy.set("planname", (Object)plan.getLocaleString("planname"));
            planCopy.set("ptplplbizarea", (Object)this.handleMulBaseData(plan.getDynamicObjectCollection("ptplplbizarea"), "ptplplbizarea"));
            planCopy.set("ptplplbizsubarea", (Object)this.handleMulBaseData(plan.getDynamicObjectCollection("ptplplbizsubarea"), "ptplplbizsubarea"));
            planCopy.set("configmode", (Object)plan.getString("configmode"));
            planCopy.set("plandescription", (Object)plan.getString("plandescription"));
            planCopy.set("industrytype", (Object)plan.getDynamicObject("industrytype"));
            planCopy.set("hric_ptplitementry", (Object)plan.getDynamicObjectCollection("hric_ptplitementry"));
            planCopyList.add(planCopy);
        }
        return planCopyList;
    }
}

