/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IPersonHeadPicEntityService;
import kd.hrmp.hric.bussiness.domain.init.IPersonHeadPicDomainService;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.constants.msg.AnnexEnum;
import kd.hrmp.hric.common.util.AttachmentUtils;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.common.util.HricCacheUtils;

public class PersonHeadPicDomainServiceImpl
implements IPersonHeadPicDomainService {
    private static Log LOG = LogFactory.getLog(PersonHeadPicDomainServiceImpl.class);
    IPersonHeadPicEntityService iPersonHeadPicEntityService = ServiceFactory.getService(IPersonHeadPicEntityService.class);
    private String QUERY_FIELD = "number,name,initstatus,filepath,errormsg,batchnumber,modifytime,modifier,errormsg_tag";
    private String QUERY_ALL = "name,number,initstatus,errormsg,errormsg_tag,filepath,creator,modifier,createtime,modifytime,batchnumber";

    @Override
    public DynamicObject[] getPersonHeadPicByIds(Object[] ids) {
        return this.iPersonHeadPicEntityService.query(this.QUERY_FIELD, new QFilter("id", "in", (Object)ids).toArray());
    }

    @Override
    public DynamicObject[] getPersonHeadPicByIdSet(Set<Long> idSet) {
        return this.iPersonHeadPicEntityService.query(this.QUERY_ALL, idSet.toArray());
    }

    @Override
    public DynamicObject[] getFailAndWaitPersonHeadPicInfo() {
        return this.iPersonHeadPicEntityService.getFailAndWaitPersonHeadPicInfo();
    }

    @Override
    public int getFailAndWaitPersonHeadPicInfoTotal() {
        return this.iPersonHeadPicEntityService.getFailAndWaitPersonHeadPicInfoTotal();
    }

    @Override
    public void saveOne(DynamicObject dyc) {
        try (TXHandle tx = TX.required();){
            this.iPersonHeadPicEntityService.save(dyc);
        }
    }

    @Override
    public int queryCountByBatchNumber(Long batchNumber) {
        return this.iPersonHeadPicEntityService.queryCountByBatchNumber(batchNumber);
    }

    @Override
    public void saveOrUpdate(List<Map<String, Object>> resultList, Long batchNumber, Map<String, String> zipParamMap, String uniqueType) {
        List numberList = resultList.stream().map(it -> ConvertUtils.toString(it.get("number"))).collect(Collectors.toList());
        LOG.info("PersonHead resultList size {}: ", (Object)resultList.size());
        if ((long)numberList.size() != numberList.stream().distinct().count()) {
            List repeatList = numberList.stream().collect(Collectors.toMap(e -> e, e -> 1, Integer::sum)).entrySet().stream().filter(e -> (Integer)e.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
            LOG.error("PersonHead repeating data {}: ", repeatList);
            if (HRStringUtils.isEmpty((String)((String)HricCacheUtils.get((String)"repeat_person_cache", String.class)))) {
                HricCacheUtils.put((String)"repeat_person_cache", (Object)"1");
            }
        }
        DynamicObject[] exists = this.iPersonHeadPicEntityService.query(this.QUERY_ALL, new QFilter("number", "in", numberList).toArray());
        ArrayList newList = new ArrayList(AppConstants.LIST_SIZE);
        Arrays.stream(exists).filter(AttachmentUtils.distinctByKey(p -> p.getString("number"))).forEach(newList::add);
        Map<String, DynamicObject> existsMap = newList.stream().collect(Collectors.toMap(it -> it.getString("number"), it -> it));
        if (exists.length != newList.size()) {
            if (HRStringUtils.isEmpty((String)((String)HricCacheUtils.get((String)"repeat_person_cache", String.class)))) {
                HricCacheUtils.put((String)"repeat_person_cache", (Object)"1");
            }
            LOG.error("PersonHead repeating data \u6709\u91cd\u590d\u6570\u636e \u8bf7\u68c0\u67e5 {}: ", Arrays.stream(exists).map(it -> it.getString("number")).collect(Collectors.toList()));
        }
        ArrayList distinctList = new ArrayList(AppConstants.LIST_SIZE);
        resultList.stream().filter(AttachmentUtils.distinctByKey(p -> p.get("number"))).forEach(distinctList::add);
        ArrayList<DynamicObject> personList = new ArrayList<DynamicObject>(AppConstants.LIST_SIZE);
        ArrayList<DynamicObject> existList = new ArrayList<DynamicObject>(AppConstants.LIST_SIZE);
        Map fileMap = new HashMap(AppConstants.MAP_SIZE);
        Map<String, Object> nameAndNumberMap = distinctList.stream().collect(Collectors.toMap(it -> ConvertUtils.toString(it.get("number")), it -> it.get("name")));
        if (!CollectionUtils.isEmpty(zipParamMap)) {
            fileMap = AttachmentUtils.parseUrl(zipParamMap.keySet().stream().collect(Collectors.toList()), (String)"hric_perheadpicinit", nameAndNumberMap, (String)uniqueType);
        }
        for (Map map : distinctList) {
            if (existsMap.containsKey(map.get("number"))) {
                DynamicObject dynamicObject = existsMap.get(map.get("number"));
                if (!HRStringUtils.equals((String)dynamicObject.getString("initstatus"), (String)"A")) {
                    dynamicObject.set("initstatus", (Object)"C");
                }
                if (fileMap.containsKey(map.get("number")) && !HRStringUtils.equals((String)ConvertUtils.toString(fileMap.get(map.get("number"))), (String)"false")) {
                    dynamicObject.set("filepath", fileMap.get(map.get("number")));
                }
                if (fileMap.containsKey(map.get("number")) && HRStringUtils.equals((String)ConvertUtils.toString(fileMap.get(map.get("number"))), (String)"false")) {
                    dynamicObject.set("errormsg", (Object)String.format(Locale.ROOT, AnnexEnum.ANNEX_NAME_CHECK.getMsg(), map.get("number")));
                    dynamicObject.set("initstatus", (Object)"B");
                }
                dynamicObject.set("batchnumber", (Object)batchNumber);
                existList.add(dynamicObject);
                continue;
            }
            DynamicObject person = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hric_perheadpicinit"));
            person.set("number", map.get("number"));
            person.set("name", map.get("name"));
            person.set("initstatus", (Object)"C");
            person.set("batchnumber", (Object)batchNumber);
            person.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            if (fileMap.containsKey(map.get("number"))) {
                person.set("filepath", fileMap.get(map.get("number")));
            }
            personList.add(person);
        }
        if (!CollectionUtils.isEmpty(personList)) {
            this.iPersonHeadPicEntityService.save(personList.toArray(new DynamicObject[0]));
        }
        if (!CollectionUtils.isEmpty(existList)) {
            this.iPersonHeadPicEntityService.save(existList.toArray(new DynamicObject[0]));
        }
    }

    @Override
    public DynamicObject[] getDataByBatchNumber(Long batchNumber) {
        return this.iPersonHeadPicEntityService.query(this.QUERY_FIELD, new QFilter("batchnumber", "=", (Object)batchNumber).toArray());
    }

    @Override
    public DynamicObject[] getPersonHeadByNumberList(List<String> numberList) {
        return this.iPersonHeadPicEntityService.query(this.QUERY_ALL, new QFilter("number", "in", numberList).toArray());
    }

    @Override
    public DynamicObject[] getPersonHeadExistByNumbers(List<String> numberList) {
        DynamicObject[] query = this.iPersonHeadPicEntityService.query(this.QUERY_FIELD, new QFilter("number", "in", numberList).and(new QFilter("initstatus", "=", (Object)"A")).toArray());
        return query;
    }
}

