/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IImplItemEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IInitPlanEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IPTplPlanEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IPlanTempBaseEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IPlanTemplateEntityService;
import kd.hrmp.hric.bussiness.domain.init.IPTplPlanDomainService;
import kd.hrmp.hric.bussiness.domain.init.IPlanTemplateDomainService;
import kd.hrmp.hric.common.constants.PlanTemplateConstants;

public class PlanTemplateDomainServiceImpl
implements IPlanTemplateDomainService,
PlanTemplateConstants {
    private IImplItemEntityService implService = ServiceFactory.getService(IImplItemEntityService.class);
    private final IPlanTemplateEntityService planTemplateEntity = ServiceFactory.getService(IPlanTemplateEntityService.class);
    private final IPTplPlanEntityService pTplPlanEntityService = ServiceFactory.getService(IPTplPlanEntityService.class);
    private final IPlanTempBaseEntityService planTempBaseEntityService = ServiceFactory.getService(IPlanTempBaseEntityService.class);
    private final IInitPlanEntityService initPlanEntityService = ServiceFactory.getService(IInitPlanEntityService.class);
    IPTplPlanDomainService pTplPlanDomainService = ServiceFactory.getService(IPTplPlanDomainService.class);

    @Override
    public Map<String, Object> getBizAreaAndSubBizArea(List<Long> bizArea, List<Long> bizSubArea) {
        DynamicObject[] implItems = this.implService.queryAllEnableImplItem("group.id,bizsubarea.id,mulfrontimpl.id");
        Map<Long, Long> bizSubAreaMap = bizSubArea.stream().collect(Collectors.toMap(it -> it, it -> it));
        List<DynamicObject> implItemList = Arrays.stream(implItems).filter(it -> it.getDynamicObject("bizsubarea") != null).filter(it -> bizSubAreaMap.containsKey(it.getDynamicObject("bizsubarea").getLong("id"))).collect(Collectors.toList());
        this.buildResultArea(bizArea, bizSubArea, Arrays.asList(implItems), implItemList);
        HashMap result = Maps.newHashMap();
        result.put("ptplbizarea", bizArea.stream().collect(Collectors.toSet()).stream().sorted().toArray());
        result.put("ptplbizsubarea", bizSubArea.stream().collect(Collectors.toSet()).stream().sorted().toArray());
        return result;
    }

    @Override
    public void setTreeForPlanTemplate(TreeView treeView, List<DynamicObject> pTplPlanList) {
        this.setTreeConfig(treeView);
        if (null != pTplPlanList) {
            treeView.addNode(this.setTreeNode(pTplPlanList));
        }
    }

    private TreeNode setTreeNode(List<DynamicObject> pTplPlanList) {
        if (CollectionUtils.isEmpty(pTplPlanList)) {
            return null;
        }
        DynamicObject masterPlan = pTplPlanList.stream().filter(it -> it.getLong("parent.id") == 0L).findFirst().get();
        TreeNode root = new TreeNode("", String.valueOf(masterPlan.getLong("id")), masterPlan.getString("planname"));
        root.setIsOpened(true);
        HashMap nodeMap = Maps.newHashMap();
        nodeMap.put(root.getId(), root);
        HashMap parentMap = Maps.newHashMap();
        parentMap.put(masterPlan.getLong("id"), masterPlan.getLong("id"));
        this.loadChildNode(nodeMap, parentMap, pTplPlanList);
        return root;
    }

    private void loadChildNode(Map<String, TreeNode> nodeMap, Map<Long, Long> parentMap, List<DynamicObject> pTplPlanList) {
        List<DynamicObject> pTplList = pTplPlanList.stream().filter(it -> parentMap.containsKey(it.getLong("parent.id"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(pTplList)) {
            return;
        }
        Map<Long, Long> pTplParentMap = pTplList.stream().collect(Collectors.toMap(it -> it.getLong("id"), it -> it.getLong("id")));
        pTplList.forEach(it -> {
            TreeNode treeNode = new TreeNode(String.valueOf(it.getLong("parent.id")), String.valueOf(it.getLong("id")), it.getString("planname"));
            nodeMap.put(treeNode.getId(), treeNode);
            String parentId = String.valueOf(it.getLong("parent.id"));
            if (nodeMap.get(parentId) != null) {
                ((TreeNode)nodeMap.get(parentId)).addChild(treeNode);
            }
            treeNode.setIsOpened(true);
        });
        this.loadChildNode(nodeMap, pTplParentMap, pTplPlanList);
    }

    private void setTreeConfig(TreeView treeView) {
        treeView.deleteAllNodes();
        treeView.setMulti(false);
        treeView.setRootVisible(true);
        treeView.setDraggable(false);
        treeView.setDroppable(false);
    }

    private void buildResultArea(List<Long> bizArea, List<Long> bizSubArea, List<DynamicObject> allImplItemList, List<DynamicObject> implItemList) {
        HashMap implMap = Maps.newHashMap();
        List<DynamicObjectCollection> preList = implItemList.stream().filter(it -> !CollectionUtils.isEmpty((Collection)it.getDynamicObjectCollection("mulfrontimpl"))).map(it -> it.getDynamicObjectCollection("mulfrontimpl")).collect(Collectors.toList());
        preList.forEach(it -> it.forEach(dyn -> {
            DynamicObject preImpl = (DynamicObject)dyn.get(1);
            if (!implMap.containsKey(preImpl.getLong("id"))) {
                implMap.put(preImpl.getLong("id"), preImpl.getLong("id"));
            }
        }));
        List<DynamicObject> preImplItemList = allImplItemList.stream().filter(it -> implMap.containsKey(it.getLong("id"))).collect(Collectors.toList());
        bizArea.addAll(preImplItemList.stream().map(it -> it.getDynamicObject("group").getLong("id")).collect(Collectors.toList()));
        bizSubArea.addAll(preImplItemList.stream().map(it -> it.getDynamicObject("bizsubarea").getLong("id")).collect(Collectors.toList()));
        if (!preImplItemList.stream().anyMatch(it -> !CollectionUtils.isEmpty((Collection)it.getDynamicObjectCollection("mulfrontimpl")))) {
            return;
        }
        this.buildResultArea(bizArea, bizSubArea, allImplItemList, preImplItemList);
    }

    @Override
    public void planTransToTemplate(DynamicObject toTemplateDyn) {
        String structNumber = toTemplateDyn.getString("structnumber");
        List<DynamicObject> pTplPlanList = this.pTplPlanDomainService.planTransToTemplate(structNumber);
        QFilter qFilter = new QFilter("structnumber", "=", (Object)structNumber);
        DynamicObject masterPlanDyn = this.initPlanEntityService.queryOne("group, bizsubarea", new QFilter[]{qFilter});
        DynamicObject planBaseDyn = this.planTempBaseEntityService.generateEmptyDynamicObject();
        pTplPlanList.forEach(pTplPlan -> {
            if (pTplPlan.getLong("parent.id") == 0L) {
                planBaseDyn.set("id", (Object)pTplPlan.getLong("id"));
            }
        });
        planBaseDyn.set("name", (Object)toTemplateDyn.getLocaleString("name"));
        planBaseDyn.set("enable", (Object)"1");
        if (HRBaseDataConfigUtil.getAudit((String)"hric_ptplbase")) {
            planBaseDyn.set("status", (Object)"A");
        } else {
            planBaseDyn.set("status", (Object)"C");
        }
        planBaseDyn.set("number", (Object)toTemplateDyn.getString("number"));
        planBaseDyn.set("description", (Object)toTemplateDyn.getLocaleString("description"));
        planBaseDyn.set("ptplebizarea", (Object)this.handleMulBaseData(masterPlanDyn.getDynamicObjectCollection("group"), "ptplebizarea"));
        planBaseDyn.set("ptplebizsubarea", (Object)this.handleMulBaseData(masterPlanDyn.getDynamicObjectCollection("bizsubarea"), "ptplebizsubarea"));
        this.planTempBaseEntityService.save(planBaseDyn);
        this.savePlanTemp(pTplPlanList);
    }

    @Override
    public boolean savePTplByBaseId(Long planTemplateId) {
        DynamicObject planDyn = this.planTempBaseEntityService.queryOne("issyspreset", planTemplateId);
        if (planDyn != null && !planDyn.getBoolean("issyspreset")) {
            return true;
        }
        boolean pTplPlanExists = this.pTplPlanEntityService.isExists(new QFilter("id", "=", (Object)planTemplateId));
        if (pTplPlanExists) {
            return true;
        }
        DynamicObject planTemplateDyn = this.planTempBaseEntityService.query("ptplbizarea, ptplbizsubarea, ptplebizsubarea", planTemplateId);
        DynamicObjectCollection bizAreaList = planTemplateDyn.getDynamicObjectCollection("ptplbizarea");
        DynamicObjectCollection bizSubAreaList = planTemplateDyn.getDynamicObjectCollection("ptplbizsubarea");
        DynamicObjectCollection eBizSubArea = planTemplateDyn.getDynamicObjectCollection("ptplebizsubarea");
        List<DynamicObject> pTplPlanList = this.pTplPlanDomainService.createPlanInfo(planTemplateId, bizAreaList, bizSubAreaList, eBizSubArea);
        this.savePlanTemp(pTplPlanList);
        return true;
    }

    private DynamicObjectCollection handleMulBaseData(DynamicObjectCollection mulBaseData, String field) {
        DynamicObjectType type = this.planTempBaseEntityService.generateEmptyDynamicObject().getDynamicObjectCollection(field).getDynamicObjectType();
        MulBasedataDynamicObjectCollection dys = new MulBasedataDynamicObjectCollection();
        mulBaseData.forEach(bizArea -> {
            DynamicObject dynamicObject = new DynamicObject(type);
            dynamicObject.set("fbasedataid_id", (Object)bizArea.getLong("fbasedataid_id"));
            dynamicObject.set("fbasedataid", (Object)bizArea.getDynamicObject("fbasedataid"));
            dys.add(dynamicObject);
        });
        return dys;
    }

    @Override
    public void savePlanTemp(List<DynamicObject> planTempList) {
        Long rootId = planTempList.stream().filter(s -> s.getLong("parent.id") == 0L).map(m -> m.getLong("id")).findFirst().orElse(0L);
        Set pageIdSet = planTempList.stream().map(s -> s.getLong("id")).collect(Collectors.toSet());
        List<Long> planDBIds = this.pTplPlanEntityService.queryPlanTempIdByRootId(Sets.newHashSet((Object[])new Long[]{rootId}));
        List fromDatabaseList = planTempList.stream().filter(s -> s.getDataEntityState().getFromDatabase()).map(s -> s.getLong("id")).collect(Collectors.toList());
        boolean exists = this.pTplPlanEntityService.isExists(new QFilter("id", "=", (Object)rootId));
        boolean idNoChange = planDBIds.containsAll(pageIdSet) && pageIdSet.containsAll(planDBIds);
        try {
            if (!exists || idNoChange) {
                this.planTemplateEntity.save(planTempList.toArray(new DynamicObject[0]));
            } else {
                Object[] removeIdArray = (Long[])planDBIds.stream().filter(s -> !fromDatabaseList.contains(s)).toArray(Long[]::new);
                this.planTemplateEntity.delete(removeIdArray);
                DynamicObject[] planTempDBArray = (DynamicObject[])planTempList.stream().filter(s -> s.getDataEntityState().getFromDatabase()).toArray(DynamicObject[]::new);
                this.planTemplateEntity.save(planTempDBArray);
                DynamicObject[] planTempPageArray = (DynamicObject[])planTempList.stream().filter(s -> !s.getDataEntityState().getFromDatabase()).toArray(DynamicObject[]::new);
                this.planTemplateEntity.save(planTempPageArray);
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f02\u5e38", (String)"PlanTemplateDomainServiceImpl_0", (String)"hrmp-hric-opplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void filterPTplPlanList(List<DynamicObject> pTplPlanList, String name) {
        List<DynamicObject> filterList = pTplPlanList.stream().filter(it -> it.getString("planname").contains(name)).collect(Collectors.toList());
        HashMap idMap = Maps.newHashMap();
        ArrayList result = Lists.newArrayList();
        result.add(pTplPlanList.stream().filter(it -> it.getLong("parent.id") == 0L).findFirst().get());
        Map allTplMap = pTplPlanList.stream().collect(Collectors.toMap(it -> it.getLong("id"), Function.identity()));
        filterList.forEach(it -> this.buildResultTplList((DynamicObject)it, idMap, result, allTplMap));
        pTplPlanList.clear();
        pTplPlanList.addAll(result);
    }

    private void buildResultTplList(DynamicObject tpl, Map<Long, Long> idMap, List<DynamicObject> result, Map<Long, DynamicObject> allTplMap) {
        if (idMap.containsKey(tpl.getLong("id")) || tpl.getLong("parent.id") == 0L) {
            return;
        }
        result.add(tpl);
        idMap.put(tpl.getLong("id"), tpl.getLong("id"));
        this.buildResultTplList(allTplMap.get(tpl.getLong("parent.id")), idMap, result, allTplMap);
    }
}

