/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl.clear.bo;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IDataClearEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IDataClearLogEntityService;
import kd.hrmp.hric.bussiness.domain.init.impl.clear.IDataClear;
import kd.hrmp.hric.bussiness.domain.init.impl.clear.bo.DataClearStrategyBo;
import kd.hrmp.hric.bussiness.domain.init.impl.clear.bo.FieldConfigBo;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.constants.InitDataClearConstants;
import kd.hrmp.hric.common.constants.InitDataClearLogConstants;
import kd.hrmp.hric.common.exception.KDHricException;
import kd.hrmp.hric.common.exception.code.HRICErrorEnum;
import kd.hrmp.hric.common.util.DateUtils;
import kd.hrmp.hric.common.util.HricDynamicObjectUtils;
import kd.hrmp.hric.common.util.TXHandleUtils;

abstract class AbstractDataClearBo
implements IDataClear,
InitDataClearConstants,
InitDataClearLogConstants {
    private static Log LOG = LogFactory.getLog(AbstractDataClearBo.class);
    private static final String DLOCK_KEY = "hric.dataClearLock_%s";
    private IDataClearLogEntityService iDataClearLogEntityService = ServiceFactory.getService(IDataClearLogEntityService.class);
    private IDataClearEntityService iDataClearEntityService = ServiceFactory.getService(IDataClearEntityService.class);
    private String number;
    private boolean clear;
    private DynamicObject dy;
    private Date startTime;
    private Date endTime;
    private boolean error;
    private String errorMsg;
    private List<DataClearStrategyBo> dataClearStrategyBoList = Lists.newArrayListWithExpectedSize((int)AppConstants.LIST_SIZE);

    AbstractDataClearBo(DynamicObject dy) {
        this.dy = dy;
        this.startTime = new Date();
        this.clear = dy.getBoolean("isclear");
        this.number = dy.getString("number");
        this.initClearStrategy(dy);
    }

    private void initClearStrategy(DynamicObject dy) {
        dy.getDynamicObjectCollection("entryentity").forEach(row -> this.dataClearStrategyBoList.add(new DataClearStrategyBo((DynamicObject)row)));
    }

    @Override
    public void startClear() {
        block14: {
            if (!this.isClear()) {
                LOG.info("{} strategy is not clear", (Object)this.number);
                return;
            }
            LOG.info("data clear start, {}", (Object)this.getDataClearName());
            try (DLock dLock = DLock.create((String)this.getLockKey());){
                if (dLock.tryLock()) {
                    this.clear();
                    break block14;
                }
                throw new KDHricException(HRICErrorEnum.TASK_PROCESSING_ERROR, new Object[0]);
            }
        }
    }

    private String getLockKey() {
        return String.format(Locale.ROOT, DLOCK_KEY, this.number);
    }

    private void clear() {
        AtomicReference mapAtomicReference = new AtomicReference();
        TXHandleUtils.execTrans(() -> mapAtomicReference.set(this.execClear()));
        TXHandleUtils.execTrans(() -> {
            this.saveLog((Map)mapAtomicReference.get());
            if (!this.error) {
                this.dy.set("latestexectime", (Object)this.startTime);
                this.iDataClearEntityService.save(this.dy);
            }
        });
    }

    private Map<DataClearStrategyBo, Integer> execClear() {
        Map<DataClearStrategyBo, Integer> resultMap = null;
        try {
            resultMap = this.doClear();
        }
        catch (Throwable throwable) {
            LOG.error("data clear error", throwable);
            this.error = true;
            this.errorMsg = throwable.getMessage();
        }
        this.endTime = new Date();
        return resultMap;
    }

    private void saveLog(Map<DataClearStrategyBo, Integer> resultMap) {
        DynamicObject logDy = this.buildLogDy(resultMap);
        this.iDataClearLogEntityService.save(logDy);
    }

    private DynamicObject buildLogDy(Map<DataClearStrategyBo, Integer> resultMap) {
        DynamicObject logDy = this.iDataClearLogEntityService.generateEmptyDynamicObject();
        logDy.set("dtclr", this.dy.getPkValue());
        logDy.set("starttime", (Object)this.startTime);
        logDy.set("endtime", (Object)this.endTime);
        logDy.set("status", (Object)(this.error ? "0" : "1"));
        logDy.set("cost", (Object)DateUtils.getSubSecond((Date)this.startTime, (Date)this.endTime));
        DynamicObjectCollection dynamicObjectCollection = logDy.getDynamicObjectCollection("entryentity");
        if (this.error) {
            HricDynamicObjectUtils.setBigText((DynamicObject)logDy, (String)"msg", (String)this.errorMsg);
        } else {
            int seq = 1;
            for (DataClearStrategyBo dataClearStrategyBo : this.dataClearStrategyBoList) {
                if (!resultMap.containsKey(dataClearStrategyBo)) continue;
                dynamicObjectCollection.add((Object)dataClearStrategyBo.buildLogEntry(resultMap.get(dataClearStrategyBo), seq++));
            }
            if (this.dataClearStrategyBoList.isEmpty() && !resultMap.isEmpty()) {
                for (Map.Entry entry : resultMap.entrySet()) {
                    dynamicObjectCollection.add((Object)((DataClearStrategyBo)entry.getKey()).buildLogEntry((Integer)entry.getValue(), seq++));
                }
            }
        }
        return logDy;
    }

    protected abstract Map<DataClearStrategyBo, Integer> doClear();

    protected abstract FieldConfigBo getFieldConfig();

    private boolean isClear() {
        return this.clear;
    }

    public List<DataClearStrategyBo> getDataClearStrategyBoList() {
        return ImmutableList.copyOf(this.dataClearStrategyBoList);
    }

    protected String getDataClearName() {
        return this.dy.getString("name");
    }
}

