/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl.clear.bo;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IDataClearLogEntityService;
import kd.hrmp.hric.bussiness.domain.init.impl.clear.bo.FieldConfigBo;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.constants.InitDataClearConstants;
import kd.hrmp.hric.common.constants.InitDataClearLogConstants;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.common.util.DateUtils;

class DataClearStrategyBo
implements InitDataClearConstants,
InitDataClearLogConstants {
    private static Log LOG = LogFactory.getLog(DataClearStrategyBo.class);
    private IDataClearLogEntityService iDataClearLogEntityService = ServiceFactory.getService(IDataClearLogEntityService.class);
    private List<Long> bizAreaList;
    private List<Long> bizSubAreaList;
    private List<String> statusList;
    private Integer keepMonth;
    private Integer keepDay;
    private boolean clear = true;
    private DynamicObject strategyDy;

    DataClearStrategyBo() {
    }

    DataClearStrategyBo(DynamicObject strategyDy) {
        this.strategyDy = strategyDy;
        this.bizAreaList = this.getDynamicObjectMulBasedataIdList(strategyDy, "dtclrstbizarea");
        this.bizSubAreaList = this.getDynamicObjectMulBasedataIdList(strategyDy, "dtclrstbizsubarea");
        this.statusList = Splitter.on((String)",").trimResults().splitToList((CharSequence)strategyDy.getString("clearstatus"));
        this.keepMonth = ConvertUtils.toInteger((Object)strategyDy.get("keepstrategy"));
        if (this.keepMonth == 0) {
            this.clear = false;
        }
        this.keepDay = (Integer)strategyDy.get("keepday");
    }

    private List<Long> getDynamicObjectMulBasedataIdList(DynamicObject strategyDy, String propKey) {
        return strategyDy.getDynamicObjectCollection(propKey).stream().map(it -> it.getLong("fbasedataid_id")).collect(Collectors.toList());
    }

    void convertStatus(Map<String, List<String>> statusConvertMap) {
        if (CollectionUtils.isEmpty(this.statusList)) {
            return;
        }
        ArrayList convertedStatusList = Lists.newArrayListWithCapacity((int)AppConstants.INT_TEN);
        this.statusList.forEach(status -> {
            if (statusConvertMap.containsKey(status)) {
                convertedStatusList.addAll((Collection)statusConvertMap.get(status));
            } else {
                convertedStatusList.add(status);
            }
        });
        this.statusList = convertedStatusList;
    }

    QFilter[] getDataClearQFilter(FieldConfigBo fieldConfigBo) {
        QFilter qFilter = this.buildKeepTimeQFilter(fieldConfigBo.getTimeField());
        if (!CollectionUtils.isEmpty(this.statusList)) {
            qFilter.and(new QFilter(fieldConfigBo.getStatusField(), "in", this.statusList));
        }
        if (qFilter == null) {
            return null;
        }
        return qFilter.toArray();
    }

    QFilter[] getAreaQFilter(FieldConfigBo fieldConfigBo) {
        QFilter qFilter = null;
        if (!CollectionUtils.isEmpty(this.bizAreaList)) {
            qFilter = new QFilter(fieldConfigBo.getBizAreaField(), "in", this.bizAreaList);
        }
        if (!CollectionUtils.isEmpty(this.bizSubAreaList)) {
            QFilter bizSubAreaQFilter = new QFilter(fieldConfigBo.getBizSubAreaField(), "in", this.bizSubAreaList);
            if (qFilter == null) {
                qFilter = bizSubAreaQFilter;
            } else {
                qFilter.and(bizSubAreaQFilter);
            }
        }
        if (qFilter == null) {
            return null;
        }
        return qFilter.toArray();
    }

    private QFilter buildKeepTimeQFilter(String timeField) {
        if (this.keepMonth > 0) {
            return new QFilter(timeField, "<=", (Object)DateUtils.addMonth((Date)new Date(), (int)(0 - this.keepMonth)));
        }
        return new QFilter(timeField, "<=", (Object)DateUtils.addDay((Date)new Date(), (int)(0 - this.keepDay)));
    }

    DynamicObject buildLogEntry(Integer count, Integer seq) {
        DynamicObject dynamicObject = this.iDataClearLogEntityService.generateEmptyEntryDynamicObject("entryentity");
        dynamicObject.set("dtclrst", this.strategyDy == null ? Long.valueOf(0L) : this.strategyDy.getPkValue());
        dynamicObject.set("clearcount", (Object)count);
        dynamicObject.set("seq", (Object)seq);
        return dynamicObject;
    }

    public boolean isClear() {
        return this.clear;
    }
}

