/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl.clear.bo;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.ext.IInitMetadataEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IInitTempEntityService;
import kd.hrmp.hric.bussiness.domain.init.IBaseConfigDomainService;
import kd.hrmp.hric.bussiness.domain.init.impl.clear.bo.AbstractDataClearBo;
import kd.hrmp.hric.bussiness.domain.init.impl.clear.bo.DataClearStrategyBo;
import kd.hrmp.hric.bussiness.domain.init.impl.clear.bo.FieldConfigBo;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.bo.MetadataBo;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.util.TableUtils;
import kd.hrmp.hric.common.bean.MidTableMetaDataClearRule;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.util.TXHandleUtils;
import org.apache.commons.collections.CollectionUtils;

public class MetadataDataClearBo
extends AbstractDataClearBo {
    private static final Log LOG = LogFactory.getLog(MetadataDataClearBo.class);
    private static final IInitMetadataEntityService iInitMetadataEntityService = ServiceFactory.getService(IInitMetadataEntityService.class);
    private static final IInitTempEntityService initTempEntityService = ServiceFactory.getService(IInitTempEntityService.class);
    private static final IBaseConfigDomainService iBaseConfigDomainService = ServiceFactory.getService(IBaseConfigDomainService.class);
    private boolean single;
    private List<String> entityNumberList;
    private MidTableMetaDataClearRule midTableMetaDataClearRule;

    public MetadataDataClearBo(DynamicObject dy) {
        super(dy);
    }

    @Override
    protected Map<DataClearStrategyBo, Integer> doClear() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)AppConstants.MAP_SIZE);
        this.midTableMetaDataClearRule = iBaseConfigDomainService.getMidTableDataClearRule();
        if (!this.single) {
            this.initNeedDeleteMetadata();
        }
        if (CollectionUtils.isNotEmpty(this.entityNumberList)) {
            Map<String, MetadataBo> metadataBoMap = iInitMetadataEntityService.getMetadataBoMap(Sets.newHashSet(this.entityNumberList));
            for (Map.Entry<String, MetadataBo> entry : metadataBoMap.entrySet()) {
                iInitMetadataEntityService.deleteMetadata(entry.getValue().getId(), "22/9TRQ536NA", "23X1H9WQ7S6U");
                LOG.info("metadata {} delete success", (Object)entry.getKey());
                if (!this.midTableMetaDataClearRule.isTableClear()) continue;
                this.dropTableByEntityNumber(entry.getKey());
            }
        }
        map.put(new DataClearStrategyBo(), this.entityNumberList.size());
        return map;
    }

    private void initNeedDeleteMetadata() {
        this.entityNumberList = initTempEntityService.getAllTemplateJudgeInfo().stream().map(it -> it.getString("intermediatetable")).collect(Collectors.toList());
        if (!this.midTableMetaDataClearRule.isClearAll()) {
            Sets.SetView needClearNumberSet = Sets.intersection((Set)Sets.newHashSet(this.entityNumberList), (Set)Sets.newHashSet((Iterable)this.midTableMetaDataClearRule.getClearMidTableEntityNumberList()));
            this.entityNumberList = Lists.newArrayList((Iterable)needClearNumberSet);
        }
    }

    private void dropTableByEntityNumber(String entityNumber) {
        TXHandleUtils.execNewTrans(() -> {
            StringBuilder entityTable = new StringBuilder("T_").append(entityNumber.toUpperCase(Locale.ROOT));
            TableUtils.dropTable("hmp", entityTable.toString());
            LOG.info("entity table delete success, table name = {}", (Object)entityTable);
            TableUtils.dropTable("hmp", "T_" + entityNumber.toUpperCase(Locale.ROOT) + "_L");
            LOG.info("entity language table delete success, table name = {}_L", (Object)entityTable);
        });
    }

    @Override
    protected FieldConfigBo getFieldConfig() {
        return null;
    }
}

