/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl.clear.bo;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.ext.IInitMetadataEntityService;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IInitTempEntityService;
import kd.hrmp.hric.bussiness.domain.init.IMidTableDomainService;
import kd.hrmp.hric.bussiness.domain.init.impl.clear.bo.AbstractDataClearBo;
import kd.hrmp.hric.bussiness.domain.init.impl.clear.bo.DataClearStrategyBo;
import kd.hrmp.hric.bussiness.domain.init.impl.clear.bo.FieldConfigBo;

public class MidTableDataClearBo
extends AbstractDataClearBo {
    private static Log LOG = LogFactory.getLog(MidTableDataClearBo.class);
    private IInitTempEntityService iInitTempEntityService = ServiceFactory.getService(IInitTempEntityService.class);
    private IMidTableDomainService iMidTableDomainService = ServiceFactory.getService(IMidTableDomainService.class);
    private IInitMetadataEntityService iInitMetadataEntityService = ServiceFactory.getService(IInitMetadataEntityService.class);
    private static final FieldConfigBo FIELD_CONFIG_BO = new FieldConfigBo("group", "bizsubarea", "initstatus", "hricmodifydate");

    public MidTableDataClearBo(DynamicObject dy) {
        super(dy);
    }

    @Override
    protected Map<DataClearStrategyBo, Integer> doClear() {
        HashMap map = Maps.newHashMap();
        int index = 1;
        for (DataClearStrategyBo dataClearStrategyBo : this.getDataClearStrategyBoList()) {
            LOG.info("strategy start, index = {}", (Object)index++);
            if (!dataClearStrategyBo.isClear()) continue;
            List<String> midTableNumberList = this.iInitTempEntityService.getMidTableNumberListByQFilter(dataClearStrategyBo.getAreaQFilter(this.getFieldConfig()));
            midTableNumberList.forEach(midTableNumber -> this.clearMidTableData(map, dataClearStrategyBo, (String)midTableNumber));
        }
        return map;
    }

    private void clearMidTableData(Map<DataClearStrategyBo, Integer> map, DataClearStrategyBo dataClearStrategyBo, String midTableNumber) {
        if (this.iInitMetadataEntityService.isNotExists(midTableNumber)) {
            LOG.warn("midTableNumber {} not exists, no need clear data", (Object)midTableNumber);
            return;
        }
        Integer count = map.getOrDefault(dataClearStrategyBo, 0);
        Integer clearCount = this.iMidTableDomainService.clearData(midTableNumber, dataClearStrategyBo.getDataClearQFilter(this.getFieldConfig()));
        LOG.info("clear {} data, clear size {}", (Object)midTableNumber, (Object)clearCount);
        map.put(dataClearStrategyBo, count + clearCount);
    }

    @Override
    protected FieldConfigBo getFieldConfig() {
        return FIELD_CONFIG_BO;
    }
}

