/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl.middle;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.util.MetadataUtils;

public class BizDesignerMetaGenerator {
    private static final Log LOG = LogFactory.getLog(BizDesignerMetaGenerator.class);
    private String number;
    private List<MainEntityType> entityTypeList = new ArrayList<MainEntityType>();
    private DesignerMeta designerMeta = new DesignerMeta();

    public BizDesignerMetaGenerator(String number) {
        this.number = number;
        this.initEntityTypeList();
    }

    public Map<String, Object> generate() {
        this.entityTypeList.forEach(entityType -> this.addDesignerMetaInfo((MainEntityType)entityType));
        try {
            String jsonStr = HRJSONUtils.toString((Object)this.designerMeta);
            return (Map)HRJSONUtils.cast((String)jsonStr, Map.class);
        }
        catch (IOException e) {
            LOG.error("json convert error", (Throwable)e);
            throw new KDBizException("jsoNewMetaItemInfon convert error, " + e.getMessage());
        }
    }

    public Map<String, Map<String, Object>> generateAllMap() {
        HashMap map = Maps.newHashMap();
        this.entityTypeList.forEach(entityType -> map.put(entityType.getName(), this.getExtDesignerMeta(entityType.getName())));
        return map;
    }

    private void addDesignerMetaInfo(MainEntityType entityType) {
        Map<String, Object> designerMetadataMap = this.getExtDesignerMeta(entityType.getName());
        this.designerMeta.entitytree.items.addAll(this.getItems(designerMetadataMap, "entitytree"));
        this.designerMeta.formmeta.items.addAll(this.getItems(designerMetadataMap, "formmeta"));
        this.designerMeta.entitymeta.items.addAll(this.getItems(designerMetadataMap, "entitymeta"));
    }

    private Map<String, Object> getExtDesignerMeta(String number) {
        String extMetaNumber = MetadataUtils.getExtMetaNumber(number);
        return MetadataUtils.getDesignerMetadata(extMetaNumber);
    }

    private Collection<? extends Map<String, Object>> getItems(Map<String, Object> designerMetadataMap, String entitymeta) {
        return Optional.ofNullable(designerMetadataMap).map(it -> (Map)it.get(entitymeta)).map(it -> (List)it.get("Items")).orElseGet(() -> new ArrayList());
    }

    private void initEntityTypeList() {
        this.entityTypeList = MetadataUtils.getEntityTypeList(this.number);
    }

    private static class Node {
        @JsonProperty(value="Items")
        private List<Map<String, Object>> items = new ArrayList<Map<String, Object>>();

        private Node() {
        }

        public List<Map<String, Object>> getItems() {
            return this.items;
        }
    }

    private static class DesignerMeta {
        private Node entitytree = new Node();
        private Node formmeta = new Node();
        private Node entitymeta = new Node();
        private Node ui = new Node();

        private DesignerMeta() {
        }

        public Node getEntitytree() {
            return this.entitytree;
        }

        public void setEntitytree(Node entitytree) {
            this.entitytree = entitytree;
        }

        public Node getFormmeta() {
            return this.formmeta;
        }

        public void setFormmeta(Node formmeta) {
            this.formmeta = formmeta;
        }

        public Node getEntitymeta() {
            return this.entitymeta;
        }

        public void setEntitymeta(Node entitymeta) {
            this.entitymeta = entitymeta;
        }

        public Node getUi() {
            return this.ui;
        }

        public void setUi(Node ui) {
            this.ui = ui;
        }
    }
}

