/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl.middle;

import java.util.Locale;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.common.exception.HricDifBizException;
import kd.hrmp.hric.common.util.HricDynamicObjectUtils;

public class MidField {
    private String number;
    private String numberProp;
    private String name;
    private String nameProp;
    private String relationBasedataNumber;
    private String ownEntityNumber;
    private String numberAlias;
    private boolean mulBasedata;

    public MidField(DynamicObject rowDy, DynamicProperty property, String ownEntityNumber) {
        this(rowDy, property, ownEntityNumber, rowDy.getString("numberalias"), rowDy.getString("entitynumber"), rowDy.getString("importprop"));
    }

    public MidField(DynamicObject rowDy, DynamicProperty property, String ownEntityNumber, String numberAlias, String number, String importProp) {
        this.number = number;
        this.name = Optional.ofNullable(rowDy.getString("entityname")).map(it -> it.replace("*", "")).orElse("");
        if (HRStringUtils.isNotEmpty((String)importProp)) {
            this.relationBasedataNumber = HricDynamicObjectUtils.getRelationBasedataNumberByProperty((IDataEntityProperty)property);
            this.initBaseDataProp(importProp, rowDy);
        }
        this.mulBasedata = property instanceof MulBasedataProp;
        this.numberAlias = numberAlias == null ? "" : numberAlias.trim();
        this.ownEntityNumber = ownEntityNumber;
    }

    private void initBaseDataProp(String importProp, DynamicObject rowDy) {
        BasedataEntityType dataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)this.relationBasedataNumber);
        if (!HricDynamicObjectUtils.entityContainsNumberAndName((BasedataEntityType)dataEntityType)) {
            this.numberProp = dataEntityType.getNumberProperty();
            if (HRStringUtils.isEmpty((String)this.numberProp)) {
                this.numberProp = dataEntityType.getNameProperty();
            }
            if (HRStringUtils.isEmpty((String)this.numberProp)) {
                String tipStr = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u6ca1\u6709\u6307\u5b9a\u7f16\u7801\u5b57\u6bb5\u3002", (String)"MidField_0", (String)"hrmp-hric-business", (Object[])new Object[0]);
                throw new HricDifBizException(String.format(Locale.ROOT, tipStr, rowDy.getString("entityname")));
            }
            this.nameProp = dataEntityType.getProperty(this.numberProp).getDisplayName().getLocaleValue();
            return;
        }
        this.numberProp = importProp;
        this.nameProp = this.getNameProp(rowDy, this.numberProp);
    }

    private String getNameProp(DynamicObject rowDy, String numberProp) {
        if (HRStringUtils.isEmpty((String)numberProp)) {
            return "";
        }
        return ((ComboProp)rowDy.getDataEntityType().getProperties().get((Object)"importprop")).getItemByName(numberProp);
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getNumberProp() {
        return this.numberProp;
    }

    public void setNumberProp(String numberProp) {
        this.numberProp = numberProp;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameProp() {
        return this.nameProp;
    }

    public void setNameProp(String nameProp) {
        this.nameProp = nameProp;
    }

    public String getRelationBasedataNumber() {
        return this.relationBasedataNumber;
    }

    public void setRelationBasedataNumber(String relationBasedataNumber) {
        this.relationBasedataNumber = relationBasedataNumber;
    }

    public boolean isMulBasedata() {
        return this.mulBasedata;
    }

    public String getNumberAlias() {
        return HRStringUtils.isNotEmpty((String)this.numberAlias) ? this.numberAlias : this.number;
    }

    public boolean needModifyFieldType() {
        return HRStringUtils.isNotEmpty((String)this.nameProp) && !"number".equals(this.nameProp);
    }

    public String getOwnEntityNumber() {
        return this.ownEntityNumber;
    }

    public void setOwnEntityNumber(String ownEntityNumber) {
        this.ownEntityNumber = ownEntityNumber;
    }

    public String toString() {
        return "MidFiled{number='" + this.number + '\'' + (HRStringUtils.isEmpty((String)this.numberProp) ? "" : ", numberProp='" + this.numberProp + '\'') + (this.name == null ? "" : ", name='" + this.name + '\'') + (this.nameProp == null ? "" : ", nameProp='" + this.nameProp + '\'') + (this.relationBasedataNumber == null ? "" : ", relationBasedataNumber='" + this.relationBasedataNumber + '\'') + (this.ownEntityNumber == null ? "" : ", ownEntityNumber='" + this.ownEntityNumber + '\'') + (this.numberAlias == null ? "" : ", numberAlias='" + this.numberAlias + '\'') + ", mulBasedata=" + this.mulBasedata + '}';
    }
}

