/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl.middle;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.ext.IInitMetadataEntityService;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.BizDesignerMetaGenerator;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.MidField;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.handle.EntityMetaNodeHandle;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.handle.EntityTreeNodeHandle;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.handle.FormMetaNodeHandle;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.handle.IsvInfoHandle;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.handle.ListMetaNodeHandle;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.handle.MysqlRowSizeLimitHandle;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.handle.NodeHandle;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.handle.NodeRepeatHandle;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.handle.UiNodeHandle;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.info.BizObjectMetaItemInfo;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.info.MetaInfoContext;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.table.MidTableAlterHandle;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.util.MetadataUtils;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.util.TableUtils;

public class MidTableGenerate {
    private static final Log LOG = LogFactory.getLog(MidTableGenerate.class);
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String FIELD_ISIMPORT = "isimport";
    private static final String BIZ_OBJECT = "entityobjscope";
    private static String dbRouteKey = new HRBaseServiceHelper("hric_initmidtpl").generateEmptyDynamicObject().getDataEntityType().getDBRouteKey();
    private IInitMetadataEntityService iInitMetadataEntityService = ServiceFactory.getService(IInitMetadataEntityService.class);
    private String midNumber;
    private DynamicObject bizObject;
    private String bizObjectNumber;
    private LinkedHashMap<String, MidField> midFieldMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
    private Map<String, Map<String, Object>> bizObjectMetaMap;
    private Map<String, Object> midOldMeta;
    private Map<String, Object> midNewMeta;
    private List<String> addNodeList;
    private List<String> removeNodeList;
    private boolean existMeta;
    private List<MainEntityType> entityTypeList;
    private MetaInfoContext metaInfoContext;
    private DynamicObject importTemplateDy;
    private List<String> errorMsgList = Lists.newArrayList();

    public MidTableGenerate(DynamicObject importTemplateDy) {
        this.importTemplateDy = importTemplateDy;
        this.init();
    }

    private void init() {
        this.midNumber = this.importTemplateDy.getString("intermediatetable");
        this.bizObject = this.importTemplateDy.getDynamicObject(BIZ_OBJECT);
        if (Objects.isNull(this.bizObject)) {
            return;
        }
        this.bizObjectNumber = this.bizObject.getString("number");
        this.entityTypeList = MetadataUtils.getEntityTypeList(this.bizObjectNumber);
        this.midFieldMap = this.getMidFieldMap();
    }

    public boolean autoGenerateMiddleTableAndMetadata() {
        if (this.doCheck()) {
            LOG.error("error msg: {}", this.errorMsgList);
            return false;
        }
        LOG.info(ResManager.loadKDString((String)"\u751f\u6210\u7f13\u5b58\u8868\u5f00\u59cb\u3002\u7f13\u5b58\u8868\u6807\u8bc6\uff1a\u201c{}\u201d, \u4e1a\u52a1\u5bf9\u8c61\u6807\u8bc6\uff1a\u201c{}\u201d\u3002", (String)"MidTableGenerate_0", (String)"hrmp-hric-business", (Object[])new Object[0]), (Object)this.midNumber, (Object)this.bizObjectNumber);
        this.printTimeCostLog(ResManager.loadKDString((String)"1.\u521d\u59cb\u5316\u8bbe\u8ba1\u671f\u5143\u6570\u636e\u4fe1\u606f\u3002", (String)"MidTableGenerate_1", (String)"hrmp-hric-business", (Object[])new Object[0]), params -> this.initDesignerMeta());
        this.printTimeCostLog(ResManager.loadKDString((String)"2.\u4fee\u6539\u5143\u6570\u636e\u8282\u70b9\u4fe1\u606f\u3002", (String)"MidTableGenerate_2", (String)"hrmp-hric-business", (Object[])new Object[0]), params -> this.doModifyMidMeta());
        this.printTimeCostLog(ResManager.loadKDString((String)"2.1\u5220\u9664\u4e3b\u8868\u901a\u7528\u8bed\u8a00\u5b57\u6bb5", (String)"MidTableGenerate_14", (String)"hrmp-hric-business", (Object[])new Object[0]), params -> this.tryDropMainGLColumn());
        this.printTimeCostLog(ResManager.loadKDString((String)"3.\u4fdd\u5b58\u5143\u6570\u636e\u3002", (String)"MidTableGenerate_3", (String)"hrmp-hric-business", (Object[])new Object[0]), params -> this.doSaveMetadata());
        this.printTimeCostLog(ResManager.loadKDString((String)"4.\u4fdd\u5b58\u5143\u6570\u636e\u5206\u7ec4\u3002", (String)"MidTableGenerate_4", (String)"hrmp-hric-business", (Object[])new Object[0]), params -> this.doSaveUnit());
        this.printTimeCostLog(ResManager.loadKDString((String)"5.\u8bf7\u4fee\u6539\u7f13\u5b58\u8868\u5b57\u6bb5\u7c7b\u578b\u3002", (String)"MidTableGenerate_5", (String)"hrmp-hric-business", (Object[])new Object[0]), params -> this.compareAndAlterColumn());
        this.printTimeCostLog(ResManager.loadKDString((String)"6.\u751f\u6210\u7f13\u5b58\u8868\u7d22\u5f15\u3002", (String)"MidTableGenerate_6", (String)"hrmp-hric-business", (Object[])new Object[0]), params -> TableUtils.addIndexOnTable(dbRouteKey, this.midNumber, "finitbatchnumber"));
        return true;
    }

    private void tryDropMainGLColumn() {
        Set<String> dropMainTableColumnSet = this.metaInfoContext.getDropMainTableColumnSet();
        String midTableName = "t_" + this.midNumber;
        dropMainTableColumnSet.forEach(columnName -> {
            try {
                TableUtils.dropTableColumn(dbRouteKey, midTableName, columnName);
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        });
    }

    private void compareAndAlterColumn() {
        new MidTableAlterHandle(this.metaInfoContext).handle();
    }

    private void doModifyMidMeta() {
        this.compareMidMeta();
        this.modifyNewMidMeta();
        if (LOG.isWarnEnabled()) {
            LOG.warn(ResManager.loadKDString((String)"\u5ffd\u7565\u7684\u8282\u70b9\u4e3a\uff1a{}\u3002", (String)"MidTableGenerate_7", (String)"hrmp-hric-business", (Object[])new Object[0]), this.metaInfoContext.getIgnoreNodeSet());
        }
    }

    private void printTimeCostLog(String logInfo, Consumer<String> consumer) {
        LOG.info(logInfo);
        long start = System.currentTimeMillis();
        consumer.accept(null);
        if (LOG.isInfoEnabled()) {
            LOG.info(ResManager.loadKDString((String)"{}\u5b8c\u6210\uff0c\u7528\u65f6: {}ms", (String)"MidTableGenerate_8", (String)"hrmp-hric-business", (Object[])new Object[0]), (Object)logInfo, (Object)(System.currentTimeMillis() - start));
        }
    }

    private void initDesignerMeta() {
        this.bizObjectMetaMap = new BizDesignerMetaGenerator(this.bizObjectNumber).generateAllMap();
        this.midOldMeta = this.getOrGenerateOldMeta(this.midNumber);
        this.midNewMeta = new LinkedHashMap<String, Object>(this.midOldMeta);
    }

    private void modifyNewMidMeta() {
        this.metaInfoContext = new MetaInfoContext(this.bizObjectMetaMap, this.midNewMeta, this.midFieldMap);
        this.initRelationMetaInfo(this.metaInfoContext);
        if (LOG.isInfoEnabled()) {
            LOG.info(ResManager.loadKDString((String)"\u7f13\u5b58\u8868\u5b57\u6bb5:\n{}", (String)"MidTableGenerate_9", (String)"hrmp-hric-business", (Object[])new Object[0]), this.midFieldMap);
        }
        List<NodeHandle> handleList = Arrays.asList(new EntityMetaNodeHandle(this.metaInfoContext), new EntityTreeNodeHandle(this.metaInfoContext), new FormMetaNodeHandle(this.metaInfoContext), new UiNodeHandle(this.metaInfoContext), new ListMetaNodeHandle(this.metaInfoContext));
        handleList.forEach(it -> it.removeNode(this.removeNodeList));
        handleList.forEach(it -> {
            it.addNode(this.addNodeList);
            it.addOtherInfo();
        });
        new NodeRepeatHandle(this.metaInfoContext).handle();
        new MysqlRowSizeLimitHandle(this.metaInfoContext).handle();
        new IsvInfoHandle().handle(this.metaInfoContext);
    }

    private void initRelationMetaInfo(MetaInfoContext metaInfoContext) {
        for (Map.Entry<String, MidField> entry : this.midFieldMap.entrySet()) {
            String relationBasedataNumber;
            Map<String, BizObjectMetaItemInfo> relationMetaInfoMap = metaInfoContext.getRelationMetaInfoMap();
            if (relationMetaInfoMap.containsKey(entry.getKey()) || !HRStringUtils.isNotEmpty((String)(relationBasedataNumber = entry.getValue().getRelationBasedataNumber()))) continue;
            relationMetaInfoMap.put(relationBasedataNumber, new BizObjectMetaItemInfo(new BizDesignerMetaGenerator(relationBasedataNumber).generate()));
        }
    }

    private void doSaveUnit() {
        if (this.existMeta) {
            return;
        }
        String formId = (String)this.midNewMeta.get("id");
        String bizUnitId = "23X1H9WQ7S6U";
        String bizAppId = (String)this.midNewMeta.get("bizappid");
        this.iInitMetadataEntityService.saveAppUnit(formId, bizUnitId, bizAppId);
    }

    private void doSaveMetadata() {
        Map<String, Object> result = this.iInitMetadataEntityService.save(this.midNewMeta);
        boolean isSuccess = (Boolean)result.getOrDefault("success", false);
        if (!isSuccess) {
            List errorList = (List)result.get("errors");
            String errorMsg = null;
            try {
                errorMsg = HRJSONUtils.toString((Object)errorList);
            }
            catch (IOException e) {
                errorMsg = errorList == null ? "" : errorList.toString();
            }
            throw new KDBizException(errorMsg);
        }
        EntityMetadataCache.removeDataEntityTypeLocalCache((String)this.midNumber);
    }

    private void compareMidMeta() {
        this.addNodeList = this.getAddNodeList();
        this.removeNodeList = this.getRemoveNodeList();
    }

    private List<String> getRemoveNodeList() {
        LinkedHashMap<String, Map> removeFieldMap = new LinkedHashMap<String, Map>();
        List mapList = Optional.ofNullable(this.midOldMeta).map(it -> (Map)it.get("formmeta")).map(it -> (List)it.get("Items")).orElseGet(() -> Lists.newArrayList());
        HashSet<String> pidSet = new HashSet<String>();
        for (Map it2 : mapList) {
            String pid = (String)it2.get("ParentId");
            if (!it2.getOrDefault("Inherit", false).booleanValue()) continue;
            pidSet.add(pid);
        }
        for (Map it2 : mapList) {
            String key = it2.getOrDefault("Key", "");
            String pid = (String)it2.get("ParentId");
            if (pidSet.contains(pid)) continue;
            removeFieldMap.put(key, it2);
        }
        return new ArrayList<String>(removeFieldMap.keySet());
    }

    private List<String> getAddNodeList() {
        return new ArrayList<String>(this.midFieldMap.keySet());
    }

    private boolean doCheck() {
        if (HRStringUtils.isEmpty((String)this.midNumber)) {
            this.errorMsgList.add(ResManager.loadKDString((String)"\u7f13\u5b58\u8868\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"MidTableGenerate_10", (String)"hrmp-hric-business", (Object[])new Object[0]));
        }
        if (this.bizObject == null) {
            this.errorMsgList.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e3a\u7a7a", (String)"MidTableGenerate_11", (String)"hrmp-hric-business", (Object[])new Object[0]));
        }
        if (this.midFieldMap.isEmpty()) {
            this.errorMsgList.add(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u5165\u7684\u5c5e\u6027\u3002", (String)"MidTableGenerate_12", (String)"hrmp-hric-business", (Object[])new Object[0]));
        }
        return this.errorMsgList.size() > 0;
    }

    private Map<String, Object> getOrGenerateOldMeta(String number) {
        Map<String, Object> designerMetadata = null;
        designerMetadata = MetadataDao.checkNumber((String)number) ? MetadataUtils.getDesignerMetadata(number) : this.getDesignerMetadataFromParent(number);
        return designerMetadata;
    }

    private Map<String, Object> getDesignerMetadataFromParent(String midnumber) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("bizunitid", "23X1H9WQ7S6U");
        param.put("parentId", "20RI2G3NWYT3");
        param.put("bizappid", "22/9TRQ536NA");
        param.put("modelType", "BaseFormModel");
        param.put("id", midnumber);
        param.put("name", this.getMidTableName());
        return MetadataUtils.createBlankModel(param);
    }

    private String getMidTableName() {
        return this.bizObject.getLocaleString("name").getLocaleValue() + this.midNumber;
    }

    private LinkedHashMap<String, MidField> getMidFieldMap() {
        LinkedHashMap<String, MidField> midField = new LinkedHashMap<String, MidField>();
        DynamicObjectCollection dynamicObjectCollection = this.importTemplateDy.getDynamicObjectCollection(TREEENTRYENTITY);
        Map<Long, String> entityMap = this.getEntityMap(dynamicObjectCollection);
        for (int row = 0; row < dynamicObjectCollection.size(); ++row) {
            DynamicObject rowDy = (DynamicObject)dynamicObjectCollection.get(row);
            boolean isImport = rowDy.getBoolean(FIELD_ISIMPORT);
            if (!isImport) continue;
            String entityNumber = rowDy.getString("entitynumber");
            DynamicProperty property = this.getProperty(entityNumber, entityMap.get(rowDy.getLong("id")));
            if (this.checkIgnoreEntityNumber(entityNumber) || !this.accessProp(property)) continue;
            MidField midFieldTemp = new MidField(rowDy, property, entityMap.get(rowDy.getLong("id")));
            midField.put(rowDy.getString("numberalias"), midFieldTemp);
            if (!Objects.nonNull(midFieldTemp.getRelationBasedataNumber()) || !"number".equals(midFieldTemp.getNumberProp())) continue;
            String key = midFieldTemp.getNumber();
            String alias = midFieldTemp.getNumberAlias() + "a";
            MidField midFieldTempName = new MidField(rowDy, property, entityMap.get(rowDy.getLong("id")), alias, key, "name");
            midField.put(alias, midFieldTempName);
        }
        this.dealDateRangeCase(midField);
        return midField;
    }

    private void dealDateRangeCase(LinkedHashMap<String, MidField> midFieldMap) {
        HashSet needRemoveKeySet = Sets.newHashSet();
        for (Map.Entry<String, MidField> fieldEntry : midFieldMap.entrySet()) {
            TimeProp timeProp;
            DateTimeProp dateTimeProp;
            MidField midField = fieldEntry.getValue();
            DynamicProperty dynamicProperty = MetadataUtils.getDynamicProperty(midField.getOwnEntityNumber(), midField.getNumber());
            if (dynamicProperty instanceof DateTimeProp && !(dateTimeProp = (DateTimeProp)dynamicProperty).isStartDateTimeRange() && HRStringUtils.isNotEmpty((String)dateTimeProp.getRelateDateTimeRange())) {
                needRemoveKeySet.add(fieldEntry.getKey());
            }
            if (!(dynamicProperty instanceof TimeProp) || (timeProp = (TimeProp)dynamicProperty).isStartTimeRange() || !HRStringUtils.isNotEmpty((String)timeProp.getRelateTimeRange())) continue;
            needRemoveKeySet.add(fieldEntry.getKey());
        }
        needRemoveKeySet.forEach(alias -> {
            MidField cfr_ignored_0 = (MidField)midFieldMap.remove(alias);
        });
    }

    private boolean checkIgnoreEntityNumber(String entityNumber) {
        if (HRStringUtils.isEmpty((String)entityNumber)) {
            return true;
        }
        return HRStringUtils.equals((String)entityNumber, (String)"id");
    }

    private Map<Long, String> getEntityMap(DynamicObjectCollection dynamicObjectCollection) {
        HashMap idEntityNumberMap = Maps.newHashMapWithExpectedSize((int)dynamicObjectCollection.size());
        Map<Long, String> pidMap = dynamicObjectCollection.stream().filter(dy -> dy.getLong("pid") == 0L).collect(Collectors.toMap(it -> it.getLong("id"), it -> it.getString("entitynumber")));
        Map<Long, Long> idPidMap = dynamicObjectCollection.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("pid"), (o1, o2) -> o1));
        for (int row = 0; row < dynamicObjectCollection.size(); ++row) {
            DynamicObject rowDy = (DynamicObject)dynamicObjectCollection.get(row);
            idEntityNumberMap.put(rowDy.getLong("id"), this.findEntityNumber(rowDy.getLong("pid"), idPidMap, pidMap));
        }
        return idEntityNumberMap;
    }

    private String findEntityNumber(long pid, Map<Long, Long> entityMap, Map<Long, String> pidMap) {
        if (entityMap.get(pid) == null || entityMap.get(pid) == 0L) {
            return pidMap.get(pid);
        }
        return this.findEntityNumber(entityMap.get(pid), entityMap, pidMap);
    }

    private boolean accessProp(DynamicProperty prop) {
        if (prop == null) {
            return false;
        }
        return !this.checkNotAccessProp(prop);
    }

    private boolean checkNotAccessProp(DynamicProperty prop) {
        return this.getNotAccessProps().stream().anyMatch(it -> it.isInstance(prop));
    }

    private List<Class> getNotAccessProps() {
        return Arrays.asList(EntryProp.class, JoinProperty.class);
    }

    private DynamicProperty getProperty(String entityNumber, String ownEntityNumber) {
        for (MainEntityType entityType : this.entityTypeList) {
            DynamicProperty property;
            if (!HRStringUtils.equals((String)entityType.getName(), (String)ownEntityNumber) || (property = this.findProperty(entityNumber, entityType)) == null) continue;
            return property;
        }
        return null;
    }

    private DynamicProperty findProperty(String entityNumber, MainEntityType entityType) {
        for (Map.Entry subEntityTypeEntry : entityType.getAllEntities().entrySet()) {
            DynamicProperty property = ((EntityType)subEntityTypeEntry.getValue()).getProperty(entityNumber);
            if (property == null) continue;
            return property;
        }
        return null;
    }

    public List<String> getErrorMsgList() {
        return this.errorMsgList;
    }
}

