/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl.middle.handle;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.MidField;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.convert.ConvertFactory;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.handle.NodeHandle;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.info.BizObjectMetaItemInfo;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.info.MetaInfoContext;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.util.MaskUtils;

public abstract class AbstractNodeHandle
implements NodeHandle {
    private static final Log LOG = LogFactory.getLog(AbstractNodeHandle.class);
    protected List<Map<String, Object>> itemList;
    private MetaInfoContext metaInfoContext;

    protected AbstractNodeHandle(MetaInfoContext metaInfoContext) {
        this.metaInfoContext = metaInfoContext;
    }

    @Override
    public NodeHandle removeNode(List<String> nodeList) {
        nodeList.forEach(node -> this.removeItemNode((String)node));
        return this;
    }

    private void removeItemNode(String node) {
        Iterator<Map<String, Object>> it = this.getItemList().iterator();
        while (it.hasNext()) {
            Map<String, Object> map = it.next();
            if (!this.isRemoveNode(node, map)) continue;
            it.remove();
        }
    }

    protected boolean isRemoveNode(String node, Map<String, Object> map) {
        String id = this.getMetaInfoContext().getMidNewMeta().getNumberIdMapping().get(node);
        if (HRStringUtils.isEmpty((String)id)) {
            return false;
        }
        return id.equals(map.get("Id"));
    }

    public List<Map<String, Object>> getItemList() {
        return this.itemList;
    }

    public MetaInfoContext getMetaInfoContext() {
        return this.metaInfoContext;
    }

    @Override
    public NodeHandle addNode(List<String> nodeList) {
        nodeList.forEach(node -> this.addMetaNode((String)node));
        return this;
    }

    private void addMetaNode(String node) {
        Map<String, Object> metaItem = this.getMetaItem(node);
        if (metaItem != null) {
            this.getItemList().add(metaItem);
        }
    }

    protected Map<String, Object> getMetaItem(String node) {
        Map<String, Object> nodeMeta = this.getNodeMetaMap(node);
        if (nodeMeta == null) {
            return null;
        }
        nodeMeta.put("Id", this.getMetaInfoContext().getMidNewMeta().getIdByNumber(node));
        nodeMeta = ConvertFactory.getConvert(nodeMeta, this.getMetaInfoContext()).convert();
        MaskUtils.maskItem(nodeMeta);
        return nodeMeta;
    }

    protected boolean checkBasedataNumber(String node) {
        return this.getMetaInfoContext().checkBasedataNumber(node);
    }

    protected BizObjectMetaItemInfo getRelBizObjMeta(MidField midField) {
        BizObjectMetaItemInfo bizObjectMetaItemInfo;
        if (this.checkBasedataNumber(midField.getNumberAlias()) && (bizObjectMetaItemInfo = this.getMetaInfoContext().getBizObjectMeta(midField.getRelationBasedataNumber())) != null) {
            return bizObjectMetaItemInfo;
        }
        return this.getMetaInfoContext().getBizObjectMeta(midField.getOwnEntityNumber());
    }

    protected Map<String, Object> getNodeMetaMap(String node) {
        if (this.getMetaInfoContext().containsIgnoreNode(node)) {
            return null;
        }
        MidField midField = this.getMetaInfoContext().getMidFieldMap().get(node);
        BizObjectMetaItemInfo relBizObjMeta = this.getRelBizObjMeta(midField);
        Map<String, Object> metaMapping = this.getMetaMapping(relBizObjMeta);
        if (this.checkBasedataNumber(node)) {
            String id = relBizObjMeta.getNumberIdMapping().get(midField.getNumberProp());
            Map propMap = (Map)metaMapping.get(id);
            if (propMap == null) {
                this.getMetaInfoContext().addIgnoreNodeSet(node);
                LOG.info("basedate propMap is null, node: {}, midfield: {}", (Object)node, (Object)midField);
                return null;
            }
            propMap.computeIfPresent("Key", (key, value) -> midField.getNumberAlias());
            propMap.computeIfPresent("Name", (key, value) -> midField.getName() + "." + midField.getNameProp());
            propMap.computeIfPresent("FieldName", (key, value) -> "fh" + midField.getNumberAlias() + ("number".equals(midField.getNumberProp()) ? "u" : "a"));
            return propMap;
        }
        String id = relBizObjMeta.getNumberIdMapping().get(midField.getNumber());
        String handleKey = this.getClass().getSimpleName() + node + id;
        if (this.getMetaInfoContext().getHandleIdSet().contains(handleKey)) {
            return null;
        }
        this.getMetaInfoContext().getHandleIdSet().add(handleKey);
        Map<String, Object> nodeMap = (Map<String, Object>)metaMapping.get(id);
        nodeMap = this.getNodeMapAndCheckFieldNameExists(nodeMap, node);
        if (nodeMap == null) {
            this.getMetaInfoContext().addIgnoreNodeSet(node);
            LOG.info("basedate propMap is null, node: {}, midfield: {}", (Object)node, (Object)midField);
            return null;
        }
        this.addColumnInfo(nodeMap, relBizObjMeta, midField);
        return nodeMap;
    }

    protected Map<String, Object> getNodeMapAndCheckFieldNameExists(Map<String, Object> nodeMap, String node) {
        return nodeMap;
    }

    protected void addColumnInfo(Map<String, Object> nodeMap, BizObjectMetaItemInfo relBizObjMeta, MidField midField) {
        nodeMap.computeIfPresent("Key", (key, value) -> midField.getNumberAlias());
    }

    protected Map<String, Object> getMetaMapping(BizObjectMetaItemInfo relBizObjMeta) {
        return new HashMap<String, Object>();
    }
}

