/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl.middle.handle;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.MetaNodeConstants;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.MidField;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.handle.AbstractNodeHandle;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.info.BizObjectMetaItemInfo;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.info.MetaInfoContext;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.table.ColumnInfo;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.table.TableInfoHelperUtils;

public class EntityMetaNodeHandle
extends AbstractNodeHandle {
    private static final Log LOG = LogFactory.getLog(EntityMetaNodeHandle.class);

    public EntityMetaNodeHandle(MetaInfoContext metaInfoContext) {
        super(metaInfoContext);
        this.itemList = metaInfoContext.getMidNewMeta().getEntityMetaItemList();
    }

    @Override
    public void addOtherInfo() {
        super.getItemList().forEach(it -> {
            if ("BaseEntity".equals(it.get("_Type_"))) {
                String number = (String)it.get("Key");
                String tableName = (String)it.get("TableName");
                if (HRStringUtils.isEmpty((String)tableName)) {
                    tableName = String.format(Locale.ROOT, "t_%s", number);
                    it.put("TableName", tableName);
                }
                this.getMetaInfoContext().getTableInfoHelper().addMidTableInfo(tableName, "hmp", number);
            }
        });
    }

    @Override
    protected Map<String, Object> getMetaMapping(BizObjectMetaItemInfo relBizObjMeta) {
        return relBizObjMeta.getEntityMetaMapping();
    }

    @Override
    protected Map<String, Object> getNodeMapAndCheckFieldNameExists(Map<String, Object> nodeMap, String node) {
        if (Objects.isNull(nodeMap)) {
            return nodeMap;
        }
        if (this.checkRangeType(nodeMap)) {
            String fieldName;
            String startDateFieldName = (String)nodeMap.get("StartDateFieldName");
            String endDateFieldName = (String)nodeMap.get("EndDateFieldName");
            if (HRStringUtils.isEmpty((String)startDateFieldName)) {
                LOG.info("startDateFieldName is empty, node: {}, alias: {}", nodeMap.get("StartDateFieldName"), (Object)node);
                fieldName = "fx" + EntityMetaNodeHandle.getTagByNodeMap(nodeMap, "StartDateFieldKey");
                nodeMap.put("StartDateFieldName", fieldName);
            }
            if (HRStringUtils.isEmpty((String)endDateFieldName)) {
                LOG.info("endDateFieldName is empty, node: {}, alias: {}", nodeMap.get("EndDateFieldName"), (Object)node);
                fieldName = "fx" + EntityMetaNodeHandle.getTagByNodeMap(nodeMap, "EndDateFieldKey");
                nodeMap.put("EndDateFieldName", fieldName);
            }
            return nodeMap;
        }
        String fieldName = (String)nodeMap.get("FieldName");
        if (HRStringUtils.isEmpty((String)fieldName)) {
            LOG.info("fieldName is empty, node: {}, alias: {}", nodeMap.get("Key"), (Object)node);
            fieldName = "fx" + node;
            nodeMap.put("FieldName", fieldName);
        }
        return StringUtils.isBlank((CharSequence)fieldName) ? null : nodeMap;
    }

    private static String getTagByNodeMap(Map<String, Object> nodeMap, String tag) {
        String startDateFieldKey = (String)nodeMap.get(tag);
        if ((startDateFieldKey = startDateFieldKey.replaceAll("_", "")).length() > 25) {
            return startDateFieldKey.substring(startDateFieldKey.length() - 25);
        }
        return startDateFieldKey;
    }

    private boolean checkRangeType(Map<String, Object> nodeMap) {
        String type = (String)nodeMap.getOrDefault("_Type_", "");
        return MetaNodeConstants.RANGE_TYPE_SET.contains(type);
    }

    @Override
    protected void addColumnInfo(Map<String, Object> nodeMap, BizObjectMetaItemInfo relBizObjMeta, MidField midField) {
        ColumnInfo bizColumnInfo = TableInfoHelperUtils.generateColumn(nodeMap, relBizObjMeta.getTableInfo());
        super.addColumnInfo(nodeMap, relBizObjMeta, midField);
        TableInfoHelperUtils.generateColumn(nodeMap, bizColumnInfo, this.getMetaInfoContext().getTableInfoHelper().getMidTableInfo());
    }
}

