/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl.middle.handle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.ID;
import kd.bos.list.SeqColumnType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.handle.AbstractNodeHandle;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.handle.NodeHandle;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.info.MetaInfoContext;

public class ListMetaNodeHandle
extends AbstractNodeHandle {
    private static final String END_DATE_FIELD_KEY = "EndDateFieldKey";
    private static final String NAME = "Name";
    private static final String KEY = "Key";
    private static final String TYPE = "_Type_";
    private Map<String, String> keyNameMapping = new HashMap<String, String>();
    private Map<String, String> startEndMapping = new HashMap<String, String>();
    private int maxIndex = 0;

    public ListMetaNodeHandle(MetaInfoContext metaInfoContext) {
        super(metaInfoContext);
        this.itemList = metaInfoContext.getMidNewMeta().getListMetaItemList();
        this.initMaxIndex();
        this.initKeyNameMapping();
    }

    private void initMaxIndex() {
        for (Map<String, Object> map : this.getItemList()) {
            int index = map.get("Index") == null ? 0 : (Integer)map.get("Index");
            this.maxIndex = this.maxIndex < index ? index : this.maxIndex;
        }
    }

    private void initKeyNameMapping() {
        this.getMetaInfoContext().getMidNewMeta().getEntityMetaItemList().forEach(it -> {
            if (this.isDateRangeField((Map<String, Object>)it)) {
                this.keyNameMapping.put(it.get(END_DATE_FIELD_KEY).toString(), it.get(NAME).toString() + this.getEndSuffix());
                this.startEndMapping.put(it.get(KEY).toString(), it.get(END_DATE_FIELD_KEY).toString());
            }
        });
        this.getMetaInfoContext().getMidNewMeta().getFormMetaItemList().forEach(it -> {
            if (this.startEndMapping.containsKey(it.get(KEY).toString())) {
                this.keyNameMapping.put((String)it.get(KEY), (String)it.get(NAME) + this.getStartSuffix());
            } else {
                this.keyNameMapping.put((String)it.get(KEY), (String)it.get(NAME));
            }
        });
    }

    private String getStartSuffix() {
        return ResManager.loadKDString((String)".\u5f00\u59cb", (String)"ListMetaNodeHandle_0", (String)"hrmp-hric-business", (Object[])new Object[0]);
    }

    private String getEndSuffix() {
        return ResManager.loadKDString((String)".\u7ed3\u675f", (String)"ListMetaNodeHandle_1", (String)"hrmp-hric-business", (Object[])new Object[0]);
    }

    @Override
    public NodeHandle removeNode(List<String> nodeList) {
        return super.removeNode(this.getNeedGenNodeList(nodeList));
    }

    private boolean isDateRangeField(Map<String, Object> map) {
        long count = map.entrySet().stream().filter(e -> HRStringUtils.equals((String)((String)e.getKey()), (String)TYPE)).filter(e -> HRStringUtils.equals((String)e.getValue().toString(), (String)"DateRangeField") || HRStringUtils.equals((String)e.getValue().toString(), (String)"TimeRangeField")).count();
        return count > 0L;
    }

    @Override
    public NodeHandle addNode(List<String> nodeList) {
        this.initKeyNameMapping();
        return super.addNode(this.getNeedGenNodeList(nodeList));
    }

    private List<String> getNeedGenNodeList(List<String> nodeList) {
        ArrayList needGenNodeList = Lists.newArrayList(nodeList);
        for (Map.Entry<String, String> entry : this.startEndMapping.entrySet()) {
            if (!needGenNodeList.contains(entry.getKey())) continue;
            needGenNodeList.add(needGenNodeList.indexOf(entry.getKey()) + 1, entry.getValue());
        }
        return needGenNodeList;
    }

    @Override
    protected boolean isRemoveNode(String node, Map<String, Object> map) {
        return node.equals(map.get("ListFieldId"));
    }

    @Override
    protected Map<String, Object> getMetaItem(String node) {
        if (!this.keyNameMapping.containsKey(node)) {
            return null;
        }
        LinkedHashMap<String, Object> nodeMeta = new LinkedHashMap<String, Object>();
        nodeMeta.put("ParentId", "gridview");
        nodeMeta.put(TYPE, "ListColumnAp");
        nodeMeta.put(NAME, this.getNodeName(node));
        nodeMeta.put("Order", "NotOrder");
        nodeMeta.put("SeqColumnType", SeqColumnType.NotSeq.name());
        nodeMeta.put("Index", this.getMetaIndex());
        nodeMeta.put("ListFieldId", this.getFieldId(node));
        nodeMeta.put("ColumnOrderAndFilter", true);
        nodeMeta.put("Id", this.generateListId());
        nodeMeta.put(KEY, this.getListKey());
        return nodeMeta;
    }

    private String getListKey() {
        return "listcolumnap" + this.getMetaIndex();
    }

    private String generateListId() {
        return ID.genStringId();
    }

    private String getFieldId(String node) {
        return node;
    }

    private int getMetaIndex() {
        ++this.maxIndex;
        return this.maxIndex;
    }

    private String getNodeName(String node) {
        return this.keyNameMapping.get(node);
    }
}

