/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl.middle.handle;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.info.MetaInfoContext;

public class NodeRepeatHandle {
    private List<Map<String, Object>> entityMetaItemList;
    private Map<String, String> fieldNameMap = Maps.newHashMap();
    private Set<String> fieldSet = Sets.newHashSet();
    private int index = 0;

    public NodeRepeatHandle(MetaInfoContext metaInfoContext) {
        this.entityMetaItemList = metaInfoContext.getMidNewMeta().getEntityMetaItemList();
    }

    public void handle() {
        this.modifyFieldNameRepeat();
    }

    private void modifyFieldNameRepeat() {
        this.entityMetaItemList.forEach(entityMap -> {
            this.fieldNameMap.put((String)entityMap.get("Key"), (String)entityMap.get("FieldName"));
            this.fieldSet.add((String)entityMap.get("FieldName"));
        });
        Map fieldListMap = this.fieldNameMap.keySet().stream().map(it -> this.fieldNameMap.get(it)).filter(HRStringUtils::isNotEmpty).collect(Collectors.groupingBy(Function.identity()));
        if (this.fieldSet.contains("fid")) {
            this.index = 2;
            this.doModify("fid", false);
        }
        fieldListMap.keySet().forEach(key -> {
            if (((List)fieldListMap.get(key)).size() > 1) {
                this.doModify((String)key, true);
            }
        });
    }

    private void doModify(String key, boolean reset) {
        if (reset) {
            this.index = 0;
        }
        this.entityMetaItemList.forEach(node -> {
            if (HRStringUtils.equals((String)((String)node.get("FieldName")), (String)key)) {
                node.put("FieldName", this.getFieldName(key));
            }
        });
    }

    private String getFieldName(String key) {
        if (this.index == 0) {
            ++this.index;
        }
        return this.getFieldNameAndCheckExists(key, this.index);
    }

    private String getFieldNameAndCheckExists(String key, int index) {
        String fieldKey = key + index;
        while (this.fieldSet.contains(fieldKey)) {
            fieldKey = key + ++index;
        }
        this.fieldSet.add(fieldKey);
        return fieldKey;
    }
}

