/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl.middle.info;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.MetaNodeConstants;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.table.TableInfo;

public class MetaItemInfo {
    private Map<String, Object> metaContext;
    private List<Map<String, Object>> entityTreeList;
    private List<Map<String, Object>> entityMetaItemList;
    private List<Map<String, Object>> formMetaItemList;
    private List<Map<String, Object>> uiItemList;
    private List<Map<String, Object>> listMetaItemList;
    private Map<String, String> idNumberMapping;
    private Map<String, String> numberIdMapping;
    private TableInfo tableInfo;

    public MetaItemInfo(Map<String, Object> metaContext) {
        this.metaContext = metaContext;
        this.entityTreeList = this.getMetaItemList(metaContext, "entitytree");
        this.formMetaItemList = this.getMetaItemList(metaContext, "formmeta");
        this.entityMetaItemList = this.getMetaItemList(metaContext, "entitymeta");
        this.uiItemList = this.getUiModelList(metaContext, "businessap");
        this.listMetaItemList = this.getListMetaItemList(metaContext);
        this.initIdAndNumberMapping();
        this.initEntityInfo();
    }

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    private void initEntityInfo() {
        if (!CollectionUtils.isEmpty(this.entityMetaItemList)) {
            Map<String, Object> nodeMap = this.entityMetaItemList.get(0);
            String entityNumber = (String)nodeMap.get("Key");
            String tableName = (String)nodeMap.get("TableName");
            String dbRoute = (String)nodeMap.get("dbRoute");
            this.tableInfo = new TableInfo(tableName, dbRoute, entityNumber);
        }
    }

    protected void addRangeNumberIdMapping() {
        this.entityMetaItemList.forEach(nodeInfo -> MetaNodeConstants.RANGE_KEY_SET.forEach(it -> {
            String value = (String)nodeInfo.get(it);
            if (HRStringUtils.isNotEmpty((String)value)) {
                this.getNumberIdMapping().put(value, (String)nodeInfo.get("Id"));
            }
        }));
    }

    private List<Map<String, Object>> getMetaItemList(Map<String, Object> metaContext, String entitytree) {
        return Optional.ofNullable(metaContext).map(it -> (Map)it.get(entitytree)).map(it -> (List)it.get("Items")).orElseGet(() -> Lists.newArrayList());
    }

    private List<Map<String, Object>> getListMetaItemList(Map<String, Object> metaContext) {
        return Optional.ofNullable(metaContext).map(it -> (Map)it.get("formmeta")).map(it -> (List)it.get("Items")).filter(Objects::nonNull).filter(it -> !it.isEmpty()).map(it -> (Map)it.get(0)).map(it -> (Map)it.get("ListMeta")).map(it -> (List)it.get("Items")).orElseGet(() -> Lists.newArrayList());
    }

    private void initIdAndNumberMapping() {
        this.idNumberMapping = Maps.newHashMapWithExpectedSize((int)this.formMetaItemList.size());
        this.numberIdMapping = Maps.newHashMapWithExpectedSize((int)this.formMetaItemList.size());
        this.formMetaItemList.forEach(it -> {
            this.idNumberMapping.put((String)it.get("Id"), (String)it.get("Key"));
            this.numberIdMapping.put((String)it.get("Key"), (String)it.get("Id"));
        });
    }

    public List<Map<String, Object>> getEntityTreeList() {
        return this.entityTreeList;
    }

    public List<Map<String, Object>> getEntityMetaItemList() {
        return this.entityMetaItemList;
    }

    public List<Map<String, Object>> getFormMetaItemList() {
        return this.formMetaItemList;
    }

    public List<Map<String, Object>> getUiItemList() {
        return this.uiItemList;
    }

    private List<Map<String, Object>> getUiModelList(Map<String, Object> newContent, String businessapId) {
        String apId = Optional.ofNullable(newContent).map(it -> (Map)it.get("formmeta")).map(it -> (List)it.get("Items")).map(it -> {
            for (Map objectMap : it) {
                if (!businessapId.equals(objectMap.get("Key"))) continue;
                return (String)objectMap.get("Id");
            }
            return null;
        }).orElse("");
        return Optional.ofNullable(newContent).map(it -> (Map)it.get("ui")).map(it -> (List)it.get("Items")).map(it -> {
            List list = it;
            for (Map objectMap : list) {
                if (!objectMap.getOrDefault("ui", "").equals(apId)) continue;
                List itemList = (List)objectMap.get("Items");
                if (itemList == null) {
                    objectMap.put("Items", new ArrayList());
                }
                return (List)objectMap.get("Items");
            }
            return Lists.newArrayList();
        }).orElseGet(() -> Lists.newArrayList());
    }

    public Map<String, Object> getMetaContext() {
        return this.metaContext;
    }

    public Map<String, String> getIdNumberMapping() {
        return this.idNumberMapping;
    }

    public Map<String, String> getNumberIdMapping() {
        return this.numberIdMapping;
    }

    public List<Map<String, Object>> getListMetaItemList() {
        return this.listMetaItemList;
    }
}

