/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl.middle.info;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.info.MetaItemInfo;
import kd.hrmp.hric.bussiness.service.BaseConfigServiceHelper;
import kd.hrmp.hric.common.util.ConvertUtils;

public class NewMetaItemInfo
extends MetaItemInfo {
    private static final Log LOG = LogFactory.getLog(NewMetaItemInfo.class);
    private BiMap<String, String> newNumberIdMapping = HashBiMap.create();
    private String entityNumber;
    private String parentId;
    private Integer maxIdTimes;

    public NewMetaItemInfo(Map<String, Object> metaContext) {
        super(metaContext);
        this.initEntityNumber();
        this.initNewNumberIdInfo();
        String idGenerateTimes = BaseConfigServiceHelper.get("max.id.generate.times");
        this.maxIdTimes = ConvertUtils.toInteger((Object)idGenerateTimes);
        this.addRangeNumberIdMapping();
    }

    private void initNewNumberIdInfo() {
        for (Map<String, Object> itemMap : this.getEntityMetaItemList()) {
            this.newNumberIdMapping.put(ConvertUtils.convert((Object)itemMap.get("Key")), ConvertUtils.convert((Object)itemMap.get("Id")));
        }
        LOG.debug("newNumberIdMapping info after init: {}", this.newNumberIdMapping);
    }

    private void initEntityNumber() {
        for (Map<String, Object> itemMap : this.getEntityMetaItemList()) {
            if (!"BaseEntity".equals(itemMap.get("_Type_"))) continue;
            this.entityNumber = (String)itemMap.get("Key");
        }
    }

    public String getIdByNumber(String number) {
        return (String)this.newNumberIdMapping.computeIfAbsent((Object)number, key -> this.generateNewMetaId());
    }

    public String getNumberById(String id) {
        return (String)this.newNumberIdMapping.inverse().get((Object)id);
    }

    private String generateNewMetaId() {
        int index = 0;
        do {
            String id = ID.genStringId();
            if (this.getIdNumberMapping().containsKey(id)) continue;
            return id;
        } while (++index <= this.maxIdTimes);
        throw new KDBizException(ResManager.loadKDString((String)"ID\u751f\u6210\u6b21\u6570\u8d85\u8fc7\u6700\u5927\u6b21\u6570\uff0c\u6700\u5927\u6b21\u6570\u4e3a%s\u6b21\u3002", (String)"NewMetaItemInfo_0", (String)"hrmp-hric-business", (Object[])new Object[]{this.maxIdTimes}));
    }

    public String getParentId() {
        if (this.parentId == null) {
            for (Map<String, Object> map : this.getFormMetaItemList()) {
                if (!map.get("Key").equals("businessap")) continue;
                this.parentId = (String)map.get("Id");
                break;
            }
        }
        return this.parentId;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }
}

