/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl.middle.table;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import kd.bos.dataentity.utils.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.MetaNodeConstants;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.table.TableInfo;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.table.type.NormalDataTypeConverter;
import kd.hrmp.hric.common.PredicateContainer;
import kd.hrmp.hric.common.constants.DataTypeConstants;

public class ColumnInfo {
    private static final String ALTER_SQL = "EXEC p_AlterColumn '%s', '%s', '%s', '%s', '%s', %s;";
    private static final String NULLABLE = "NULL";
    private static final String NOT_NULLABLE = "NOT NULL";
    private static final String DEFAULT_STR = "''' '''";
    private static final String DEFAULT_INT = "'0'";
    private static final String INT_TYPE = "1111";
    private static final String CHAR_TYPE = "0100";
    private static final String DEFAULT_TYPE = "0000";
    private static final String GEO_POINT_FIELD = "GeoPointField";
    private static List<Predicate<ColumnInfo>> predicateList = Lists.newArrayList();
    private String name;
    private String type;
    private String controlType;
    private int length;
    private int decimal;
    private String key;
    private String defaultValue;
    private boolean allowNull;
    private TableInfo tableInfo;
    private ColumnInfo bizColumnInfo;

    public boolean checkTypeAndLengthEqual() {
        if (Objects.isNull(this.bizColumnInfo)) {
            return false;
        }
        return HRStringUtils.equals((String)this.type, (String)this.bizColumnInfo.type) && this.bizColumnInfo.length == this.length && this.bizColumnInfo.decimal == this.decimal;
    }

    public Optional<String> generateAlterSqlByBizColumn() {
        if (!ColumnInfo.getPredicateContainer().allMatch((Object)this)) {
            return Optional.empty();
        }
        String dataTypeWithLength = this.getBizKsqlDataType();
        NormalDataTypeConverter dataTypeConverter = new NormalDataTypeConverter();
        String dataType = dataTypeConverter.getKsqlDataType(this.bizColumnInfo.getType());
        String sql = String.format(Locale.ROOT, ALTER_SQL, ColumnInfo.upperCase(this.getTableInfo().getTableName()), ColumnInfo.upperCase(this.getName()), ColumnInfo.upperCase(dataTypeWithLength), ColumnInfo.upperCase(this.getNullable(dataType)), ColumnInfo.upperCase(this.getFieldType(dataType)), this.getSqlDefaultValue(dataType));
        return Optional.of(sql);
    }

    private static PredicateContainer<ColumnInfo> getPredicateContainer() {
        PredicateContainer predicateContainer = PredicateContainer.getInstance();
        predicateContainer.setPredicateList(predicateList);
        return predicateContainer;
    }

    private static String upperCase(String str) {
        return StringUtils.upperCase((String)str, (Locale)Locale.ROOT);
    }

    private String getFieldType(String dataType) {
        if (this.isNumber(dataType)) {
            return INT_TYPE;
        }
        if (this.isChar(dataType)) {
            return CHAR_TYPE;
        }
        return DEFAULT_TYPE;
    }

    private String getNullable(String dataType) {
        return this.checkIsNullable(dataType) ? NULLABLE : NOT_NULLABLE;
    }

    private boolean checkIsNullable(String dataType) {
        return this.bizColumnInfo.allowNull && !this.isNumber(dataType) && !this.isChar(dataType);
    }

    private String getSqlDefaultValue(String dataType) {
        if (this.isNumber(dataType)) {
            return DEFAULT_INT;
        }
        if (this.isChar(dataType)) {
            return DEFAULT_STR;
        }
        return NULLABLE;
    }

    private boolean isChar(String dataType) {
        if (DataTypeConstants.DATATYPE_CHAR_SET.contains(dataType)) {
            return true;
        }
        return dataType.contains("CHAR");
    }

    private boolean isNumber(String dataType) {
        if (DataTypeConstants.DATATYPE_NUMBER_SET.contains(dataType)) {
            return true;
        }
        return dataType.contains("INT") || dataType.contains("FLOAT");
    }

    private String getBizKsqlDataType() {
        NormalDataTypeConverter dataTypeConverter = new NormalDataTypeConverter();
        return dataTypeConverter.getKsqlDataTypeWithLength(this.bizColumnInfo.type, this.bizColumnInfo.length, this.bizColumnInfo.decimal);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getDecimal() {
        return this.decimal;
    }

    public void setDecimal(int decimal) {
        this.decimal = decimal;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public ColumnInfo getBizColumnInfo() {
        return this.bizColumnInfo;
    }

    public void setBizColumnInfo(ColumnInfo bizColumnInfo) {
        this.bizColumnInfo = bizColumnInfo;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
    }

    public ColumnInfo getMutiLangColumnInfo() {
        return Optional.of(this.getTableInfo()).map(TableInfo::getMutiLangTableInfo).map(it -> it.getColumnInfo(this.getKey())).orElseGet(() -> null);
    }

    public String getControlType() {
        return this.controlType;
    }

    public void setControlType(String controlType) {
        this.controlType = controlType;
    }

    static {
        predicateList.add(Objects::nonNull);
        predicateList.add(columnInfo -> Objects.nonNull(columnInfo.getBizColumnInfo()));
        predicateList.add(columnInfo -> Objects.nonNull(columnInfo.getBizColumnInfo().getType()));
        predicateList.add(columnInfo -> !GEO_POINT_FIELD.equals(columnInfo.getControlType()));
        predicateList.add(columnInfo -> !columnInfo.getTableInfo().isMainTable() && !MetaNodeConstants.MULI_LANG_TEXT_FIELD.equals(columnInfo.getControlType()));
        predicateList.add(columnInfo -> !columnInfo.checkTypeAndLengthEqual());
    }
}

