/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl.middle.table;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.info.MetaInfoContext;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.table.ColumnInfo;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.table.ColumnInfoReaderFactory;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.table.TableInfo;

public class MidTableAlterHandle {
    private static Log LOG = LogFactory.getLog(MidTableAlterHandle.class);
    private TableInfo midTableInfo;
    private Set<TableInfo> bizTableInfoSet = Sets.newHashSet();

    public MidTableAlterHandle(MetaInfoContext metaInfoContext) {
        this.midTableInfo = metaInfoContext.getTableInfoHelper().getMidTableInfo();
    }

    public void handle() {
        this.loadColumnInfo();
        List<String> sqlList = this.generateAlterSql();
        this.exec(sqlList);
    }

    private void exec(List<String> sqlList) {
        sqlList.forEach(sql -> {
            try {
                DB.execute((DBRoute)DBRoute.of((String)this.midTableInfo.getDbRoute()), (String)sql);
                LOG.info("exec success, sql: {}", sql);
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        });
    }

    private List<String> generateAlterSql() {
        String temp;
        ArrayList sqlList = Lists.newArrayList();
        this.appendColumnSql(sqlList, this.midTableInfo);
        if (Objects.nonNull(this.midTableInfo.getMutiLangTableInfo())) {
            this.appendColumnSql(sqlList, this.midTableInfo.getMutiLangTableInfo());
        }
        String tableName = MidTableAlterHandle.toUpperCase(this.midTableInfo.getTableName());
        if (!this.midTableInfo.containsTemplateKeyField("FHRICSOURCESYSID")) {
            temp = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '%s' AND KSQL_COL_NAME ='FHRICSOURCESYSID') \n ALTER TABLE %s ADD FHRICSOURCESYSID BIGINT DEFAULT 0 NOT NULL; ";
            sqlList.add(String.format(Locale.ROOT, temp, tableName, tableName));
        }
        if (!this.midTableInfo.containsTemplateKeyField("FHRICSOURCESYSKEY")) {
            temp = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '%s' AND KSQL_COL_NAME ='FHRICSOURCESYSKEY') \n ALTER TABLE %s ADD FHRICSOURCESYSKEY VARCHAR(255) DEFAULT ' ' NOT NULL; ";
            sqlList.add(String.format(Locale.ROOT, temp, tableName, tableName));
        }
        return sqlList;
    }

    private static String toUpperCase(String tableName) {
        if (tableName == null) {
            return "";
        }
        return tableName.toUpperCase(Locale.ROOT);
    }

    private void appendColumnSql(List<String> sqlList, TableInfo tableInfo) {
        tableInfo.getColumnInfoList().forEach(it -> {
            Optional<String> sql = it.generateAlterSqlByBizColumn();
            if (sql.isPresent()) {
                sqlList.add(sql.get());
            }
        });
    }

    private void loadColumnInfo() {
        this.initBizTableInfo();
        this.loadMidTableInfo();
        this.loadBizColumnInfo();
    }

    private void loadMidTableInfo() {
        this.loadSingleColumnInfo(this.midTableInfo);
        if (Objects.nonNull(this.midTableInfo.getMutiLangTableInfo()) && !CollectionUtils.isEmpty(this.midTableInfo.getMutiLangTableInfo().getColumnInfoList())) {
            this.loadSingleColumnInfo(this.midTableInfo.getMutiLangTableInfo());
        }
    }

    private void initBizTableInfo() {
        this.midTableInfo.getColumnInfoList().forEach(column -> this.bizTableInfoSet.add(column.getBizColumnInfo().getTableInfo()));
    }

    private void loadBizColumnInfo() {
        this.bizTableInfoSet.forEach(tableInfo -> {
            this.loadSingleColumnInfo((TableInfo)tableInfo);
            if (Objects.nonNull(tableInfo.getMutiLangTableInfo()) && !CollectionUtils.isEmpty(tableInfo.getMutiLangTableInfo().getColumnInfoList())) {
                this.loadSingleColumnInfo(tableInfo.getMutiLangTableInfo());
            }
        });
    }

    private void loadSingleColumnInfo(TableInfo tableInfo) {
        if (HRStringUtils.isEmpty((String)tableInfo.getTableName()) || HRStringUtils.isEmpty((String)tableInfo.getDbRoute())) {
            return;
        }
        List<ColumnInfo> list = ColumnInfoReaderFactory.getReader(tableInfo.getDbRoute()).read(tableInfo.getTableName());
        Map columnMap = list.stream().collect(Collectors.toMap(ColumnInfo::getName, Function.identity(), (o1, o2) -> o1));
        tableInfo.getColumnInfoList().forEach(it -> {
            ColumnInfo dbColumn = (ColumnInfo)columnMap.get(it.getName());
            if (dbColumn != null) {
                it.setType(dbColumn.getType());
                it.setLength(dbColumn.getLength());
                it.setAllowNull(dbColumn.isAllowNull());
                it.setDefaultValue(dbColumn.getDefaultValue());
            } else {
                LOG.warn(" table: {}, column {}, meta field type {} : db column info is null ", new Object[]{tableInfo.getTableName(), it.getName(), it.getControlType()});
            }
        });
        for (String key : columnMap.keySet()) {
            if (!"FHRICSOURCESYSID".equalsIgnoreCase(key) && !"FHRICSOURCESYSKEY".equalsIgnoreCase(key)) continue;
            tableInfo.addTemplateKeyField(key.toUpperCase(Locale.ROOT));
        }
    }
}

