/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.bussiness.domain.init.impl.middle.table;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hrmp.hric.bussiness.domain.init.impl.middle.table.ColumnInfo;

public class TableInfo {
    private static Log LOG = LogFactory.getLog(TableInfo.class);
    public TableInfo mutiLangTableInfo;
    private String tableName;
    private String dbRoute;
    private String key;
    private List<ColumnInfo> columnInfoList = Lists.newArrayList();
    private Set<String> templateFieldSet = Sets.newHashSet();
    private Map<String, ColumnInfo> columnInfoMap = Maps.newHashMap();

    TableInfo() {
    }

    public TableInfo(String tableName, String dbRoute, String key) {
        this.tableName = tableName;
        this.dbRoute = dbRoute;
        this.key = key;
    }

    void setTableName(String tableName) {
        this.tableName = tableName;
    }

    void setDbRoute(String dbRoute) {
        this.dbRoute = dbRoute;
    }

    void setKey(String key) {
        this.key = key;
    }

    public void addColumnInfo(ColumnInfo columnInfo) {
        this.columnInfoList.add(columnInfo);
        this.columnInfoMap.put(columnInfo.getKey(), columnInfo);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDbRoute() {
        return this.dbRoute;
    }

    public String getKey() {
        return this.key;
    }

    public List<ColumnInfo> getColumnInfoList() {
        return this.columnInfoList;
    }

    public TableInfo getMutiLangTableInfo() {
        return this.mutiLangTableInfo;
    }

    public void setMutiLangTableInfo(TableInfo mutiLangTableInfo) {
        this.mutiLangTableInfo = mutiLangTableInfo;
    }

    public ColumnInfo getColumnInfo(String key) {
        return this.columnInfoMap.get(key);
    }

    public boolean isMainTable() {
        return !this.tableName.endsWith("_l");
    }

    public void addTemplateKeyField(String key) {
        this.templateFieldSet.add(key);
    }

    public boolean containsTemplateKeyField(String key) {
        return this.templateFieldSet.contains(key);
    }
}

